/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkContextManager;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WireTcpHandler<T extends NetworkContext<T>>
extends SimpleCloseable
implements TcpHandler<T>,
NetworkContextManager<T> {
    private static final int SIZE_OF_SIZE = 4;
    protected Wire outWire;
    @Nullable
    protected WireType wireType;
    long lastWritePosition = 0L;
    private Wire inWire;
    private boolean recreateWire;
    private WireOutPublisher publisher;
    private T nc;
    private boolean isAcceptor;

    private static void logYaml(@NotNull DocumentContext dc) {
        try {
            System.out.println("Server Reads:\n" + Wires.fromSizePrefixedBlobs((DocumentContext)dc));
        }
        catch (Exception e) {
            Jvm.warn().on(WireOutPublisher.class, "\nServer Reads ( corrupted ) :\n" + dc.wire().bytes().toDebugString());
        }
    }

    private static void logYaml(@NotNull WireOut outWire) {
        if (YamlLogging.showServerWrites()) {
            try {
                System.out.println("Server Sends:\n" + Wires.fromSizePrefixedBlobs((WireIn)((Wire)outWire)));
            }
            catch (Exception e) {
                Jvm.warn().on(WireOutPublisher.class, "\nServer Sends ( corrupted ) :\n" + outWire.bytes().toDebugString());
            }
        }
    }

    public boolean isAcceptor() {
        return this.isAcceptor;
    }

    public void wireType(@NotNull WireType wireType) {
        if (wireType == WireType.BINARY) {
            wireType = WireType.DELTA_BINARY.isAvailable() ? WireType.DELTA_BINARY : WireType.BINARY;
        }
        this.wireType = wireType;
        if (this.publisher != null) {
            this.publisher.wireType(wireType);
        }
    }

    public WireOutPublisher publisher() {
        return this.publisher;
    }

    public void publisher(@NotNull WireOutPublisher publisher) {
        this.publisher = publisher;
        if (this.wireType() != null) {
            publisher.wireType(this.wireType());
        }
    }

    public void isAcceptor(boolean isAcceptor) {
        this.isAcceptor = isAcceptor;
    }

    @Override
    public void process(@NotNull Bytes<?> in, @NotNull Bytes<?> out, T nc) {
        if (this.isClosed()) {
            return;
        }
        WireType wireType = this.wireType();
        if (wireType == null) {
            wireType = in.readByte(in.readPosition() + 4L) < 0 ? WireType.BINARY : WireType.TEXT;
        }
        this.checkWires(in, out, wireType);
        Bytes bytes = this.outWire.bytes();
        if (bytes.writePosition() != this.lastWritePosition) {
            this.onBytesWritten();
        }
        if (this.publisher != null) {
            this.publisher.applyAction((WireOut)this.outWire);
        }
        if (in.readRemaining() >= 4L) {
            this.onRead0();
        } else {
            long remaining = bytes.readRemaining();
            if (YamlLogging.showServerWrites() && remaining >= 4L) {
                int length = Wires.lengthOf((int)bytes.peekVolatileInt());
                if ((long)length <= remaining) {
                    System.out.println("sending from WTH: " + Wires.fromSizePrefixedBlobs((WireIn)this.outWire));
                } else {
                    System.out.println("send remaining from WTH: " + remaining);
                }
            }
            this.onWrite((WireOut)this.outWire);
        }
        this.lastWritePosition = bytes.writePosition();
    }

    protected void onBytesWritten() {
    }

    @Override
    public void onEndOfConnection(boolean heartbeatTimeOut) {
        NetworkStatsListener networkStatsListener = this.nc.networkStatsListener();
        if (networkStatsListener != null) {
            networkStatsListener.onNetworkStats(-1L, -1L, -1L);
        }
        if (this.publisher != null) {
            this.publisher.close();
        }
    }

    protected void onWrite(@NotNull WireOut out) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onRead0() {
        assert (this.inWire.startUse());
        this.ensureCapacity();
        try {
            long index = -1L;
            while (!this.inWire.bytes().isEmpty()) {
                DocumentContext dc = this.inWire.readingDocument();
                Throwable throwable = null;
                try {
                    if (!dc.isPresent()) {
                        return;
                    }
                    if (dc.index() == index) {
                        dc.rollbackOnClose();
                        return;
                    }
                    index = dc.index();
                    try {
                        if (YamlLogging.showServerReads()) {
                            WireTcpHandler.logYaml(dc);
                        }
                        this.onRead(dc, (WireOut)this.outWire);
                        this.onWrite((WireOut)this.outWire);
                    }
                    catch (Exception e) {
                        Jvm.warn().on(this.getClass(), "inWire=" + this.inWire.getClass() + ",yaml=" + Wires.fromSizePrefixedBlobs((DocumentContext)dc), (Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                }
            }
            return;
        }
        finally {
            assert (this.inWire.endUse());
        }
    }

    private void ensureCapacity() {
        int length;
        long pos;
        long size;
        @NotNull Bytes bytes = this.inWire.bytes();
        if (bytes.readRemaining() >= 4L && (size = (pos = bytes.readPosition()) + 8L + (long)Wires.lengthOf((int)(length = bytes.readInt(pos)))) > bytes.realCapacity()) {
            this.resizeInWire(size);
        }
    }

    private void resizeInWire(long size) {
        @NotNull Bytes bytes = this.inWire.bytes();
        if (size > bytes.realCapacity()) {
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.getClass(), Integer.toHexString(System.identityHashCode(bytes)) + " resized to: " + size);
            }
            bytes.ensureCapacity(size);
        }
    }

    protected void checkWires(Bytes<?> in, Bytes<?> out, @NotNull WireType wireType) {
        boolean replace;
        if (this.recreateWire) {
            this.recreateWire = false;
            this.initialiseInWire(wireType, in);
            this.initialiseOutWire(out, wireType);
            return;
        }
        if (this.inWire == null) {
            this.initialiseInWire(wireType, in);
            this.recreateWire = false;
        }
        assert (this.inWire.startUse());
        if (this.inWire.bytes() != in) {
            this.initialiseInWire(wireType, in);
            this.recreateWire = false;
        }
        assert (this.inWire.endUse());
        boolean bl = replace = this.outWire == null;
        if (!replace) {
            assert (this.outWire.startUse());
            boolean bl2 = replace = this.outWire.bytes() != out;
            assert (this.outWire.endUse());
        }
        if (replace) {
            this.initialiseOutWire(out, wireType);
            this.recreateWire = false;
        }
    }

    protected Wire initialiseOutWire(Bytes<?> out, @NotNull WireType wireType) {
        Wire wire = (Wire)wireType.apply(out);
        wire.usePadding(TcpChannelHub.TCP_USE_PADDING);
        this.outWire = wire;
        return this.outWire;
    }

    protected Wire initialiseInWire(@NotNull WireType wireType, Bytes<?> in) {
        Wire wire = (Wire)wireType.apply(in);
        wire.usePadding(TcpChannelHub.TCP_USE_PADDING);
        this.inWire = wire;
        return this.inWire;
    }

    public WireType wireType() {
        return this.wireType;
    }

    protected abstract void onRead(@NotNull DocumentContext var1, @NotNull WireOut var2);

    protected void writeData(@NotNull Bytes<?> inBytes, @NotNull WriteMarshallable c) {
        this.outWire.writeDocument(false, out -> {
            long readPosition = inBytes.readPosition();
            long position = this.outWire.bytes().writePosition();
            try {
                c.writeMarshallable((WireOut)this.outWire);
            }
            catch (Throwable t) {
                inBytes.readPosition(readPosition);
                Jvm.warn().on(WireTcpHandler.class, "While reading " + inBytes.toDebugString() + " processing wire " + c, t);
                this.outWire.bytes().writePosition(position);
                this.outWire.writeEventName((CharSequence)"exception").throwable(t);
            }
            if (position == this.outWire.bytes().writePosition()) {
                this.outWire.writeEventName((WireKey)CoreFields.reply).marshallable(WriteMarshallable.EMPTY);
            }
        });
        WireTcpHandler.logYaml((WireOut)this.outWire);
    }

    protected void writeData(boolean isNotComplete, @NotNull Bytes<?> inBytes, @NotNull WriteMarshallable c) {
        @NotNull WriteMarshallable marshallable = out -> {
            long readPosition = inBytes.readPosition();
            long position = this.outWire.bytes().writePosition();
            try {
                c.writeMarshallable((WireOut)this.outWire);
            }
            catch (Throwable t) {
                inBytes.readPosition(readPosition);
                Jvm.warn().on(WireTcpHandler.class, "While reading " + inBytes.toDebugString() + " processing wire " + c, t);
                this.outWire.bytes().writePosition(position);
                this.outWire.writeEventName((CharSequence)"exception").throwable(t);
            }
            if (position == this.outWire.bytes().writePosition()) {
                this.outWire.writeEventName((WireKey)CoreFields.reply).marshallable(WriteMarshallable.EMPTY);
            }
        };
        if (isNotComplete) {
            this.outWire.writeNotCompleteDocument(false, marshallable);
        } else {
            this.outWire.writeDocument(false, marshallable);
        }
        WireTcpHandler.logYaml((WireOut)this.outWire);
    }

    @Override
    public final void nc(T nc) {
        this.nc = nc;
        if (!this.isClosed()) {
            this.onInitialize();
        }
    }

    @Override
    public T nc() {
        return this.nc;
    }

    protected abstract void onInitialize();

    protected void performClose() {
        Closeable.closeQuietly((Object[])new Object[]{this.publisher, this.nc});
    }

    protected void publish(WriteMarshallable w) {
        this.publisher.put("", w);
    }
}

