/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkContextManager;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class WireTypeSniffingTcpHandler<T extends NetworkContext<T>>
extends SimpleCloseable
implements TcpHandler<T> {
    @NotNull
    private final TcpEventHandler handlerManager;
    @NotNull
    private final Function<T, TcpHandler<T>> delegateHandlerFactory;

    public WireTypeSniffingTcpHandler(@NotNull TcpEventHandler handlerManager, @NotNull Function<T, TcpHandler<T>> delegateHandlerFactory) {
        this.handlerManager = handlerManager;
        this.delegateHandlerFactory = delegateHandlerFactory;
    }

    @Override
    public void process(@NotNull Bytes in, @NotNull Bytes out, T nc) {
        WireType wireType;
        this.throwExceptionIfClosed();
        WireOutPublisher publisher = nc.wireOutPublisher();
        if (publisher != null) {
            publisher.applyAction(out);
        }
        if (in.readRemaining() < 5L) {
            return;
        }
        int required = Wires.lengthOf((int)in.readInt(in.readPosition()));
        assert (required < 0xA00000);
        if (in.readRemaining() < (long)(required + 4)) {
            return;
        }
        byte b = in.readByte(4L);
        if (b < 0) {
            wireType = WireType.DELTA_BINARY.isAvailable() ? WireType.DELTA_BINARY : WireType.BINARY;
        } else if (b > 32) {
            wireType = WireType.TEXT;
        } else {
            throw new IllegalStateException("Unable to identify the wire type from " + Integer.toHexString(b & 0xFF));
        }
        nc.wireType(wireType);
        TcpHandler<T> handler = this.delegateHandlerFactory.apply(nc);
        if (handler instanceof NetworkContextManager) {
            ((NetworkContextManager)((Object)handler)).nc(nc);
        }
        this.handlerManager.tcpHandler(handler);
    }

    public String toString() {
        return "WireTypeSniffingTcpHandler@" + Integer.toHexString(this.hashCode());
    }
}

