/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util.math;

import net.openhft.chronicle.hash.impl.util.math.Precision;

abstract class ContinuedFraction {
    ContinuedFraction() {
    }

    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    public double evaluate(double x, double epsilon, int maxIterations) {
        int n;
        double small = 1.0E-50;
        double hPrev = this.getA(0, x);
        if (Precision.equals(hPrev, 0.0, 1.0E-50)) {
            hPrev = 1.0E-50;
        }
        double dPrev = 0.0;
        double cPrev = hPrev;
        double hN = hPrev;
        for (n = 1; n < maxIterations; ++n) {
            double deltaN;
            double cN;
            double b;
            double a = this.getA(n, x);
            double dN = a + (b = this.getB(n, x)) * dPrev;
            if (Precision.equals(dN, 0.0, 1.0E-50)) {
                dN = 1.0E-50;
            }
            if (Precision.equals(cN = a + b / cPrev, 0.0, 1.0E-50)) {
                cN = 1.0E-50;
            }
            if (Double.isInfinite(hN = hPrev * (deltaN = cN * (dN = 1.0 / dN)))) {
                throw new IllegalStateException("Continued fraction convergents diverged to +/- infinity for value " + x);
            }
            if (Double.isNaN(hN)) {
                throw new IllegalStateException("Continued fraction diverged to NaN for value " + x);
            }
            if (Math.abs(deltaN - 1.0) < epsilon) break;
            dPrev = dN;
            cPrev = cN;
            hPrev = hN;
        }
        if (n >= maxIterations) {
            throw new IllegalStateException("Continued fraction convergents failed to converge (in less than " + maxIterations + " iterations) for value " + x);
        }
        return hN;
    }
}

