/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.NativeAccess;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.locks.VanillaReadWriteUpdateWithWaitsLockingStrategy;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.impl.SegmentHeader;

public final class BigSegmentHeader
implements SegmentHeader {
    public static final BigSegmentHeader INSTANCE = new BigSegmentHeader();
    private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    static final long LOCK_OFFSET = 0L;
    private static final VanillaReadWriteUpdateWithWaitsLockingStrategy LOCK = (VanillaReadWriteUpdateWithWaitsLockingStrategy)VanillaReadWriteUpdateWithWaitsLockingStrategy.instance();
    private static final NativeAccess A = (NativeAccess)Access.nativeAccess();
    static final long ENTRIES_OFFSET = 8L;
    static final long LOWEST_POSSIBLY_FREE_CHUNK_OFFSET = 12L;
    static final long DELETED_OFFSET = 16L;
    private static final int TRY_LOCK_NANOS_THRESHOLD = 2000000;

    private static long roundUpNanosToMillis(long nanos) {
        return TimeUnit.NANOSECONDS.toMillis(nanos + 900000L);
    }

    private BigSegmentHeader() {
    }

    @Override
    public long entries(long address) {
        return (long)OS.memory().readInt(address + 8L) & 0xFFFFFFFFL;
    }

    @Override
    public void entries(long address, long entries) {
        if (entries >= 0x100000000L) {
            throw new IllegalStateException("segment entries overflow: up to 4294967295 supported, " + entries + " given");
        }
        OS.memory().writeInt(address + 8L, (int)entries);
    }

    @Override
    public long deleted(long address) {
        return (long)OS.memory().readInt(address + 16L) & 0xFFFFFFFFL;
    }

    @Override
    public void deleted(long address, long deleted) {
        if (deleted >= 0x100000000L) {
            throw new IllegalStateException("segment deleted entries count overflow: up to 4294967295 supported, " + deleted + " given");
        }
        OS.memory().writeInt(address + 16L, (int)deleted);
    }

    @Override
    public long lowestPossiblyFreeChunk(long address) {
        return (long)OS.memory().readInt(address + 12L) & 0xFFFFFFFFL;
    }

    @Override
    public void lowestPossiblyFreeChunk(long address, long lowestPossiblyFreeChunk) {
        OS.memory().writeInt(address + 12L, (int)lowestPossiblyFreeChunk);
    }

    @Override
    public void readLock(long address) {
        if (!this.tryReadLock(address, 2L, TimeUnit.SECONDS)) {
            throw new RuntimeException("Dead lock");
        }
    }

    @Override
    public void readLockInterruptibly(long address) {
        this.readLock(address);
    }

    @Override
    public boolean tryReadLock(long address) {
        return LOCK.tryReadLock((Access)A, null, address + 0L);
    }

    @Override
    public boolean tryReadLock(long address, long time, TimeUnit unit) {
        return this.tryReadLock(address) || this.tryReadLock0(address, time, unit);
    }

    private boolean tryReadLock0(long address, long time, TimeUnit unit) {
        long timeInNanos = unit.toNanos(time);
        if (timeInNanos < 2000000L) {
            return this.tryReadLockNanos(address, timeInNanos);
        }
        return this.tryReadLockMillis(address, BigSegmentHeader.roundUpNanosToMillis(timeInNanos));
    }

    private boolean tryReadLockNanos(long address, long timeInNanos) {
        long end = System.nanoTime() + timeInNanos;
        do {
            if (!this.tryReadLock(address)) continue;
            return true;
        } while (System.nanoTime() <= end);
        return false;
    }

    private boolean tryReadLockMillis(long address, long timeInMillis) {
        long lastTime = System.currentTimeMillis();
        do {
            if (this.tryReadLock(address)) {
                return true;
            }
            long now = System.currentTimeMillis();
            if (now == lastTime) continue;
            lastTime = now;
            --timeInMillis;
        } while (timeInMillis >= 0L);
        return false;
    }

    @Override
    public boolean tryUpgradeReadToUpdateLock(long address) {
        return LOCK.tryUpgradeReadToUpdateLock((Access)A, null, address + 0L);
    }

    @Override
    public boolean tryUpgradeReadToWriteLock(long address) {
        return LOCK.tryUpgradeReadToWriteLock((Access)A, null, address + 0L);
    }

    @Override
    public void updateLock(long address) {
        if (!this.tryUpdateLock(address, 2L, TimeUnit.SECONDS)) {
            throw new RuntimeException("Dead lock");
        }
    }

    @Override
    public void updateLockInterruptibly(long address) {
        this.updateLock(address);
    }

    @Override
    public boolean tryUpdateLock(long address) {
        return LOCK.tryUpdateLock((Access)A, null, address + 0L);
    }

    @Override
    public boolean tryUpdateLock(long address, long time, TimeUnit unit) {
        return this.tryUpdateLock(address) || this.tryUpdateLock0(address, time, unit);
    }

    private boolean tryUpdateLock0(long address, long time, TimeUnit unit) {
        long timeInNanos = unit.toNanos(time);
        if (timeInNanos < 2000000L) {
            return this.tryUpdateLockNanos(address, timeInNanos);
        }
        return this.tryUpdateLockMillis(address, BigSegmentHeader.roundUpNanosToMillis(timeInNanos));
    }

    private boolean tryUpdateLockNanos(long address, long timeInNanos) {
        long end = System.nanoTime() + timeInNanos;
        do {
            if (!this.tryUpdateLock(address)) continue;
            return true;
        } while (System.nanoTime() <= end);
        return false;
    }

    private boolean tryUpdateLockMillis(long address, long timeInMillis) {
        long lastTime = System.currentTimeMillis();
        do {
            if (this.tryUpdateLock(address)) {
                return true;
            }
            long now = System.currentTimeMillis();
            if (now == lastTime) continue;
            lastTime = now;
            --timeInMillis;
        } while (timeInMillis >= 0L);
        return false;
    }

    @Override
    public void writeLock(long address) {
        if (!this.tryWriteLock(address, 2L, TimeUnit.SECONDS)) {
            throw new RuntimeException("Dead lock");
        }
    }

    @Override
    public void writeLockInterruptibly(long address) {
        this.writeLock(address);
    }

    @Override
    public boolean tryWriteLock(long address) {
        return LOCK.tryWriteLock((Access)A, null, address + 0L);
    }

    @Override
    public boolean tryWriteLock(long address, long time, TimeUnit unit) {
        return this.tryWriteLock(address) || this.tryWriteLock0(address, time, unit);
    }

    private boolean tryWriteLock0(long address, long time, TimeUnit unit) {
        long timeInNanos = unit.toNanos(time);
        if (timeInNanos < 2000000L) {
            return this.tryWriteLockNanos(address, timeInNanos);
        }
        return this.tryWriteLockMillis(address, BigSegmentHeader.roundUpNanosToMillis(timeInNanos));
    }

    private boolean tryWriteLockNanos(long address, long timeInNanos) {
        long end = System.nanoTime() + timeInNanos;
        BigSegmentHeader.registerWait(address);
        do {
            if (!LOCK.tryWriteLockAndDeregisterWait((Access)A, null, address + 0L)) continue;
            return true;
        } while (System.nanoTime() <= end);
        BigSegmentHeader.deregisterWait(address);
        return false;
    }

    private boolean tryWriteLockMillis(long address, long timeInMillis) {
        long lastTime = System.currentTimeMillis();
        BigSegmentHeader.registerWait(address);
        do {
            if (LOCK.tryWriteLockAndDeregisterWait((Access)A, null, address + 0L)) {
                return true;
            }
            long now = System.currentTimeMillis();
            if (now == lastTime) continue;
            lastTime = now;
            --timeInMillis;
        } while (timeInMillis >= 0L);
        BigSegmentHeader.deregisterWait(address);
        return false;
    }

    private static void registerWait(long address) {
        LOCK.registerWait((Access)A, null, address + 0L);
    }

    private static void deregisterWait(long address) {
        LOCK.deregisterWait((Access)A, null, address + 0L);
    }

    @Override
    public void upgradeUpdateToWriteLock(long address) {
        if (!this.tryUpgradeUpdateToWriteLock(address, 2L, TimeUnit.SECONDS)) {
            throw new RuntimeException("Dead lock");
        }
    }

    @Override
    public void upgradeUpdateToWriteLockInterruptibly(long address) {
        this.upgradeUpdateToWriteLock(address);
    }

    @Override
    public boolean tryUpgradeUpdateToWriteLock(long address) {
        return LOCK.tryUpgradeUpdateToWriteLock((Access)A, null, address + 0L);
    }

    @Override
    public boolean tryUpgradeUpdateToWriteLock(long address, long time, TimeUnit unit) {
        return this.tryUpgradeUpdateToWriteLock(address) || this.tryUpgradeUpdateToWriteLock0(address, time, unit);
    }

    private boolean tryUpgradeUpdateToWriteLock0(long address, long time, TimeUnit unit) {
        long timeInNanos = unit.toNanos(time);
        if (timeInNanos < 2000000L) {
            return this.tryUpgradeUpdateToWriteLockNanos(address, timeInNanos);
        }
        return this.tryUpgradeUpdateToWriteLockMillis(address, BigSegmentHeader.roundUpNanosToMillis(timeInNanos));
    }

    private boolean tryUpgradeUpdateToWriteLockNanos(long address, long timeInNanos) {
        long end = System.nanoTime() + timeInNanos;
        BigSegmentHeader.registerWait(address);
        do {
            if (!LOCK.tryUpgradeUpdateToWriteLockAndDeregisterWait((Access)A, null, address + 0L)) continue;
            return true;
        } while (System.nanoTime() <= end);
        BigSegmentHeader.deregisterWait(address);
        return false;
    }

    private boolean tryUpgradeUpdateToWriteLockMillis(long address, long timeInMillis) {
        long lastTime = System.currentTimeMillis();
        BigSegmentHeader.registerWait(address);
        do {
            if (LOCK.tryUpgradeUpdateToWriteLockAndDeregisterWait((Access)A, null, address + 0L)) {
                return true;
            }
            long now = System.currentTimeMillis();
            if (now == lastTime) continue;
            lastTime = now;
            --timeInMillis;
        } while (timeInMillis >= 0L);
        BigSegmentHeader.deregisterWait(address);
        return false;
    }

    @Override
    public void readUnlock(long address) {
        LOCK.readUnlock((Access)A, null, address + 0L);
    }

    @Override
    public void updateUnlock(long address) {
        LOCK.updateUnlock((Access)A, null, address + 0L);
    }

    @Override
    public void downgradeUpdateToReadLock(long address) {
        LOCK.downgradeUpdateToReadLock((Access)A, null, address + 0L);
    }

    @Override
    public void writeUnlock(long address) {
        LOCK.writeUnlock((Access)A, null, address + 0L);
    }

    @Override
    public void downgradeWriteToUpdateLock(long address) {
        LOCK.downgradeWriteToUpdateLock((Access)A, null, address + 0L);
    }

    @Override
    public void downgradeWriteToReadLock(long address) {
        LOCK.downgradeWriteToReadLock((Access)A, null, address + 0L);
    }

    @Override
    public void resetLock(long address) {
        LOCK.reset((Access)A, null, address + 0L);
    }

    @Override
    public long resetLockState() {
        return LOCK.resetState();
    }

    @Override
    public long getLockState(long address) {
        return LOCK.getState((ReadAccess)A, null, address + 0L);
    }

    @Override
    public String lockStateToString(long lockState) {
        return LOCK.toString(lockState);
    }
}

