/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import net.openhft.chronicle.hash.replication.RemoteOperationContext;
import net.openhft.chronicle.hash.replication.ReplicableEntry;

public final class DefaultEventualConsistencyStrategy {
    public static AcceptanceDecision decideOnRemoteModification(ReplicableEntry entry, RemoteOperationContext<?> context) {
        long originTimestamp;
        long remoteTimestamp = context.remoteTimestamp();
        boolean shouldAccept = remoteTimestamp > (originTimestamp = entry.originTimestamp()) || remoteTimestamp == originTimestamp && context.remoteIdentifier() <= entry.originIdentifier();
        return shouldAccept ? AcceptanceDecision.ACCEPT : AcceptanceDecision.DISCARD;
    }

    private DefaultEventualConsistencyStrategy() {
    }

    public static enum AcceptanceDecision {
        ACCEPT,
        DISCARD;

    }
}

