/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.io.Serializable;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.hash.serialization.impl.EnumMarshallable;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public interface HashSplitting
extends Serializable,
Marshallable {
    public int segmentIndex(long var1);

    public long segmentHash(long var1);

    public static class ForNonPowerOf2Segments
    implements HashSplitting {
        private static final long serialVersionUID = 0L;
        private static final int MASK = Integer.MAX_VALUE;
        private static final int BITS = 31;
        private int segments;

        public ForNonPowerOf2Segments(int segments) {
            this.segments = segments;
        }

        @Override
        public int segmentIndex(long hash) {
            return ((int)hash & Integer.MAX_VALUE) % this.segments;
        }

        @Override
        public long segmentHash(long hash) {
            return hash >>> 31;
        }

        public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
            this.segments = wire.read(() -> "segments").int32();
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write(() -> "segments").int32(this.segments);
        }
    }

    public static class ForPowerOf2Segments
    implements HashSplitting {
        private static final long serialVersionUID = 0L;
        private int mask;
        private int bits;

        ForPowerOf2Segments(int segments) {
            this.mask = segments - 1;
            this.bits = Integer.numberOfTrailingZeros(segments);
        }

        @Override
        public int segmentIndex(long hash) {
            return (int)hash & this.mask;
        }

        @Override
        public long segmentHash(long hash) {
            return hash >>> this.bits;
        }

        public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
            this.mask = wire.read(() -> "mask").int32();
            this.bits = wire.read(() -> "bits").int32();
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write(() -> "mask").int32(this.mask);
            wire.write(() -> "bits").int32(this.bits);
        }
    }

    public static enum ForSingleSegment implements HashSplitting,
    EnumMarshallable<ForSingleSegment>
    {
        INSTANCE;


        @Override
        public int segmentIndex(long hash) {
            return 0;
        }

        @Override
        public long segmentHash(long hash) {
            return hash;
        }

        public ForSingleSegment readResolve() {
            return INSTANCE;
        }
    }

    public static class Splitting {
        static HashSplitting forSegments(int segments) {
            assert (segments > 0);
            if (segments == 1) {
                return ForSingleSegment.INSTANCE;
            }
            if (Maths.isPowerOf2((long)segments)) {
                return new ForPowerOf2Segments(segments);
            }
            return new ForNonPowerOf2Segments(segments);
        }
    }
}

