/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.query;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.stage.data.bytes.InputKeyBytesData;
import net.openhft.chronicle.hash.impl.stage.query.HashQuery;
import net.openhft.chronicle.hash.impl.stage.query.KeySearch;
import net.openhft.chronicle.hash.impl.stage.query.SearchAllocatedChunks;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.map.impl.stage.entry.MapEntryStages;
import net.openhft.chronicle.map.impl.stage.query.Absent;
import net.openhft.chronicle.map.impl.stage.query.AcquireHandle;
import net.openhft.chronicle.map.impl.stage.query.MapAbsent;
import net.openhft.chronicle.map.impl.stage.query.MapAndSetContext;
import net.openhft.chronicle.map.impl.stage.ret.DefaultReturnValue;
import net.openhft.chronicle.map.impl.stage.ret.UsingReturnValue;
import net.openhft.chronicle.set.ExternalSetQueryContext;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Staged
public abstract class MapQuery<K, V, R>
extends HashQuery<K>
implements MapEntry<K, V>,
ExternalMapQueryContext<K, V, R>,
ExternalSetQueryContext<K, R>,
QueryContextInterface<K, V, R>,
MapAndSetContext<K, V, R> {
    @StageRef
    public AcquireHandle<K, V> acquireHandle;
    @StageRef
    public DefaultReturnValue<V> defaultReturnValue;
    @StageRef
    public UsingReturnValue<V> usingReturnValue;
    @StageRef
    public MapAbsent<K, V> absent;
    @StageRef
    VanillaChronicleMapHolder<K, V, R> mh;
    final DataAccess<V> innerInputValueDataAccess;
    @StageRef
    MapEntryStages<K, V> e;
    @StageRef
    SearchAllocatedChunks allocatedChunks;
    @StageRef
    KeySearch<K> ks;
    @StageRef
    InputKeyBytesData<K> inputKeyBytesData;
    @Stage(value="InputValueDataAccess")
    private boolean inputValueDataAccessInitialized;

    public MapQuery() {
        this.innerInputValueDataAccess = (DataAccess)this.mh.m().valueDataAccess.copy();
        this.inputValueDataAccessInitialized = false;
    }

    void initInputValueDataAccess() {
        this.inputValueDataAccessInitialized = true;
    }

    void closeInputValueDataAccess() {
        this.innerInputValueDataAccess.uninit();
        this.inputValueDataAccessInitialized = false;
    }

    @Override
    public DataAccess<V> inputValueDataAccess() {
        this.initInputValueDataAccess();
        return this.innerInputValueDataAccess;
    }

    @Override
    public MapQuery<K, V, R> entry() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.entryPresent() ? this : null;
    }

    @Override
    @Nullable
    public Absent<K, V> absentEntry() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.entryPresent() ? null : this.absent;
    }

    protected void putPrefix() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        if (!this.s.innerUpdateLock.isHeldByCurrentThread()) {
            this.s.innerUpdateLock.lock();
        }
        if (this.s.nestedContextsLockedOnSameSegment && this.s.rootContextLockedOnThisSegment.latestSameThreadSegmentModCount() != this.s.contextModCount && this.hlp.hashLookupPosInit() && this.ks.searchStateAbsent()) {
            this.hlp.closeHashLookupPos();
        }
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.putPrefix();
        if (!this.entryPresent()) {
            throw new IllegalStateException(this.mh.h().toIdentityString() + ": Entry is absent in the map when doReplaceValue() is called");
        }
        this.e.innerDefaultReplaceValue(newValue);
        this.s.incrementModCount();
        this.ks.setSearchState(KeySearch.SearchState.PRESENT);
        this.initPresenceOfEntry(HashQuery.EntryPresence.PRESENT);
    }

    @Override
    @NotNull
    public MapQuery<K, V, R> context() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this;
    }

    @Override
    public Data<K> getInputKeyBytesAsData(BytesStore<?, ?> bytesStore, long offset, long size) {
        this.inputKeyBytesData.initInputKeyBytesStore(bytesStore, offset, size);
        return this.inputKeyBytesData;
    }
}

