/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.SizedWriter;
import net.openhft.chronicle.hash.serialization.impl.EnumMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LongMarshaller
implements SizedReader<Long>,
BytesReader<Long>,
SizedWriter<Long>,
BytesWriter<Long>,
EnumMarshallable<LongMarshaller> {
    public static final LongMarshaller INSTANCE = new LongMarshaller();

    private LongMarshaller() {
    }

    @Override
    public long size(@NotNull Long toWrite) {
        return 8L;
    }

    @Override
    @NotNull
    public Long read(@NotNull Bytes in, long size, @Nullable Long using) {
        return in.readLong();
    }

    @Override
    public void write(@NotNull Bytes out, long size, @NotNull Long toWrite) {
        out.writeLong(toWrite.longValue());
    }

    @Override
    @NotNull
    public Long read(Bytes<?> in, @Nullable Long using) {
        return in.readLong();
    }

    @Override
    public void write(Bytes<?> out, @NotNull Long toWrite) {
        out.writeLong(toWrite.longValue());
    }

    @NotNull
    public LongMarshaller readResolve() {
        return INSTANCE;
    }
}

