/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntegerDataAccess_3_13
extends AbstractData<Integer>
implements DataAccess<Integer>,
Data<Integer> {
    private transient boolean bsInit;
    private transient BytesStore<?, ?> bs;
    private transient Integer instance;

    public IntegerDataAccess_3_13() {
        this.initTransients();
    }

    private void initTransients() {
        this.bs = BytesStore.wrap((byte[])new byte[4]);
    }

    @Override
    public RandomDataInput bytes() {
        if (!this.bsInit) {
            this.bs.writeInt(0L, this.instance.intValue());
            this.bsInit = true;
        }
        return this.bs;
    }

    @Override
    public long offset() {
        return 0L;
    }

    @Override
    public long size() {
        return 4L;
    }

    @Override
    public Integer get() {
        return this.instance;
    }

    @Override
    public Integer getUsing(@Nullable Integer using) {
        return this.instance;
    }

    @Override
    public long hash(LongHashFunction f) {
        return f.hashInt(this.instance.intValue());
    }

    @Override
    public boolean equivalent(RandomDataInput source, long sourceOffset) {
        return source.readInt(sourceOffset) == this.instance.intValue();
    }

    @Override
    public void writeTo(RandomDataOutput target, long targetOffset) {
        target.writeInt(targetOffset, this.instance.intValue());
    }

    @Override
    public Data<Integer> getData(@NotNull Integer instance) {
        this.instance = instance;
        this.bsInit = false;
        return this;
    }

    @Override
    public void uninit() {
        this.instance = null;
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
        this.initTransients();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
    }

    @Override
    public DataAccess<Integer> copy() {
        return new IntegerDataAccess_3_13();
    }
}

