/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.openhft.chronicle.core.CleaningRandomAccessFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.ChronicleFileLockException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CanonicalRandomAccessFiles {
    private static final String DISABLE_LOCKING = "chronicle.map.disable.locking";
    private static final boolean USE_EXCLUSIVE_LOCKING = !Jvm.getBoolean((String)"chronicle.map.disable.locking");
    private static final boolean USE_SHARED_LOCKING = !OS.isWindows() && !Jvm.getBoolean((String)"chronicle.map.disable.locking") && !"shared".equalsIgnoreCase(System.getProperty("chronicle.map.disable.locking"));
    private static final AtomicBoolean LOCK_WARNING_PRINTED = new AtomicBoolean();
    private static final ConcurrentHashMap<File, RafReference> CANONICAL_RAFS = new ConcurrentHashMap();

    private CanonicalRandomAccessFiles() {
    }

    public static RandomAccessFile acquire(@NotNull File file) throws FileNotFoundException {
        return CanonicalRandomAccessFiles.acquire0(file, ref -> {}).raf;
    }

    private static RafReference acquire0(@NotNull File file, Consumer<RafReference> action) {
        return CANONICAL_RAFS.compute(file, (f, ref) -> {
            block5: {
                if (ref != null) {
                    try {
                        ((RafReference)ref).raf.length();
                    }
                    catch (IOException e) {
                        break block5;
                    }
                    ((RafReference)ref).refCount++;
                    action.accept((RafReference)ref);
                    return ref;
                }
            }
            try {
                return new RafReference((RandomAccessFile)new CleaningRandomAccessFile(f, "rw"));
            }
            catch (FileNotFoundException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        });
    }

    public static void release(@NotNull File file) {
        CanonicalRandomAccessFiles.release0(file, ref -> {});
    }

    private static RafReference release0(@NotNull File file, Consumer<RafReference> action) {
        return CANONICAL_RAFS.computeIfPresent(file, (f, ref) -> {
            action.accept((RafReference)ref);
            if (--((RafReference)ref).refCount == 0) {
                try {
                    ((RafReference)ref).raf.close();
                }
                catch (IOException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                return null;
            }
            return ref;
        });
    }

    public static void acquireSharedFileLock(@NotNull File canonicalFile, @NotNull FileChannel channel) {
        if (USE_SHARED_LOCKING) {
            CanonicalRandomAccessFiles.acquire0(canonicalFile, rafReference -> {
                try {
                    if (((RafReference)rafReference).lockRef == null) {
                        ((RafReference)rafReference).lockRef = new FileLockReference(channel.lock(0L, Long.MAX_VALUE, true));
                    } else {
                        if (!((RafReference)rafReference).lockRef.fileLock.isShared()) {
                            throw CanonicalRandomAccessFiles.newUnableToAcquireSharedFileLockException(canonicalFile, null);
                        }
                        ((RafReference)rafReference).lockRef.reserve();
                    }
                }
                catch (IOException | IllegalStateException e) {
                    throw CanonicalRandomAccessFiles.newUnableToAcquireSharedFileLockException(canonicalFile, e);
                }
            });
        } else {
            CanonicalRandomAccessFiles.printWarningTheFirstTime();
        }
    }

    public static void acquireExclusiveFileLock(@NotNull File canonicalFile, @NotNull FileChannel channel) {
        if (USE_EXCLUSIVE_LOCKING) {
            CanonicalRandomAccessFiles.acquire0(canonicalFile, rafReference -> {
                if (((RafReference)rafReference).lockRef == null) {
                    try {
                        FileLock fileLock = channel.lock(0L, Long.MAX_VALUE, false);
                        ((RafReference)rafReference).lockRef = new FileLockReference(fileLock);
                    }
                    catch (IOException e) {
                        throw CanonicalRandomAccessFiles.newUnableToAcquireExclusiveFileLockException(canonicalFile, e);
                    }
                } else {
                    throw CanonicalRandomAccessFiles.newUnableToAcquireExclusiveFileLockException(canonicalFile, null);
                }
            });
        } else {
            CanonicalRandomAccessFiles.printWarningTheFirstTime();
        }
    }

    public static void releaseSharedFileLock(@NotNull File canonicalFile) {
        if (USE_SHARED_LOCKING) {
            CanonicalRandomAccessFiles.releaseFileLock0(canonicalFile);
        } else {
            CanonicalRandomAccessFiles.printWarningTheFirstTime();
        }
    }

    public static void releaseExclusiveFileLock(@NotNull File canonicalFile) {
        if (USE_EXCLUSIVE_LOCKING) {
            CanonicalRandomAccessFiles.releaseFileLock0(canonicalFile);
        } else {
            CanonicalRandomAccessFiles.printWarningTheFirstTime();
        }
    }

    private static void releaseFileLock0(@NotNull File canonicalFile) {
        CanonicalRandomAccessFiles.release0(canonicalFile, rafReference -> {
            if (((RafReference)rafReference).lockRef == null) {
                throw new ChronicleFileLockException("Trying to release lock on file " + canonicalFile + " that did not exist");
            }
            int cnt = ((RafReference)rafReference).lockRef.release();
            if (cnt == 0) {
                ((RafReference)rafReference).lockRef = null;
            }
        });
    }

    public static boolean tryRunExclusively(@NotNull File canonicalFile, @NotNull FileChannel fileChannel, @NotNull FileIOAction fileIOAction) {
        AtomicBoolean locked = new AtomicBoolean(false);
        CanonicalRandomAccessFiles.acquire0(canonicalFile, rafReference -> {
            if (((RafReference)rafReference).lockRef != null) {
                return;
            }
            try {
                if (USE_EXCLUSIVE_LOCKING) {
                    try (FileLock ignored2 = fileChannel.tryLock();){
                        if (ignored2 == null) {
                            ((RafReference)rafReference).lockRef = null;
                            return;
                        }
                        fileIOAction.fileIOAction();
                        locked.set(true);
                    }
                    catch (OverlappingFileLockException ignored2) {}
                } else {
                    fileIOAction.fileIOAction();
                    locked.set(true);
                }
                ((RafReference)rafReference).lockRef = null;
            }
            catch (Exception e) {
                throw Jvm.rethrow((Throwable)e);
            }
        });
        CanonicalRandomAccessFiles.release(canonicalFile);
        return locked.get();
    }

    public static void runExclusively(@NotNull File canonicalFile, @NotNull FileChannel fileChannel, @NotNull FileIOAction fileIOAction) {
        CanonicalRandomAccessFiles.acquire0(canonicalFile, rafReference -> {
            block16: {
                if (((RafReference)rafReference).lockRef != null) {
                    throw new ChronicleFileLockException("A file lock instance already exists for the file " + canonicalFile);
                }
                try {
                    if (USE_EXCLUSIVE_LOCKING) {
                        try (FileLock ignored = fileChannel.lock();){
                            fileIOAction.fileIOAction();
                            break block16;
                        }
                    }
                    fileIOAction.fileIOAction();
                }
                catch (Exception e) {
                    throw Jvm.rethrow((Throwable)e);
                }
            }
        });
    }

    static void dump() {
        System.out.println(CANONICAL_RAFS);
    }

    private static ChronicleFileLockException newUnableToAcquireSharedFileLockException(@NotNull File canonicalFile, @Nullable Exception e) {
        return new ChronicleFileLockException("Unable to acquire a shared file lock for " + canonicalFile + ". Make sure another process is not recovering the map.", e);
    }

    private static ChronicleFileLockException newUnableToAcquireExclusiveFileLockException(@NotNull File canonicalFile, @Nullable Exception e) {
        return new ChronicleFileLockException("Unable to acquire an exclusive file lock for " + canonicalFile + ". Make sure no other process is using the map.", e);
    }

    private static void printWarningTheFirstTime() {
        if (LOCK_WARNING_PRINTED.compareAndSet(false, true)) {
            Jvm.warn().on(CanonicalRandomAccessFiles.class, "File locking is disabled or not supported on this platform (" + System.getProperty("os.name") + "). Make sure you are not running ChronicleMapBuilder::*recover* methods when other processes or threads have the mapped file open!");
        }
    }

    private static final class RafReference {
        private final RandomAccessFile raf;
        private FileLockReference lockRef;
        private int refCount;

        RafReference(@NotNull RandomAccessFile raf) {
            this.raf = raf;
            this.lockRef = null;
            this.refCount = 1;
        }

        public String toString() {
            return "RafReference{raf=" + this.raf + ", lockRef=" + this.lockRef + ", refCount=" + this.refCount + '}';
        }
    }

    @FunctionalInterface
    public static interface FileIOAction {
        public void fileIOAction() throws IOException;
    }

    public static final class FileLockReference {
        private final FileLock fileLock;
        private int refCount;

        FileLockReference(@NotNull FileLock fileLock) {
            this.fileLock = fileLock;
            this.refCount = 1;
        }

        int reserve() {
            if (this.refCount == 0) {
                throw new IllegalStateException("Ref counter previously released");
            }
            return ++this.refCount;
        }

        int release() {
            int cnt;
            if ((cnt = --this.refCount) == 0) {
                try {
                    this.fileLock.release();
                }
                catch (IOException e) {
                    throw new ChronicleFileLockException(e);
                }
            }
            if (cnt < 0) {
                throw new IllegalStateException("Ref counter was " + cnt);
            }
            return cnt;
        }

        public String toString() {
            return "FileLockReference{fileLock=" + this.fileLock + ", refCount=" + this.refCount + '}';
        }
    }
}

