/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util.jna;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import net.openhft.chronicle.core.Jvm;

public final class PosixFallocate {
    private PosixFallocate() {
    }

    public static void fallocate(FileDescriptor descriptor, long offset, long length) throws IOException {
        int ret;
        int fd = PosixFallocate.getNativeFileDescriptor(descriptor);
        if (fd != -1 && (ret = PosixFallocate.posix_fallocate(PosixFallocate.getNativeFileDescriptor(descriptor), offset, length)) != 0) {
            throw new IOException("posix_fallocate() returned " + ret);
        }
    }

    private static native int posix_fallocate(int var0, long var1, long var3);

    private static int getNativeFileDescriptor(FileDescriptor descriptor) throws IOException {
        try {
            Field field = descriptor.getClass().getDeclaredField("fd");
            Jvm.setAccessible((AccessibleObject)field);
            return (Integer)field.get(descriptor);
        }
        catch (Exception e) {
            throw new IOException("unsupported FileDescriptor implementation", e);
        }
    }

    static {
        Native.register((String)Platform.C_LIBRARY_NAME);
    }
}

