/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.query;

import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.stage.query.HashQuery;
import net.openhft.chronicle.hash.impl.stage.query.KeySearch;
import net.openhft.chronicle.hash.impl.stage.query.SearchAllocatedChunks;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.impl.MapAbsentEntryHolder;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.map.impl.stage.entry.MapEntryStages;
import net.openhft.chronicle.map.impl.stage.query.AcquireHandle;
import net.openhft.chronicle.map.impl.stage.ret.DefaultReturnValue;
import net.openhft.chronicle.map.impl.stage.ret.UsingReturnValue;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Staged
public abstract class MapQuery<K, V, R>
extends HashQuery<K>
implements MapEntry<K, V>,
ExternalMapQueryContext<K, V, R>,
QueryContextInterface<K, V, R> {
    @StageRef
    VanillaChronicleMapHolder<K, V, R> mh;
    @StageRef
    MapEntryStages<K, V> e;
    @StageRef
    SearchAllocatedChunks allocatedChunks;
    @StageRef
    KeySearch<K> ks;
    @StageRef
    public AcquireHandle<K, V> acquireHandle;
    @StageRef
    public DefaultReturnValue<V> defaultReturnValue;
    @StageRef
    public UsingReturnValue<V> usingReturnValue;
    @StageRef
    public MapAbsentEntryHolder<K, V> absent;
    final DataAccess<V> innerInputValueDataAccess;
    @Stage(value="InputValueDataAccess")
    private boolean inputValueDataAccessInitialized;

    public MapQuery() {
        this.innerInputValueDataAccess = (DataAccess)this.mh.m().valueDataAccess.copy();
        this.inputValueDataAccessInitialized = false;
    }

    void initInputValueDataAccess() {
        this.inputValueDataAccessInitialized = true;
    }

    void closeInputValueDataAccess() {
        this.innerInputValueDataAccess.uninit();
        this.inputValueDataAccessInitialized = false;
    }

    @Override
    public DataAccess<V> inputValueDataAccess() {
        this.initInputValueDataAccess();
        return this.innerInputValueDataAccess;
    }

    @Override
    public MapEntry<K, V> entry() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.entryPresent() ? this : null;
    }

    @Override
    @Nullable
    public MapAbsentEntry<K, V> absentEntry() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.entryPresent() ? null : this.absent.absent();
    }

    protected void putPrefix() {
        boolean searchResultsNotTrusted;
        boolean underUpdatedLockIsHeld;
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        boolean bl = underUpdatedLockIsHeld = !this.s.innerUpdateLock.isHeldByCurrentThread();
        if (underUpdatedLockIsHeld) {
            this.s.innerUpdateLock.lock();
        }
        boolean bl2 = searchResultsNotTrusted = underUpdatedLockIsHeld || this.s.nestedContextsLockedOnSameSegment;
        if (this.hlp.hashLookupPosInit() && this.ks.searchStateAbsent() && searchResultsNotTrusted) {
            this.hlp.closeHashLookupPos();
        }
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.doReplaceValueWithoutChecksum(newValue);
        this.e.checksumStrategy.computeAndStoreChecksum();
    }

    public void doReplaceValueWithoutChecksum(Data<V> newValue) {
        this.putPrefix();
        if (!this.entryPresent()) {
            throw new IllegalStateException("Entry is absent in the map when doReplaceValue() is called");
        }
        this.e.innerDefaultReplaceValue(newValue);
        this.s.incrementModCount();
        this.ks.setSearchState(KeySearch.SearchState.PRESENT);
        this.initPresenceOfEntry(HashQuery.EntryPresence.PRESENT);
    }

    @Override
    @NotNull
    public MapContext<K, V, ?> context() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this;
    }
}

