/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.replication.UdpTransportConfig;
import net.openhft.chronicle.map.AbstractChannelReplicator;
import net.openhft.chronicle.map.EntryReader;
import net.openhft.chronicle.map.EntryWriter;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.UdpChannelReplicator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UdpReplicator
extends UdpChannelReplicator
implements Replica.ModificationNotifier,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)UdpReplicator.class.getName());
    public static final int UPD_BUFFER_SIZE = 77056;

    public UdpReplicator(@NotNull Replica replica, @NotNull Replica.EntryExternalizable entryExternalizable, @NotNull UdpTransportConfig replicationConfig) throws IOException {
        super(replicationConfig, replica.identifier());
        Replica.ModificationIterator modificationIterator = replica.acquireModificationIterator((byte)127);
        modificationIterator.setModificationNotifier(this);
        this.setReader(new UdpSocketChannelEntryReader(replicationConfig.udpBufferSize(), entryExternalizable));
        this.setWriter(new UdpSocketChannelEntryWriter(replicationConfig.udpBufferSize(), entryExternalizable, modificationIterator, this, 77056));
        this.start();
    }

    private static class UdpSocketChannelEntryWriter
    implements EntryWriter {
        private final AbstractChannelReplicator.EntryCallback entryCallback;
        private final UdpChannelReplicator udpReplicator;
        private final Bytes<ByteBuffer> entryIn;
        private Replica.ModificationIterator modificationIterator;

        UdpSocketChannelEntryWriter(int updBufferSize, @NotNull Replica.EntryExternalizable externalizable, @NotNull Replica.ModificationIterator modificationIterator, UdpChannelReplicator udpReplicator, int udpBufferSize) {
            this.udpReplicator = udpReplicator;
            this.entryIn = Bytes.elasticByteBuffer((int)udpBufferSize);
            this.entryCallback = new AbstractChannelReplicator.EntryCallback(externalizable, updBufferSize);
            this.modificationIterator = modificationIterator;
        }

        @Override
        public int writeAll(@NotNull DatagramChannel socketChannel) throws InterruptedException, IOException {
            Bytes<ByteBuffer> in = this.entryIn;
            ByteBuffer out = (ByteBuffer)this.entryIn.underlyingObject();
            out.clear();
            in.clear();
            in.writeSkip(4L);
            boolean wasDataRead = this.modificationIterator.nextEntry(this.entryCallback, 0);
            if (!wasDataRead) {
                this.udpReplicator.disableWrites();
                return 0;
            }
            in.writeShort(0L, (short)(~in.readUnsignedShort(4L)));
            out.limit((int)in.writePosition());
            return socketChannel.write(out);
        }
    }

    private class UdpSocketChannelEntryReader
    implements EntryReader {
        private final Replica.EntryExternalizable externalizable;
        private final ByteBuffer socketIn;
        private final Bytes entryOut;

        UdpSocketChannelEntryReader(@NotNull int serializedEntrySize, Replica.EntryExternalizable externalizable) {
            this.socketIn = ByteBuffer.allocateDirect(serializedEntrySize * 2);
            this.externalizable = externalizable;
            this.entryOut = Bytes.wrapForRead((ByteBuffer)this.socketIn.slice());
            this.entryOut.readLimit(0L);
            this.socketIn.clear();
        }

        @Override
        public void readAll(@NotNull DatagramChannel socketChannel) throws IOException, InterruptedException {
            this.entryOut.clear();
            this.socketIn.clear();
            socketChannel.receive(this.socketIn);
            int bytesRead = this.socketIn.position();
            if (bytesRead < 8) {
                return;
            }
            this.entryOut.readLimit((long)this.socketIn.position());
            int invertedSize = this.entryOut.readInt();
            int size = this.entryOut.readInt();
            if (~size != invertedSize) {
                return;
            }
            if (this.entryOut.readRemaining() != (long)size) {
                return;
            }
            this.externalizable.readExternalEntry(this.entryOut);
        }
    }
}

