/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.zip.CRC32;
import net.openhft.chronicle.hash.impl.stage.entry.Crc32;

public enum NativeCrc32 implements Crc32
{
    INSTANCE;

    static final MethodHandle updateByteBuffer;

    @Override
    public int crc32(long addr, long len) {
        if (len > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Native Crc32 checksum doesn't support entries bigger than 2^31 - 1 in size, " + len + " given");
        }
        try {
            return updateByteBuffer.invoke(addr, 0, (int)len);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            updateByteBuffer = lookup.findStatic(CRC32.class, "updateByteBuffer", MethodType.methodType(Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

