/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.locks.AcquisitionStrategies;
import net.openhft.chronicle.algo.locks.AcquisitionStrategy;
import net.openhft.chronicle.algo.locks.LockingStrategy;
import net.openhft.chronicle.algo.locks.TryAcquireOperation;
import net.openhft.chronicle.algo.locks.TryAcquireOperations;
import net.openhft.chronicle.algo.locks.VanillaReadWriteUpdateWithWaitsLockingStrategy;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashBuilderPrivateAPI;
import net.openhft.chronicle.hash.ExternalHashQueryContext;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.VanillaGlobalMutableState;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.DummyReferenceCounted;
import net.openhft.chronicle.hash.impl.HashSplitting;
import net.openhft.chronicle.hash.impl.IntCompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.LongCompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.util.BuildVersion;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.impl.SerializationBuilder;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.values.Values;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VanillaChronicleHash<K, C extends HashEntry<K>, SC extends HashSegmentContext<K, ?>, ECQ extends ExternalHashQueryContext<K>>
implements ChronicleHash<K, C, SC, ECQ>,
Serializable,
Marshallable {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaChronicleHash.class);
    private static final long serialVersionUID = 0L;
    public static final long TIER_COUNTERS_AREA_SIZE = 64L;
    public static final long RESERVED_GLOBAL_MUTABLE_STATE_BYTES = 1024L;
    private String dataFileVersion = BuildVersion.version();
    public transient boolean createdOrInMemory = true;
    public Class<K> keyClass;
    public SizeMarshaller keySizeMarshaller;
    public SizedReader<K> keyReader;
    public DataAccess<K> keyDataAccess;
    public boolean checksumEntries;
    public int actualSegments;
    public HashSplitting hashSplitting;
    public long entriesPerSegment;
    public long chunkSize;
    public int maxChunksPerEntry;
    public long actualChunksPerSegment;
    int segmentHeaderSize;
    public int tierHashLookupValueBits;
    public int tierHashLookupKeyBits;
    public int tierHashLookupEntrySize;
    public long tierHashLookupCapacity;
    long tierHashLookupInnerSize;
    public long tierHashLookupOuterSize;
    public long tierFreeListInnerSize;
    public long tierFreeListOuterSize;
    long tierEntrySpaceInnerSize;
    public int tierEntrySpaceInnerOffset;
    long tierEntrySpaceOuterSize;
    public long tierSize;
    long maxExtraTiers;
    long tierBulkSizeInBytes;
    long tierBulkInnerOffsetToTiers;
    protected long tiersInBulk;
    protected int log2TiersInBulk;
    private transient File file;
    protected transient BytesStore bs;
    public transient List<TierBulkData> tierBulkOffsets;
    public transient long headerSize;
    transient long segmentHeadersOffset;
    transient long segmentsOffset;
    public transient CompactOffHeapLinearHashTable hashLookup;
    protected volatile transient boolean closed = false;
    private transient VanillaGlobalMutableState globalMutableState;
    static final LockingStrategy globalMutableStateLockingStrategy = VanillaReadWriteUpdateWithWaitsLockingStrategy.instance();
    static final TryAcquireOperation<LockingStrategy> globalMutableStateLockTryAcquireOperation = TryAcquireOperations.lock();
    static final AcquisitionStrategy<LockingStrategy, RuntimeException> globalMutableStateLockAcquisitionStrategy = AcquisitionStrategies.spinLoopOrFail((long)2L, (TimeUnit)TimeUnit.SECONDS);
    private static final long GLOBAL_MUTABLE_STATE_LOCK_OFFSET = 0L;
    private static final long GLOBAL_MUTABLE_STATE_VALUE_OFFSET = 8L;

    public VanillaChronicleHash(ChronicleMapBuilder<K, ?> builder) {
        ChronicleHashBuilderPrivateAPI<K> privateAPI = builder.privateAPI();
        SerializationBuilder<K> keyBuilder = privateAPI.keyBuilder();
        this.keyClass = keyBuilder.tClass;
        this.keySizeMarshaller = keyBuilder.sizeMarshaller();
        this.keyReader = keyBuilder.reader();
        this.keyDataAccess = keyBuilder.dataAccess();
        this.actualSegments = privateAPI.actualSegments();
        this.hashSplitting = HashSplitting.Splitting.forSegments(this.actualSegments);
        this.entriesPerSegment = privateAPI.entriesPerSegment();
        this.chunkSize = privateAPI.chunkSize();
        this.maxChunksPerEntry = privateAPI.maxChunksPerEntry();
        this.actualChunksPerSegment = privateAPI.actualChunksPerSegment();
        this.segmentHeaderSize = privateAPI.segmentHeaderSize();
        this.tierHashLookupValueBits = CompactOffHeapLinearHashTable.valueBits(this.actualChunksPerSegment);
        this.tierHashLookupKeyBits = CompactOffHeapLinearHashTable.keyBits(this.entriesPerSegment, this.tierHashLookupValueBits);
        this.tierHashLookupEntrySize = CompactOffHeapLinearHashTable.entrySize(this.tierHashLookupKeyBits, this.tierHashLookupValueBits);
        if (!privateAPI.aligned64BitMemoryOperationsAtomic() && this.tierHashLookupEntrySize > 4) {
            throw new IllegalStateException("aligned64BitMemoryOperationsAtomic() == false, but hash lookup slot is " + this.tierHashLookupEntrySize);
        }
        this.tierHashLookupCapacity = CompactOffHeapLinearHashTable.capacityFor(this.entriesPerSegment);
        this.tierHashLookupInnerSize = this.tierHashLookupCapacity * (long)this.tierHashLookupEntrySize;
        this.tierHashLookupOuterSize = MemoryUnit.CACHE_LINES.align(this.tierHashLookupInnerSize, MemoryUnit.BYTES);
        this.tierFreeListInnerSize = MemoryUnit.LONGS.align(MemoryUnit.BYTES.alignAndConvert(this.actualChunksPerSegment, MemoryUnit.BITS), MemoryUnit.BYTES);
        this.tierFreeListOuterSize = MemoryUnit.CACHE_LINES.align(this.tierFreeListInnerSize, MemoryUnit.BYTES);
        this.tierEntrySpaceInnerSize = this.chunkSize * this.actualChunksPerSegment;
        this.tierEntrySpaceInnerOffset = privateAPI.segmentEntrySpaceInnerOffset();
        this.tierEntrySpaceOuterSize = MemoryUnit.CACHE_LINES.align((long)this.tierEntrySpaceInnerOffset + this.tierEntrySpaceInnerSize, MemoryUnit.BYTES);
        this.tierSize = this.segmentSize();
        this.maxExtraTiers = privateAPI.maxExtraTiers();
        this.tiersInBulk = this.computeNumberOfTiersInBulk();
        this.log2TiersInBulk = Maths.intLog2((long)this.tiersInBulk);
        this.tierBulkInnerOffsetToTiers = this.computeTierBulkInnerOffsetToTiers(this.tiersInBulk);
        this.tierBulkSizeInBytes = this.computeTierBulkBytesSize(this.tiersInBulk);
        this.checksumEntries = privateAPI.checksumEntries();
    }

    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        this.readMarshallableFields(wire);
        this.initTransients();
    }

    protected void readMarshallableFields(@NotNull WireIn wireIn) throws IORuntimeException {
        this.createdOrInMemory = false;
        this.closed = false;
        this.dataFileVersion = wireIn.read(() -> "dataFileVersion").text();
        this.keyClass = wireIn.read(() -> "keyClass").typeLiteral();
        this.keySizeMarshaller = (SizeMarshaller)wireIn.read(() -> "keySizeMarshaller").typedMarshallable();
        this.keyReader = (SizedReader)wireIn.read(() -> "keyReader").typedMarshallable();
        this.keyDataAccess = (DataAccess)wireIn.read(() -> "keyDataAccess").typedMarshallable();
        this.checksumEntries = wireIn.read(() -> "checksumEntries").bool();
        this.actualSegments = wireIn.read(() -> "actualSegments").int32();
        this.hashSplitting = (HashSplitting)wireIn.read(() -> "hashSplitting").typedMarshallable();
        this.entriesPerSegment = wireIn.read(() -> "entriesPerSegment").int64();
        this.chunkSize = wireIn.read(() -> "chunkSize").int64();
        this.maxChunksPerEntry = wireIn.read(() -> "maxChunksPerEntry").int32();
        this.actualChunksPerSegment = wireIn.read(() -> "actualChunksPerSegment").int64();
        this.segmentHeaderSize = wireIn.read(() -> "segmentHeaderSize").int32();
        this.tierHashLookupValueBits = wireIn.read(() -> "tierHashLookupValueBits").int32();
        this.tierHashLookupKeyBits = wireIn.read(() -> "tierHashLookupKeyBits").int32();
        this.tierHashLookupEntrySize = wireIn.read(() -> "tierHashLookupEntrySize").int32();
        this.tierHashLookupCapacity = wireIn.read(() -> "tierHashLookupCapacity").int64();
        this.tierHashLookupInnerSize = wireIn.read(() -> "tierHashLookupInnerSize").int64();
        this.tierHashLookupOuterSize = wireIn.read(() -> "tierHashLookupOuterSize").int64();
        this.tierFreeListInnerSize = wireIn.read(() -> "tierFreeListInnerSize").int64();
        this.tierFreeListOuterSize = wireIn.read(() -> "tierFreeListOuterSize").int64();
        this.tierEntrySpaceInnerSize = wireIn.read(() -> "tierEntrySpaceInnerSize").int64();
        this.tierEntrySpaceInnerOffset = wireIn.read(() -> "tierEntrySpaceInnerOffset").int32();
        this.tierEntrySpaceOuterSize = wireIn.read(() -> "tierEntrySpaceOuterSize").int64();
        this.tierSize = wireIn.read(() -> "tierSize").int64();
        this.maxExtraTiers = wireIn.read(() -> "maxExtraTiers").int64();
        this.tierBulkSizeInBytes = wireIn.read(() -> "tierBulkSizeInBytes").int64();
        this.tierBulkInnerOffsetToTiers = wireIn.read(() -> "tierBulkInnerOffsetToTiers").int64();
        this.tiersInBulk = wireIn.read(() -> "tiersInBulk").int64();
        this.log2TiersInBulk = wireIn.read(() -> "log2TiersInBulk").int32();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write(() -> "dataFileVersion").text((CharSequence)this.dataFileVersion);
        wireOut.write(() -> "keyClass").typeLiteral(this.keyClass);
        wireOut.write(() -> "keySizeMarshaller").typedMarshallable((WriteMarshallable)this.keySizeMarshaller);
        wireOut.write(() -> "keyReader").typedMarshallable(this.keyReader);
        wireOut.write(() -> "keyDataAccess").typedMarshallable(this.keyDataAccess);
        wireOut.write(() -> "checksumEntries").bool(Boolean.valueOf(this.checksumEntries));
        wireOut.write(() -> "actualSegments").int32(this.actualSegments);
        wireOut.write(() -> "hashSplitting").typedMarshallable((WriteMarshallable)this.hashSplitting);
        wireOut.write(() -> "entriesPerSegment").int64(this.entriesPerSegment);
        wireOut.write(() -> "chunkSize").int64(this.chunkSize);
        wireOut.write(() -> "maxChunksPerEntry").int32(this.maxChunksPerEntry);
        wireOut.write(() -> "actualChunksPerSegment").int64(this.actualChunksPerSegment);
        wireOut.write(() -> "segmentHeaderSize").int32(this.segmentHeaderSize);
        wireOut.write(() -> "tierHashLookupValueBits").int32(this.tierHashLookupValueBits);
        wireOut.write(() -> "tierHashLookupKeyBits").int32(this.tierHashLookupKeyBits);
        wireOut.write(() -> "tierHashLookupEntrySize").int32(this.tierHashLookupEntrySize);
        wireOut.write(() -> "tierHashLookupCapacity").int64(this.tierHashLookupCapacity);
        wireOut.write(() -> "tierHashLookupInnerSize").int64(this.tierHashLookupInnerSize);
        wireOut.write(() -> "tierHashLookupOuterSize").int64(this.tierHashLookupOuterSize);
        wireOut.write(() -> "tierFreeListInnerSize").int64(this.tierFreeListInnerSize);
        wireOut.write(() -> "tierFreeListOuterSize").int64(this.tierFreeListOuterSize);
        wireOut.write(() -> "tierEntrySpaceInnerSize").int64(this.tierEntrySpaceInnerSize);
        wireOut.write(() -> "tierEntrySpaceInnerOffset").int32(this.tierEntrySpaceInnerOffset);
        wireOut.write(() -> "tierEntrySpaceOuterSize").int64(this.tierEntrySpaceOuterSize);
        wireOut.write(() -> "tierSize").int64(this.tierSize);
        wireOut.write(() -> "maxExtraTiers").int64(this.maxExtraTiers);
        wireOut.write(() -> "tierBulkSizeInBytes").int64(this.tierBulkSizeInBytes);
        wireOut.write(() -> "tierBulkInnerOffsetToTiers").int64(this.tierBulkInnerOffsetToTiers);
        wireOut.write(() -> "tiersInBulk").int64(this.tiersInBulk);
        wireOut.write(() -> "log2TiersInBulk").int32(this.log2TiersInBulk);
    }

    protected VanillaGlobalMutableState createGlobalMutableState() {
        return (VanillaGlobalMutableState)Values.newNativeReference(VanillaGlobalMutableState.class);
    }

    protected VanillaGlobalMutableState globalMutableState() {
        return this.globalMutableState;
    }

    private long segmentSize() {
        long ss = this.tierHashLookupOuterSize + 64L + this.tierFreeListOuterSize + this.tierEntrySpaceOuterSize;
        if ((ss & 0x3FL) != 0L) {
            throw new AssertionError();
        }
        return this.breakL1CacheAssociativityContention(ss);
    }

    private long breakL1CacheAssociativityContention(long segmentSize) {
        int alignmentToBreak = 2048;
        int eachNthSegmentFallIntoTheSameSet = Math.max(1, alignmentToBreak >> Long.numberOfTrailingZeros(segmentSize));
        if (eachNthSegmentFallIntoTheSameSet < this.actualSegments) {
            segmentSize |= MemoryUnit.CACHE_LINES.toBytes(1L);
        }
        return segmentSize;
    }

    private long computeNumberOfTiersInBulk() {
        int tiersInBulk = this.actualSegments / 8;
        tiersInBulk = Maths.nextPower2((int)tiersInBulk, (int)1);
        while (this.tierSize * (long)tiersInBulk < (long)OS.pageSize()) {
            tiersInBulk *= 2;
        }
        return tiersInBulk;
    }

    private long computeTierBulkBytesSize(long tiersInBulk) {
        return this.computeTierBulkInnerOffsetToTiers(tiersInBulk) + tiersInBulk * this.tierSize;
    }

    protected long computeTierBulkInnerOffsetToTiers(long tiersInBulk) {
        return 0L;
    }

    public void initTransients() {
        this.initOwnTransients();
    }

    private void initOwnTransients() {
        this.globalMutableState = this.createGlobalMutableState();
        this.tierBulkOffsets = new ArrayList<TierBulkData>();
        if (this.tierHashLookupEntrySize == 4) {
            this.hashLookup = new IntCompactOffHeapLinearHashTable(this);
        } else if (this.tierHashLookupEntrySize == 8) {
            this.hashLookup = new LongCompactOffHeapLinearHashTable(this);
        } else {
            throw new AssertionError((Object)("hash lookup slot size could be 4 or 8, " + this.tierHashLookupEntrySize + " observed"));
        }
    }

    public final void initBeforeMapping(FileChannel ch, long headerSize) throws IOException {
        this.headerSize = VanillaChronicleHash.roundUpMapHeaderSize(headerSize);
        if (!this.createdOrInMemory) {
            ByteBuffer globalMutableStateBuffer = ByteBuffer.allocate((int)this.globalMutableState.maxSize());
            while (globalMutableStateBuffer.remaining() > 0) {
                if (ch.read(globalMutableStateBuffer, this.headerSize + 8L + (long)globalMutableStateBuffer.position()) != -1) continue;
                throw new RuntimeException();
            }
            globalMutableStateBuffer.flip();
            this.globalMutableState.bytesStore(BytesStore.wrap((ByteBuffer)globalMutableStateBuffer), 0L, this.globalMutableState.maxSize());
        }
    }

    private static long roundUpMapHeaderSize(long headerSize) {
        long roundUp = headerSize + 127L & 0xFFFFFFFFFFFFFF80L;
        if (roundUp - headerSize < 64L) {
            roundUp += 128L;
        }
        return roundUp;
    }

    public final void createMappedStoreAndSegments(BytesStore bytesStore) throws IOException {
        if (bytesStore.start() != 0L) {
            throw new AssertionError((Object)("bytes store " + bytesStore + " starts from " + bytesStore.start() + ", 0 expected"));
        }
        this.bs = bytesStore;
        this.globalMutableState.bytesStore(this.bs, this.headerSize + 8L, this.globalMutableState.maxSize());
        this.onHeaderCreated();
        this.segmentHeadersOffset = this.segmentHeadersOffset();
        long segmentHeadersSize = this.actualSegments * this.segmentHeaderSize;
        this.segmentsOffset = this.segmentHeadersOffset + segmentHeadersSize;
        if (this.createdOrInMemory) {
            this.zeroOutNewlyMappedChronicleMapBytes();
            this.globalMutableState.setSegmentHeadersOffset(this.segmentHeadersOffset);
        } else if (this.globalMutableState.getAllocatedExtraTierBulks() > 0) {
            this.appendBulkData(0, this.globalMutableState.getAllocatedExtraTierBulks() - 1, this.bs, this.sizeInBytesWithoutTiers());
        }
    }

    public final void createMappedStoreAndSegments(File file, RandomAccessFile raf) throws IOException {
        this.file = file;
        long mapSize = this.expectedFileSize();
        this.createMappedStoreAndSegments((BytesStore)VanillaChronicleHash.map(raf, mapSize, 0L));
    }

    private boolean persisted() {
        return this.file != null;
    }

    protected void zeroOutNewlyMappedChronicleMapBytes() {
        this.zeroOutGlobalMutableState();
        this.zeroOutSegmentHeaders();
        this.zeroOutFirstSegmentTiers();
    }

    private void zeroOutGlobalMutableState() {
        this.bs.zeroOut(this.headerSize, this.headerSize + this.globalMutableStateTotalUsedSize());
    }

    protected long globalMutableStateTotalUsedSize() {
        return 8L + this.globalMutableState().maxSize();
    }

    private void zeroOutSegmentHeaders() {
        this.bs.zeroOut(this.segmentHeadersOffset, this.segmentsOffset);
    }

    private void zeroOutFirstSegmentTiers() {
        for (int segmentIndex = 0; segmentIndex < this.segments(); ++segmentIndex) {
            long segmentOffset = this.segmentOffset(segmentIndex);
            this.zeroOutNewlyMappedTier(this.bs, segmentOffset);
        }
    }

    private void zeroOutNewlyMappedTier(BytesStore bytesStore, long segmentOffset) {
        bytesStore.zeroOut(segmentOffset, segmentOffset + this.tierSize - this.tierEntrySpaceOuterSize);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initOwnTransients();
    }

    public void onHeaderCreated() {
    }

    public String persistedDataVersion() {
        return this.dataFileVersion;
    }

    private long segmentHeadersOffset() {
        if (this.createdOrInMemory) {
            long reserved = 1024L - this.globalMutableStateTotalUsedSize();
            return OS.pageAlign((long)(this.mapHeaderInnerSize() + reserved));
        }
        return this.globalMutableState.getSegmentHeadersOffset();
    }

    public long mapHeaderInnerSize() {
        return this.headerSize + this.globalMutableStateTotalUsedSize();
    }

    @Override
    public File file() {
        return this.file;
    }

    public final long sizeInBytesWithoutTiers() {
        return this.segmentHeadersOffset() + (long)this.actualSegments * ((long)this.segmentHeaderSize + this.tierSize);
    }

    public final long expectedFileSize() {
        long sizeInBytesWithoutTiers = this.sizeInBytesWithoutTiers();
        int allocatedExtraTierBulks = !this.createdOrInMemory ? this.globalMutableState.getAllocatedExtraTierBulks() : 0;
        return OS.pageAlign((long)(sizeInBytesWithoutTiers + (long)allocatedExtraTierBulks * this.tierBulkSizeInBytes));
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.file != null) {
            try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");){
                raf.getChannel().force(true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.bs = null;
        this.file = null;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    public final void checkKey(Object key) {
        if (!this.keyClass.isInstance(key)) {
            throw new ClassCastException("Key must be a " + this.keyClass.getName() + " but was a " + key.getClass());
        }
    }

    public final long[] segmentSizes() {
        long[] sizes = new long[this.actualSegments];
        for (int i = 0; i < this.actualSegments; ++i) {
            sizes[i] = BigSegmentHeader.INSTANCE.size(this.segmentHeaderAddress(i));
        }
        return sizes;
    }

    public final long segmentHeaderAddress(int segmentIndex) {
        return this.bsAddress() + this.segmentHeadersOffset + (long)segmentIndex * (long)this.segmentHeaderSize;
    }

    public long bsAddress() {
        return this.bs.address(0L);
    }

    public final long segmentBaseAddr(int segmentIndex) {
        return this.bsAddress() + this.segmentOffset(segmentIndex);
    }

    private long segmentOffset(long segmentIndex) {
        return this.segmentsOffset + segmentIndex * this.tierSize;
    }

    public final int inChunks(long sizeInBytes) {
        if (sizeInBytes <= this.chunkSize) {
            return 1;
        }
        if (--sizeInBytes <= Integer.MAX_VALUE) {
            return (int)sizeInBytes / (int)this.chunkSize + 1;
        }
        return (int)(sizeInBytes / this.chunkSize) + 1;
    }

    @Override
    public final long longSize() {
        long result = 0L;
        for (int i = 0; i < this.actualSegments; ++i) {
            long segmentHeaderAddress = this.segmentHeaderAddress(i);
            result += BigSegmentHeader.INSTANCE.size(segmentHeaderAddress) - BigSegmentHeader.INSTANCE.deleted(segmentHeaderAddress);
        }
        return result;
    }

    public final int size() {
        long size = this.longSize();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    @Override
    public int segments() {
        return this.actualSegments;
    }

    private long globalMutableStateAddress() {
        return this.bsAddress() + this.headerSize;
    }

    public void globalMutableStateLock() {
        globalMutableStateLockAcquisitionStrategy.acquire(globalMutableStateLockTryAcquireOperation, globalMutableStateLockingStrategy, Access.nativeAccess(), null, this.globalMutableStateAddress() + 0L);
    }

    public void globalMutableStateUnlock() {
        globalMutableStateLockingStrategy.unlock(Access.nativeAccess(), null, this.globalMutableStateAddress() + 0L);
    }

    public long allocateTier(int forSegmentIndex, int tier) {
        LOG.debug("Allocate tier for segment # {}, tier {}", (Object)forSegmentIndex, (Object)tier);
        this.globalMutableStateLock();
        try {
            long tiersInUse = this.globalMutableState.getExtraTiersInUse();
            if (tiersInUse == this.maxExtraTiers) {
                throw new IllegalStateException("Attempt to allocate " + (this.maxExtraTiers + 1L) + "th extra segment tier, " + this.maxExtraTiers + " is maximum.\n" + "Possible reasons include:\n" + " - you have forgotten to configure (or configured wrong) " + "builder.entries() number\n" + " - same regarding other sizing Chronicle Hash configurations, most " + "likely maxBloatFactor(), averageKeySize(), or averageValueSize()\n" + " - keys, inserted into the ChronicleHash, are distributed suspiciously " + "bad. This might be a DOS attack");
            }
            while (true) {
                long firstFreeTierIndex;
                if ((firstFreeTierIndex = this.globalMutableState.getFirstFreeTierIndex()) > 0L) {
                    this.globalMutableState.setExtraTiersInUse(tiersInUse + 1L);
                    BytesStore allocatedTierBytes = this.tierBytesStore(firstFreeTierIndex);
                    long allocatedTierOffset = this.tierBytesOffset(firstFreeTierIndex);
                    long tierBaseAddr = allocatedTierBytes.address(0L) + allocatedTierOffset;
                    long tierCountersAreaAddr = tierBaseAddr + this.tierHashLookupOuterSize;
                    long nextFreeTierIndex = TierCountersArea.nextTierIndex(tierCountersAreaAddr);
                    TierCountersArea.nextTierIndex(tierCountersAreaAddr, 0L);
                    TierCountersArea.segmentIndex(tierCountersAreaAddr, forSegmentIndex);
                    TierCountersArea.tier(tierCountersAreaAddr, tier);
                    this.globalMutableState.setFirstFreeTierIndex(nextFreeTierIndex);
                    long l = firstFreeTierIndex;
                    return l;
                }
                this.allocateTierBulk();
            }
        }
        finally {
            this.globalMutableStateUnlock();
        }
    }

    private void allocateTierBulk() {
        int allocatedExtraTierBulks = this.globalMutableState.getAllocatedExtraTierBulks();
        this.mapTierBulks(allocatedExtraTierBulks);
        long firstTierIndex = (long)this.actualSegments + 1L + (long)allocatedExtraTierBulks * this.tiersInBulk;
        BytesStore tierBytesStore = this.tierBytesStore(firstTierIndex);
        long firstTierOffset = this.tierBytesOffset(firstTierIndex);
        if (this.tierBulkInnerOffsetToTiers > 0L) {
            tierBytesStore.zeroOut(firstTierOffset - this.tierBulkInnerOffsetToTiers, firstTierOffset);
        }
        long lastTierIndex = firstTierIndex + this.tiersInBulk - 1L;
        for (long tierIndex = firstTierIndex; tierIndex <= lastTierIndex; ++tierIndex) {
            long tierOffset = this.tierBytesOffset(tierIndex);
            this.zeroOutNewlyMappedTier(tierBytesStore, tierOffset);
            if (tierIndex >= lastTierIndex) continue;
            long tierCountersAreaOffset = tierOffset + this.tierHashLookupOuterSize;
            TierCountersArea.nextTierIndex(tierBytesStore.address(0L) + tierCountersAreaOffset, tierIndex + 1L);
        }
        this.globalMutableState.setAllocatedExtraTierBulks(allocatedExtraTierBulks + 1);
        this.globalMutableState.setFirstFreeTierIndex(firstTierIndex);
    }

    public long tierIndexToBaseAddr(long tierIndex) {
        long tierIndexMinusOne = tierIndex - 1L;
        if (tierIndexMinusOne < (long)this.actualSegments) {
            return this.segmentBaseAddr((int)tierIndexMinusOne);
        }
        return this.extraTierIndexToBaseAddr(tierIndexMinusOne);
    }

    public BytesStore tierBytesStore(long tierIndex) {
        long tierIndexMinusOne = tierIndex - 1L;
        if (tierIndexMinusOne < (long)this.actualSegments) {
            return this.bs;
        }
        return this.tierBulkData((long)tierIndexMinusOne).bytesStore;
    }

    public long tierBytesOffset(long tierIndex) {
        long tierIndexMinusOne = tierIndex - 1L;
        if (tierIndexMinusOne < (long)this.actualSegments) {
            return this.segmentOffset(tierIndexMinusOne);
        }
        long extraTierIndex = tierIndexMinusOne - (long)this.actualSegments;
        int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
        if (bulkIndex >= this.tierBulkOffsets.size()) {
            this.mapTierBulks(bulkIndex);
        }
        return this.tierBulkOffsets.get((int)bulkIndex).offset + this.tierBulkInnerOffsetToTiers + (extraTierIndex & this.tiersInBulk - 1L) * this.tierSize;
    }

    private TierBulkData tierBulkData(long tierIndexMinusOne) {
        long extraTierIndex = tierIndexMinusOne - (long)this.actualSegments;
        int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
        if (bulkIndex >= this.tierBulkOffsets.size()) {
            this.mapTierBulks(bulkIndex);
        }
        return this.tierBulkOffsets.get(bulkIndex);
    }

    private long extraTierIndexToBaseAddr(long tierIndexMinusOne) {
        long extraTierIndex = tierIndexMinusOne - (long)this.actualSegments;
        int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
        if (bulkIndex >= this.tierBulkOffsets.size()) {
            this.mapTierBulks(bulkIndex);
        }
        TierBulkData tierBulkData = this.tierBulkOffsets.get(bulkIndex);
        long tierIndexOffsetWithinBulk = extraTierIndex & this.tiersInBulk - 1L;
        return this.tierAddr(tierBulkData, tierIndexOffsetWithinBulk);
    }

    protected long tierAddr(TierBulkData tierBulkData, long tierIndexOffsetWithinBulk) {
        return tierBulkData.bytesStore.address(0L) + tierBulkData.offset + this.tierBulkInnerOffsetToTiers + tierIndexOffsetWithinBulk * this.tierSize;
    }

    private void mapTierBulks(int upToBulkIndex) {
        if (this.persisted()) {
            try {
                this.mapTierBulksMapped(upToBulkIndex);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.allocateTierBulks(upToBulkIndex);
        }
    }

    private void mapTierBulksMapped(int upToBulkIndex) throws IOException {
        long firstBulkToMapOffsetWithinMapping;
        long mappingOffsetInFile;
        int firstBulkToMapIndex = this.tierBulkOffsets.size();
        int bulksToMap = upToBulkIndex + 1 - firstBulkToMapIndex;
        long mapSize = (long)bulksToMap * this.tierBulkSizeInBytes;
        long firstBulkToMapOffset = this.bulkOffset(firstBulkToMapIndex);
        if (OS.mapAlign((long)firstBulkToMapOffset) == firstBulkToMapOffset) {
            mappingOffsetInFile = firstBulkToMapOffset;
            firstBulkToMapOffsetWithinMapping = 0L;
        } else {
            mappingOffsetInFile = OS.mapAlign((long)firstBulkToMapOffset) - OS.mapAlignment();
            firstBulkToMapOffsetWithinMapping = firstBulkToMapOffset - mappingOffsetInFile;
            mapSize += firstBulkToMapOffsetWithinMapping;
        }
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");){
            NativeBytesStore extraStore = VanillaChronicleHash.map(raf, mapSize, mappingOffsetInFile);
            this.appendBulkData(firstBulkToMapIndex, upToBulkIndex, (BytesStore)extraStore, firstBulkToMapOffsetWithinMapping);
        }
    }

    private static NativeBytesStore map(RandomAccessFile raf, long mapSize, long mappingOffsetInFile) throws IOException {
        long minFileSize = mappingOffsetInFile + mapSize;
        FileChannel fileChannel = raf.getChannel();
        if (fileChannel.size() < minFileSize) {
            try (FileLock ignored = fileChannel.lock();){
                if (fileChannel.size() < minFileSize) {
                    raf.setLength(minFileSize);
                }
            }
        }
        long address = OS.map((FileChannel)fileChannel, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE, (long)mappingOffsetInFile, (long)mapSize);
        OS.Unmapper unmapper = new OS.Unmapper(address, mapSize, (ReferenceCounted)DummyReferenceCounted.DUMMY_REFERENCE_COUNTED);
        return new NativeBytesStore(address, mapSize, (Runnable)unmapper, false);
    }

    private long bulkOffset(int bulkIndex) {
        return this.sizeInBytesWithoutTiers() + (long)bulkIndex * this.tierBulkSizeInBytes;
    }

    private void allocateTierBulks(int upToBulkIndex) {
        int firstBulkToMapIndex = this.tierBulkOffsets.size();
        int bulksToMap = upToBulkIndex + 1 - firstBulkToMapIndex;
        long mapSize = (long)bulksToMap * this.tierBulkSizeInBytes;
        NativeBytesStore extraStore = NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity((long)mapSize);
        this.appendBulkData(firstBulkToMapIndex, upToBulkIndex, (BytesStore)extraStore, 0L);
    }

    private void appendBulkData(int firstBulkToMapIndex, int upToBulkIndex, BytesStore extraStore, long offsetWithinMapping) {
        TierBulkData firstMappedBulkData = new TierBulkData(extraStore, offsetWithinMapping);
        this.tierBulkOffsets.add(firstMappedBulkData);
        for (int bulkIndex = firstBulkToMapIndex + 1; bulkIndex <= upToBulkIndex; ++bulkIndex) {
            this.tierBulkOffsets.add(new TierBulkData(firstMappedBulkData, offsetWithinMapping += this.tierBulkSizeInBytes));
        }
    }

    public static class TierBulkData {
        public final BytesStore bytesStore;
        public final long offset;

        public TierBulkData(BytesStore bytesStore, long offset) {
            this.bytesStore = bytesStore;
            this.offset = offset;
        }

        public TierBulkData(TierBulkData data, long offset) {
            this.bytesStore = data.bytesStore;
            this.offset = offset;
        }
    }
}

