/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.SizedWriter;
import net.openhft.chronicle.hash.serialization.impl.InstanceCreatingMarshaller;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytesMarshallableReaderWriter<V extends BytesMarshallable>
extends InstanceCreatingMarshaller<V>
implements SizedReader<V>,
SizedWriter<V> {
    private static final ThreadLocal<VanillaBytes> VANILLA_BYTES_TL = ThreadLocal.withInitial(() -> new VanillaBytes(BytesStore.empty()));

    public BytesMarshallableReaderWriter(Class<V> vClass) {
        super(vClass);
    }

    @Override
    @NotNull
    public V read(Bytes in, long size, @Nullable V using) {
        if (using == null) {
            using = (BytesMarshallable)this.createInstance();
        }
        VanillaBytes vanillaBytes = VANILLA_BYTES_TL.get();
        vanillaBytes.bytesStore((BytesStore)in, in.readPosition(), size);
        using.readMarshallable((BytesIn)vanillaBytes);
        return using;
    }

    @Override
    public long size(@NotNull V toWrite) {
        Bytes bytes = Wires.acquireBytes();
        toWrite.writeMarshallable((BytesOut)bytes);
        return bytes.readRemaining();
    }

    @Override
    public void write(Bytes out, long size, @NotNull V toWrite) {
        VanillaBytes vanillaBytes = VANILLA_BYTES_TL.get();
        vanillaBytes.bytesStore((BytesStore)out, out.readPosition(), out.readRemaining());
        vanillaBytes.writeLimit(out.writePosition() + size);
        toWrite.writeMarshallable((BytesOut)vanillaBytes);
    }
}

