/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Stream;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.VanillaGlobalMutableState;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.ReplicatedGlobalMutableState;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.CompiledReplicatedMapIterationContext;
import net.openhft.chronicle.map.impl.CompiledReplicatedMapQueryContext;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.replication.MapRemoteOperations;
import net.openhft.chronicle.values.Values;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedChronicleMap<K, V, R>
extends VanillaChronicleMap<K, V, R>
implements Replica,
Replica.EntryExternalizable {
    public static final int ADDITIONAL_ENTRY_BYTES = 10;
    static final byte ENTRY_HUNK = 1;
    static final byte BOOTSTRAP_TIME_HUNK = 2;
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatedChronicleMap.class);
    public transient boolean cleanupRemovedEntries;
    public transient long cleanupTimeout;
    public transient TimeUnit cleanupTimeoutUnit;
    public transient MapRemoteOperations<K, V, R> remoteOperations;
    transient BitSetFrame tierModIterFrame;
    private long tierModIterBitSetSizeInBits = this.computeTierModIterBitSetSizeInBits();
    private long tierModIterBitSetOuterSize = this.computeTierModIterBitSetOuterSize();
    private long segmentModIterBitSetsForIdentifierOuterSize = this.computeSegmentModIterBitSetsForIdentifierOuterSize();
    private long tierBulkModIterBitSetsForIdentifierOuterSize = this.computeTierBulkModIterBitSetsForIdentifierOuterSize(this.tiersInBulk);
    private transient byte localIdentifier;
    private transient ModificationIterator[] assignedModificationIterators;
    private transient AtomicReferenceArray<ModificationIterator> modificationIterators;
    private transient long startOfModificationIterators;
    private transient long[] remoteNodeCouldBootstrapFrom;

    public ReplicatedChronicleMap(@NotNull ChronicleMapBuilder<K, V> builder) throws IOException {
        super(builder);
    }

    @Override
    protected void readMarshallableFields(@NotNull WireIn wireIn) {
        super.readMarshallableFields(wireIn);
        this.tierModIterBitSetSizeInBits = wireIn.read(() -> "tierModIterBitSetSizeInBits").int64();
        this.tierModIterBitSetOuterSize = wireIn.read(() -> "tierModIterBitSetOuterSize").int64();
        this.segmentModIterBitSetsForIdentifierOuterSize = wireIn.read(() -> "segmentModIterBitSetsForIdentifierOuterSize").int64();
        this.tierBulkModIterBitSetsForIdentifierOuterSize = wireIn.read(() -> "tierBulkModIterBitSetsForIdentifierOuterSize").int64();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wireOut) {
        super.writeMarshallable(wireOut);
        wireOut.write(() -> "tierModIterBitSetSizeInBits").int64(this.tierModIterBitSetSizeInBits);
        wireOut.write(() -> "tierModIterBitSetOuterSize").int64(this.tierModIterBitSetOuterSize);
        wireOut.write(() -> "segmentModIterBitSetsForIdentifierOuterSize").int64(this.segmentModIterBitSetsForIdentifierOuterSize);
        wireOut.write(() -> "tierBulkModIterBitSetsForIdentifierOuterSize").int64(this.tierBulkModIterBitSetsForIdentifierOuterSize);
    }

    @Override
    protected VanillaGlobalMutableState createGlobalMutableState() {
        return (VanillaGlobalMutableState)Values.newNativeReference(ReplicatedGlobalMutableState.class);
    }

    @Override
    public ReplicatedGlobalMutableState globalMutableState() {
        return (ReplicatedGlobalMutableState)super.globalMutableState();
    }

    @Override
    public void initTransients() {
        super.initTransients();
        this.initOwnTransients();
    }

    private void initOwnTransients() {
        this.assignedModificationIterators = new ModificationIterator[0];
        this.modificationIterators = new AtomicReferenceArray(128);
        this.tierModIterFrame = new SingleThreadedFlatBitSetFrame(this.computeTierModIterBitSetSizeInBits());
        this.remoteNodeCouldBootstrapFrom = new long[128];
    }

    @Override
    void initTransientsFromBuilder(ChronicleMapBuilder<K, V> builder) {
        super.initTransientsFromBuilder(builder);
        this.localIdentifier = builder.replicationIdentifier;
        this.remoteOperations = builder.remoteOperations;
        this.cleanupRemovedEntries = builder.cleanupRemovedEntries;
        this.cleanupTimeout = builder.cleanupTimeout;
        this.cleanupTimeoutUnit = builder.cleanupTimeoutUnit;
    }

    private long computeTierModIterBitSetSizeInBits() {
        return MemoryUnit.LONGS.align(this.actualChunksPerSegmentTier, MemoryUnit.BITS);
    }

    private long computeTierModIterBitSetOuterSize() {
        long tierModIterBitSetOuterSize = MemoryUnit.BYTES.convert(this.computeTierModIterBitSetSizeInBits(), MemoryUnit.BITS);
        if (MemoryUnit.CACHE_LINES.align(tierModIterBitSetOuterSize += MemoryUnit.BYTES.convert(2L, MemoryUnit.CACHE_LINES), MemoryUnit.BYTES) == tierModIterBitSetOuterSize) {
            tierModIterBitSetOuterSize = this.breakL1CacheAssociativityContention(tierModIterBitSetOuterSize);
        }
        return tierModIterBitSetOuterSize;
    }

    private long computeSegmentModIterBitSetsForIdentifierOuterSize() {
        return this.computeTierModIterBitSetOuterSize() * (long)this.actualSegments;
    }

    private long computeTierBulkModIterBitSetsForIdentifierOuterSize(long tiersInBulk) {
        return this.computeTierModIterBitSetOuterSize() * tiersInBulk;
    }

    @Override
    protected long computeTierBulkInnerOffsetToTiers(long tiersInBulk) {
        long tierBulkBitSetsInnerSize = this.computeTierBulkModIterBitSetsForIdentifierOuterSize(tiersInBulk) * 128L;
        return super.computeTierBulkInnerOffsetToTiers(tiersInBulk) + MemoryUnit.CACHE_LINES.align(tierBulkBitSetsInnerSize, MemoryUnit.BYTES);
    }

    @Override
    public long mapHeaderInnerSize() {
        return super.mapHeaderInnerSize() + this.segmentModIterBitSetsForIdentifierOuterSize * 128L;
    }

    @Override
    public void setRemoteNodeCouldBootstrapFrom(byte remoteIdentifier, long bootstrapTimestamp) {
        this.remoteNodeCouldBootstrapFrom[remoteIdentifier] = bootstrapTimestamp;
    }

    @Override
    public long remoteNodeCouldBootstrapFrom(byte remoteIdentifier) {
        return this.remoteNodeCouldBootstrapFrom[remoteIdentifier];
    }

    @Override
    public void onHeaderCreated() {
        this.startOfModificationIterators = super.mapHeaderInnerSize() + 1024L - MemoryUnit.BYTES.convert(3L, MemoryUnit.CACHE_LINES);
    }

    @Override
    protected void zeroOutNewlyMappedChronicleMapBytes() {
        super.zeroOutNewlyMappedChronicleMapBytes();
        this.bs.zeroOut(super.mapHeaderInnerSize(), this.mapHeaderInnerSize());
    }

    @Override
    public byte identifier() {
        byte id = this.localIdentifier;
        if (id == 0) {
            throw new IllegalStateException("Replication identifier is not set for this\nreplicated Chronicle Map. This should only be possible if persisted\nreplicated Chronicle Map access from another process/JVM run/after\na transfer from another machine, and replication identifier is not\nspecified when access is configured, e. g. ChronicleMap.of(...).createPersistedTo(existingFile).\nIn this case, replicated Chronicle Map \"doesn't know\" it's identifier,\nand is able to perform simple _read_ operations like map.get(), which\ndoesn't access the identifier. To perform updates, insertions, replication\ntasks, you should configure the current node identifier,\nby `replication(identifier)` method call in ChronicleMapBuilder\nconfiguration chain.");
        }
        assert (id > 0);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModificationIterator acquireModificationIterator(byte remoteIdentifier) {
        ModificationIterator modificationIterator = this.modificationIterators.get(remoteIdentifier);
        if (modificationIterator != null) {
            return modificationIterator;
        }
        this.globalMutableStateLock();
        try {
            modificationIterator = this.modificationIterators.get(remoteIdentifier);
            if (modificationIterator != null) {
                ModificationIterator modificationIterator2 = modificationIterator;
                return modificationIterator2;
            }
            ReplicatedGlobalMutableState globalMutableState = this.globalMutableState();
            boolean modificationIteratorInit = globalMutableState.getModificationIteratorInitAt(remoteIdentifier);
            ModificationIterator modIter = new ModificationIterator(remoteIdentifier, modificationIteratorInit);
            if (!modificationIteratorInit) {
                globalMutableState.setModificationIteratorInitAt(remoteIdentifier, true);
                globalMutableState.addModificationIteratorsCount(1);
            }
            this.assignedModificationIterators = (ModificationIterator[])Stream.concat(Arrays.stream(this.assignedModificationIterators), Stream.of(modIter)).sorted(Comparator.comparing(it -> ((ModificationIterator)it).remoteIdentifier)).toArray(ModificationIterator[]::new);
            this.modificationIterators.set(remoteIdentifier, modIter);
            ModificationIterator modificationIterator3 = modIter;
            return modificationIterator3;
        }
        finally {
            this.globalMutableStateUnlock();
        }
    }

    public ModificationIterator[] acquireAllModificationIterators() {
        for (int remoteIdentifier = 0; remoteIdentifier < 128; ++remoteIdentifier) {
            if (!this.globalMutableState().getModificationIteratorInitAt(remoteIdentifier)) continue;
            this.acquireModificationIterator((byte)remoteIdentifier);
        }
        return this.assignedModificationIterators;
    }

    private void updateModificationIteratorsArray() {
        if (this.globalMutableState().getModificationIteratorsCount() != this.assignedModificationIterators.length) {
            this.acquireAllModificationIterators();
        }
    }

    public void raiseChange(long tierIndex, long pos) {
        this.raiseChangeForAllExcept(tierIndex, pos, (byte)-1);
    }

    public void raiseChangeFor(long tierIndex, long pos, byte remoteIdentifier) {
        this.acquireModificationIterator(remoteIdentifier).raiseChange0(tierIndex, pos);
    }

    public void raiseChangeForAllExcept(long tierIndex, long pos, byte remoteIdentifier) {
        this.updateModificationIteratorsArray();
        if (tierIndex <= (long)this.actualSegments) {
            long segmentIndex = tierIndex - 1L;
            long offsetToTierBitSet = segmentIndex * this.tierModIterBitSetOuterSize;
            for (ModificationIterator it : this.assignedModificationIterators) {
                if (it.remoteIdentifier == remoteIdentifier) continue;
                it.raiseChangeInSegment(offsetToTierBitSet, pos);
            }
        } else {
            long extraTierIndex = tierIndex - 1L - (long)this.actualSegments;
            int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
            long offsetToTierBitSet = (extraTierIndex & this.tiersInBulk - 1L) * this.tierModIterBitSetOuterSize;
            for (ModificationIterator it : this.assignedModificationIterators) {
                if (it.remoteIdentifier == remoteIdentifier) continue;
                it.raiseChangeInTierBulk(bulkIndex, offsetToTierBitSet, pos);
            }
        }
    }

    public void dropChange(long tierIndex, long pos) {
        this.updateModificationIteratorsArray();
        if (tierIndex <= (long)this.actualSegments) {
            long segmentIndex = tierIndex - 1L;
            long offsetToTierBitSet = segmentIndex * this.tierModIterBitSetOuterSize;
            for (ModificationIterator modificationIterator : this.assignedModificationIterators) {
                modificationIterator.dropChangeInSegment(offsetToTierBitSet, pos);
            }
        } else {
            long extraTierIndex = tierIndex - 1L - (long)this.actualSegments;
            int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
            long offsetToTierBitSet = (extraTierIndex & this.tiersInBulk - 1L) * this.tierModIterBitSetOuterSize;
            for (ModificationIterator modificationIterator : this.assignedModificationIterators) {
                modificationIterator.dropChangeInTierBulk(bulkIndex, offsetToTierBitSet, pos);
            }
        }
    }

    public void dropChangeFor(long tierIndex, long pos, byte remoteIdentifier) {
        this.acquireModificationIterator(remoteIdentifier).dropChange0(tierIndex, pos);
    }

    public void moveChange(long oldTierIndex, long oldPos, long newTierIndex, long newPos) {
        this.updateModificationIteratorsArray();
        if (oldTierIndex <= (long)this.actualSegments) {
            long oldSegmentIndex = oldTierIndex - 1L;
            long oldOffsetToTierBitSet = oldSegmentIndex * this.tierModIterBitSetOuterSize;
            if (newTierIndex <= (long)this.actualSegments) {
                long newSegmentIndex = newTierIndex - 1L;
                long newOffsetToTierBitSet = newSegmentIndex * this.tierModIterBitSetOuterSize;
                for (ModificationIterator modificationIterator : this.assignedModificationIterators) {
                    if (!modificationIterator.dropChangeInSegment(oldOffsetToTierBitSet, oldPos)) continue;
                    modificationIterator.raiseChangeInSegment(newOffsetToTierBitSet, newPos);
                }
            } else {
                long newExtraTierIndex = newTierIndex - 1L - (long)this.actualSegments;
                int newBulkIndex = (int)(newExtraTierIndex >> this.log2TiersInBulk);
                long newOffsetToTierBitSet = (newExtraTierIndex & this.tiersInBulk - 1L) * this.tierModIterBitSetOuterSize;
                for (ModificationIterator modificationIterator : this.assignedModificationIterators) {
                    if (!modificationIterator.dropChangeInSegment(oldOffsetToTierBitSet, oldPos)) continue;
                    modificationIterator.raiseChangeInTierBulk(newBulkIndex, newOffsetToTierBitSet, newPos);
                }
            }
        } else {
            long oldExtraTierIndex = oldTierIndex - 1L - (long)this.actualSegments;
            int oldBulkIndex = (int)(oldExtraTierIndex >> this.log2TiersInBulk);
            long oldOffsetToTierBitSet = (oldExtraTierIndex & this.tiersInBulk - 1L) * this.tierModIterBitSetOuterSize;
            if (newTierIndex <= (long)this.actualSegments) {
                long newSegmentIndex = newTierIndex - 1L;
                long newOffsetToTierBitSet = newSegmentIndex * this.tierModIterBitSetOuterSize;
                for (ModificationIterator modificationIterator : this.assignedModificationIterators) {
                    if (!modificationIterator.dropChangeInTierBulk(oldBulkIndex, oldOffsetToTierBitSet, oldPos)) continue;
                    modificationIterator.raiseChangeInSegment(newOffsetToTierBitSet, newPos);
                }
            } else {
                long newExtraTierIndex = newTierIndex - 1L - (long)this.actualSegments;
                int newBulkIndex = (int)(newExtraTierIndex >> this.log2TiersInBulk);
                long newOffsetToTierBitSet = (newExtraTierIndex & this.tiersInBulk - 1L) * this.tierModIterBitSetOuterSize;
                for (ModificationIterator modificationIterator : this.assignedModificationIterators) {
                    if (!modificationIterator.dropChangeInTierBulk(oldBulkIndex, oldOffsetToTierBitSet, oldPos)) continue;
                    modificationIterator.raiseChangeInTierBulk(newBulkIndex, newOffsetToTierBitSet, newPos);
                }
            }
        }
    }

    public boolean isChanged(long tierIndex, long pos) {
        this.updateModificationIteratorsArray();
        if (tierIndex <= (long)this.actualSegments) {
            long segmentIndex = tierIndex - 1L;
            long offsetToTierBitSet = segmentIndex * this.tierModIterBitSetOuterSize;
            for (ModificationIterator modificationIterator : this.assignedModificationIterators) {
                if (!modificationIterator.isChangedSegment(offsetToTierBitSet, pos)) continue;
                return true;
            }
        } else {
            long extraTierIndex = tierIndex - 1L - (long)this.actualSegments;
            int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
            long offsetToTierBitSet = (extraTierIndex & this.tiersInBulk - 1L) * this.tierModIterBitSetOuterSize;
            for (ModificationIterator modificationIterator : this.assignedModificationIterators) {
                if (!modificationIterator.isChangedTierBulk(bulkIndex, offsetToTierBitSet, pos)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean identifierCheck(@NotNull ReplicableEntry entry, int chronicleId) {
        return entry.originIdentifier() == this.identifier();
    }

    @Override
    public void writeExternalEntry(ReplicableEntry entry, Bytes payload, @NotNull Bytes destination, int chronicleId) {
        if (payload != null) {
            this.writePayload(payload, destination);
        }
        if (entry != null) {
            this.writeExternalEntry0(entry, destination);
        }
    }

    private void writePayload(Bytes payload, Bytes destination) {
        destination.writeByte((byte)2);
        destination.write((BytesStore)payload, payload.readPosition(), payload.readRemaining());
    }

    private void writeExternalEntry0(ReplicableEntry entry, Bytes destination) {
        Data key;
        boolean isDeleted;
        destination.writeByte((byte)1);
        destination.writeStopBit(entry.originTimestamp());
        if (entry.originIdentifier() == 0) {
            throw new IllegalStateException("Identifier can't be 0");
        }
        destination.writeByte(entry.originIdentifier());
        if (entry instanceof MapEntry) {
            isDeleted = false;
            key = ((MapEntry)((Object)entry)).key();
        } else {
            isDeleted = true;
            key = ((MapAbsentEntry)((Object)entry)).absentKey();
        }
        destination.writeBoolean(isDeleted);
        this.keySizeMarshaller.writeSize(destination, key.size());
        key.writeTo((RandomDataOutput)destination, destination.writePosition());
        destination.writeSkip(key.size());
        boolean debugEnabled = LOG.isDebugEnabled();
        String message = null;
        if (debugEnabled) {
            if (isDeleted) {
                LOG.debug("WRITING ENTRY TO DEST -  into local-id={}, remove(key={})", (Object)this.identifier(), key);
            } else {
                message = String.format("WRITING ENTRY TO DEST  -  into local-id=%d, put(key=%s,", this.identifier(), key);
            }
        }
        if (isDeleted) {
            return;
        }
        Data value = ((MapEntry)((Object)entry)).value();
        this.valueSizeMarshaller.writeSize(destination, value.size());
        value.writeTo((RandomDataOutput)destination, destination.writePosition());
        destination.writeSkip(value.size());
        if (debugEnabled) {
            LOG.debug(message + "value=" + value + ")");
        }
    }

    @Override
    ChainingInterface newQueryContext() {
        return new CompiledReplicatedMapQueryContext(this);
    }

    @Override
    public CompiledReplicatedMapQueryContext<K, V, R> mapContext() {
        return this.q().getContext(CompiledReplicatedMapQueryContext.class, CompiledReplicatedMapQueryContext::new, this);
    }

    @Override
    public void readExternalEntry(@NotNull Bytes source, byte remoteNodeIdentifier) {
        byte hunk = source.readByte();
        if (hunk == 2) {
            this.setRemoteNodeCouldBootstrapFrom(remoteNodeIdentifier, source.readLong());
        } else {
            assert (hunk == 1);
            try (QueryContextInterface remoteOpContext = this.mapContext();){
                ((CompiledReplicatedMapQueryContext)remoteOpContext).processReplicatedEvent(remoteNodeIdentifier, source);
            }
        }
    }

    @Override
    ChainingInterface newIterationContext() {
        return new CompiledReplicatedMapIterationContext(this);
    }

    @Override
    public CompiledReplicatedMapIterationContext<K, V, R> iterationContext() {
        return this.i().getContext(CompiledReplicatedMapIterationContext.class, CompiledReplicatedMapIterationContext::new, this);
    }

    @Override
    public final V get(Object key) {
        return this.defaultGet(key);
    }

    @Override
    public final V getUsing(K key, V usingValue) {
        return this.defaultGetUsing(key, usingValue);
    }

    public class ModificationIterator
    implements Replica.ModificationIterator {
        private final byte remoteIdentifier;
        private final long segmentBitSetsAddr;
        private final long offsetToBitSetsWithinATierBulk;
        private Replica.ModificationNotifier modificationNotifier;
        private long bootstrapTimeAfterNextIterationComplete = 0L;
        private boolean somethingSentOnThisIteration = false;
        private int segmentIndex;
        private int bulkIndex;
        private int tierIndexOffsetWithinBulk;
        private long entryPos;
        private long tierBitSetAddr;

        public ModificationIterator(byte remoteIdentifier, boolean sharedMemoryInit) {
            this.remoteIdentifier = remoteIdentifier;
            this.segmentBitSetsAddr = ReplicatedChronicleMap.this.bsAddress() + ReplicatedChronicleMap.this.startOfModificationIterators + (long)remoteIdentifier * ReplicatedChronicleMap.this.segmentModIterBitSetsForIdentifierOuterSize;
            if (!sharedMemoryInit) {
                Access.nativeAccess().zeroOut(null, this.segmentBitSetsAddr, ReplicatedChronicleMap.this.segmentModIterBitSetsForIdentifierOuterSize);
            }
            this.offsetToBitSetsWithinATierBulk = (long)remoteIdentifier * ReplicatedChronicleMap.this.tierBulkModIterBitSetsForIdentifierOuterSize;
            this.resetCursor();
        }

        private void resetCursor() {
            this.segmentIndex = 0;
            this.bulkIndex = -1;
            this.tierIndexOffsetWithinBulk = -1;
            this.entryPos = -1L;
            this.tierBitSetAddr = this.segmentBitSetsAddr;
        }

        @Override
        public void setModificationNotifier(@NotNull Replica.ModificationNotifier modificationNotifier) {
            this.modificationNotifier = modificationNotifier;
        }

        void raiseChangeInSegment(long offsetToTierBitSet, long pos) {
            ReplicatedChronicleMap.this.tierModIterFrame.set(Access.nativeAccess(), null, this.segmentBitSetsAddr + offsetToTierBitSet, pos);
            if (this.modificationNotifier != null) {
                this.modificationNotifier.onChange();
            }
        }

        void raiseChangeInTierBulk(int bulkIndex, long offsetToTierBitSet, long pos) {
            VanillaChronicleHash.TierBulkData tierBulkData = (VanillaChronicleHash.TierBulkData)ReplicatedChronicleMap.this.tierBulkOffsets.get(bulkIndex);
            long bitSetAddr = this.bitSetsAddr(tierBulkData) + offsetToTierBitSet;
            ReplicatedChronicleMap.this.tierModIterFrame.set(Access.nativeAccess(), null, bitSetAddr, pos);
            if (this.modificationNotifier != null) {
                this.modificationNotifier.onChange();
            }
        }

        boolean dropChangeInSegment(long offsetToTierBitSet, long pos) {
            return ReplicatedChronicleMap.this.tierModIterFrame.clearIfSet(Access.nativeAccess(), null, this.segmentBitSetsAddr + offsetToTierBitSet, pos);
        }

        boolean dropChangeInTierBulk(int bulkIndex, long offsetToTierBitSet, long pos) {
            VanillaChronicleHash.TierBulkData tierBulkData = (VanillaChronicleHash.TierBulkData)ReplicatedChronicleMap.this.tierBulkOffsets.get(bulkIndex);
            long bitSetAddr = this.bitSetsAddr(tierBulkData) + offsetToTierBitSet;
            return ReplicatedChronicleMap.this.tierModIterFrame.clearIfSet(Access.nativeAccess(), null, bitSetAddr, pos);
        }

        boolean isChangedSegment(long offsetToTierBitSet, long pos) {
            return ReplicatedChronicleMap.this.tierModIterFrame.isSet(Access.nativeAccess(), null, this.segmentBitSetsAddr + offsetToTierBitSet, pos);
        }

        boolean isChangedTierBulk(int bulkIndex, long offsetToTierBitSet, long pos) {
            VanillaChronicleHash.TierBulkData tierBulkData = (VanillaChronicleHash.TierBulkData)ReplicatedChronicleMap.this.tierBulkOffsets.get(bulkIndex);
            long bitSetAddr = this.bitSetsAddr(tierBulkData) + offsetToTierBitSet;
            return ReplicatedChronicleMap.this.tierModIterFrame.isSet(Access.nativeAccess(), null, bitSetAddr, pos);
        }

        private long bitSetsAddr(VanillaChronicleHash.TierBulkData tierBulkData) {
            return tierBulkData.bytesStore.addressForRead(tierBulkData.offset) + this.offsetToBitSetsWithinATierBulk;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntryPos(null, 0) != -1L;
        }

        private long nextEntryPos(Replica.ModificationIterator.Callback callback, int chronicleId) {
            boolean allBitSetsScannedFromTheStart = false;
            while (!allBitSetsScannedFromTheStart) {
                long nextEntryPos;
                if (this.segmentIndex >= 0) {
                    boolean bl = allBitSetsScannedFromTheStart = this.segmentIndex == 0 && this.entryPos == -1L;
                    if (allBitSetsScannedFromTheStart) {
                        this.bootstrapTimeAfterNextIterationComplete = TimeProvider.currentTime();
                        this.somethingSentOnThisIteration = false;
                    }
                    while (this.segmentIndex < ReplicatedChronicleMap.this.actualSegments) {
                        if (this.entryPos == -1L) {
                            this.acquireAndReleaseUpdateLock(this.segmentIndex);
                        }
                        if ((nextEntryPos = ReplicatedChronicleMap.this.tierModIterFrame.nextSetBit(Access.nativeAccess(), null, this.tierBitSetAddr, this.entryPos + 1L)) != -1L) {
                            return nextEntryPos;
                        }
                        ++this.segmentIndex;
                        this.tierBitSetAddr += ReplicatedChronicleMap.this.tierModIterBitSetOuterSize;
                        this.entryPos = -1L;
                    }
                    this.segmentIndex = -1;
                    this.bulkIndex = 0;
                    this.tierIndexOffsetWithinBulk = 0;
                    if (this.bulkIndex < ReplicatedChronicleMap.this.globalMutableState().getAllocatedExtraTierBulks()) {
                        this.tierBitSetAddr = this.bitSetsAddr((VanillaChronicleHash.TierBulkData)ReplicatedChronicleMap.this.tierBulkOffsets.get(this.bulkIndex));
                    }
                }
                while (this.bulkIndex < ReplicatedChronicleMap.this.globalMutableState().getAllocatedExtraTierBulks()) {
                    while ((long)this.tierIndexOffsetWithinBulk < ReplicatedChronicleMap.this.tiersInBulk) {
                        nextEntryPos = ReplicatedChronicleMap.this.tierModIterFrame.nextSetBit(Access.nativeAccess(), null, this.tierBitSetAddr, this.entryPos + 1L);
                        if (nextEntryPos != -1L) {
                            return nextEntryPos;
                        }
                        ++this.tierIndexOffsetWithinBulk;
                        this.tierBitSetAddr += ReplicatedChronicleMap.this.tierModIterBitSetOuterSize;
                        this.entryPos = -1L;
                    }
                    ++this.bulkIndex;
                    this.tierIndexOffsetWithinBulk = 0;
                    if (this.bulkIndex >= ReplicatedChronicleMap.this.globalMutableState().getAllocatedExtraTierBulks()) continue;
                    this.tierBitSetAddr = this.bitSetsAddr((VanillaChronicleHash.TierBulkData)ReplicatedChronicleMap.this.tierBulkOffsets.get(this.bulkIndex));
                }
                this.resetCursor();
                if (callback == null || !this.somethingSentOnThisIteration) continue;
                callback.onBootstrapTime(this.bootstrapTimeAfterNextIterationComplete, chronicleId);
            }
            return -1L;
        }

        private void acquireAndReleaseUpdateLock(int segmentIndex) {
            try (IterationContext c = ReplicatedChronicleMap.this.iterationContext();){
                ((CompiledReplicatedMapIterationContext)c).initSegmentIndex(segmentIndex);
                ((CompiledReplicatedMapIterationContext)c).updateLock().lock();
            }
        }

        @Override
        public boolean nextEntry(@NotNull Replica.ModificationIterator.Callback callback, int chronicleId) {
            long nextEntryPos;
            while ((nextEntryPos = this.nextEntryPos(callback, chronicleId)) != -1L) {
                this.entryPos = nextEntryPos;
                IterationContext context = ReplicatedChronicleMap.this.iterationContext();
                Throwable throwable = null;
                try {
                    if (this.segmentIndex >= 0) {
                        ((CompiledReplicatedMapIterationContext)context).initSegmentIndex(this.segmentIndex);
                    } else {
                        VanillaChronicleHash.TierBulkData tierBulkData = (VanillaChronicleHash.TierBulkData)ReplicatedChronicleMap.this.tierBulkOffsets.get(this.bulkIndex);
                        long tierBaseAddr = ReplicatedChronicleMap.this.tierAddr(tierBulkData, this.tierIndexOffsetWithinBulk);
                        long tierCountersAreaAddr = tierBaseAddr + ReplicatedChronicleMap.this.tierHashLookupOuterSize;
                        ((CompiledReplicatedMapIterationContext)context).initSegmentIndex(TierCountersArea.segmentIndex(tierCountersAreaAddr));
                        int tier = TierCountersArea.tier(tierCountersAreaAddr);
                        long tierIndex = ReplicatedChronicleMap.this.actualSegments + (this.bulkIndex << ReplicatedChronicleMap.this.log2TiersInBulk) + this.tierIndexOffsetWithinBulk + 1;
                        ((CompiledReplicatedMapIterationContext)context).initSegmentTier(tier, tierIndex, tierBaseAddr);
                    }
                    ((CompiledReplicatedMapIterationContext)context).updateLock().lock();
                    if (!this.entryIsStillDirty(this.entryPos)) continue;
                    ((CompiledReplicatedMapIterationContext)context).readExistingEntry(this.entryPos);
                    ReplicableEntry entry = (ReplicableEntry)((CompiledReplicatedMapIterationContext)context).entryForIteration();
                    callback.onEntry(entry, chronicleId);
                    this.somethingSentOnThisIteration = true;
                    this.clearEntry(this.entryPos);
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            ((CompiledReplicatedMapIterationContext)context).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((CompiledReplicatedMapIterationContext)context).close();
                    continue;
                }
                break;
            }
            return false;
        }

        private boolean entryIsStillDirty(long entryPos) {
            return ReplicatedChronicleMap.this.tierModIterFrame.get(Access.nativeAccess(), null, this.tierBitSetAddr, entryPos);
        }

        private void clearEntry(long entryPos) {
            ReplicatedChronicleMap.this.tierModIterFrame.clear(Access.nativeAccess(), null, this.tierBitSetAddr, entryPos);
        }

        @Override
        public void dirtyEntries(long fromTimeStamp) {
            try (IterationContext c = ReplicatedChronicleMap.this.iterationContext();){
                boolean debugEnabled = LOG.isDebugEnabled();
                for (int segmentIndex = 0; segmentIndex < ReplicatedChronicleMap.this.actualSegments; ++segmentIndex) {
                    ((CompiledReplicatedMapIterationContext)c).initSegmentIndex(segmentIndex);
                    ((CompiledReplicatedMapIterationContext)c).forEachSegmentReplicableEntry(arg_0 -> this.lambda$dirtyEntries$0(debugEnabled, (CompiledReplicatedMapIterationContext)c, fromTimeStamp, arg_0));
                }
            }
        }

        void raiseChange0(long tierIndex, long pos) {
            if (tierIndex <= (long)ReplicatedChronicleMap.this.actualSegments) {
                long segmentIndex = tierIndex - 1L;
                long offsetToTierBitSet = segmentIndex * ReplicatedChronicleMap.this.tierModIterBitSetOuterSize;
                this.raiseChangeInSegment(offsetToTierBitSet, pos);
            } else {
                long extraTierIndex = tierIndex - 1L - (long)ReplicatedChronicleMap.this.actualSegments;
                int bulkIndex = (int)(extraTierIndex >> ReplicatedChronicleMap.this.log2TiersInBulk);
                long offsetToTierBitSet = (extraTierIndex & ReplicatedChronicleMap.this.tiersInBulk - 1L) * ReplicatedChronicleMap.this.tierModIterBitSetOuterSize;
                this.raiseChangeInTierBulk(bulkIndex, offsetToTierBitSet, pos);
            }
        }

        void dropChange0(long tierIndex, long pos) {
            if (tierIndex <= (long)ReplicatedChronicleMap.this.actualSegments) {
                long segmentIndex = tierIndex - 1L;
                long offsetToTierBitSet = segmentIndex * ReplicatedChronicleMap.this.tierModIterBitSetOuterSize;
                this.dropChangeInSegment(offsetToTierBitSet, pos);
            } else {
                long extraTierIndex = tierIndex - 1L - (long)ReplicatedChronicleMap.this.actualSegments;
                int bulkIndex = (int)(extraTierIndex >> ReplicatedChronicleMap.this.log2TiersInBulk);
                long offsetToTierBitSet = (extraTierIndex & ReplicatedChronicleMap.this.tiersInBulk - 1L) * ReplicatedChronicleMap.this.tierModIterBitSetOuterSize;
                this.dropChangeInTierBulk(bulkIndex, offsetToTierBitSet, pos);
            }
        }

        public void clearRange0(long tierIndex, long pos, long endPosExclusive) {
            if (tierIndex <= (long)ReplicatedChronicleMap.this.actualSegments) {
                long segmentIndex = tierIndex - 1L;
                long offsetToTierBitSet = segmentIndex * ReplicatedChronicleMap.this.tierModIterBitSetOuterSize;
                ReplicatedChronicleMap.this.tierModIterFrame.clearRange(Access.nativeAccess(), null, this.segmentBitSetsAddr + offsetToTierBitSet, pos, endPosExclusive);
            } else {
                long extraTierIndex = tierIndex - 1L - (long)ReplicatedChronicleMap.this.actualSegments;
                int bulkIndex = (int)(extraTierIndex >> ReplicatedChronicleMap.this.log2TiersInBulk);
                long offsetToTierBitSet = (extraTierIndex & ReplicatedChronicleMap.this.tiersInBulk - 1L) * ReplicatedChronicleMap.this.tierModIterBitSetOuterSize;
                VanillaChronicleHash.TierBulkData tierBulkData = (VanillaChronicleHash.TierBulkData)ReplicatedChronicleMap.this.tierBulkOffsets.get(bulkIndex);
                long bitSetAddr = this.bitSetsAddr(tierBulkData) + offsetToTierBitSet;
                ReplicatedChronicleMap.this.tierModIterFrame.clearRange(Access.nativeAccess(), null, bitSetAddr, pos, endPosExclusive);
            }
        }

        private /* synthetic */ void lambda$dirtyEntries$0(boolean debugEnabled, CompiledReplicatedMapIterationContext c, long fromTimeStamp, ReplicableEntry e) {
            if (debugEnabled) {
                LOG.debug("Bootstrap entry: id {}, key {}, value {}", new Object[]{ReplicatedChronicleMap.this.localIdentifier, c.key(), c.value()});
            }
            if (debugEnabled) {
                LOG.debug("Bootstrap decision: bs ts: {}, entry ts: {}, entry id: {}, local id: {}", new Object[]{fromTimeStamp, e.originTimestamp(), e.originIdentifier(), ReplicatedChronicleMap.this.localIdentifier});
            }
            if (e.originIdentifier() != ReplicatedChronicleMap.this.localIdentifier || e.originTimestamp() >= fromTimeStamp) {
                this.raiseChange0(c.tierIndex(), c.pos());
            }
        }
    }
}

