/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.iter;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.ReplicatedHashSegmentContext;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.impl.ReplicatedIterationContext;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.map.impl.stage.data.DummyValueZeroData;
import net.openhft.chronicle.map.impl.stage.entry.ReplicatedMapEntryStages;
import net.openhft.chronicle.map.impl.stage.iter.MapSegmentIteration;
import net.openhft.chronicle.map.impl.stage.iter.ReplicatedMapAbsentDelegatingForIteration;
import net.openhft.chronicle.map.impl.stage.iter.ReplicatedMapEntryDelegating;
import net.openhft.chronicle.map.impl.stage.replication.ReplicationUpdate;
import net.openhft.chronicle.set.DummyValueData;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class ReplicatedMapSegmentIteration<K, V, R>
extends MapSegmentIteration<K, V, R>
implements ReplicatedIterationContext<K, V, R>,
ReplicableEntry,
ReplicatedHashSegmentContext<K, MapEntry<K, V>> {
    @StageRef
    VanillaChronicleMapHolder<K, V, R> mh;
    @StageRef
    ReplicatedMapEntryStages<K, V> e;
    @StageRef
    ReplicationUpdate<K> ru;
    @StageRef
    DummyValueZeroData<V> dummyValue;
    @StageRef
    ReplicatedMapAbsentDelegatingForIteration<K, V> absentEntryDelegating;
    @StageRef
    ReplicatedMapEntryDelegating<K, V> entryDelegating;
    EntriesToTest entriesToTest = null;

    void initEntriesToTest(EntriesToTest entriesToTest) {
        this.entriesToTest = entriesToTest;
    }

    @Override
    public boolean shouldTestEntry() {
        return this.entriesToTest == EntriesToTest.ALL || !this.e.entryDeleted();
    }

    @Override
    public Object entryForIteration() {
        return !this.e.entryDeleted() ? this.entryDelegating : this.absentEntryDelegating;
    }

    @Override
    public long tierEntriesForIteration() {
        return this.entriesToTest == EntriesToTest.ALL ? this.s.tierEntries() : this.s.tierEntries() - this.s.tierDeleted();
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        try {
            this.entry.innerDefaultReplaceValue(newValue);
            this.e.updatedReplicationStateOnPresentEntry();
            this.ru.updateChange();
        }
        finally {
            this.s.innerWriteLock.unlock();
        }
    }

    @Override
    public boolean forEachSegmentEntryWhile(Predicate<? super MapEntry<K, V>> predicate) {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.initEntriesToTest(EntriesToTest.PRESENT);
        this.s.innerUpdateLock.lock();
        return this.innerForEachSegmentEntryWhile(predicate);
    }

    @Override
    public boolean forEachSegmentReplicableEntryWhile(Predicate<? super ReplicableEntry> predicate) {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.initEntriesToTest(EntriesToTest.ALL);
        this.s.innerUpdateLock.lock();
        return this.innerForEachSegmentEntryWhile(predicate);
    }

    @Override
    public void forEachSegmentReplicableEntry(Consumer<? super ReplicableEntry> action) {
        this.forEachSegmentReplicableEntryWhile(e -> {
            action.accept((ReplicableEntry)e);
            return true;
        });
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        try {
            if (this.e.valueSize > this.dummyValue.size()) {
                this.e.innerDefaultReplaceValue(this.dummyValue);
            }
            this.e.updatedReplicationStateOnPresentEntry();
            this.e.writeEntryDeleted();
            this.ru.updateChange();
            this.s.tierDeleted(this.s.tierDeleted() + 1L);
        }
        finally {
            this.s.innerWriteLock.unlock();
        }
        this.initEntryRemovedOnThisIteration(true);
    }

    @Override
    public void doRemoveCompletely() {
        boolean wasDeleted = this.e.entryDeleted();
        super.doRemove();
        this.ru.dropChange();
        if (wasDeleted) {
            this.s.tierDeleted(this.s.tierDeleted() - 1L);
        }
    }

    public void doInsert(Data<V> value) {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        if (this.e.entryDeleted()) {
            try {
                this.s.tierDeleted(this.s.tierDeleted() - 1L);
                this.e.innerDefaultReplaceValue(value);
                this.s.incrementModCount();
                this.e.writeEntryPresent();
                this.e.updatedReplicationStateOnPresentEntry();
                this.ru.updateChange();
            }
            finally {
                this.s.innerWriteLock.unlock();
            }
        } else {
            throw new IllegalStateException(this.mh.h().toIdentityString() + ": Entry is present in the map when doInsert() is called");
        }
    }

    public void doInsert() {
        if (this.mh.set() == null) {
            throw new IllegalStateException(this.mh.h().toIdentityString() + ": Called SetAbsentEntry.doInsert() from Map context");
        }
        this.doInsert(DummyValueData.INSTANCE);
    }

    static enum EntriesToTest {
        PRESENT,
        ALL;

    }
}

