/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.hash.impl.ContextFactory;
import net.openhft.chronicle.hash.impl.HashContext;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.BytesBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.DelegatingMetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.MapKeyContext;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.RandomDataInput;

class VanillaContext<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
extends HashContext<K, KI, MKI>
implements MapKeyContext<K, V> {
    long valueSizeOffset;
    long valueOffset;
    long valueSize;
    BytesReader<V> valueReader;
    V value;
    VI valueInterop;
    V newValue;
    MVI metaValueInterop;
    long newValueSize;
    private final MultiStoreBytes valueCopy = new MultiStoreBytes();
    TcpReplicator.TcpSocketChannelEntryWriter output;

    VanillaContext() {
    }

    VanillaContext(HashContext contextCache, int indexInContextCache) {
        super(contextCache, indexInContextCache);
    }

    @Override
    public void totalCheckClosed() {
        super.totalCheckClosed();
        assert (!this.valueBytesInit()) : "value bytes not closed";
        assert (!this.valueReaderInit()) : "value reader not closed";
        assert (!this.valueInit()) : "value not closed";
        assert (!this.valueModelInit()) : "value model not closed";
        assert (!this.newValueInit()) : "new value not closed";
    }

    public VanillaChronicleMap<K, KI, MKI, V, VI, MVI> m() {
        return (VanillaChronicleMap)this.h;
    }

    @Override
    public void closeHashDependants() {
        super.closeHashDependants();
        this.closeValueModel();
        this.closeValue();
        this.closeValueReader();
    }

    @Override
    public HashContext.HashAndContextLocals<K> newHashAndContextLocals() {
        return new MapAndContextLocals(this.m());
    }

    public MapAndContextLocals<K, V> mapAndContextLocals() {
        return (MapAndContextLocals)this.hashAndContextLocals();
    }

    @Override
    public void closeHashContextAndLocalsDependants() {
        super.closeHashContextAndLocalsDependants();
        this.closeValue();
    }

    @Override
    public void closeKeySearchDependants() {
        super.closeKeySearchDependants();
        this.closeValueBytes();
    }

    void initValueBytes() {
        if (this.valueBytesInit()) {
            return;
        }
        this.initValueBytesDependencies();
        this.initValueBytes0();
    }

    boolean valueBytesInit() {
        return this.valueSizeOffset != 0L;
    }

    void initValueBytesDependencies() {
        this.initKeySearch();
    }

    void initValueBytes0() {
        if (!this.searchStatePresent()) {
            throw new IllegalStateException("Key should be present");
        }
        this.initValueSizeOffset0();
        this.entry.position(this.valueSizeOffset);
        this.valueSize = this.m().readValueSize((Bytes)this.entry);
        this.m().alignment.alignPositionAddr((Bytes)this.entry);
        this.valueOffset = this.entry.position();
    }

    void initValueSizeOffset0() {
        this.valueSizeOffset = this.keyOffset0() + this.keySize0();
    }

    void closeValueBytes() {
        if (!this.valueBytesInit()) {
            return;
        }
        this.closeValueBytesDependants();
        this.closeValueBytes0();
    }

    void closeValueBytesDependants() {
        this.closeValue();
        this.closeEntrySizeInChunks();
    }

    void closeValueBytes0() {
        this.valueSizeOffset = 0L;
    }

    @Override
    public long valueOffset() {
        this.checkContainsKey();
        this.initValueBytes();
        return this.valueOffset;
    }

    @Override
    public long valueSize() {
        this.checkContainsKey();
        this.initValueBytes();
        return this.valueSize;
    }

    void initValueReader() {
        if (this.valueReaderInit()) {
            return;
        }
        this.initValueReaderDependencies();
        this.initValueReader0();
    }

    boolean valueReaderInit() {
        return this.valueReader != null;
    }

    void initValueReaderDependencies() {
        this.checkHashInit();
    }

    void initValueReader0() {
        this.valueReader = (BytesReader)this.m().valueReaderProvider.get(this.copies, this.m().originalValueReader);
    }

    void closeValueReader() {
        if (!this.valueReaderInit()) {
            return;
        }
        this.closeValueReaderDependants();
        this.closeValueReader0();
    }

    void closeValueReaderDependants() {
        this.closeValue();
    }

    void closeValueReader0() {
        this.valueReader = null;
    }

    @Override
    public V get() {
        this.checkOnEachPublicOperation();
        if (this.valueInit()) {
            return this.value;
        }
        if (!this.containsKey()) {
            return null;
        }
        this.initValueDependencies();
        this.initHashAndContextLocals();
        this.initValue0(this.mapAndContextLocals().reusableValue);
        this.mapAndContextLocals().reusableValue = this.value;
        return this.value;
    }

    boolean valueInit() {
        return this.value != null;
    }

    void initValueDependencies() {
        this.initValueBytes();
        this.initValueReader();
    }

    @Override
    public V getUsing(V usingValue) {
        this.checkOnEachPublicOperation();
        if (!this.containsKey()) {
            return null;
        }
        this.initValueDependencies();
        this.initValue0(usingValue);
        return this.value;
    }

    void initValue0(V usingValue) {
        this.entry.position(this.valueOffset);
        this.value = this.valueReader.read((Bytes)this.entry, this.valueSize, usingValue);
    }

    void closeValue() {
        if (!this.valueInit()) {
            return;
        }
        this.closeValueDependants();
        this.closeValue0();
    }

    void closeValueDependants() {
    }

    void closeValue0() {
        this.closeInstanceValue0();
    }

    void closeInstanceValue0() {
        this.value = null;
    }

    void initValueModel() {
        if (this.valueModelInit()) {
            return;
        }
        this.initValueModelDependencies();
        this.initValueModel0();
    }

    boolean valueModelInit() {
        return this.valueInterop != null;
    }

    void initValueModelDependencies() {
        this.checkHashInit();
    }

    void initValueModel0() {
        this.initInstanceValueModel0();
    }

    void initInstanceValueModel0() {
        this.valueInterop = this.m().valueInteropProvider.get(this.copies, this.m().originalValueInterop);
    }

    void closeValueModel() {
        if (!this.valueModelInit()) {
            return;
        }
        this.closeValueModelDependants();
        this.closeValueModel0();
    }

    void closeValueModelDependants() {
        this.closeNewValue();
    }

    void closeValueModel0() {
        this.valueInterop = null;
    }

    void initNewValue(V newValue) {
        this.initNewValueDependencies();
        this.initNewValue0(newValue);
    }

    boolean newValueInit() {
        return this.newValue != null;
    }

    void initNewValueDependencies() {
        this.initValueModel();
    }

    void initNewValue0(V newValue) {
        this.initNewInstanceValue0(newValue);
    }

    void initNewInstanceValue0(V newValue) {
        this.m().checkValue((Object)newValue);
        this.newValue = newValue;
        this.metaValueInterop = (MetaBytesInterop)this.m().metaValueInteropProvider.get(this.copies, this.m().originalMetaValueInterop, this.valueInterop, newValue);
        this.newValueSize = this.metaValueInterop.size(this.valueInterop, newValue);
    }

    void closeNewValue() {
        if (!this.newValueInit()) {
            return;
        }
        this.closeNewValueDependants();
        this.closeNewValue0();
    }

    void closeNewValueDependants() {
    }

    void closeNewValue0() {
        this.metaValueInterop = null;
        this.newValue = null;
    }

    @Override
    public boolean valueEqualTo(V value) {
        this.checkOnEachPublicOperation();
        this.initValueBytes();
        this.initNewValue(value);
        try {
            if (this.newValueSize != this.valueSize) {
                boolean bl = false;
                return bl;
            }
            this.entry.position(this.valueOffset);
            boolean bl = this.metaValueInterop.startsWith(this.valueInterop, (Bytes)this.entry, this.newValue);
            return bl;
        }
        finally {
            this.closeNewValue();
        }
    }

    @Override
    public void initEntrySizeInChunksDependencies() {
        super.initEntrySizeInChunksDependencies();
        this.initValueBytes();
    }

    @Override
    public void initEntrySizeInChunks0() {
        this.entrySizeInChunks = this.m().inChunks(this.valueOffset + this.valueSize);
    }

    @Override
    public boolean put(V newValue) {
        return this.doPut(newValue);
    }

    boolean doPut(V newValue) {
        this.checkOnEachPublicOperation();
        this.initPutDependencies();
        this.initNewValue(newValue);
        return this.put0();
    }

    void initPutDependencies() {
        this.initLocks();
        this.updateLockIfNeeded();
        this.initKeySearch();
        this.initValueModel();
        this.initKeyModel();
    }

    boolean put0() {
        if (this.searchState0() == HashContext.SearchState.ABSENT) {
            this.putEntry();
        } else {
            this.initValueBytes();
            this.putValue();
        }
        return true;
    }

    void putEntry() {
        long entrySize = this.entrySize(this.keySize0(), this.newValueSize);
        int allocatedChunks = this.allocateEntryAndWriteKey(entrySize - this.keySize0());
        this.initValueSizeOffset0();
        this.writeValueAndPutPos(allocatedChunks);
    }

    void writeValueAndPutPos(int allocatedChunks) {
        this.writeNewValueSize();
        this.writeNewValueAndSwitch();
        this.commitEntryAllocation();
        this.freeExtraAllocatedChunks(allocatedChunks);
    }

    /*
     * Enabled aggressive block sorting
     */
    void putValue() {
        this.initEntrySizeInChunks();
        int lesserChunks = -1;
        if (this.newValueSize != this.valueSize) {
            block11: {
                long newSizeOfEverythingBeforeValue = this.valueSizeOffset + (long)this.m().valueSizeMarshaller.sizeEncodingSize(this.newValueSize);
                long entryStartAddr = this.entry.address();
                long newValueAddr = this.m().alignment.alignAddr(entryStartAddr + newSizeOfEverythingBeforeValue);
                long newEntrySize = newValueAddr + this.newValueSize - entryStartAddr;
                int newSizeInChunks = this.m().inChunks(newEntrySize);
                if (newSizeInChunks > this.entrySizeInChunks) {
                    if (newSizeInChunks > this.m().maxChunksPerEntry) {
                        throw new IllegalArgumentException("Value too large: entry takes " + newSizeInChunks + " chunks, " + this.m().maxChunksPerEntry + " is maximum.");
                    }
                    if (this.freeList.allClear(this.pos + (long)this.entrySizeInChunks, this.pos + (long)newSizeInChunks)) {
                        long setFrom = this.searchStatePresent() ? this.pos + (long)this.entrySizeInChunks : this.pos;
                        this.freeList.set(setFrom, this.pos + (long)newSizeInChunks);
                        break block11;
                    } else {
                        this.beforeRelocation();
                        if (this.searchStatePresent()) {
                            this.free(this.pos, this.entrySizeInChunks);
                        }
                        int allocatedChunks = this.m().inChunks(this.innerEntrySize(newSizeOfEverythingBeforeValue, this.newValueSize));
                        this.pos = this.alloc(allocatedChunks);
                        this.reuse(this.pos);
                        NativeBytes.UNSAFE.copyMemory(entryStartAddr, this.entry.address(), this.valueSizeOffset);
                        this.writeValueAndPutPos(allocatedChunks);
                        return;
                    }
                }
                if (newSizeInChunks < this.entrySizeInChunks) {
                    if (this.searchStatePresent()) {
                        this.freeList.clear(this.pos + (long)newSizeInChunks, this.pos + (long)this.entrySizeInChunks);
                    }
                    lesserChunks = newSizeInChunks;
                }
            }
            this.upgradeToWriteLock();
            this.writeNewValueSize();
        } else {
            this.entry.position(this.valueOffset);
            this.upgradeToWriteLock();
        }
        this.writeNewValueAndSwitch();
        if (!this.searchStatePresent()) {
            this.freeList.set(this.pos, this.pos + (long)this.entrySizeInChunks);
            this.entries(this.entries() + 1L);
            this.commitEntryAllocation();
        }
        if (lesserChunks > 0) {
            this.freeExtraAllocatedChunks(lesserChunks);
        }
    }

    void beforeRelocation() {
    }

    void writeNewValueSize() {
        this.entry.position(this.valueSizeOffset);
        this.m().valueSizeMarshaller.writeSize((Bytes)this.entry, this.newValueSize);
        this.valueSize = this.newValueSize;
        this.m().alignment.alignPositionAddr((Bytes)this.entry);
        this.valueOffset = this.entry.position();
    }

    void writeNewValueAndSwitch() {
        this.entry.position(this.valueOffset);
        this.metaValueInterop.write(this.valueInterop, (Bytes)this.entry, this.newValue);
        this.value = this.newValue;
        this.closeNewValue0();
    }

    final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        if (this.m().constantlySizedEntry) {
            return this.m().alignment.alignAddr(sizeOfEverythingBeforeValue + valueSize);
        }
        if (this.m().couldNotDetermineAlignmentBeforeAllocation) {
            return sizeOfEverythingBeforeValue + (long)this.m().worstAlignment + valueSize;
        }
        return this.m().alignment.alignAddr(sizeOfEverythingBeforeValue) + valueSize;
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)(this.m().metaDataBytes + this.m().keySizeMarshaller.sizeEncodingSize(keySize)) + keySize + (long)this.m().valueSizeMarshaller.sizeEncodingSize(valueSize);
    }

    void initBytesValueModel0() {
        this.valueInterop = BytesBytesInterop.INSTANCE;
    }

    void initNewBytesValue0(Bytes entry) {
        this.metaValueInterop = DelegatingMetaBytesInterop.instance();
        entry.position(entry.limit());
        entry.limit(entry.capacity());
        this.newValueSize = this.m().valueSizeMarshaller.readSize(entry);
        entry.limit(entry.position() + this.newValueSize);
        this.initNewBytesValue00(entry);
    }

    void initNewBytesValue00(Bytes value) {
        this.valueCopy.setBytesOffset(value, value.position());
        this.valueCopy.limit(this.newValueSize);
        this.newValue = this.valueCopy;
    }

    void closeBytesValue0() {
        this.closeInstanceValue0();
        this.output = null;
    }

    Bytes getBytes() {
        return this.getBytesUsing(null);
    }

    Bytes getBytesUsing(Bytes usingValue) {
        this.initKeySearch();
        if (!this.containsKey()) {
            if (this.output != null) {
                this.output.ensureBufferSize(1L);
                this.output.in().writeBoolean(true);
            }
            return null;
        }
        if (this.output != null) {
            this.initValueBytes();
            long totalSize = 1L + (long)this.m().valueSizeMarshaller.sizeEncodingSize(this.valueSize) + this.valueSize;
            this.output.ensureBufferSize(totalSize);
            this.output.in().writeBoolean(false);
            this.m().valueSizeMarshaller.writeSize(this.output.in(), this.valueSize);
            this.output.in().write((RandomDataInput)this.entry, this.valueOffset, this.valueSize);
        }
        return DUMMY_BYTES;
    }

    final void freeExtraAllocatedChunks(int allocatedChunks) {
        int actuallyUsedChunks;
        if (!this.m().constantlySizedEntry && this.m().couldNotDetermineAlignmentBeforeAllocation && (actuallyUsedChunks = this.m().inChunks(this.valueOffset + this.valueSize)) < allocatedChunks) {
            this.free(this.pos + (long)actuallyUsedChunks, allocatedChunks - actuallyUsedChunks);
            this.entrySizeInChunks = actuallyUsedChunks;
        } else {
            this.entrySizeInChunks = allocatedChunks;
        }
    }

    @Override
    public void initKeyFromPos() {
        super.initKeyFromPos();
        this.initValueBytes();
    }

    boolean acquirePut(V newValue) {
        throw new UnsupportedOperationException("Acquire context doesn't support explicit put. Use simple lazy context (map.context()) instead.");
    }

    boolean acquireRemove() {
        throw new UnsupportedOperationException("Acquire context doesn't support remove. Use simple lazy context (map.context()) instead.");
    }

    void acquireClose() {
        this.checkOnEachPublicOperation();
        this.doPut(this.value);
        this.doClose();
    }

    static class MapAndContextLocals<K, V>
    extends HashContext.HashAndContextLocals<K> {
        V reusableValue;

        MapAndContextLocals(ChronicleMap<K, V> map) {
            super(map);
            if (map.valueClass() == CharSequence.class) {
                this.reusableValue = new StringBuilder();
            }
        }
    }

    static enum VanillaChronicleMapContextFactory implements ContextFactory<VanillaContext>
    {
        INSTANCE;


        @Override
        public VanillaContext createContext(HashContext root, int indexInContextCache) {
            return new VanillaContext(root, indexInContextCache);
        }

        @Override
        public VanillaContext createRootContext() {
            return new VanillaContext();
        }

        @Override
        public Class<VanillaContext> contextClass() {
            return VanillaContext.class;
        }
    }
}

