/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.hash.impl.util.Objects;
import net.openhft.chronicle.map.AbstractChronicleMap;
import net.openhft.chronicle.map.MapKeyContext;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.VanillaContext;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

public class BytesChronicleMap
implements AbstractChronicleMap<Bytes, Bytes> {
    final VanillaChronicleMap<?, ?, ?, ?, ?, ?> delegate;
    TcpReplicator.TcpSocketChannelEntryWriter output;

    public BytesChronicleMap(VanillaChronicleMap<?, ?, ?, ?, ?, ?> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void putDefaultValue(VanillaContext context) {
        this.delegate.putDefaultValue(context);
    }

    @Override
    public int actualSegments() {
        return this.delegate.actualSegments();
    }

    @Override
    public VanillaContext<Bytes, ?, ?, Bytes, ?, ?> mapContext() {
        VanillaContext context = this.delegate.bytesMapContext();
        context.output = this.output;
        return context;
    }

    @Override
    public File file() {
        return this.delegate.file();
    }

    @Override
    public long longSize() {
        return this.delegate.longSize();
    }

    @Override
    public VanillaContext<Bytes, ?, ?, Bytes, ?, ?> context(Bytes key) {
        VanillaContext context = this.delegate.bytesMapContext();
        context.output = this.output;
        context.initKey(key);
        return context;
    }

    @Override
    public void checkValue(Bytes value) {
        Objects.requireNonNull(value);
    }

    @Override
    public Class<Bytes> keyClass() {
        return Bytes.class;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    @NotNull
    public MapKeyContext<Bytes, Bytes> acquireContext(@NotNull Bytes key, @NotNull Bytes usingValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bytes newValueInstance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bytes newKeyInstance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<Bytes> valueClass() {
        return Bytes.class;
    }

    final void putAll(Bytes entries) {
        long numberOfEntries = entries.readStopBit();
        long entryPosition = entries.position();
        while (numberOfEntries-- > 0L) {
            long keySize = this.delegate.keySizeMarshaller.readSize(entries);
            entries.skip(keySize);
            long valueSize = this.delegate.valueSizeMarshaller.readSize(entries);
            long nextEntryPosition = entries.position() + valueSize;
            entries.position(entryPosition);
            this.put(entries, entries);
            entries.clear();
            entryPosition = nextEntryPosition;
            entries.position(entryPosition);
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    @NotNull
    public Set<Map.Entry<Bytes, Bytes>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

