/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.hashing.LongHashFunction;
import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

public final class LongMarshaller
extends Enum<LongMarshaller>
implements BytesInterop<Long>,
BytesReader<Long>,
SizeMarshaller {
    public static final /* enum */ LongMarshaller INSTANCE = new LongMarshaller();
    private static final /* synthetic */ LongMarshaller[] $VALUES;

    public static LongMarshaller[] values() {
        return (LongMarshaller[])$VALUES.clone();
    }

    public static LongMarshaller valueOf(String name) {
        return Enum.valueOf(LongMarshaller.class, name);
    }

    @Override
    public long size(@NotNull Long e) {
        return 8L;
    }

    @Override
    public int sizeEncodingSize(long size) {
        return 0;
    }

    @Override
    public long minEncodableSize() {
        return 8L;
    }

    @Override
    public int minSizeEncodingSize() {
        return 0;
    }

    @Override
    public int maxSizeEncodingSize() {
        return 0;
    }

    @Override
    public void writeSize(Bytes bytes, long size) {
        assert (size == 8L);
    }

    @Override
    public boolean startsWith(@NotNull Bytes bytes, @NotNull Long e) {
        return e.longValue() == bytes.readLong(bytes.position());
    }

    @Override
    public boolean equivalent(@NotNull Long a, @NotNull Long b) {
        return a.longValue() == b.longValue();
    }

    @Override
    public long hash(@NotNull LongHashFunction hashFunction, @NotNull Long e) {
        return hashFunction.hashLong(e);
    }

    @Override
    public void write(@NotNull Bytes bytes, @NotNull Long e) {
        bytes.writeLong(e.longValue());
    }

    @Override
    public long readSize(Bytes bytes) {
        return 8L;
    }

    @Override
    @NotNull
    public Long read(@NotNull Bytes bytes, long size) {
        return bytes.readLong();
    }

    @Override
    @NotNull
    public Long read(@NotNull Bytes bytes, long size, Long toReuse) {
        return bytes.readLong();
    }

    static {
        $VALUES = new LongMarshaller[]{INSTANCE};
    }
}

