/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.hashlookup;

import net.openhft.chronicle.hash.impl.hashlookup.EntryConsumer;
import net.openhft.chronicle.hash.impl.hashlookup.HashLookupIteration;
import net.openhft.lang.Maths;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.io.NativeBytes;

public class HashLookup {
    public static final int MAX_SEGMENT_CHUNKS = 0x40000000;
    public static final int MAX_SEGMENT_ENTRIES = 0x20000000;
    private static final long UNSET_KEY = 0L;
    private static final long UNSET_ENTRY = 0L;
    private long address;
    private long capacityMask;
    private int entrySize;
    private long capacityMask2;
    private int keyBits;
    private long keyMask;
    private long valueMask;
    private long entryMask;
    private long searchKey = 0L;
    private long searchStartPos = -1L;
    private long searchPos = -1L;

    public static int valueBits(long actualChunksPerSegment) {
        return 64 - Long.numberOfLeadingZeros(actualChunksPerSegment - 1L);
    }

    public static int keyBits(long entriesPerSegment, int valueBits) {
        int minKeyBits = 64 - Long.numberOfLeadingZeros(entriesPerSegment - 1L);
        int actualEntryBits = (int)MemoryUnit.BYTES.align((long)((minKeyBits += 3) + valueBits), MemoryUnit.BITS);
        return actualEntryBits - valueBits;
    }

    public static int entrySize(int keyBits, int valueBits) {
        return (int)MemoryUnit.BYTES.alignAndConvert((long)(keyBits + valueBits), MemoryUnit.BITS);
    }

    public static long capacityFor(long entriesPerSegment) {
        if (entriesPerSegment < 0L) {
            throw new IllegalArgumentException("entriesPerSegment should be positive");
        }
        long capacity = Maths.nextPower2((long)entriesPerSegment, (long)64L);
        if ((double)entriesPerSegment / (double)capacity > 0.6666666666666666) {
            capacity <<= 1;
        }
        return capacity;
    }

    private static long mask(int bits) {
        return (1L << bits) - 1L;
    }

    public void reuse(long address, long capacity, int entrySize, int keyBits, int valueBits) {
        this.address = address;
        this.capacityMask = capacity - 1L;
        this.entrySize = entrySize;
        this.capacityMask2 = this.capacityMask * (long)entrySize;
        this.keyBits = keyBits;
        this.keyMask = HashLookup.mask(keyBits);
        this.valueMask = HashLookup.mask(valueBits);
        this.entryMask = HashLookup.mask(keyBits + valueBits);
    }

    private long indexToPos(long index) {
        return index * (long)this.entrySize;
    }

    private long maskUnsetKey(long key) {
        return (key &= this.keyMask) != 0L ? key : this.keyMask;
    }

    private void checkValueForPut(long value) {
        assert ((value & (this.valueMask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) : "Value out of range, was " + value;
    }

    private boolean empty(long entry) {
        return (entry & this.entryMask) == 0L;
    }

    private long key(long entry) {
        return entry & this.keyMask;
    }

    private long value(long entry) {
        return entry >>> this.keyBits & this.valueMask;
    }

    private long entry(long key, long value) {
        return key | value << this.keyBits;
    }

    private long pos(long key) {
        return this.indexToPos(key & this.capacityMask);
    }

    private long step(long pos) {
        return (pos += (long)this.entrySize) <= this.capacityMask2 ? pos : 0L;
    }

    private long stepBack(long pos) {
        return (pos -= (long)this.entrySize) >= 0L ? pos : this.capacityMask2;
    }

    private long readEntry(long pos) {
        return NativeBytes.UNSAFE.getLong(this.address + pos);
    }

    private void writeEntry(long pos, long prevEntry, long key, long value) {
        long entry = prevEntry & (this.entryMask ^ 0xFFFFFFFFFFFFFFFFL) | this.entry(key, value);
        NativeBytes.UNSAFE.putLong(this.address + pos, entry);
    }

    private void writeEntryVolatile(long pos, long prevEntry, long key, long value) {
        long entry = prevEntry & (this.entryMask ^ 0xFFFFFFFFFFFFFFFFL) | this.entry(key, value);
        NativeBytes.UNSAFE.putLongVolatile(null, this.address + pos, entry);
    }

    private void writeEntry(long pos, long prevEntry, long anotherEntry) {
        long entry = prevEntry & (this.entryMask ^ 0xFFFFFFFFFFFFFFFFL) | anotherEntry & this.entryMask;
        NativeBytes.UNSAFE.putLong(this.address + pos, entry);
    }

    private void clearEntry(long pos, long prevEntry) {
        long entry = prevEntry & (this.entryMask ^ 0xFFFFFFFFFFFFFFFFL);
        NativeBytes.UNSAFE.putLong(this.address + pos, entry);
    }

    public void init0(long key) {
        this.searchKey = key = this.maskUnsetKey(key);
        this.searchStartPos = this.pos(key);
    }

    public boolean isInit() {
        return this.searchKey != 0L;
    }

    public void close0() {
        this.searchKey = 0L;
    }

    public void initSearch0() {
        this.searchPos = this.searchStartPos;
    }

    public boolean isSearchInit() {
        return this.searchPos >= 0L;
    }

    public void closeSearch0() {
        this.searchPos = -1L;
    }

    public long nextPos() {
        block2: {
            long entry;
            long pos = this.searchPos;
            do {
                if (this.empty(entry = this.readEntry(pos))) {
                    this.searchPos = pos;
                    return -1L;
                }
                if ((pos = this.step(pos)) == this.searchStartPos) break block2;
            } while (this.key(entry) != this.searchKey);
            this.searchPos = pos;
            return this.value(entry);
        }
        throw new IllegalStateException("MultiMap is full, that most likely means you misconfigured entrySize/chunkSize, and entries tend to take less chunks than expected");
    }

    public void found() {
        this.searchPos = this.stepBack(this.searchPos);
    }

    public void remove() {
        this.searchPos = this.remove0();
    }

    private long remove0() {
        return this.remove00(this.searchPos);
    }

    private long remove00(long posToRemove) {
        long entryToShift;
        long entryToRemove = this.readEntry(posToRemove);
        long posToShift = posToRemove;
        while (!this.empty(entryToShift = this.readEntry(posToShift = this.step(posToShift)))) {
            boolean cond2;
            long insertPos = this.pos(this.key(entryToShift));
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= posToShift;
            if ((!cond1 || !cond2) && (posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.writeEntry(posToRemove, entryToRemove, entryToShift);
            posToRemove = posToShift;
            entryToRemove = entryToShift;
        }
        this.clearEntry(posToRemove, entryToRemove);
        return posToRemove;
    }

    public void put(long value) {
        this.checkValueForPut(value);
        this.writeEntry(this.searchPos, this.readEntry(this.searchPos), this.searchKey, value);
    }

    public void putVolatile(long value) {
        this.checkValueForPut(value);
        this.writeEntryVolatile(this.searchPos, this.readEntry(this.searchPos), this.searchKey, value);
    }

    public void clear() {
        NativeBytes.UNSAFE.setMemory(this.address, this.capacityMask2 + (long)this.entrySize, (byte)0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        this.forEach((key, value) -> sb.append(key).append('=').append(value).append(','));
        sb.append('}');
        return sb.toString();
    }

    public void forEach(EntryConsumer action) {
        for (long pos = 0L; pos <= this.capacityMask2; pos += (long)this.entrySize) {
            long entry = this.readEntry(pos);
            if (this.empty(entry)) continue;
            action.accept(this.key(entry), this.value(entry));
        }
    }

    public void forEachRemoving(HashLookupIteration iteration) {
        long pos = 0L;
        while (!this.empty(this.readEntry(pos))) {
            pos = this.step(pos);
        }
        long startPos = pos;
        do {
            long entry;
            if (this.empty(entry = this.readEntry(pos = this.step(pos)))) continue;
            iteration.accept(this.key(entry), this.value(entry));
            if (!iteration.remove()) continue;
            this.remove00(pos);
            pos = this.stepBack(pos);
        } while (pos != startPos && iteration.continueIteration());
    }
}

