/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.channels.FileChannel;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.ChronicleHashErrorListener;
import net.openhft.chronicle.hash.hashing.Hasher;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.internal.BytesBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.DelegatingMetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesWriter;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.Asserts;
import net.openhft.chronicle.map.BuildVersion;
import net.openhft.chronicle.map.BytesMapEventListener;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.ConstantValueProvider;
import net.openhft.chronicle.map.Context;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.Function;
import net.openhft.chronicle.map.GetValueInterops;
import net.openhft.chronicle.map.HashSplitting;
import net.openhft.chronicle.map.InstanceOrBytesToInstance;
import net.openhft.chronicle.map.JsonSerializer;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.map.MultiMap;
import net.openhft.chronicle.map.MultiMapFactory;
import net.openhft.chronicle.map.PrepareValueBytesAsWriter;
import net.openhft.chronicle.map.ReadContext;
import net.openhft.chronicle.map.ReadValue;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.SearchState;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.SharedSegment;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.UnaryOperator;
import net.openhft.chronicle.map.WriteContext;
import net.openhft.lang.Jvm;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.MappedStore;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.StatefulCopyable;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VanillaChronicleMap<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
extends AbstractMap<K, V>
implements ChronicleMap<K, V>,
Serializable,
ReadValue<V>,
InstanceOrBytesToInstance,
GetValueInterops<V, VI, MVI> {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaChronicleMap.class);
    private static final long serialVersionUID = 2L;
    final Class<K> kClass;
    final String dataFileVersion;
    final SizeMarshaller keySizeMarshaller;
    final BytesReader<K> originalKeyReader;
    final KI originalKeyInterop;
    final MKI originalMetaKeyInterop;
    final MetaProvider<K, KI, MKI> metaKeyInteropProvider;
    final Class<V> vClass;
    final SizeMarshaller valueSizeMarshaller;
    final BytesReader<V> originalValueReader;
    final VI originalValueInterop;
    final MVI originalMetaValueInterop;
    final MetaProvider<V, VI, MVI> metaValueInteropProvider;
    final DefaultValueProvider<K, V> defaultValueProvider;
    final PrepareValueBytesAsWriter<K> prepareValueBytesAsWriter;
    final int metaDataBytes;
    final long chunkSize;
    final Alignment alignment;
    final boolean constantlySizedEntry;
    final int worstAlignment;
    final boolean couldNotDetermineAlignmentBeforeAllocation;
    final int specialEntrySpaceOffset;
    final int actualSegments;
    final long actualChunksPerSegment;
    final long entriesPerSegment;
    final MapEventListener<K, V> eventListener;
    final BytesMapEventListener bytesEventListener;
    final boolean putReturnsNull;
    final boolean removeReturnsNull;
    private final long lockTimeOutNS;
    private final ChronicleHashErrorListener errorListener;
    private final int segmentHeaderSize;
    private final HashSplitting hashSplitting;
    final Class nativeValueClass;
    final MultiMapFactory multiMapFactory;
    final int maxChunksPerEntry;
    transient Provider<BytesReader<K>> keyReaderProvider;
    transient Provider<KI> keyInteropProvider;
    transient Provider<BytesReader<V>> valueReaderProvider;
    transient Provider<VI> valueInteropProvider;
    transient Segment[] segments;
    transient BytesStore ms;
    transient long headerSize;
    transient Set<Map.Entry<K, V>> entrySet;
    transient InstanceOrBytesToInstance<Bytes, K> keyBytesToInstance = new InstanceOrBytesToInstance<Bytes, K>(){

        @Override
        public K toInstance(@NotNull ThreadLocalCopies copies, Bytes keyBytes, long size) {
            Asserts.assertNotNull(copies);
            BytesReader keyReader = (BytesReader)VanillaChronicleMap.this.keyReaderProvider.get(copies, VanillaChronicleMap.this.originalKeyReader);
            return keyReader.read(keyBytes, size);
        }
    };
    transient InstanceOrBytesToInstance<Bytes, V> valueBytesToInstance = new InstanceOrBytesToInstance<Bytes, V>(){

        @Override
        public V toInstance(@NotNull ThreadLocalCopies copies, Bytes valueBytes, long size) {
            return VanillaChronicleMap.this.readValue(copies, valueBytes, null, size);
        }
    };
    transient InstanceOrBytesToInstance<Bytes, V> outputValueBytesToInstance = new InstanceOrBytesToInstance<Bytes, V>(){

        @Override
        public V toInstance(@NotNull ThreadLocalCopies copies, Bytes outputBytes, long size) {
            outputBytes.position(outputBytes.position() - size);
            return VanillaChronicleMap.this.readValue(copies, outputBytes, null, size);
        }
    };
    static final boolean checkSegmentMultiMapsAndBitSetsConsistencyOnBootstrap = Boolean.getBoolean("chronicleMap.checkSegmentMultiMapsAndBitSetsConsistencyOnBootstrap");

    public VanillaChronicleMap(ChronicleMapBuilder<K, V> builder) throws IOException {
        SerializationBuilder keyBuilder = builder.keyBuilder;
        this.kClass = keyBuilder.eClass;
        this.keySizeMarshaller = keyBuilder.sizeMarshaller();
        this.originalKeyReader = keyBuilder.reader();
        this.dataFileVersion = BuildVersion.version();
        this.originalKeyInterop = keyBuilder.interop();
        this.originalMetaKeyInterop = keyBuilder.metaInterop();
        this.metaKeyInteropProvider = keyBuilder.metaInteropProvider();
        SerializationBuilder valueBuilder = builder.valueBuilder;
        this.vClass = valueBuilder.eClass;
        if (this.vClass.getName().endsWith("$$Native")) {
            this.nativeValueClass = this.vClass;
        } else if (this.vClass.isInterface()) {
            Class nativeValueClass = null;
            try {
                nativeValueClass = DataValueClasses.directClassFor(this.vClass);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.nativeValueClass = nativeValueClass;
        } else {
            this.nativeValueClass = null;
        }
        this.valueSizeMarshaller = valueBuilder.sizeMarshaller();
        this.originalValueReader = valueBuilder.reader();
        this.originalValueInterop = valueBuilder.interop();
        this.originalMetaValueInterop = valueBuilder.metaInterop();
        this.metaValueInteropProvider = valueBuilder.metaInteropProvider();
        this.defaultValueProvider = builder.defaultValueProvider();
        this.prepareValueBytesAsWriter = builder.prepareValueBytesAsWriter();
        this.lockTimeOutNS = builder.lockTimeOut(TimeUnit.NANOSECONDS);
        boolean replicated = this.getClass() == ReplicatedChronicleMap.class;
        this.chunkSize = builder.chunkSize(replicated);
        this.alignment = builder.valueAlignment();
        this.constantlySizedEntry = builder.constantlySizedEntries();
        this.worstAlignment = builder.worstAlignment(replicated);
        int alignment = this.alignment.alignment();
        this.couldNotDetermineAlignmentBeforeAllocation = ChronicleMapBuilder.greatestCommonDivisor((int)this.chunkSize, alignment) != alignment;
        this.specialEntrySpaceOffset = builder.specialEntrySpaceOffset(replicated);
        this.errorListener = builder.errorListener();
        this.putReturnsNull = builder.putReturnsNull();
        this.removeReturnsNull = builder.removeReturnsNull();
        this.actualSegments = builder.actualSegments(replicated);
        this.actualChunksPerSegment = builder.actualChunksPerSegment(replicated);
        this.entriesPerSegment = builder.entriesPerSegment(replicated);
        this.multiMapFactory = builder.multiMapFactory(replicated);
        this.metaDataBytes = builder.metaDataBytes();
        this.eventListener = builder.eventListener();
        this.bytesEventListener = builder.bytesEventListener();
        this.segmentHeaderSize = builder.segmentHeaderSize(replicated);
        this.maxChunksPerEntry = builder.maxChunksPerEntry();
        this.hashSplitting = HashSplitting.Splitting.forSegments(this.actualSegments);
        this.initTransients();
    }

    public String persistedDataVersion() {
        return this.dataFileVersion;
    }

    public String applicationVersion() {
        return BuildVersion.version();
    }

    final long segmentHash(long hash) {
        return this.hashSplitting.segmentHash(hash);
    }

    final int getSegment(long hash) {
        return this.hashSplitting.segmentIndex(hash);
    }

    void initTransients() {
        ConstantValueProvider constantValueProvider;
        this.keyReaderProvider = Provider.of(this.originalKeyReader.getClass());
        this.keyInteropProvider = Provider.of(this.originalKeyInterop.getClass());
        this.valueReaderProvider = Provider.of(this.originalValueReader.getClass());
        this.valueInteropProvider = Provider.of(this.originalValueInterop.getClass());
        if (this.defaultValueProvider instanceof ConstantValueProvider && (constantValueProvider = (ConstantValueProvider)this.defaultValueProvider).wasDeserialized()) {
            ThreadLocalCopies copies = this.valueReaderProvider.getCopies(null);
            BytesReader valueReader = (BytesReader)this.valueReaderProvider.get(copies, this.originalValueReader);
            constantValueProvider.initTransients(valueReader);
        }
        Segment[] ss = (Segment[])Array.newInstance(this.segmentType(), this.actualSegments);
        this.segments = ss;
    }

    Class segmentType() {
        return Segment.class;
    }

    final long createMappedStoreAndSegments(BytesStore bytesStore) throws IOException {
        this.ms = bytesStore;
        this.onHeaderCreated();
        long offset = this.getHeaderSize();
        long segmentHeaderSize = this.getSegmentHeaderSize();
        long segmentHeadersSize = (long)this.segments.length * segmentHeaderSize;
        Bytes segmentHeaders = this.ms.bytes(offset, segmentHeadersSize);
        offset += segmentHeadersSize;
        long segmentSize = this.segmentSize();
        long headerOffset = 0L;
        for (int i = 0; i < this.segments.length; ++i) {
            Bytes segmentHeader = segmentHeaders.bytes(headerOffset, segmentHeaderSize);
            NativeBytes segmentData = (NativeBytes)this.ms.bytes(offset, segmentSize);
            this.segments[i] = this.createSegment(segmentHeader, segmentData, i);
            headerOffset += segmentHeaderSize;
            offset += segmentSize;
        }
        return offset;
    }

    void warnOnWindows() {
        if (!Jvm.isWindows()) {
            return;
        }
        long offHeapMapSize = this.sizeInBytes();
        long oneGb = MemoryUnit.GIGABYTES.toBytes(1L);
        double offHeapMapSizeInGb = (double)offHeapMapSize * 1.0 / (double)oneGb;
        if (offHeapMapSize > MemoryUnit.GIGABYTES.toBytes(4L)) {
            System.out.printf("WARNING: On Windows, you probably cannot create a ChronicleMap\nof more than 4 GB. The configured map requires %.2f GB of off-heap memory.\n", offHeapMapSizeInGb);
        }
        try {
            long freePhysicalMemory = Jvm.freePhysicalMemoryOnWindowsInBytes();
            if ((double)offHeapMapSize > (double)freePhysicalMemory * 0.9) {
                double freePhysicalMemoryInGb = (double)freePhysicalMemory * 1.0 / (double)oneGb;
                System.out.printf("WARNING: On Windows, you probably cannot create a ChronicleMap\nof more than 90%% of available free memory in the system.\nThe configured map requires %.2f GB of off-heap memory.\nThere is only %.2f GB of free physical memory in the system.\n", offHeapMapSizeInGb, freePhysicalMemoryInGb);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    final long createMappedStoreAndSegments(File file) throws IOException {
        this.warnOnWindows();
        return this.createMappedStoreAndSegments((BytesStore)new MappedStore(file, FileChannel.MapMode.READ_WRITE, this.sizeInBytes(), (ObjectSerializer)JDKObjectSerializer.INSTANCE));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransients();
    }

    void onHeaderCreated() {
    }

    long getHeaderSize() {
        return this.headerSize;
    }

    final long getSegmentHeaderSize() {
        return this.segmentHeaderSize;
    }

    Segment createSegment(Bytes segmentHeader, NativeBytes bytes, int index) {
        return new Segment(segmentHeader, bytes, index);
    }

    @Override
    public File file() {
        return this.ms.file();
    }

    final long sizeInBytes() {
        return this.getHeaderSize() + (long)this.segments.length * this.getSegmentHeaderSize() + (long)this.segments.length * this.segmentSize();
    }

    private long sizeOfMultiMap() {
        return this.multiMapFactory.sizeInBytes(this.entriesPerSegment);
    }

    private long sizeOfMultiMapBitSet() {
        return MultiMapFactory.sizeOfBitSetInBytes(this.actualChunksPerSegment);
    }

    private long sizeOfSegmentFreeListBitSets() {
        return MemoryUnit.CACHE_LINES.align(MemoryUnit.BYTES.alignAndConvert(this.actualChunksPerSegment, MemoryUnit.BITS), MemoryUnit.BYTES);
    }

    private int numberOfBitSets() {
        return 1;
    }

    private long segmentSize() {
        long ss = MemoryUnit.CACHE_LINES.align(this.sizeOfMultiMap() + this.sizeOfMultiMapBitSet(), MemoryUnit.BYTES) * (long)this.multiMapsPerSegment() + (long)this.numberOfBitSets() * this.sizeOfSegmentFreeListBitSets() + this.sizeOfEntrySpaceInSegment();
        if ((ss & 0x3FL) != 0L) {
            throw new AssertionError();
        }
        return this.breakL1CacheAssociativityContention(ss);
    }

    private long breakL1CacheAssociativityContention(long segmentSize) {
        int alignmentToBreak = 2048;
        int eachNthSegmentFallIntoTheSameSet = Math.max(1, alignmentToBreak >> Long.numberOfTrailingZeros(segmentSize));
        if (eachNthSegmentFallIntoTheSameSet < this.actualSegments) {
            segmentSize |= 0x40L;
        }
        return segmentSize;
    }

    private int multiMapsPerSegment() {
        return 1;
    }

    private long sizeOfEntrySpaceInSegment() {
        return MemoryUnit.CACHE_LINES.align((long)this.specialEntrySpaceOffset + this.actualChunksPerSegment * this.chunkSize, MemoryUnit.BYTES);
    }

    @Override
    public void close() {
        if (this.ms == null) {
            return;
        }
        this.ms.free();
        this.segments = null;
        this.ms = null;
    }

    final void checkKey(Object key) {
        if (!this.kClass.isInstance(key)) {
            throw new ClassCastException("Key must be a " + this.kClass.getName() + " but was a " + key.getClass());
        }
    }

    final void checkValue(Object value) {
        if (this.vClass != Void.class && !this.vClass.isInstance(value)) {
            throw new ClassCastException("Value must be a " + this.vClass.getName() + " but was a " + value.getClass());
        }
    }

    @Override
    final void put(Bytes entry, TcpReplicator.TcpSocketChannelEntryWriter output) {
        this.put(entry, output, true);
    }

    @Override
    final void putIfAbsent(Bytes entry, TcpReplicator.TcpSocketChannelEntryWriter output) {
        this.put(entry, output, false);
    }

    private void put(Bytes entry, TcpReplicator.TcpSocketChannelEntryWriter output, boolean replaceIfPresent) {
        ThreadLocalCopies copies = SegmentState.getCopies(null);
        SegmentState segmentState = SegmentState.get(copies);
        ReadValueToOutputBytes readValueToOutputBytes = segmentState.readValueToOutputBytes;
        readValueToOutputBytes.reuse(this.valueSizeMarshaller, output);
        long keySize = this.keySizeMarshaller.readSize(entry);
        entry.limit(entry.position() + keySize);
        GetRemoteBytesValueInterops getRemoteBytesValueInterops = segmentState.getRemoteBytesValueInterops;
        MultiStoreBytes value = getRemoteBytesValueInterops.getValueBytes(entry, entry.position() + keySize);
        getRemoteBytesValueInterops.valueSizeMarshaller(this.valueSizeMarshaller);
        this.putBytes(copies, segmentState, entry, keySize, getRemoteBytesValueInterops, value, replaceIfPresent, readValueToOutputBytes);
    }

    void putBytes(ThreadLocalCopies copies, SegmentState segmentState, Bytes key, long keySize, GetRemoteBytesValueInterops getRemoteBytesValueInterops, MultiStoreBytes value, boolean replaceIfPresent, ReadValue<Bytes> readValue) {
        this.put2(copies, segmentState, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, key, keySize, this.keyBytesToInstance, getRemoteBytesValueInterops, value, this.valueBytesToInstance, replaceIfPresent, readValue, false);
    }

    final void put(Bytes entry) {
        ThreadLocalCopies copies = SegmentState.getCopies(null);
        SegmentState segmentState = SegmentState.get(copies);
        long keySize = this.keySizeMarshaller.readSize(entry);
        entry.limit(entry.position() + keySize);
        GetRemoteBytesValueInterops getRemoteBytesValueInterops = segmentState.getRemoteBytesValueInterops;
        MultiStoreBytes value = getRemoteBytesValueInterops.getValueBytes(entry, entry.position() + keySize);
        getRemoteBytesValueInterops.valueSizeMarshaller(this.valueSizeMarshaller);
        ReadValueToBytes readValueToLazyBytes = segmentState.readValueToLazyBytes;
        readValueToLazyBytes.valueSizeMarshaller(this.valueSizeMarshaller);
        this.put2(copies, segmentState, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, entry, keySize, this.keyBytesToInstance, getRemoteBytesValueInterops, value, this.valueBytesToInstance, true, readValueToLazyBytes, true);
    }

    @Override
    public final V put(K key, V value) {
        return this.put1(key, value, true);
    }

    @Override
    public final V putIfAbsent(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.put1(key, value, false);
    }

    V put1(K key, V value, boolean replaceIfPresent) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkKey(key);
        this.checkValue(value);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long keySize = metaKeyInterop.size(keyInterop, key);
        return (V)this.put2(copies, null, metaKeyInterop, keyInterop, key, keySize, this.keyIdentity(), this, value, this.valueIdentity(), replaceIfPresent, this, this.putReturnsNull);
    }

    <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> RV put2(ThreadLocalCopies copies, SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB value, InstanceOrBytesToInstance<? super VB, V> toValue, boolean replaceIfPresent, ReadValue<RV> readValue, boolean resultUnused) {
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        return this.segments[segmentNum].put3(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, getValueInterops, value, toValue, segmentHash, replaceIfPresent, readValue, resultUnused);
    }

    @Override
    public final V get(Object key) {
        this.checkKey(key);
        try {
            return this.lookupUsing(key, null, false);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final V getUsing(K key, V usingValue) {
        this.checkKey(key);
        try {
            return this.lookupUsing(key, usingValue, false);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final V acquireUsing(@NotNull K key, V usingValue) {
        this.checkKey(key);
        try {
            return this.lookupUsing(key, usingValue, true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    final void getBytes(Bytes key, TcpReplicator.TcpSocketChannelEntryWriter output) {
        ThreadLocalCopies copies = SegmentState.getCopies(null);
        SegmentState segmentState = SegmentState.get(copies);
        ReadValueToOutputBytes readValueToOutputBytes = segmentState.readValueToOutputBytes;
        readValueToOutputBytes.reuse(this.valueSizeMarshaller, output);
        try {
            this.lookupUsing(copies, segmentState, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, key, this.keySizeMarshaller.readSize(key), this.keyBytesToInstance, readValueToOutputBytes, null, this.outputValueBytesToInstance, false, null);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private V lookupUsing(K key, V usingValue, boolean create) throws InterruptedException {
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long keySize = metaKeyInterop.size(keyInterop, key);
        return this.lookupUsing(copies, null, metaKeyInterop, keyInterop, key, keySize, this.keyIdentity(), this, usingValue, this.valueIdentity(), create, null);
    }

    private <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV> RV lookupUsing(ThreadLocalCopies copies, SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, ReadValue<RV> readValue, RV usingValue, InstanceOrBytesToInstance<RV, V> toValue, boolean create, MutableLockedEntry lock) throws InterruptedException {
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        Segment segment = this.segments[segmentNum];
        return segment.acquire(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, readValue, usingValue, toValue, segmentHash, create, lock);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R getMapped(K key, @NotNull Function<? super V, R> function) {
        try (ReadContext entry = (ReadContext)this.lookupUsing(key, null, false, false, LockType.READ_LOCK);){
            R r = entry.present() ? (R)function.apply((V)entry.value()) : null;
            return r;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public V putMapped(K key, @NotNull UnaryOperator<V> unaryOperator) {
        return this.vClass.equals(CharSequence.class) || this.vClass.equals(StringBuilder.class) ? this.putMappedSB(key, unaryOperator) : this.putMapped0(key, unaryOperator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    V putMappedSB(K key, @NotNull UnaryOperator<V> unaryOperator) {
        StringBuilder usingSB = new StringBuilder("\uffff");
        try (WriteContext entry = (WriteContext)this.lookupUsing(key, usingSB, false, true, LockType.WRITE_LOCK);){
            usingSB = (StringBuilder)entry.value();
            if (usingSB.length() == 1 && usingSB.charAt(0) == '\uffff') {
                V v = null;
                return v;
            }
            StringBuilder result = unaryOperator.update(usingSB);
            if (usingSB != result) {
                usingSB.setLength(0);
                usingSB.append((CharSequence)result);
            }
            StringBuilder stringBuilder = result;
            return (V)stringBuilder;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    V putMapped0(K key, @NotNull UnaryOperator<V> unaryOperator) {
        try (WriteContext entry = (WriteContext)this.lookupUsing(key, null, false, true, LockType.WRITE_LOCK);){
            if (entry.value() == null) {
                V v = null;
                return v;
            }
            V result = unaryOperator.update(entry.value());
            ((MutableLockedEntry)((Object)entry)).value(result);
            V v = result;
            return v;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void getAll(File toFile) throws IOException {
        JsonSerializer.getAll(toFile, this, Collections.emptyList());
    }

    @Override
    public synchronized void putAll(File fromFile) throws IOException {
        JsonSerializer.putAll(fromFile, this, Collections.emptyList());
    }

    @Override
    public V newValueInstance() {
        if (this.vClass == CharSequence.class || this.vClass == StringBuilder.class) {
            return (V)new StringBuilder();
        }
        return VanillaChronicleMap.newInstance(this.vClass, false);
    }

    @Override
    public K newKeyInstance() {
        return VanillaChronicleMap.newInstance(this.kClass, true);
    }

    @Override
    public Class<K> keyClass() {
        return this.kClass;
    }

    @Override
    public Class<V> valueClass() {
        return this.vClass;
    }

    static <T> T newInstance(Class<T> aClass, boolean isKey) {
        try {
            return (T)(isKey ? DataValueClasses.newInstance(aClass) : DataValueClasses.newDirectInstance(aClass));
        }
        catch (Exception e) {
            if (e.getCause() instanceof IllegalStateException) {
                throw e;
            }
            if (aClass.isInterface()) {
                throw new IllegalStateException("It not possible to create a instance from interface=" + aClass.getSimpleName() + " we recommend you create an " + "instance in the usual way.", e);
            }
            try {
                return aClass.newInstance();
            }
            catch (Exception e1) {
                throw new IllegalStateException("It has not been possible to create a instance of class=" + aClass.getSimpleName() + ", Note : its more efficient if your chronicle map is configured with " + "interface key " + "and value types rather than classes, as this method is able to use " + "interfaces to generate off heap proxies that point straight at your data. " + "In this case you have used a class and chronicle is unable to create an " + "instance of this class has it does not have a default constructor. " + "If your class is mutable, we " + "recommend you create and instance of your class=" + aClass.getSimpleName() + " in the usual way, rather than using this method.", e);
            }
        }
    }

    @Override
    @NotNull
    public final WriteContext<K, V> acquireUsingLocked(@NotNull K key, @NotNull V usingValue) {
        try {
            return (WriteContext)this.lookupUsing(key, usingValue, true, true, LockType.WRITE_LOCK);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public final ReadContext<K, V> getUsingLocked(@NotNull K key, @NotNull V usingValue) {
        try {
            return (ReadContext)this.lookupUsing(key, usingValue, true, false, LockType.READ_LOCK);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private <T extends Context> T lookupUsing(K key, V usingValue, boolean mustReuseValue, boolean create, LockType lockType) throws InterruptedException {
        this.checkKey(key);
        ThreadLocalCopies copies = SegmentState.getCopies(null);
        SegmentState segmentState = SegmentState.get(copies);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long keySize = metaKeyInterop.size(keyInterop, key);
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        Segment segment = this.segments[segmentNum];
        boolean nativeValueClass = usingValue != null && usingValue.getClass() == this.nativeValueClass;
        WriteLocked lock = lockType == LockType.WRITE_LOCK ? segment.writeLock(segmentState, nativeValueClass) : segment.readLock(segmentState);
        V v = segment.acquireWithoutLock(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, this.keyIdentity(), this, usingValue, this.valueIdentity(), segmentHash, create, lock);
        this.checkReallyUsingValue(usingValue, mustReuseValue, v);
        lock.initKey(copies, metaKeyInterop, keyInterop, keySize, segmentHash, key);
        if (!nativeValueClass && lockType == LockType.WRITE_LOCK && v == null) {
            v = usingValue;
        }
        lock.value(v);
        return (T)lock;
    }

    private void checkReallyUsingValue(V usingValue, boolean mustReuseValue, V returnedValue) {
        if (mustReuseValue && returnedValue != null && returnedValue != usingValue) {
            throw new IllegalArgumentException("acquireUsingLocked/getUsingLocked MUST reuse given values. Given value" + usingValue + " cannot be reused to read " + returnedValue);
        }
    }

    public final Object toInstance(@NotNull ThreadLocalCopies copies, Object instance, long size) {
        return instance;
    }

    final InstanceOrBytesToInstance<K, K> keyIdentity() {
        return this;
    }

    final InstanceOrBytesToInstance<V, V> valueIdentity() {
        return this;
    }

    @Override
    public final boolean containsKey(Object k) {
        this.checkKey(k);
        Object key = k;
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        try {
            return this.containsKey(copies, metaKeyInterop, keyInterop, key, metaKeyInterop.size(keyInterop, key));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    final boolean containsBytesKey(Bytes key) throws InterruptedException {
        return this.containsKey(null, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, key, this.keySizeMarshaller.readSize(key));
    }

    private <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>> boolean containsKey(ThreadLocalCopies copies, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize) throws InterruptedException {
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        Segment segment = this.segments[segmentNum];
        return segment.containsKey(copies, metaKeyInterop, keyInterop, key, keySize, segmentHash);
    }

    @Override
    public void clear() {
        for (Segment segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    @NotNull
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = this.newEntrySet());
    }

    Set<Map.Entry<K, V>> newEntrySet() {
        return new EntrySet();
    }

    @Override
    public final V remove(Object key) {
        return (V)this.removeIfValueIs(key, null);
    }

    @Override
    public final boolean remove(@net.openhft.lang.model.constraints.NotNull Object key, Object value) {
        if (value == null) {
            return false;
        }
        return (Boolean)this.removeIfValueIs(key, value);
    }

    @Override
    public final VI getValueInterop(@NotNull ThreadLocalCopies copies) {
        Asserts.assertNotNull(copies);
        return (VI)this.valueInteropProvider.get(copies, this.originalValueInterop);
    }

    @Override
    public final MVI getMetaValueInterop(@NotNull ThreadLocalCopies copies, VI valueInterop, V value) {
        Asserts.assertNotNull(copies);
        return (MVI)((MetaBytesInterop)this.metaValueInteropProvider.get(copies, this.originalMetaValueInterop, valueInterop, value));
    }

    private Object removeIfValueIs(Object k, V expectedValue) {
        this.checkKey(k);
        Object key = k;
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long keySize = metaKeyInterop.size(keyInterop, key);
        return this.remove(copies, null, metaKeyInterop, keyInterop, key, keySize, this.keyIdentity(), this, expectedValue, this.valueIdentity(), this, this.removeReturnsNull);
    }

    final void removeBytesKeyWithoutOutput(Bytes key) {
        ThreadLocalCopies copies = SegmentState.getCopies(null);
        SegmentState segmentState = SegmentState.get(copies);
        ReadValueToBytes readValueToLazyBytes = segmentState.readValueToLazyBytes;
        readValueToLazyBytes.valueSizeMarshaller(this.valueSizeMarshaller);
        long keySize = this.keySizeMarshaller.readSize(key);
        key.limit(key.position() + keySize);
        this.remove(null, null, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, key, keySize, this.keyBytesToInstance, null, null, this.outputValueBytesToInstance, readValueToLazyBytes, true);
    }

    final void removeBytesKeyOutputPrevValue(Bytes key, TcpReplicator.TcpSocketChannelEntryWriter output) {
        ThreadLocalCopies copies = SegmentState.getCopies(null);
        SegmentState segmentState = SegmentState.get(copies);
        ReadValueToOutputBytes readValueToOutputBytes = segmentState.readValueToOutputBytes;
        readValueToOutputBytes.reuse(this.valueSizeMarshaller, output);
        long keySize = this.keySizeMarshaller.readSize(key);
        key.limit(key.position() + keySize);
        this.remove(copies, segmentState, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, key, keySize, this.keyBytesToInstance, null, null, this.outputValueBytesToInstance, readValueToOutputBytes, false);
    }

    final boolean removeBytesEntry(Bytes entry) {
        ThreadLocalCopies copies = SegmentState.getCopies(null);
        SegmentState segmentState = SegmentState.get(copies);
        long keySize = this.keySizeMarshaller.readSize(entry);
        entry.limit(entry.position() + keySize);
        GetRemoteBytesValueInterops getRemoveBytesValueInterops = segmentState.getRemoteBytesValueInterops;
        MultiStoreBytes value = getRemoveBytesValueInterops.getValueBytes(entry, entry.position() + keySize);
        getRemoveBytesValueInterops.valueSizeMarshaller(this.valueSizeMarshaller);
        ReadValueToBytes readValueToLazyBytes = segmentState.readValueToLazyBytes;
        readValueToLazyBytes.valueSizeMarshaller(this.valueSizeMarshaller);
        return (Boolean)this.remove(copies, segmentState, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, entry, keySize, this.keyBytesToInstance, getRemoveBytesValueInterops, value, this.valueBytesToInstance, readValueToLazyBytes, false);
    }

    private <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<? super VB, ? super VBI>> Object remove(ThreadLocalCopies copies, SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB expectedValue, InstanceOrBytesToInstance<RV, V> toValue, ReadValue<RV> readValue, boolean resultUnused) {
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        Segment segment = this.segments[segmentNum];
        return segment.remove(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, getValueInterops, expectedValue, toValue, segmentHash, readValue, resultUnused);
    }

    @Override
    public final boolean replace(@net.openhft.lang.model.constraints.NotNull K key, @net.openhft.lang.model.constraints.NotNull V oldValue, @net.openhft.lang.model.constraints.NotNull V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        this.checkValue(oldValue);
        return (Boolean)this.replaceIfValueIs(key, oldValue, newValue);
    }

    @Override
    public final V replace(@net.openhft.lang.model.constraints.NotNull K key, @net.openhft.lang.model.constraints.NotNull V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return (V)this.replaceIfValueIs(key, null, value);
    }

    @Override
    public final long longSize() {
        long result = 0L;
        for (Segment segment : this.segments) {
            result += segment.size();
        }
        return result;
    }

    @Override
    public final int size() {
        long size = this.longSize();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    private Object replaceIfValueIs(@net.openhft.lang.model.constraints.NotNull K key, V expectedValue, V newValue) {
        this.checkKey(key);
        this.checkValue(newValue);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long keySize = metaKeyInterop.size(keyInterop, key);
        return this.replace(copies, null, metaKeyInterop, keyInterop, key, keySize, this.keyIdentity(), this, expectedValue, this, newValue, this, this.valueIdentity());
    }

    final void replaceKV(Bytes keyAndNewValue, TcpReplicator.TcpSocketChannelEntryWriter output) {
        ThreadLocalCopies copies = SegmentState.getCopies(null);
        SegmentState segmentState = SegmentState.get(copies);
        ReadValueToOutputBytes readValueToOutputBytes = segmentState.readValueToOutputBytes;
        readValueToOutputBytes.reuse(this.valueSizeMarshaller, output);
        long keySize = this.keySizeMarshaller.readSize(keyAndNewValue);
        keyAndNewValue.limit(keyAndNewValue.position() + keySize);
        GetRemoteBytesValueInterops getRemoteBytesValueInterops = segmentState.getRemoteBytesValueInterops;
        MultiStoreBytes value = getRemoteBytesValueInterops.getValueBytes(keyAndNewValue, keyAndNewValue.position() + keySize);
        getRemoteBytesValueInterops.valueSizeMarshaller(this.valueSizeMarshaller);
        this.replace(copies, segmentState, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, keyAndNewValue, keySize, this.keyBytesToInstance, null, null, getRemoteBytesValueInterops, value, readValueToOutputBytes, this.valueBytesToInstance);
    }

    final void replaceWithOldAndNew(Bytes entryAndNewValue, Bytes output) {
        ThreadLocalCopies copies = SegmentState.getCopies(null);
        SegmentState segmentState = SegmentState.get(copies);
        long keySize = this.keySizeMarshaller.readSize(entryAndNewValue);
        long keyPosition = entryAndNewValue.position();
        GetRemoteBytesValueInterops getExpectedValueInterops = segmentState.getRemoteBytesValueInterops;
        MultiStoreBytes expectedValue = getExpectedValueInterops.getValueBytes(entryAndNewValue, keyPosition + keySize);
        getExpectedValueInterops.valueSizeMarshaller(this.valueSizeMarshaller);
        entryAndNewValue.position(keyPosition + keySize);
        long expectedValueSize = this.valueSizeMarshaller.readSize(entryAndNewValue);
        GetRemoteBytesValueInterops getNewValueInterops = segmentState.getRemoteBytesValueInterops2;
        MultiStoreBytes newValue = getNewValueInterops.getValueBytes(entryAndNewValue, entryAndNewValue.position() + expectedValueSize);
        getNewValueInterops.valueSizeMarshaller(this.valueSizeMarshaller);
        entryAndNewValue.position(keyPosition);
        entryAndNewValue.limit(keyPosition + keySize);
        output.writeBoolean(((Boolean)this.replace(copies, segmentState, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, entryAndNewValue, keySize, this.keyBytesToInstance, getExpectedValueInterops, expectedValue, getNewValueInterops, newValue, null, this.valueBytesToInstance)).booleanValue());
    }

    private <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> Object replace(ThreadLocalCopies copies, SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getExpectedValueInterops, VB existingValue, GetValueInterops<VB, VBI, MVBI> getNewValueInterops, VB newValue, ReadValue<RV> readValue, InstanceOrBytesToInstance<? super RV, V> toValue) {
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        return this.segments[segmentNum].replace(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, getExpectedValueInterops, existingValue, getNewValueInterops, newValue, readValue, toValue, segmentHash);
    }

    final void checkConsistency() throws InterruptedException {
        for (Segment segment : this.segments) {
            segment.checkConsistency();
        }
    }

    final long readValueSize(Bytes entry) {
        long valueSize = this.valueSizeMarshaller.readSize(entry);
        this.alignment.alignPositionAddr(entry);
        return valueSize;
    }

    final V readValue(@NotNull ThreadLocalCopies copies, MultiStoreBytes entry, V value) {
        return this.readValue(copies, (Bytes)entry, value, this.readValueSize((Bytes)entry));
    }

    @Override
    public final V readValue(@NotNull ThreadLocalCopies copies, Bytes entry, V value, long valueSize) {
        Asserts.assertNotNull(copies);
        BytesReader valueReader = (BytesReader)this.valueReaderProvider.get(copies, this.originalValueReader);
        return valueReader.read(entry, valueSize, value);
    }

    @Override
    public final V readNull() {
        return null;
    }

    final void putAll(Bytes entries) {
        long numberOfEntries = entries.readStopBit();
        long entryPosition = entries.position();
        while (numberOfEntries-- > 0L) {
            long keySize = this.keySizeMarshaller.readSize(entries);
            entries.skip(keySize);
            long valueSize = this.valueSizeMarshaller.readSize(entries);
            long nextEntryPosition = entries.position() + valueSize;
            entries.position(entryPosition);
            this.put(entries);
            entries.clear();
            entryPosition = nextEntryPosition;
            entries.position(entryPosition);
        }
    }

    final long[] segmentSizes() {
        long[] sizes = new long[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            sizes[i] = this.segments[i].size();
        }
        return sizes;
    }

    void onRemove(Segment segment, long pos) {
    }

    void onRemoteRemove(Segment segment, long pos) {
    }

    void onPut(Segment segment, long pos) {
    }

    void onRemotePut(Segment segment, long pos) {
    }

    void onRelocation(Segment segment, long pos) {
    }

    static void segmentStateNotNullImpliesCopiesNotNull(@Nullable ThreadLocalCopies copies, @Nullable SegmentState segmentState) {
        assert (copies != null || segmentState == null);
    }

    static void expectedValueNotNullImpliesBooleanResult(@Nullable Object expectedValue, boolean booleanResult) {
        assert (booleanResult || expectedValue == null);
    }

    void shouldNotBeCalledFromReplicatedChronicleMap(String method) {
    }

    private static class HeapWriteLocked<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
    extends WriteLocked<K, KI, MKI, V, VI, MVI> {
        private boolean putOnClose;

        HeapWriteLocked(SegmentState segmentState) {
            super(segmentState);
        }

        @Override
        void init() {
            super.init();
            this.putOnClose = true;
        }

        @Override
        public void close() {
            Segment segment = this.segment();
            if (this.putOnClose) {
                assert (!this.removed);
                long pos = this.segmentState.pos;
                VanillaChronicleMap map = this.map();
                ThreadLocalCopies copies = this.copies();
                long offset = segment.offsetFromPos(pos);
                MultiStoreBytes entry = segment.reuse(this.segmentState.tmpBytes, offset);
                long keySize = map.keySizeMarshaller.readSize((Bytes)entry);
                entry.skip(keySize);
                segment.manageReplicationBytes((Bytes)entry, true, false);
                long valueSizePos = entry.position();
                long valueSize = map.valueSizeMarshaller.readSize((Bytes)entry);
                long sizeOfEverythingBeforeValue = entry.position();
                map.alignment.alignPositionAddr((Bytes)entry);
                long entryEndAddr = entry.positionAddr() + valueSize;
                Object valueInterop = map.valueInteropProvider.get(copies, map.originalValueInterop);
                Object value = this.value();
                MetaBytesInterop metaValueInterop = (MetaBytesInterop)map.metaValueInteropProvider.get(copies, map.originalMetaValueInterop, valueInterop, value);
                long newValueSize = metaValueInterop.size(valueInterop, value);
                segment.putValue(pos, offset, entry, valueSizePos, entryEndAddr, this.removed, this.segmentState, metaValueInterop, valueInterop, value, newValueSize, segment.hashLookup(), sizeOfEverythingBeforeValue);
                map.onPut(segment, this.segmentState.pos);
            }
            super.close();
        }

        @Override
        public void dontPutOnClose() {
            if (this.removed) {
                throw new IllegalStateException("Shouldn't call this method after removeEntry()");
            }
            this.putOnClose = false;
        }

        @Override
        public void removeEntry() {
            this.putOnClose = false;
            this.removed = true;
            VanillaChronicleMap map = this.map();
            this.segment().removeWithoutLock(this.copies(), this.segmentState, this.metaKeyInterop(), this.keyInterop(), this.key(), this.keySize(), map.keyIdentity(), map, null, map.valueIdentity(), this.segmentHash(), map, true);
        }
    }

    private static class NativeWriteLocked<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
    extends WriteLocked<K, KI, MKI, V, VI, MVI> {
        NativeWriteLocked(SegmentState segmentState) {
            super(segmentState);
        }

        @Override
        public void close() {
            if (!this.removed) {
                long pos = this.segmentState.pos;
                Segment segment = this.segment();
                VanillaChronicleMap map = this.map();
                long offset = segment.offsetFromPos(pos);
                MultiStoreBytes entry = segment.reuse(this.segmentState.tmpBytes, offset);
                long keySize = map.keySizeMarshaller.readSize((Bytes)entry);
                entry.skip(keySize);
                segment.manageReplicationBytes((Bytes)entry, true, false);
                map.onPut(segment, pos);
            }
            super.close();
        }

        @Override
        public void dontPutOnClose() {
            throw new IllegalStateException("dontPutOnClose() method is not supported for native value classes");
        }

        @Override
        public void removeEntry() {
            this.removed = true;
            VanillaChronicleMap map = this.map();
            this.segment().removeWithoutLock(this.copies(), this.segmentState, this.metaKeyInterop(), this.keyInterop(), this.key(), this.keySize(), map.keyIdentity(), map, null, map.valueIdentity(), this.segmentHash(), map, true);
        }
    }

    static abstract class WriteLocked<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
    extends MutableLockedEntry<K, KI, MKI, V, VI, MVI>
    implements WriteContext<K, V> {
        private boolean created;
        boolean removed;

        WriteLocked(SegmentState segmentState) {
            super(segmentState);
        }

        @Override
        void init() {
            super.init();
            this.created = false;
            this.removed = false;
        }

        @Override
        public boolean created() {
            return this.created;
        }

        public void created(boolean created) {
            this.created = created;
        }
    }

    private static class ReadLocked<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
    extends MutableLockedEntry<K, KI, MKI, V, VI, MVI>
    implements ReadContext<K, V> {
        ReadLocked(SegmentState segmentState) {
            super(segmentState);
        }

        @Override
        public boolean present() {
            return this.value() != null;
        }
    }

    static abstract class MutableLockedEntry<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
    implements Context<K, V> {
        final SegmentState segmentState;
        private VanillaChronicleMap<K, KI, MKI, V, VI, MVI> map;
        private Segment segment;
        private ThreadLocalCopies copies;
        private MKI metaKeyInterop;
        private KI keyInterop;
        private long keySize;
        private long segmentHash;
        private K key;
        private V value;

        MutableLockedEntry(SegmentState segmentState) {
            this.segmentState = segmentState;
        }

        final void initSegment(Segment segment) {
            this.map = segment.map();
            this.segment = segment;
            this.init();
        }

        final void initKey(ThreadLocalCopies copies, MKI metaKeyInterop, KI keyInterop, long keySize, long segmentHash, K key) {
            this.copies = copies;
            this.metaKeyInterop = metaKeyInterop;
            this.keyInterop = keyInterop;
            this.keySize = keySize;
            this.segmentHash = segmentHash;
            this.key = key;
            this.init();
        }

        void init() {
        }

        final VanillaChronicleMap<K, KI, MKI, V, VI, MVI> map() {
            return this.map;
        }

        final Segment segment() {
            return this.segment;
        }

        final ThreadLocalCopies copies() {
            return this.copies;
        }

        final MKI metaKeyInterop() {
            return this.metaKeyInterop;
        }

        final KI keyInterop() {
            return this.keyInterop;
        }

        final long keySize() {
            return this.keySize;
        }

        final long segmentHash() {
            return this.segmentHash;
        }

        @Override
        public final K key() {
            return this.key;
        }

        @Override
        public final V value() {
            return this.value;
        }

        final void value(V value) {
            this.value = value;
        }

        @Override
        public void close() {
            this.segmentState.close();
            this.segment().readUnlock();
        }
    }

    class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        private static final long serialVersionUID = 0L;

        WriteThroughEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            VanillaChronicleMap.this.put(this.getKey(), value);
            return super.setValue(value);
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            try {
                Object v = VanillaChronicleMap.this.get(e.getKey());
                return v != null && v.equals(e.getValue());
            }
            catch (ClassCastException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }

        @Override
        public final boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            try {
                Object key = e.getKey();
                Object value = e.getValue();
                return VanillaChronicleMap.this.remove(key, value);
            }
            catch (ClassCastException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }

        @Override
        public final int size() {
            return VanillaChronicleMap.this.size();
        }

        @Override
        public final boolean isEmpty() {
            return VanillaChronicleMap.this.isEmpty();
        }

        @Override
        public final void clear() {
            VanillaChronicleMap.this.clear();
        }
    }

    class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        Map.Entry<K, V> returnedEntry;
        private int returnedSeg = -1;
        private long returnedPos = -1L;
        private int nextSeg;
        private long nextPos;
        MultiStoreBytes entry = new MultiStoreBytes();

        EntryIterator() {
            this.nextSeg = VanillaChronicleMap.this.segments.length - 1;
            this.nextPos = -1L;
            this.advance(this.nextSeg, -1L);
        }

        private boolean advance(int segIndex, long pos) {
            while (segIndex >= 0) {
                pos = VanillaChronicleMap.this.segments[segIndex].hashLookup().getPositions().nextSetBit(pos + 1L);
                if (pos >= 0L) {
                    this.nextSeg = segIndex;
                    this.nextPos = pos;
                    return true;
                }
                --segIndex;
                pos = -1L;
            }
            this.nextSeg = -1;
            this.nextPos = -1L;
            return false;
        }

        @Override
        public final boolean hasNext() {
            return this.nextSeg >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next() {
            while (true) {
                int segIndex = this.nextSeg;
                long pos = this.nextPos;
                if (segIndex < 0) {
                    throw new NoSuchElementException();
                }
                Segment segment = VanillaChronicleMap.this.segments[segIndex];
                ThreadLocalCopies copies = SegmentState.getCopies(null);
                SegmentState segmentState = SegmentState.get(copies);
                try {
                    try {
                        segment.readLock(null);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    if (segment.hashLookup().getPositions().isClear(pos)) {
                        this.advance(segIndex, pos);
                        continue;
                    }
                    this.returnedSeg = segIndex;
                    this.returnedPos = pos;
                    this.advance(this.returnedSeg, this.returnedPos);
                    this.returnedEntry = segment.getEntry(segmentState, pos);
                    Map.Entry entry = this.returnedEntry;
                    return entry;
                }
                finally {
                    segmentState.close();
                    segment.readUnlock();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void remove() {
            int segIndex = this.returnedSeg;
            if (segIndex < 0) {
                throw new IllegalStateException();
            }
            Segment segment = VanillaChronicleMap.this.segments[segIndex];
            long pos = this.returnedPos;
            try {
                segment.writeLock();
                if (segment.hashLookup().getPositions().isClear(pos)) {
                    segment.writeUnlock();
                    VanillaChronicleMap.this.remove(this.returnedEntry.getKey());
                    segment.writeLock();
                } else {
                    this.removePresent(segment, pos);
                }
                this.returnedSeg = -1;
                this.returnedEntry = null;
            }
            finally {
                segment.writeUnlock();
            }
        }

        void removePresent(Segment segment, long pos) {
            long offset = segment.offsetFromPos(pos);
            MultiStoreBytes entry = segment.reuse(this.entry, offset);
            long keySize = VanillaChronicleMap.this.keySizeMarshaller.readSize((Bytes)entry);
            long position = entry.position();
            long segmentHash = VanillaChronicleMap.this.segmentHash(Hasher.hash((Bytes)entry, position, position + keySize));
            this.removePresent(segment, pos, (NativeBytes)entry, keySize, segmentHash, true);
        }

        final void removePresent(Segment segment, long pos, NativeBytes entry, long keySize, long segmentHash, boolean removeFromMultiMap) {
            entry.skip(keySize);
            segment.manageReplicationBytes((Bytes)entry, true, true);
            long valueSizePos = entry.position();
            long valueSize = VanillaChronicleMap.this.readValueSize((Bytes)entry);
            long entryEndAddr = entry.positionAddr() + valueSize;
            if (removeFromMultiMap) {
                segment.hashLookup().remove(segmentHash, pos);
                segment.free(pos, segment.inChunks(entryEndAddr - entry.address()));
            } else {
                segment.hashLookup().removePosition(pos);
            }
            segment.decrementSize();
            VanillaChronicleMap.this.onRemove(segment, pos);
            if (VanillaChronicleMap.this.bytesEventListener != null) {
                VanillaChronicleMap.this.bytesEventListener.onRemove((Bytes)entry, 0L, VanillaChronicleMap.this.metaDataBytes, valueSizePos, false);
            }
            if (VanillaChronicleMap.this.eventListener != null) {
                VanillaChronicleMap.this.eventListener.onRemove(this.returnedEntry.getKey(), this.returnedEntry.getValue(), false);
            }
        }
    }

    class Segment
    implements SharedSegment {
        static final long LOCK_OFFSET = 0L;
        static final long SIZE_OFFSET = 8L;
        final Bytes segmentHeader;
        final Bytes bytes;
        final long entriesOffset;
        private final int index;
        private final SingleThreadedDirectBitSet freeList;
        private MultiMap hashLookup;
        private long nextPosToSearchFrom = 0L;
        long startWriteLock = 0L;

        private VanillaChronicleMap<K, KI, MKI, V, VI, MVI> map() {
            return VanillaChronicleMap.this;
        }

        Segment(Bytes segmentHeader, NativeBytes bytes, int index) {
            this.segmentHeader = segmentHeader;
            this.bytes = bytes;
            this.index = index;
            long start = bytes.startAddr();
            this.hashLookup = this.createMultiMap(start);
            NativeBytes bsBytes = new NativeBytes(VanillaChronicleMap.this.ms.objectSerializer(), start += MemoryUnit.CACHE_LINES.align(VanillaChronicleMap.this.sizeOfMultiMap() + VanillaChronicleMap.this.sizeOfMultiMapBitSet(), MemoryUnit.BYTES) * (long)VanillaChronicleMap.this.multiMapsPerSegment(), start + MultiMapFactory.sizeOfBitSetInBytes(VanillaChronicleMap.this.actualChunksPerSegment), null);
            this.freeList = new SingleThreadedDirectBitSet((Bytes)bsBytes);
            start += (long)VanillaChronicleMap.this.numberOfBitSets() * VanillaChronicleMap.this.sizeOfSegmentFreeListBitSets();
            this.entriesOffset = (start += (long)VanillaChronicleMap.this.specialEntrySpaceOffset) - bytes.startAddr();
            assert (bytes.capacity() >= this.entriesOffset + VanillaChronicleMap.this.actualChunksPerSegment * VanillaChronicleMap.this.chunkSize);
            if (checkSegmentMultiMapsAndBitSetsConsistencyOnBootstrap) {
                this.checkMultiMapsAndBitSetsConsistency();
            }
        }

        final MultiMap hashLookup() {
            return this.hashLookup;
        }

        private MultiMap createMultiMap(long start) {
            NativeBytes multiMapBytes = new NativeBytes((ObjectSerializer)null, start, start += VanillaChronicleMap.this.sizeOfMultiMap(), null);
            NativeBytes sizeOfMultiMapBitSetBytes = new NativeBytes((ObjectSerializer)null, start, start + VanillaChronicleMap.this.sizeOfMultiMapBitSet(), null);
            return VanillaChronicleMap.this.multiMapFactory.create((Bytes)multiMapBytes, (Bytes)sizeOfMultiMapBitSetBytes);
        }

        void checkMultiMapsAndBitSetsConsistency() {
            MultiMap hashLookup = this.hashLookup();
            final DirectBitSet positions = hashLookup.getPositions();
            class EntryChecker
            implements MultiMap.EntryConsumer {
                long size = 0L;

                EntryChecker() {
                }

                @Override
                public void accept(long key, long value) {
                    if (positions.isSet(value)) {
                        ++this.size;
                    }
                    if (Segment.this.freeList.isClear(value)) {
                        throw new IllegalStateException("Position " + value + " is present in " + "multiMap but available in the free chunk list");
                    }
                }
            }
            EntryChecker entryChecker = new EntryChecker();
            hashLookup.forEach(entryChecker);
            if (this.size() != entryChecker.size || entryChecker.size != positions.cardinality()) {
                throw new IllegalStateException("Segment inconsistent: size by Segment counter: " + this.size() + ", size by multiMap records present in bit set: " + entryChecker.size + ", size by multiMap bit set cardinality: " + positions.cardinality());
            }
        }

        @Override
        public final int getIndex() {
            return this.index;
        }

        final void incrementSize() {
            this.segmentHeader.addLong(8L, 1L);
        }

        private void resetSize() {
            this.segmentHeader.writeLong(8L, 0L);
        }

        final void decrementSize() {
            this.segmentHeader.addLong(8L, -1L);
        }

        long size() {
            return Math.max(0L, this.segmentHeader.readVolatileLong(8L));
        }

        @Override
        public final ReadLocked<K, KI, MKI, V, VI, MVI> readLock(@Nullable SegmentState segmentState) throws InterruptedException {
            while (true) {
                boolean success;
                if (success = this.segmentHeader.tryRWWriteLock(0L, VanillaChronicleMap.this.lockTimeOutNS)) {
                    if (segmentState != null) {
                        return segmentState.readLocked(this);
                    }
                    return null;
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new IllegalStateException(new InterruptedException("Unable to obtain lock, interrupted"));
                }
                VanillaChronicleMap.this.errorListener.onLockTimeout(this.segmentHeader.threadIdForLockLong(0L));
                this.segmentHeader.resetLockLong(0L);
            }
        }

        final WriteLocked<K, KI, MKI, V, VI, MVI> writeLock() {
            return this.writeLock(null, false);
        }

        final WriteLocked<K, KI, MKI, V, VI, MVI> writeLock(SegmentState segmentState, boolean nativeValueClass) {
            this.startWriteLock = System.nanoTime();
            while (true) {
                boolean success;
                try {
                    success = this.segmentHeader.tryRWWriteLock(0L, VanillaChronicleMap.this.lockTimeOutNS);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                if (success) {
                    if (segmentState != null) {
                        if (nativeValueClass) {
                            return segmentState.nativeWriteLocked(this);
                        }
                        return segmentState.heapWriteLocked(this);
                    }
                    return null;
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new IllegalStateException(new InterruptedException("Unable to obtain lock, interrupted"));
                }
                VanillaChronicleMap.this.errorListener.onLockTimeout(this.segmentHeader.threadIdForLockLong(0L));
                this.segmentHeader.resetLockLong(0L);
            }
        }

        @Override
        public final void readUnlock() {
            try {
                this.segmentHeader.unlockRWWriteLock(0L);
            }
            catch (IllegalMonitorStateException e) {
                VanillaChronicleMap.this.errorListener.errorOnUnlock(e);
            }
        }

        @Override
        public final void writeUnlock() {
            try {
                this.segmentHeader.unlockRWWriteLock(0L);
            }
            catch (IllegalMonitorStateException e) {
                VanillaChronicleMap.this.errorListener.errorOnUnlock(e);
            }
            long lockTime = System.nanoTime() - this.startWriteLock;
            if ((double)lockTime > 1.0E8 && LOG.isInfoEnabled()) {
                LOG.info("Thread took " + lockTime / 1000000L + "ms to release the lock, (Was there a GC?)");
            }
        }

        @Override
        public final long offsetFromPos(long pos) {
            return this.entriesOffset + pos * VanillaChronicleMap.this.chunkSize;
        }

        final MultiStoreBytes reuse(MultiStoreBytes entry, long offset) {
            entry.setBytesOffset(this.bytes, offset);
            entry.position((long)VanillaChronicleMap.this.metaDataBytes);
            return entry;
        }

        final long entrySize(long keySize, long valueSize) {
            long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
            return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
        }

        private long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
            if (VanillaChronicleMap.this.constantlySizedEntry) {
                return VanillaChronicleMap.this.alignment.alignAddr(sizeOfEverythingBeforeValue + valueSize);
            }
            if (VanillaChronicleMap.this.couldNotDetermineAlignmentBeforeAllocation) {
                return sizeOfEverythingBeforeValue + (long)VanillaChronicleMap.this.worstAlignment + valueSize;
            }
            return VanillaChronicleMap.this.alignment.alignAddr(sizeOfEverythingBeforeValue) + valueSize;
        }

        long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
            return (long)(VanillaChronicleMap.this.metaDataBytes + VanillaChronicleMap.this.keySizeMarshaller.sizeEncodingSize(keySize)) + keySize + (long)VanillaChronicleMap.this.valueSizeMarshaller.sizeEncodingSize(valueSize);
        }

        final int inChunks(long sizeInBytes) {
            if (sizeInBytes <= VanillaChronicleMap.this.chunkSize) {
                return 1;
            }
            if (--sizeInBytes <= Integer.MAX_VALUE) {
                return (int)sizeInBytes / (int)VanillaChronicleMap.this.chunkSize + 1;
            }
            return (int)(sizeInBytes / VanillaChronicleMap.this.chunkSize) + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV> RV acquire(@Nullable ThreadLocalCopies copies, @Nullable SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, ReadValue<RV> readValue, RV usingValue, InstanceOrBytesToInstance<RV, V> toValue, long hash2, boolean create, MutableLockedEntry lock) throws InterruptedException {
            VanillaChronicleMap.segmentStateNotNullImpliesCopiesNotNull(copies, segmentState);
            if (segmentState == null) {
                copies = SegmentState.getCopies(copies);
                segmentState = SegmentState.get(copies);
            }
            this.readLock(null);
            try {
                RV RV = this.acquireWithoutLock(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, readValue, usingValue, toValue, hash2, create, lock);
                return RV;
            }
            finally {
                segmentState.close();
                this.readUnlock();
            }
        }

        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV> RV acquireWithoutLock(@NotNull ThreadLocalCopies copies, @NotNull SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, ReadValue<RV> readValue, RV usingValue, InstanceOrBytesToInstance<RV, V> toValue, long hash2, boolean create, MutableLockedEntry lock) {
            long pos;
            MultiStoreBytes entry = segmentState.tmpBytes;
            MultiMap hashLookup = this.hashLookup;
            SearchState searchState = segmentState.searchState;
            hashLookup.startSearch(hash2, searchState);
            while ((pos = hashLookup.nextPos(searchState)) >= 0L) {
                long offset = this.offsetFromPos(pos);
                this.reuse(entry, offset);
                if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                entry.skip(keySize);
                segmentState.pos = pos;
                return this.readValueAndNotifyGet(copies, key, keySize, toKey, readValue, usingValue, toValue, entry);
            }
            if (!create) {
                return readValue.readNull();
            }
            RV result = this.createEntryOnAcquire(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, readValue, usingValue, toValue, entry);
            this.entryCreated(lock);
            return result;
        }

        final void entryCreated(MutableLockedEntry lock) {
            if (lock instanceof WriteLocked) {
                ((WriteLocked)lock).created(true);
            }
        }

        final <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV> RV createEntryOnAcquire(ThreadLocalCopies copies, @NotNull SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, ReadValue<RV> readValue, RV usingValue, InstanceOrBytesToInstance<RV, V> toValue, MultiStoreBytes entry) {
            long valueSize;
            Object keyInstance = toKey.toInstance(copies, key, keySize);
            if (VanillaChronicleMap.this.defaultValueProvider != null) {
                Object defaultValue = VanillaChronicleMap.this.defaultValueProvider.get(keyInstance);
                Object valueInterop = VanillaChronicleMap.this.valueInteropProvider.get(copies, VanillaChronicleMap.this.originalValueInterop);
                Object metaValueInterop = VanillaChronicleMap.this.metaValueInteropProvider.get(copies, VanillaChronicleMap.this.originalMetaValueInterop, valueInterop, defaultValue);
                valueSize = this.putEntry(segmentState, metaKeyInterop, keyInterop, key, keySize, (MetaBytesWriter)metaValueInterop, (Object)valueInterop, (Object)defaultValue, entry, true);
            } else if (VanillaChronicleMap.this.prepareValueBytesAsWriter != null) {
                valueSize = this.putEntry(segmentState, metaKeyInterop, keyInterop, key, keySize, VanillaChronicleMap.this.prepareValueBytesAsWriter, null, keyInstance, entry, true);
            } else {
                throw this.defaultValueOrPrepareBytesShouldBeSpecified();
            }
            entry.positionAddr(entry.positionAddr() - valueSize);
            RV v = readValue.readValue(copies, (Bytes)entry, usingValue, valueSize);
            VanillaChronicleMap.this.onPut(this, segmentState.pos);
            if (VanillaChronicleMap.this.bytesEventListener != null) {
                long keyPos = VanillaChronicleMap.this.metaDataBytes;
                VanillaChronicleMap.this.bytesEventListener.onPut((Bytes)entry, 0L, keyPos, segmentState.valueSizePos, true, false);
            }
            if (VanillaChronicleMap.this.eventListener != null) {
                VanillaChronicleMap.this.eventListener.onPut(toKey.toInstance(copies, key, keySize), toValue.toInstance(copies, v, valueSize), null, false);
            }
            return v;
        }

        final IllegalStateException defaultValueOrPrepareBytesShouldBeSpecified() {
            return new IllegalStateException("To call acquire*() methods, you should specify either default value, default value provider or prepareBytes strategy during map building");
        }

        final <KB, RV> RV readValueAndNotifyGet(ThreadLocalCopies copies, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, ReadValue<RV> readValue, RV usingValue, InstanceOrBytesToInstance<RV, V> toValue, MultiStoreBytes entry) {
            long valueSize = VanillaChronicleMap.this.readValueSize((Bytes)entry);
            long valuePos = entry.position();
            RV v = readValue.readValue(copies, (Bytes)entry, usingValue, valueSize);
            if (VanillaChronicleMap.this.bytesEventListener != null) {
                VanillaChronicleMap.this.bytesEventListener.onGetFound((Bytes)entry, 0L, VanillaChronicleMap.this.metaDataBytes, valuePos);
            }
            if (VanillaChronicleMap.this.eventListener != null) {
                VanillaChronicleMap.this.eventListener.onGetFound(toKey.toInstance(copies, key, keySize), toValue.toInstance(copies, v, valueSize));
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> RV put3(@Nullable ThreadLocalCopies copies, @Nullable SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB value, InstanceOrBytesToInstance<? super VB, V> toValue, long hash2, boolean replaceIfPresent, ReadValue<RV> readValue, boolean resultUnused) {
            VanillaChronicleMap.this.shouldNotBeCalledFromReplicatedChronicleMap("Segment.put");
            VanillaChronicleMap.segmentStateNotNullImpliesCopiesNotNull(copies, segmentState);
            if (segmentState == null) {
                copies = SegmentState.getCopies(copies);
                segmentState = SegmentState.get(copies);
            }
            this.writeLock();
            try {
                RV RV = this.putWithoutLock(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, getValueInterops, value, toValue, hash2, replaceIfPresent, readValue, resultUnused);
                return RV;
            }
            finally {
                segmentState.close();
                this.writeUnlock();
            }
        }

        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> RV putWithoutLock(@NotNull ThreadLocalCopies copies, @NotNull SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB value, InstanceOrBytesToInstance<? super VB, V> toValue, long hash2, boolean replaceIfPresent, ReadValue<RV> readValue, boolean resultUnused) {
            long pos;
            SearchState searchState = segmentState.searchState;
            this.hashLookup.startSearch(hash2, searchState);
            MultiStoreBytes entry = segmentState.tmpBytes;
            while ((pos = this.hashLookup.nextPos(searchState)) >= 0L) {
                long offset = this.offsetFromPos(pos);
                this.reuse(entry, offset);
                if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                entry.skip(keySize);
                if (replaceIfPresent) {
                    return this.replaceValueAndNotifyPut(copies, segmentState, key, keySize, toKey, getValueInterops, value, toValue, entry, pos, offset, this.hashLookup, readValue, resultUnused, false, false);
                }
                long valueSize = VanillaChronicleMap.this.readValueSize((Bytes)entry);
                return resultUnused ? null : readValue.readValue(copies, (Bytes)entry, null, valueSize);
            }
            VBI valueInterop = getValueInterops.getValueInterop(copies);
            MVBI metaValueInterop = getValueInterops.getMetaValueInterop(copies, valueInterop, value);
            long valueSize = metaValueInterop.size(valueInterop, value);
            this.putEntry(segmentState, metaKeyInterop, keyInterop, key, keySize, (MetaBytesWriter)metaValueInterop, (Object)valueInterop, (Object)value, entry, false);
            VanillaChronicleMap.this.onPut(this, segmentState.pos);
            if (VanillaChronicleMap.this.bytesEventListener != null) {
                VanillaChronicleMap.this.bytesEventListener.onPut((Bytes)entry, 0L, VanillaChronicleMap.this.metaDataBytes, segmentState.valueSizePos, true, false);
            }
            if (VanillaChronicleMap.this.eventListener != null) {
                VanillaChronicleMap.this.eventListener.onPut(toKey.toInstance(copies, key, keySize), toValue.toInstance(copies, value, valueSize), null, false);
            }
            return resultUnused ? null : (RV)readValue.readNull();
        }

        final <KB, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> RV replaceValueAndNotifyPut(ThreadLocalCopies copies, SegmentState segmentState, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB value, InstanceOrBytesToInstance<? super VB, V> toValue, MultiStoreBytes entry, long pos, long offset, MultiMap searchedHashLookup, ReadValue<RV> readValue, boolean resultUnused, boolean entryIsDeleted, boolean remote) {
            VBI valueInterop = getValueInterops.getValueInterop(copies);
            MVBI metaValueInterop = getValueInterops.getMetaValueInterop(copies, valueInterop, value);
            long valueSize = metaValueInterop.size(valueInterop, value);
            long valueSizePos = entry.position();
            long prevValueSize = VanillaChronicleMap.this.valueSizeMarshaller.readSize((Bytes)entry);
            long sizeOfEverythingBeforeValue = entry.position();
            VanillaChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
            long valueAddr = entry.positionAddr();
            long entryEndAddr = valueAddr + prevValueSize;
            RV prevValue = null;
            Object prevValueInstance = null;
            if (!resultUnused && !entryIsDeleted) {
                prevValue = readValue.readValue(copies, (Bytes)entry, null, prevValueSize);
            }
            if (VanillaChronicleMap.this.eventListener != null && !entryIsDeleted) {
                entry.positionAddr(valueAddr);
                prevValueInstance = VanillaChronicleMap.this.readValue(copies, (Bytes)entry, null, prevValueSize);
            }
            this.putValue(pos, offset, entry, valueSizePos, entryEndAddr, entryIsDeleted, segmentState, (MetaBytesWriter)metaValueInterop, (Object)valueInterop, (Object)value, valueSize, searchedHashLookup, sizeOfEverythingBeforeValue);
            this.onPutMaybeRemote(segmentState.pos, remote);
            if (VanillaChronicleMap.this.bytesEventListener != null) {
                VanillaChronicleMap.this.bytesEventListener.onPut((Bytes)entry, 0L, VanillaChronicleMap.this.metaDataBytes, valueSizePos, false, remote);
            }
            if (VanillaChronicleMap.this.eventListener != null) {
                VanillaChronicleMap.this.eventListener.onPut(toKey.toInstance(copies, key, keySize), toValue.toInstance(copies, value, valueSize), prevValueInstance, remote);
            }
            return resultUnused ? null : prevValue;
        }

        final void onPutMaybeRemote(long pos, boolean remote) {
            if (remote) {
                VanillaChronicleMap.this.onRemotePut(this, pos);
            } else {
                VanillaChronicleMap.this.onPut(this, pos);
            }
        }

        final <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, E, EW> long putEntry(SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, MetaBytesWriter<E, ? super EW> metaElemWriter, EW elemWriter, E elem, MultiStoreBytes entry, boolean writeDefaultInitialReplicationValues) {
            long pos;
            long valueSize = metaElemWriter.size(elemWriter, elem);
            long entrySize = this.entrySize(keySize, valueSize);
            int allocatedChunks = this.inChunks(entrySize);
            segmentState.pos = pos = this.alloc(allocatedChunks);
            long offset = this.offsetFromPos(pos);
            this.clearMetaData(offset);
            this.reuse(entry, offset);
            VanillaChronicleMap.this.keySizeMarshaller.writeSize((Bytes)entry, keySize);
            metaKeyInterop.write(keyInterop, (Bytes)entry, key);
            this.manageReplicationBytes((Bytes)entry, writeDefaultInitialReplicationValues, false);
            segmentState.valueSizePos = entry.position();
            VanillaChronicleMap.this.valueSizeMarshaller.writeSize((Bytes)entry, valueSize);
            VanillaChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
            metaElemWriter.write(elemWriter, (Bytes)entry, elem);
            this.freeExtraAllocatedChunks(pos, allocatedChunks, (Bytes)entry);
            this.hashLookup.putAfterFailedSearch(segmentState.searchState, pos);
            this.incrementSize();
            return valueSize;
        }

        final void freeExtraAllocatedChunks(long pos, int allocatedChunks, Bytes entry) {
            int actuallyUsedChunks;
            if (!VanillaChronicleMap.this.constantlySizedEntry && VanillaChronicleMap.this.couldNotDetermineAlignmentBeforeAllocation && (actuallyUsedChunks = this.inChunks(entry.position())) < allocatedChunks) {
                this.free(pos + (long)actuallyUsedChunks, allocatedChunks - actuallyUsedChunks);
            }
        }

        void manageReplicationBytes(Bytes entry, boolean writeDefaultInitialReplicationValues, boolean remove) {
        }

        final void clearMetaData(long offset) {
            if (VanillaChronicleMap.this.metaDataBytes > 0) {
                this.bytes.zeroOut(offset, offset + (long)VanillaChronicleMap.this.metaDataBytes);
            }
        }

        final long alloc(int chunks) {
            if (chunks > VanillaChronicleMap.this.maxChunksPerEntry) {
                throw new IllegalArgumentException("Entry is too large: requires " + chunks + " entry size chucks, " + VanillaChronicleMap.this.maxChunksPerEntry + " is maximum.");
            }
            long ret = this.freeList.setNextNContinuousClearBits(this.nextPosToSearchFrom, chunks);
            if (ret == -1L || ret + (long)chunks > VanillaChronicleMap.this.actualChunksPerSegment) {
                if (ret != -1L && ret + (long)chunks > VanillaChronicleMap.this.actualChunksPerSegment && ret < VanillaChronicleMap.this.actualChunksPerSegment) {
                    this.freeList.clear(ret, VanillaChronicleMap.this.actualChunksPerSegment);
                }
                if ((ret = this.freeList.setNextNContinuousClearBits(0L, chunks)) == -1L || ret + (long)chunks > VanillaChronicleMap.this.actualChunksPerSegment) {
                    if (ret != -1L && ret + (long)chunks > VanillaChronicleMap.this.actualChunksPerSegment && ret < VanillaChronicleMap.this.actualChunksPerSegment) {
                        this.freeList.clear(ret, VanillaChronicleMap.this.actualChunksPerSegment);
                    }
                    if (chunks == 1) {
                        throw new IllegalStateException("Segment is full, no free entries found");
                    }
                    throw new IllegalStateException("Segment is full or has no ranges of " + chunks + " continuous free chunks");
                }
                this.updateNextPosToSearchFrom(ret, chunks);
            } else if (chunks == 1 || this.freeList.isSet(this.nextPosToSearchFrom)) {
                this.updateNextPosToSearchFrom(ret, chunks);
            }
            return ret;
        }

        private void updateNextPosToSearchFrom(long allocated, int chunks) {
            this.nextPosToSearchFrom = allocated + (long)chunks;
            if (this.nextPosToSearchFrom >= VanillaChronicleMap.this.actualChunksPerSegment) {
                this.nextPosToSearchFrom = 0L;
            }
        }

        private boolean realloc(long fromPos, int oldChunks, int newChunks) {
            if (this.freeList.allClear(fromPos + (long)oldChunks, fromPos + (long)newChunks)) {
                this.freeList.set(fromPos + (long)oldChunks, fromPos + (long)newChunks);
                return true;
            }
            return false;
        }

        private void free(long fromPos, int chunks) {
            this.freeList.clear(fromPos, fromPos + (long)chunks);
            if (fromPos < this.nextPosToSearchFrom) {
                this.nextPosToSearchFrom = fromPos;
            }
        }

        final <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>> boolean keyEquals(KBI keyInterop, MKBI metaKeyInterop, KB key, long keySize, Bytes entry) {
            return keySize == VanillaChronicleMap.this.keySizeMarshaller.readSize(entry) && metaKeyInterop.startsWith(keyInterop, entry, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<? super VB, ? super VBI>> Object remove(@Nullable ThreadLocalCopies copies, @Nullable SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB expectedValue, InstanceOrBytesToInstance<RV, V> toValue, long hash2, ReadValue<RV> readValue, boolean resultUnused) {
            VanillaChronicleMap.segmentStateNotNullImpliesCopiesNotNull(copies, segmentState);
            if (segmentState == null) {
                copies = SegmentState.getCopies(copies);
                segmentState = SegmentState.get(copies);
            }
            this.writeLock();
            try {
                Object object = this.removeWithoutLock(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, getValueInterops, expectedValue, toValue, hash2, readValue, resultUnused);
                return object;
            }
            finally {
                segmentState.close();
                this.writeUnlock();
            }
        }

        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<? super VB, ? super VBI>> Object removeWithoutLock(@NotNull ThreadLocalCopies copies, @NotNull SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB expectedValue, InstanceOrBytesToInstance<RV, V> toValue, long hash2, ReadValue<RV> readValue, boolean resultUnused) {
            long pos;
            MultiStoreBytes entry = segmentState.tmpBytes;
            SearchState searchState = segmentState.searchState;
            MultiMap hashLookup = this.hashLookup();
            hashLookup.startSearch(hash2, searchState);
            while ((pos = hashLookup.nextPos(searchState)) >= 0L) {
                long offset = this.offsetFromPos(pos);
                this.reuse(entry, offset);
                if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                entry.skip(keySize);
                long valueSizePos = entry.position();
                long valueSize = VanillaChronicleMap.this.readValueSize((Bytes)entry);
                if (expectedValue != null) {
                    VBI valueInterop = getValueInterops.getValueInterop(copies);
                    MVBI metaValueInterop = getValueInterops.getMetaValueInterop(copies, valueInterop, expectedValue);
                    if (metaValueInterop.size(valueInterop, expectedValue) != valueSize) {
                        return Boolean.FALSE;
                    }
                    if (!metaValueInterop.startsWith(valueInterop, (Bytes)entry, expectedValue)) {
                        return Boolean.FALSE;
                    }
                }
                return this.removeEntry(copies, searchState, key, keySize, toKey, toValue, readValue, resultUnused, hashLookup, entry, pos, valueSizePos, valueSize, false, true, expectedValue != null);
            }
            if (expectedValue == null) {
                return resultUnused ? null : readValue.readNull();
            }
            return Boolean.FALSE;
        }

        final <KB, RV, VB extends RV> Object removeEntry(ThreadLocalCopies copies, SearchState searchState, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, InstanceOrBytesToInstance<RV, V> toValue, ReadValue<RV> readValue, boolean resultUnused, MultiMap hashLookup, MultiStoreBytes entry, long pos, long valueSizePos, long valueSize, boolean remote, boolean removeFromMultiMap, boolean booleanResult) {
            Object removedValue = null;
            if (!booleanResult && !resultUnused || VanillaChronicleMap.this.eventListener != null) {
                removedValue = readValue.readValue(copies, (Bytes)entry, null, valueSize);
                entry.position(entry.position() - valueSize);
            }
            if (removeFromMultiMap) {
                hashLookup.removePrevPos(searchState);
                long entrySizeInBytes = entry.positionAddr() + valueSize - entry.startAddr();
                this.free(pos, this.inChunks(entrySizeInBytes));
            } else {
                hashLookup.removePosition(pos);
            }
            this.decrementSize();
            this.onRemoveMaybeRemote(pos, remote);
            if (VanillaChronicleMap.this.bytesEventListener != null) {
                VanillaChronicleMap.this.bytesEventListener.onRemove((Bytes)entry, 0L, VanillaChronicleMap.this.metaDataBytes, valueSizePos, remote);
            }
            if (VanillaChronicleMap.this.eventListener != null) {
                Object removedValueForEventListener = toValue.toInstance(copies, removedValue, valueSize);
                VanillaChronicleMap.this.eventListener.onRemove(toKey.toInstance(copies, key, keySize), removedValueForEventListener, remote);
            }
            return booleanResult ? Boolean.TRUE : removedValue;
        }

        final void onRemoveMaybeRemote(long pos, boolean remote) {
            if (remote) {
                VanillaChronicleMap.this.onRemoteRemove(this, pos);
            } else {
                VanillaChronicleMap.this.onRemove(this, pos);
            }
        }

        /*
         * Loose catch block
         */
        private <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>> boolean containsKey(ThreadLocalCopies copies, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, long hash2) throws InterruptedException {
            this.readLock(null);
            copies = SegmentState.getCopies(copies);
            try {
                try (SegmentState segmentState = SegmentState.get(copies);){
                    long pos;
                    MultiStoreBytes entry = segmentState.tmpBytes;
                    MultiMap hashLookup = this.hashLookup();
                    SearchState searchState = segmentState.searchState;
                    hashLookup.startSearch(hash2, searchState);
                    while ((pos = hashLookup.nextPos(searchState)) >= 0L) {
                        long offset = this.offsetFromPos(pos);
                        this.reuse(entry, offset);
                        if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry) || this.isDeleted((Bytes)entry, keySize)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.readUnlock();
            }
        }

        boolean isDeleted(Bytes entry, long keySize) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> Object replace(@Nullable ThreadLocalCopies copies, @Nullable SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getExpectedValueInterops, VB expectedValue, GetValueInterops<VB, VBI, MVBI> getNewValueInterops, VB newValue, ReadValue<RV> readValue, InstanceOrBytesToInstance<? super RV, V> toValue, long hash2) {
            VanillaChronicleMap.segmentStateNotNullImpliesCopiesNotNull(copies, segmentState);
            if (segmentState == null) {
                copies = SegmentState.getCopies(copies);
                segmentState = SegmentState.get(copies);
            }
            this.writeLock();
            try {
                long pos;
                SearchState searchState = segmentState.searchState;
                this.hashLookup.startSearch(hash2, searchState);
                MultiStoreBytes entry = segmentState.tmpBytes;
                while ((pos = this.hashLookup.nextPos(searchState)) >= 0L) {
                    long offset = this.offsetFromPos(pos);
                    this.reuse(entry, offset);
                    if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    Object object = this.onKeyPresentOnReplace(copies, segmentState, key, keySize, toKey, getExpectedValueInterops, expectedValue, getNewValueInterops, newValue, readValue, toValue, pos, offset, entry, this.hashLookup);
                    return object;
                }
                Boolean bl = expectedValue == null ? null : Boolean.FALSE;
                return bl;
            }
            finally {
                segmentState.close();
                this.writeUnlock();
            }
        }

        final <KB, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> Object onKeyPresentOnReplace(ThreadLocalCopies copies, @NotNull SegmentState segmentState, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getExpectedValueInterops, VB expectedValue, GetValueInterops<VB, VBI, MVBI> getNewValueInterops, VB newValue, ReadValue<RV> readValue, InstanceOrBytesToInstance<? super RV, V> toValue, long pos, long offset, MultiStoreBytes entry, MultiMap searchedHashLookup) {
            Boolean prevValue;
            MVBI metaValueInterop;
            VBI valueInterop;
            long valueSizePos = entry.position();
            long valueSize = VanillaChronicleMap.this.valueSizeMarshaller.readSize((Bytes)entry);
            long sizeOfEverythingBeforeValue = entry.position();
            VanillaChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
            long entryEndAddr = entry.positionAddr() + valueSize;
            if (expectedValue != null) {
                valueInterop = getExpectedValueInterops.getValueInterop(copies);
                metaValueInterop = getExpectedValueInterops.getMetaValueInterop(copies, valueInterop, expectedValue);
                if (metaValueInterop.size(valueInterop, expectedValue) != valueSize) {
                    return Boolean.FALSE;
                }
                if (!metaValueInterop.startsWith(valueInterop, (Bytes)entry, expectedValue)) {
                    return Boolean.FALSE;
                }
                prevValue = (Boolean)expectedValue;
            } else {
                prevValue = readValue.readValue(copies, (Bytes)entry, null, valueSize);
            }
            valueInterop = getNewValueInterops.getValueInterop(copies);
            metaValueInterop = getNewValueInterops.getMetaValueInterop(copies, valueInterop, newValue);
            long newValueSize = metaValueInterop.size(valueInterop, newValue);
            boolean entryIsDeleted = false;
            this.putValue(pos, offset, entry, valueSizePos, entryEndAddr, entryIsDeleted, segmentState, (MetaBytesWriter)metaValueInterop, (Object)valueInterop, (Object)newValue, newValueSize, searchedHashLookup, sizeOfEverythingBeforeValue);
            VanillaChronicleMap.this.onPut(this, segmentState.pos);
            if (VanillaChronicleMap.this.bytesEventListener != null) {
                long keyPos = VanillaChronicleMap.this.metaDataBytes;
                VanillaChronicleMap.this.bytesEventListener.onPut((Bytes)entry, 0L, keyPos, segmentState.valueSizePos, true, false);
            }
            if (VanillaChronicleMap.this.eventListener != null) {
                VanillaChronicleMap.this.eventListener.onPut(toKey.toInstance(copies, key, keySize), toValue.toInstance(copies, newValue, newValueSize), toValue.toInstance(copies, prevValue, valueSize), false);
            }
            return expectedValue == null ? prevValue : Boolean.TRUE;
        }

        final <E, EW> long putValue(long pos, long offset, MultiStoreBytes entry, long valueSizePos, long entryEndAddr, boolean entryIsDeleted, SegmentState segmentState, MetaBytesWriter<E, ? super EW> metaElemWriter, EW elemWriter, E newElem, long newElemSize, MultiMap searchedHashLookup, long sizeOfEverythingBeforeValue) {
            long entryStartAddr = entry.address();
            long valueSizeAddr = entryStartAddr + valueSizePos;
            long newValueAddr = VanillaChronicleMap.this.alignment.alignAddr(valueSizeAddr + (long)VanillaChronicleMap.this.valueSizeMarshaller.sizeEncodingSize(newElemSize));
            long newEntryEndAddr = newValueAddr + newElemSize;
            if (newEntryEndAddr != entryEndAddr) {
                long oldEntrySize = entryEndAddr - entryStartAddr;
                int oldSizeInChunks = this.inChunks(oldEntrySize);
                int newSizeInChunks = this.inChunks(newEntryEndAddr - entryStartAddr);
                if (newSizeInChunks > oldSizeInChunks) {
                    if (newSizeInChunks > VanillaChronicleMap.this.maxChunksPerEntry) {
                        throw new IllegalArgumentException("Value too large: entry takes " + newSizeInChunks + " chunks, " + VanillaChronicleMap.this.maxChunksPerEntry + " is maximum.");
                    }
                    if (!this.realloc(pos, oldSizeInChunks, newSizeInChunks)) {
                        this.free(pos, oldSizeInChunks);
                        VanillaChronicleMap.this.onRelocation(this, pos);
                        int allocatedChunks = this.inChunks(this.innerEntrySize(sizeOfEverythingBeforeValue, newElemSize));
                        long newPos = this.alloc(allocatedChunks);
                        searchedHashLookup.replacePrevPos(segmentState.searchState, newPos, !entryIsDeleted);
                        long newOffset = this.offsetFromPos(newPos);
                        this.reuse(entry, newOffset);
                        long newEntryStartAddr = entry.address();
                        NativeBytes.UNSAFE.copyMemory(entryStartAddr, newEntryStartAddr, valueSizeAddr - entryStartAddr);
                        entry.position(valueSizePos);
                        VanillaChronicleMap.this.valueSizeMarshaller.writeSize((Bytes)entry, newElemSize);
                        VanillaChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
                        metaElemWriter.write(elemWriter, (Bytes)entry, newElem);
                        this.freeExtraAllocatedChunks(newPos, allocatedChunks, (Bytes)entry);
                        segmentState.pos = newPos;
                        return offset;
                    }
                } else if (newSizeInChunks < oldSizeInChunks) {
                    this.freeList.clear(pos + (long)newSizeInChunks, pos + (long)oldSizeInChunks);
                }
            }
            entry.position(valueSizePos);
            VanillaChronicleMap.this.valueSizeMarshaller.writeSize((Bytes)entry, newElemSize);
            VanillaChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
            metaElemWriter.write(elemWriter, (Bytes)entry, newElem);
            segmentState.pos = pos;
            return offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() {
            VanillaChronicleMap.this.shouldNotBeCalledFromReplicatedChronicleMap("Segment.clear");
            this.writeLock();
            try {
                this.hashLookup.clear();
                this.freeList.clear();
                this.nextPosToSearchFrom = 0L;
                this.resetSize();
            }
            finally {
                this.writeUnlock();
            }
        }

        @Override
        public Map.Entry<K, V> getEntry(@NotNull SegmentState segmentState, long pos) {
            MultiStoreBytes entry = this.reuse(segmentState.tmpBytes, this.offsetFromPos(pos));
            long keySize = VanillaChronicleMap.this.keySizeMarshaller.readSize((Bytes)entry);
            ThreadLocalCopies copies = VanillaChronicleMap.this.keyReaderProvider.getCopies(null);
            Object key = ((BytesReader)VanillaChronicleMap.this.keyReaderProvider.get(copies, VanillaChronicleMap.this.originalKeyReader)).read((Bytes)entry, keySize);
            long valueSize = VanillaChronicleMap.this.valueSizeMarshaller.readSize((Bytes)entry);
            VanillaChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
            copies = VanillaChronicleMap.this.valueReaderProvider.getCopies(copies);
            Object value = ((BytesReader)VanillaChronicleMap.this.valueReaderProvider.get(copies, VanillaChronicleMap.this.originalValueReader)).read((Bytes)entry, valueSize);
            return new WriteThroughEntry(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkConsistency() throws InterruptedException {
            this.readLock(null);
            try (SegmentState segmentState = SegmentState.get(SegmentState.getCopies(null));){
                MultiStoreBytes entry = segmentState.tmpBytes;
                MultiMap hashLookup = this.hashLookup();
                long pos = 0L;
                while ((pos = this.freeList.nextSetBit(pos)) >= 0L) {
                    PosPresentOnce check = new PosPresentOnce(pos);
                    hashLookup.forEach(check);
                    if (check.count != 1) {
                        throw new AssertionError();
                    }
                    long offset = this.offsetFromPos(pos);
                    this.reuse(entry, offset);
                    long keySize = VanillaChronicleMap.this.keySizeMarshaller.readSize((Bytes)entry);
                    entry.skip(keySize);
                    this.manageReplicationBytes((Bytes)entry, false, false);
                    long valueSize = VanillaChronicleMap.this.valueSizeMarshaller.readSize((Bytes)entry);
                    long sizeInBytes = this.entrySize(keySize, valueSize);
                    int entrySizeInChunks = this.inChunks(sizeInBytes);
                    if (!this.freeList.allSet(pos, pos + (long)entrySizeInChunks)) {
                        throw new AssertionError();
                    }
                    pos += (long)entrySizeInChunks;
                }
            }
            finally {
                this.readUnlock();
            }
        }

        private class PosPresentOnce
        implements MultiMap.EntryConsumer {
            long pos;
            int count = 0;

            PosPresentOnce(long pos) {
                this.pos = pos;
            }

            @Override
            public void accept(long hash, long pos) {
                if (this.pos == pos) {
                    ++this.count;
                }
            }
        }
    }

    static final class SegmentState
    implements StatefulCopyable<SegmentState>,
    AutoCloseable {
        private static final Provider<SegmentState> segmentStateProvider = Provider.of(SegmentState.class);
        private static final SegmentState originalSegmentState = new SegmentState(0);
        private final int depth;
        private boolean used;
        private SegmentState next;
        private final ReadLocked readLocked = new ReadLocked(this);
        private final NativeWriteLocked nativeWriteLocked = new NativeWriteLocked(this);
        private final HeapWriteLocked heapWriteLocked = new HeapWriteLocked(this);
        final MultiStoreBytes tmpBytes = new MultiStoreBytes();
        final GetRemoteBytesValueInterops getRemoteBytesValueInterops = new GetRemoteBytesValueInterops();
        final GetRemoteBytesValueInterops getRemoteBytesValueInterops2 = new GetRemoteBytesValueInterops();
        final ReadValueToOutputBytes readValueToOutputBytes = new ReadValueToOutputBytes();
        final ReadValueToBytes readValueToLazyBytes = new ReadValueToLazyBytes();
        long pos;
        long valueSizePos;
        final SearchState searchState = new SearchState();

        @NotNull
        static ThreadLocalCopies getCopies(ThreadLocalCopies copies) {
            return segmentStateProvider.getCopies(copies);
        }

        @NotNull
        static SegmentState get(@NotNull ThreadLocalCopies copies) {
            Asserts.assertNotNull(copies);
            return ((SegmentState)segmentStateProvider.get(copies, (Object)originalSegmentState)).get();
        }

        private SegmentState(int depth) {
            if (depth > 65536) {
                throw new IllegalStateException("More than 65536 nested ChronicleMap contexts are not supported. Very probable that you simply forgot to close context somewhere (recommended to use try-with-resources statement). Otherwise this is a ChronicleMap bug, please report with this stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
            }
            this.depth = depth;
        }

        private SegmentState get() {
            if (!this.used) {
                this.used = true;
                return this;
            }
            if (this.next != null) {
                return this.next.get();
            }
            this.next = new SegmentState(this.depth + 1);
            return this.next;
        }

        public Object stateIdentity() {
            return SegmentState.class;
        }

        public SegmentState copy() {
            return new SegmentState(0);
        }

        @Override
        public void close() {
            this.used = false;
        }

        <K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>> ReadLocked<K, KI, MKI, V, VI, MVI> readLocked(Segment segment) {
            this.readLocked.initSegment(segment);
            return this.readLocked;
        }

        <K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>> WriteLocked<K, KI, MKI, V, VI, MVI> nativeWriteLocked(Segment segment) {
            this.nativeWriteLocked.initSegment(segment);
            return this.nativeWriteLocked;
        }

        <K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>> WriteLocked<K, KI, MKI, V, VI, MVI> heapWriteLocked(Segment segment) {
            this.heapWriteLocked.initSegment(segment);
            return this.heapWriteLocked;
        }
    }

    static class GetRemoteBytesValueInterops
    implements GetValueInterops<MultiStoreBytes, Void, GetRemoteBytesValueInterops>,
    MetaBytesInterop<Bytes, Void> {
        private static final long serialVersionUID = 0L;
        private final MultiStoreBytes valueBytes = new MultiStoreBytes();
        private Bytes remoteEntryBytes;
        private long offset;
        private SizeMarshaller valueSizeMarshaller;
        private long valueSize;

        GetRemoteBytesValueInterops() {
        }

        MultiStoreBytes getValueBytes(Bytes remoteEntryBytes, long offset) {
            this.remoteEntryBytes = remoteEntryBytes;
            this.offset = offset;
            this.valueSizeMarshaller = null;
            this.valueSize = -1L;
            return this.valueBytes;
        }

        void valueSize(long valueSize) {
            this.valueSize = valueSize;
        }

        void valueSizeMarshaller(SizeMarshaller valueSizeMarshaller) {
            this.valueSizeMarshaller = valueSizeMarshaller;
        }

        @Override
        public GetRemoteBytesValueInterops getMetaValueInterop(@NotNull ThreadLocalCopies copies, Void valueInterop, MultiStoreBytes value) {
            value.setBytesOffset(this.remoteEntryBytes, this.offset);
            if (this.valueSize == -1L) {
                this.valueSize = this.valueSizeMarshaller.readSize((Bytes)value);
            }
            value.limit(value.position() + this.valueSize);
            return this;
        }

        @Override
        public Void getValueInterop(@NotNull ThreadLocalCopies copies) {
            return null;
        }

        @Override
        public boolean startsWith(Void interop, Bytes bytes, Bytes value) {
            return bytes.startsWith((RandomDataInput)value);
        }

        @Override
        public long hash(Void interop, Bytes value) {
            return BytesBytesInterop.INSTANCE.hash(value);
        }

        @Override
        public long size(Void writer, Bytes value) {
            return this.valueSize;
        }

        @Override
        public void write(Void writer, Bytes bytes, Bytes value) {
            bytes.write((RandomDataInput)value, value.position(), value.remaining());
        }
    }

    static enum LockType {
        READ_LOCK,
        WRITE_LOCK;

    }

    private static class ReadValueToLazyBytes
    extends ReadValueToBytes {
        DirectBytes lazyBytes;

        private ReadValueToLazyBytes() {
        }

        @Override
        Bytes bytes(long valueSize) {
            valueSize = (long)this.valueSizeMarshaller.sizeEncodingSize(valueSize) + valueSize;
            if (this.lazyBytes != null) {
                if (this.lazyBytes.capacity() < valueSize) {
                    DirectStore store = (DirectStore)this.lazyBytes.store();
                    store.resize(valueSize, false);
                    this.lazyBytes = store.bytes();
                }
                this.lazyBytes.clear();
                return this.lazyBytes;
            }
            this.lazyBytes = new DirectStore(valueSize).bytes();
            return this.lazyBytes;
        }

        @Override
        public Bytes readNull() {
            return null;
        }
    }

    private static class ReadValueToOutputBytes
    extends ReadValueToBytes {
        private TcpReplicator.TcpSocketChannelEntryWriter output;

        private ReadValueToOutputBytes() {
        }

        void reuse(SizeMarshaller valueSizeMarshaller, TcpReplicator.TcpSocketChannelEntryWriter output) {
            this.valueSizeMarshaller(valueSizeMarshaller);
            this.output = output;
        }

        @Override
        Bytes bytes(long valueSize) {
            return this.output.in();
        }

        @Override
        public Bytes readValue(@NotNull ThreadLocalCopies copies, Bytes entry, Bytes usingBytes, long valueSize) {
            long totalSize = (long)(1 + this.valueSizeMarshaller.sizeEncodingSize(valueSize)) + valueSize;
            this.output.ensureBufferSize(totalSize);
            this.output.in().writeBoolean(false);
            return super.readValue(copies, entry, usingBytes, valueSize);
        }

        @Override
        public Bytes readNull() {
            this.output.ensureBufferSize(1L);
            this.output.in().writeBoolean(true);
            return null;
        }
    }

    static abstract class ReadValueToBytes
    implements ReadValue<Bytes> {
        SizeMarshaller valueSizeMarshaller;

        ReadValueToBytes() {
        }

        abstract Bytes bytes(long var1);

        void valueSizeMarshaller(SizeMarshaller valueSizeMarshaller) {
            this.valueSizeMarshaller = valueSizeMarshaller;
        }

        @Override
        public Bytes readValue(@NotNull ThreadLocalCopies copies, Bytes entry, Bytes usingBytes, long valueSize) {
            usingBytes = this.bytes(valueSize);
            this.valueSizeMarshaller.writeSize(usingBytes, valueSize);
            usingBytes.write((RandomDataInput)entry, entry.position(), valueSize);
            entry.skip(valueSize);
            return usingBytes;
        }
    }
}

