/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import net.openhft.chronicle.map.NodeDiscoveryBroadcaster;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.model.constraints.NotNull;

class ConcurrentExpiryMap<K extends BytesMarshallable, V extends BytesMarshallable>
implements BytesMarshallable {
    final ConcurrentMap<K, V> map = new ConcurrentHashMap();
    private final Class<K> kClass;
    private final Class<V> vClass;
    private final Queue<Map.Entry<K, W<V>>> queue = new ConcurrentLinkedQueue<Map.Entry<K, W<V>>>();

    ConcurrentExpiryMap(Class<K> kClass, Class<V> vClass) {
        this.kClass = kClass;
        this.vClass = vClass;
    }

    public String toString() {
        return "ConcurrentExpiryMap{" + this.map + '}';
    }

    public void readMarshallable(@NotNull Bytes in) throws IllegalStateException {
        int size = in.readShort();
        try {
            for (int i = 0; i < size; ++i) {
                BytesMarshallable k = (BytesMarshallable)this.kClass.newInstance();
                k.readMarshallable(in);
                BytesMarshallable v = (BytesMarshallable)this.vClass.newInstance();
                v.readMarshallable(in);
                this.map.put(k, v);
            }
        }
        catch (Exception e) {
            NodeDiscoveryBroadcaster.LOG.error("", (Throwable)e);
        }
    }

    public void writeMarshallable(@NotNull Bytes out) {
        HashMap<K, V> safeCopy = new HashMap<K, V>(this.map);
        out.writeShort(safeCopy.size());
        for (Map.Entry entry : safeCopy.entrySet()) {
            ((BytesMarshallable)entry.getKey()).writeMarshallable(out);
            ((BytesMarshallable)entry.getValue()).writeMarshallable(out);
        }
    }

    void put(K k, V v) {
        this.map.put(k, v);
        W<V> w = new W<V>(v);
        this.queue.add(new Map.Entry<K, W<V>>((BytesMarshallable)k, w){
            final /* synthetic */ BytesMarshallable val$k;
            final /* synthetic */ W val$w;
            {
                this.val$k = bytesMarshallable;
                this.val$w = w;
            }

            @Override
            public K getKey() {
                return this.val$k;
            }

            @Override
            public W<V> getValue() {
                return this.val$w;
            }

            @Override
            public W<V> setValue(W<V> value) {
                throw new UnsupportedOperationException();
            }
        });
    }

    Collection<V> values() {
        return this.map.values();
    }

    void expireEntries(long timeOlderThan) {
        Map.Entry<K, W<V>> e;
        while ((e = this.queue.peek()) != null) {
            if (e.getValue().timestamp < timeOlderThan) {
                this.map.remove(e.getKey(), e.getValue().v);
            }
            this.queue.poll();
        }
    }

    public static void main(String ... args) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    String ip = addr.getHostAddress();
                    System.out.println(iface.getDisplayName() + " " + ip);
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    public static NetworkInterface defaultNetworkInterface() throws SocketException {
        String suggestedName;
        NetworkInterface networkInterface = null;
        String[] arr$ = new String[]{"en0", "eth0"};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (networkInterface = NetworkInterface.getByName(suggestedName = arr$[i$])) == null; ++i$) {
        }
        if (networkInterface != null) {
            return networkInterface;
        }
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        if (networkInterfaces == null || !networkInterfaces.hasMoreElements()) {
            return null;
        }
        return networkInterfaces.nextElement();
    }

    public static InetAddress getDefaultAddress() throws SocketException {
        NetworkInterface networkInterface = ConcurrentExpiryMap.defaultNetworkInterface();
        Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
        InetAddress inetAddress = null;
        while (inetAddresses.hasMoreElements()) {
            inetAddress = inetAddresses.nextElement();
        }
        if (inetAddress == null) {
            throw new IllegalStateException();
        }
        return inetAddress;
    }

    class W<V> {
        final long timestamp;
        final V v;

        W(V v) {
            this.v = v;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

