/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import net.openhft.chronicle.hash.replication.TcpConfig;
import net.openhft.chronicle.hash.replication.UdpConfig;
import org.jetbrains.annotations.Nullable;

class AbstractReplication {
    private final byte localIdentifier;
    private final TcpConfig tcpConfig;
    private final UdpConfig udpConfig;

    AbstractReplication(byte localIdentifier, Builder builder) {
        this.localIdentifier = localIdentifier;
        this.tcpConfig = builder.tcpConfig;
        this.udpConfig = builder.udpConfig;
    }

    public byte identifier() {
        return this.localIdentifier;
    }

    @Nullable
    public TcpConfig tcpTransportAndNetwork() {
        return this.tcpConfig;
    }

    @Nullable
    public UdpConfig udpTransport() {
        return this.udpConfig;
    }

    static abstract class Builder<B extends Builder> {
        private TcpConfig tcpConfig = null;
        private UdpConfig udpConfig = null;

        Builder() {
        }

        public B tcpTransportAndNetwork(TcpConfig tcpConfig) {
            this.tcpConfig = tcpConfig;
            return (B)this;
        }

        public B udpTransport(UdpConfig udpConfig) {
            this.udpConfig = udpConfig;
            return (B)this;
        }

        void check() {
            if (this.udpConfig == null && this.tcpConfig == null) {
                throw new IllegalStateException("At least one transport method (TCP or UDP) should be configured");
            }
        }
    }
}

