/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.Hasher;
import net.openhft.chronicle.hash.serialization.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.MetaProvider;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.StatefulCopyable;
import net.openhft.lang.threadlocal.ThreadLocalCopies;

public abstract class CopyingMetaBytesInterop<E, W>
implements MetaBytesInterop<E, W> {
    private static final long serialVersionUID = 0L;
    final DirectBytesBuffer buffer;
    transient long size;
    transient long hash;
    transient W writer;
    transient E cur;
    private static final Provider<DirectBytesBuffer> provider = Provider.of(DirectBytesBuffer.class);

    private CopyingMetaBytesInterop(DirectBytesBuffer buffer) {
        this.buffer = buffer;
    }

    void init(W writer, E e, boolean mutable, long maxSize) {
        if (mutable || writer != this.writer || e != this.cur) {
            this.writer = writer;
            this.cur = e;
            Bytes buffer = this.buffer.obtain(maxSize);
            this.innerWrite(writer, buffer, e);
            buffer.flip();
            this.size = buffer.remaining();
            this.hash = 0L;
        }
    }

    abstract void innerWrite(W var1, Bytes var2, E var3);

    @Override
    public long size(W writer, E e) {
        return this.size;
    }

    @Override
    public boolean startsWith(W writer, Bytes bytes, E e) {
        return bytes.startsWith((RandomDataInput)this.buffer.buffer);
    }

    @Override
    public long hash(W writer, E e) {
        long h = this.hash;
        if (h == 0L) {
            this.hash = Hasher.hash((Bytes)this.buffer.buffer);
            return this.hash;
        }
        return h;
    }

    @Override
    public void write(W writer, Bytes bytes, E e) {
        assert (bytes.limit() == bytes.capacity());
        bytes.write((RandomDataInput)this.buffer.buffer);
    }

    DirectBytesBuffer buffer() {
        return this.buffer;
    }

    public static <E, M extends BytesMarshaller<E>> MetaBytesInterop<E, M> forBytesMarshaller(Serializable bufferIdentity) {
        return new DirectBytesBuffer(bufferIdentity).forBytesMarshaller;
    }

    public static <E, W extends BytesWriter<E>> MetaBytesInterop<E, W> forBytesWriter(Serializable bufferIdentity) {
        return new DirectBytesBuffer(bufferIdentity).forBytesWriter;
    }

    public static <E, M extends BytesMarshaller<E>> MetaProvider<E, M, CopyingMetaBytesInterop<E, M>> providerForBytesMarshaller(boolean mutable, long maxSize) {
        return new BytesMarshallerCopyingMetaBytesInteropProvider(mutable, maxSize);
    }

    public static <E, W extends BytesWriter<E>> MetaProvider<E, W, CopyingMetaBytesInterop<E, W>> providerForBytesWriter(boolean mutable, long maxSize) {
        return new BytesWriterCopyingMetaBytesInteropProvider(mutable, maxSize);
    }

    private static class DirectBytesBuffer
    implements StatefulCopyable<DirectBytesBuffer>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Serializable identity;
        private transient DirectBytes buffer;
        private transient ForBytesMarshaller forBytesMarshaller;
        private transient ForBytesWriter forBytesWriter;

        DirectBytesBuffer(Serializable identity) {
            this.identity = identity;
            this.initTransients();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.initTransients();
        }

        private void initTransients() {
            this.forBytesMarshaller = new ForBytesMarshaller();
            this.forBytesWriter = new ForBytesWriter();
        }

        Bytes obtain(long maxSize) {
            DirectBytes buf = this.buffer;
            if (buf != null) {
                if (maxSize <= buf.capacity()) {
                    return buf.clear();
                }
                DirectStore store = (DirectStore)buf.store();
                store.resize(maxSize, false);
                this.buffer = store.bytes();
                return this.buffer;
            }
            this.buffer = new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, maxSize, false).bytes();
            return this.buffer;
        }

        public Object stateIdentity() {
            return this.identity;
        }

        public DirectBytesBuffer copy() {
            return new DirectBytesBuffer(this.identity);
        }

        private class ForBytesWriter<E, W extends BytesWriter<E>>
        extends CopyingMetaBytesInterop<E, W> {
            private static final long serialVersionUID = 0L;

            private ForBytesWriter() {
                super(DirectBytesBuffer.this);
            }

            @Override
            void innerWrite(W writer, Bytes bytes, E e) {
                writer.write(bytes, e);
            }
        }

        private class ForBytesMarshaller<E, M extends BytesMarshaller<E>>
        extends CopyingMetaBytesInterop<E, M> {
            private static final long serialVersionUID = 0L;

            private ForBytesMarshaller() {
                super(DirectBytesBuffer.this);
            }

            @Override
            void innerWrite(M writer, Bytes bytes, E e) {
                writer.write(bytes, e);
            }
        }
    }

    private static class BytesWriterCopyingMetaBytesInteropProvider<E, W extends BytesWriter<E>>
    extends AbstractCopyingMetaBytesInteropProvider<E, W, CopyingMetaBytesInterop<E, W>> {
        private static final long serialVersionUID = 0L;
        private final boolean mutable;
        private final long maxSize;

        public BytesWriterCopyingMetaBytesInteropProvider(boolean mutable, long maxSize) {
            this.mutable = mutable;
            this.maxSize = maxSize;
        }

        @Override
        public CopyingMetaBytesInterop<E, W> get(ThreadLocalCopies copies, CopyingMetaBytesInterop<E, W> originalMetaWriter, W writer, E e) {
            DirectBytesBuffer.ForBytesWriter forBytesWriter = ((DirectBytesBuffer)provider.get(copies, (Object)originalMetaWriter.buffer())).forBytesWriter;
            forBytesWriter.init(writer, e, this.mutable, this.maxSize);
            return forBytesWriter;
        }
    }

    private static class BytesMarshallerCopyingMetaBytesInteropProvider<E, M extends BytesMarshaller<E>>
    extends AbstractCopyingMetaBytesInteropProvider<E, M, CopyingMetaBytesInterop<E, M>> {
        private static final long serialVersionUID = 0L;
        private final boolean mutable;
        private final long maxSize;

        public BytesMarshallerCopyingMetaBytesInteropProvider(boolean mutable, long maxSize) {
            this.mutable = mutable;
            this.maxSize = maxSize;
        }

        @Override
        public CopyingMetaBytesInterop<E, M> get(ThreadLocalCopies copies, CopyingMetaBytesInterop<E, M> originalMetaWriter, M writer, E e) {
            DirectBytesBuffer.ForBytesMarshaller forBytesMarshaller = ((DirectBytesBuffer)provider.get(copies, (Object)originalMetaWriter.buffer())).forBytesMarshaller;
            forBytesMarshaller.init(writer, e, this.mutable, this.maxSize);
            return forBytesMarshaller;
        }
    }

    private static abstract class AbstractCopyingMetaBytesInteropProvider<E, I, MI extends CopyingMetaBytesInterop<E, I>>
    implements MetaProvider<E, I, MI> {
        private static final long serialVersionUID = 0L;

        private AbstractCopyingMetaBytesInteropProvider() {
        }

        @Override
        public ThreadLocalCopies getCopies(ThreadLocalCopies copies) {
            return provider.getCopies(copies);
        }
    }
}

