/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.map.Buffer;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.Serializer;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

public class StatelessMapClient<K, V>
implements ChronicleMap<K, V> {
    private final ThreadLocal<Buffer> sourceBuffer = new ThreadLocal();
    private final Map<Long, Object> transactionIDs = new HashMap<Long, Object>();
    private final AtomicLong transactionID = new AtomicLong();
    private long timeoutMs = TimeUnit.SECONDS.toMillis(20L);
    private final Serializer<V, ?, ?> valueSerializer;
    private final Serializer<K, ?, ?> keySerializer;
    private final Bytes out;

    public StatelessMapClient(Bytes out, Class<K> kClass, Class<V> vClass) {
        SerializationBuilder<K> keyBuilder = new SerializationBuilder<K>(kClass, SerializationBuilder.Role.KEY);
        SerializationBuilder<V> valueBuilder = new SerializationBuilder<V>(vClass, SerializationBuilder.Role.VALUE);
        this.keySerializer = new Serializer(keyBuilder);
        this.valueSerializer = new Serializer(valueBuilder);
        this.out = out;
    }

    @Override
    public File file() {
        return null;
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("This is not supported in the " + this.getClass().getSimpleName());
    }

    long nextUniqueTransaction() {
        boolean b;
        long l;
        long time = System.currentTimeMillis();
        if (time > (l = this.transactionID.get()) && (b = this.transactionID.compareAndSet(l, time))) {
            return time;
        }
        return this.transactionID.incrementAndGet();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.writeEvent(EventId.PUT_IF_ABSENT);
        this.writeKey(key);
        this.writeValue(value);
        return this.readValue(this.blockingFetch());
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.writeEvent(EventId.REMOVE_WITH_VALUE);
        this.writeKey(key);
        this.writeValue(value);
        return this.blockingFetch().readBoolean();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.writeEvent(EventId.REPLACE_WITH_OLD_AND_NEW_VALUE);
        this.writeKey(key);
        this.writeValue(oldValue);
        this.writeValue(newValue);
        return this.blockingFetch().readBoolean();
    }

    private void writeValue(V newValue) {
        this.valueSerializer.writeMarshallable(newValue, this.out);
    }

    @Override
    public V replace(K key, V value) {
        this.writeEvent(EventId.REPLACE);
        this.writeKey(key);
        this.writeValue(value);
        return this.readValue(this.blockingFetch());
    }

    @Override
    public int size() {
        this.writeEvent(EventId.SIZE);
        return this.blockingFetch().readInt();
    }

    @Override
    public boolean isEmpty() {
        this.writeEvent(EventId.IS_EMPTY);
        return this.blockingFetch().readBoolean();
    }

    @Override
    public boolean containsKey(Object key) {
        this.writeEvent(EventId.CONTAINS_KEY);
        this.writeKey(key);
        return this.blockingFetch().readBoolean();
    }

    @Override
    public boolean containsValue(Object value) {
        this.writeEvent(EventId.CONTAINS_VALUE);
        this.writeValue(value);
        return this.blockingFetch().readBoolean();
    }

    @Override
    public long longSize() {
        this.writeEvent(EventId.LONG_SIZE);
        return this.blockingFetch().readLong();
    }

    @Override
    public V get(Object key) {
        this.writeEvent(EventId.GET);
        this.writeKey(key);
        return this.readValue(this.blockingFetch());
    }

    V readValue(Bytes source) {
        return this.valueSerializer.readMarshallable(source);
    }

    @Override
    public V getUsing(K key, V value) {
        throw new UnsupportedOperationException("getUsing is not supported for stateless clients");
    }

    @Override
    public V acquireUsing(K key, V value) {
        throw new UnsupportedOperationException("getUsing is not supported for stateless clients");
    }

    @Override
    public V put(K key, V value) {
        this.writeEvent(EventId.PUT);
        this.writeKey(key);
        this.writeValue(value);
        return this.readValue(this.blockingFetch());
    }

    @Override
    public V remove(Object key) {
        this.writeEvent(EventId.REMOVE);
        this.writeKey(key);
        return this.readValue(this.blockingFetch());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.writeEvent(EventId.PUT_ALL);
        this.writeEntries(map);
        this.blockingFetch();
    }

    private void writeEntries(Map<? extends K, ? extends V> map) {
        HashMap<K, V> safeCopy = new HashMap<K, V>(map);
        this.out.writeStopBit((long)safeCopy.size());
        Set<Map.Entry<K, V>> entries = safeCopy.entrySet();
        for (Entry entry : entries) {
            this.writeKey(entry.getKey());
            this.writeValue(entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.writeEvent(EventId.CLEAR);
        this.blockingFetch();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        this.writeEvent(EventId.KEY_SET);
        return this.readKeySet(this.blockingFetch());
    }

    private Set<K> readKeySet(Bytes in) {
        long size = in.readStopBit();
        HashSet<K> result = new HashSet<K>();
        for (long i = 0L; i < size; ++i) {
            result.add(this.readKey(this.out));
        }
        return result;
    }

    private K readKey(Bytes bufferBytes) {
        return this.keySerializer.readMarshallable(bufferBytes);
    }

    @Override
    @NotNull
    public Collection<V> values() {
        this.writeEvent(EventId.VALUES);
        Bytes in = this.blockingFetch();
        long size = in.readStopBit();
        if (size > Integer.MAX_VALUE) {
            throw new IllegalStateException("size=" + size + " is too large.");
        }
        ArrayList<V> result = new ArrayList<V>((int)size);
        int i = 0;
        while ((long)i < size) {
            result.add(this.readValue(in));
            ++i;
        }
        return result;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        this.writeEvent(EventId.ENTRY_SET);
        Bytes bytes = this.blockingFetch();
        long size = bytes.readStopBit();
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        int i = 0;
        while ((long)i < size) {
            K k = this.keySerializer.readMarshallable(bytes);
            V v = this.valueSerializer.readMarshallable(bytes);
            result.add(new Entry(k, v));
            ++i;
        }
        return result;
    }

    private void writeKey(K key) {
        this.keySerializer.writeMarshallable(key, this.out);
    }

    private void writeEvent(EventId event) {
        this.out.write((int)((byte)event.ordinal()));
    }

    public Buffer buffer() {
        Buffer result = this.sourceBuffer.get();
        if (result != null) {
            return result;
        }
        result = new Buffer(){
            volatile ByteBufferBytes buffer = null;

            @Override
            public void set(ByteBufferBytes source) {
                this.buffer = source;
            }

            @Override
            public ByteBufferBytes get() {
                return this.buffer;
            }
        };
        this.sourceBuffer.set(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bytes blockingFetch(long transactionId) {
        Buffer buffer = this.buffer();
        buffer.set(null);
        StatelessMapClient statelessMapClient = this;
        synchronized (statelessMapClient) {
            this.transactionIDs.put(transactionId, buffer);
            try {
                buffer.wait(this.timeoutMs);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        ByteBufferBytes bufferBytes = buffer.get();
        if (bufferBytes == null) {
            throw new RuntimeException("Timed-out", new TimeoutException());
        }
        return bufferBytes;
    }

    private Bytes blockingFetch() {
        long transactionId = this.nextUniqueTransaction();
        this.out.writeLong(transactionId);
        return this.blockingFetch(transactionId);
    }

    class Entry
    implements Map.Entry<K, V> {
        final K key;
        final V value;

        Entry(K k1, V v) {
            this.value = v;
            this.key = k1;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            Object oldValue = this.value;
            StatelessMapClient.this.put(this.getKey(), newValue);
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    public static enum EventId {
        LONG_SIZE,
        SIZE,
        IS_EMPTY,
        CONTAINS_KEY,
        CONTAINS_VALUE,
        GET,
        PUT,
        REMOVE,
        PUT_ALL,
        CLEAR,
        KEY_SET,
        VALUES,
        ENTRY_SET,
        REPLACE,
        REPLACE_WITH_OLD_AND_NEW_VALUE,
        PUT_IF_ABSENT,
        REMOVE_WITH_VALUE;

    }
}

