/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.serialization.BytesReader;
import net.openhft.chronicle.map.serialization.MetaBytesWriter;
import net.openhft.chronicle.map.serialization.MetaProvider;
import net.openhft.chronicle.map.serialization.SizeMarshaller;
import net.openhft.chronicle.map.threadlocal.Provider;
import net.openhft.chronicle.map.threadlocal.ThreadLocalCopies;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.constraints.NotNull;

public class Serializer<O, VW, MVW extends MetaBytesWriter<O, VW>> {
    final SizeMarshaller sizeMarshaller;
    final BytesReader<O> originalReader;
    transient Provider<BytesReader<O>> readerProvider;
    final VW originalWriter;
    transient Provider<VW> writerProvider;
    final MVW originalMetaValueWriter;
    final MetaProvider<O, VW, MVW> metaValueWriterProvider;

    public Serializer(SerializationBuilder<O> serializationBuilder) {
        this.sizeMarshaller = serializationBuilder.sizeMarshaller();
        this.originalMetaValueWriter = serializationBuilder.metaInterop();
        this.metaValueWriterProvider = serializationBuilder.metaInteropProvider();
        this.originalReader = serializationBuilder.reader();
        this.originalWriter = serializationBuilder.interop();
        this.readerProvider = Provider.of(this.originalReader.getClass());
        this.writerProvider = Provider.of(this.originalWriter.getClass());
    }

    public O readMarshallable(@NotNull Bytes in) throws IllegalStateException {
        ThreadLocalCopies copies = this.readerProvider.getCopies(null);
        BytesReader<O> valueReader = this.readerProvider.get(copies, this.originalReader);
        try {
            long valueSize = this.sizeMarshaller.readSize(in);
            return valueReader.read(in, valueSize, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeMarshallable(O value, @NotNull Bytes out) {
        long valueSize;
        ThreadLocalCopies copies = this.readerProvider.getCopies(null);
        VW valueWriter = this.writerProvider.get(copies, this.originalWriter);
        copies = this.writerProvider.getCopies(copies);
        MetaBytesWriter<O, VW> metaValueWriter = null;
        if (value instanceof Byteable) {
            valueSize = ((Byteable)value).maxSize();
        } else {
            copies = this.writerProvider.getCopies(copies);
            valueWriter = this.writerProvider.get(copies, this.originalWriter);
            copies = this.metaValueWriterProvider.getCopies(copies);
            metaValueWriter = this.metaValueWriterProvider.get(copies, this.originalMetaValueWriter, valueWriter, value);
            valueSize = metaValueWriter.size(valueWriter, value);
        }
        this.sizeMarshaller.writeSize(out, valueSize);
        if (metaValueWriter == null) {
            throw new UnsupportedOperationException("");
        }
        metaValueWriter.write(valueWriter, out, value);
    }
}

