/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.openhft.chronicle.map.AbstractChannelReplicator;
import net.openhft.chronicle.map.ChannelProviderBuilder;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.Replicator;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.RandomDataInput;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelProvider
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)ChannelProvider.class.getName());
    private static final byte BOOTSTRAP_MESSAGE = 66;
    final Replica.EntryExternalizable asEntryExternalizable = new Replica.EntryExternalizable(){

        @Override
        public void writeExternalEntry(@NotNull Bytes entry, @NotNull Bytes destination, int chronicleChannel) {
            destination.writeStopBit((long)chronicleChannel);
            ChannelProvider.this.channelEntryExternalizables[chronicleChannel].writeExternalEntry(entry, destination, chronicleChannel);
        }

        @Override
        public void readExternalEntry(@NotNull Bytes source) {
            int chronicleId = (int)source.readStopBit();
            if (chronicleId < ChannelProvider.this.chronicleChannels.length) {
                ChannelProvider.this.channelEntryExternalizables[chronicleId].readExternalEntry(source);
            } else {
                LOG.info("skipped entry with chronicleId=" + chronicleId + ", ");
            }
        }
    };
    private final byte localIdentifier;
    final Replica asReplica = new Replica(){

        @Override
        public byte identifier() {
            return ChannelProvider.this.localIdentifier;
        }

        @Override
        public Replica.ModificationIterator acquireModificationIterator(final short remoteIdentifier, final Replica.ModificationNotifier notifier) {
            Replica.ModificationIterator result = (Replica.ModificationIterator)ChannelProvider.this.modificationIterator.get(remoteIdentifier);
            if (result != null) {
                return result;
            }
            Replica.ModificationIterator result0 = new Replica.ModificationIterator(){

                @Override
                public boolean hasNext() {
                    int len = ChannelProvider.this.chronicleChannelList.size();
                    for (int i = 0; i < len; ++i) {
                        Replica.ModificationIterator modificationIterator = ((Replica)ChannelProvider.this.chronicleChannelList.get(i)).acquireModificationIterator(remoteIdentifier, notifier);
                        if (!modificationIterator.hasNext()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean nextEntry(@NotNull Replica.EntryCallback callback, int na) {
                    int len = ChannelProvider.this.chronicleChannelList.size();
                    for (int i = 0; i < len; ++i) {
                        Replica chronicleChannel = (Replica)ChannelProvider.this.chronicleChannelList.get(i);
                        Replica.ModificationIterator modificationIterator = chronicleChannel.acquireModificationIterator(remoteIdentifier, notifier);
                        if (!modificationIterator.nextEntry(callback, (Integer)ChannelProvider.this.chronicleChannelIds.get(i))) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public void dirtyEntries(long fromTimeStamp) {
                    int len = ChannelProvider.this.chronicleChannelList.size();
                    for (int i = 0; i < len; ++i) {
                        ((Replica)ChannelProvider.this.chronicleChannelList.get(i)).acquireModificationIterator(remoteIdentifier, notifier).dirtyEntries(fromTimeStamp);
                        notifier.onChange();
                    }
                }
            };
            ChannelProvider.this.modificationIterator.set(remoteIdentifier, result0);
            return result0;
        }

        @Override
        public long lastModificationTime(byte remoteIdentifier) {
            long t = 0L;
            int len = ChannelProvider.this.chronicleChannelList.size();
            for (int i = 1; i < len; ++i) {
                t = t == 0L ? ChannelProvider.this.chronicleChannels[i].lastModificationTime(remoteIdentifier) : Math.min(t, ChannelProvider.this.chronicleChannels[i].lastModificationTime(remoteIdentifier));
            }
            return t;
        }

        @Override
        public void close() throws IOException {
            ChannelProvider.this.close();
        }
    };
    private final int maxEntrySize;
    private final Replica[] chronicleChannels;
    private final List<Replica> chronicleChannelList;
    private final List<Integer> chronicleChannelIds;
    private final Replica.EntryExternalizable[] channelEntryExternalizables;
    private final AtomicReferenceArray<PayloadProvider> systemModificationIterator = new AtomicReferenceArray(128);
    private final DirectBitSet systemModificationIteratorBitSet = ChannelProvider.newBitSet(this.systemModificationIterator.length());
    private final AtomicReferenceArray<Replica.ModificationIterator> modificationIterator = new AtomicReferenceArray(128);
    private final Set<AbstractChannelReplicator> replicators = new CopyOnWriteArraySet<AbstractChannelReplicator>();

    ChannelProvider(ChannelProviderBuilder builder) {
        this.localIdentifier = builder.identifier;
        this.maxEntrySize = builder.maxEntrySize;
        this.chronicleChannels = new Replica[builder.maxNumberOfChronicles];
        this.channelEntryExternalizables = new Replica.EntryExternalizable[builder.maxNumberOfChronicles];
        this.chronicleChannelList = new ArrayList<Replica>();
        this.chronicleChannelIds = new ArrayList<Integer>();
        MessageHandler systemMessageHandler = new MessageHandler(){

            @Override
            public void onMessage(Bytes bytes) {
                byte type = bytes.readByte();
                if (type == 66) {
                    ChannelProvider.this.onBootstrapMessage(bytes);
                } else {
                    LOG.info("message of type=" + type + " was ignored.");
                }
            }
        };
        SystemQueue systemMessageQueue = new SystemQueue(this.systemModificationIteratorBitSet, this.systemModificationIterator, systemMessageHandler);
        this.add((short)0, systemMessageQueue.asReplica, systemMessageQueue.asEntryExternalizable);
    }

    private static DirectBitSet newBitSet(int numberOfBits) {
        ByteBufferBytes bytes = new ByteBufferBytes(ByteBuffer.wrap(new byte[(numberOfBits + 7) / 8]));
        return new SingleThreadedDirectBitSet((Bytes)bytes);
    }

    public ChronicleChannel createChannel(short channel) {
        return new ChronicleChannel(channel);
    }

    private void onBootstrapMessage(Bytes bytes) {
        short remoteIdentifier = bytes.readByte();
        int chronicleChannel = bytes.readUnsignedShort();
        long lastModificationTime = bytes.readLong();
        if (this.chronicleChannels[chronicleChannel] != null) {
            this.chronicleChannels[chronicleChannel].acquireModificationIterator(remoteIdentifier, Replica.ModificationNotifier.NOP).dirtyEntries(lastModificationTime);
        }
    }

    private ByteBufferBytes toBootstrapMessage(short chronicleChannel, long lastModificationTime) {
        ByteBufferBytes writeBuffer = new ByteBufferBytes(ByteBuffer.allocate(12));
        writeBuffer.writeByte(66);
        writeBuffer.writeByte((int)this.localIdentifier);
        writeBuffer.writeUnsignedShort((int)chronicleChannel);
        writeBuffer.writeLong(lastModificationTime);
        writeBuffer.flip();
        return writeBuffer;
    }

    private void add(short chronicleChannel, Replica replica, Replica.EntryExternalizable entryExternalizable) {
        if (this.chronicleChannels[chronicleChannel] != null) {
            throw new IllegalStateException("chronicleId=" + chronicleChannel + " is already in use.");
        }
        this.chronicleChannels[chronicleChannel] = replica;
        this.chronicleChannelList.add(replica);
        this.chronicleChannelIds.add(Integer.valueOf(chronicleChannel));
        this.channelEntryExternalizables[chronicleChannel] = entryExternalizable;
        if (chronicleChannel == 0) {
            return;
        }
        int i = (int)this.systemModificationIteratorBitSet.nextSetBit(0L);
        while (i > 0) {
            byte remoteIdentifier = (byte)i;
            long lastModificationTime = replica.lastModificationTime(remoteIdentifier);
            ByteBufferBytes message = this.toBootstrapMessage(chronicleChannel, lastModificationTime);
            this.systemModificationIterator.get(remoteIdentifier).addPayload((Bytes)message);
            i = (int)this.systemModificationIteratorBitSet.nextSetBit((long)(i + 1));
        }
    }

    @Override
    public void close() throws IOException {
        for (AbstractChannelReplicator replicator : this.replicators) {
            replicator.close();
        }
        for (int i = this.chronicleChannelList.size() - 1; i >= 0; --i) {
            Replica chronicleChannel = this.chronicleChannelList.get(i);
            chronicleChannel.close();
        }
    }

    void add(AbstractChannelReplicator replicator) {
        this.replicators.add(replicator);
    }

    public class ChronicleChannel
    extends Replicator
    implements Closeable {
        private final short chronicleChannel;

        private ChronicleChannel(short chronicleChannel) {
            this.chronicleChannel = chronicleChannel;
        }

        public byte identifier() {
            return ChannelProvider.this.localIdentifier;
        }

        @Override
        protected Closeable applyTo(ChronicleMapBuilder builder, Replica map, Replica.EntryExternalizable entryExternalizable) {
            if (builder.entrySize() > ChannelProvider.this.maxEntrySize) {
                throw new IllegalArgumentException("During ReplicatingChannelBuilder setup, maxEntrySize=" + ChannelProvider.this.maxEntrySize + " was specified, but map with " + "entrySize=" + builder.entrySize() + " is attempted to apply" + "to the replicator");
            }
            ChannelProvider.this.add(this.chronicleChannel, map, entryExternalizable);
            return this;
        }

        @Override
        public void close() throws IOException {
            ChannelProvider.this.chronicleChannelList.remove(ChannelProvider.this.chronicleChannels[this.chronicleChannel]);
            ChannelProvider.this.chronicleChannelIds.remove(this.chronicleChannel);
            ((ChannelProvider)ChannelProvider.this).chronicleChannels[this.chronicleChannel] = null;
            ((ChannelProvider)ChannelProvider.this).channelEntryExternalizables[this.chronicleChannel] = null;
        }
    }

    static class SystemQueue {
        final Replica asReplica = new Replica(){

            @Override
            public byte identifier() {
                return 0;
            }

            @Override
            public Replica.ModificationIterator acquireModificationIterator(short remoteIdentifier, final Replica.ModificationNotifier modificationNotifier) {
                Replica.ModificationIterator result = (Replica.ModificationIterator)SystemQueue.this.systemModificationIterator.get(remoteIdentifier);
                if (result != null) {
                    return result;
                }
                PayloadProvider iterator = new PayloadProvider(){
                    final Queue<Bytes> payloads = new LinkedTransferQueue<Bytes>();

                    @Override
                    public boolean hasNext() {
                        return this.payloads.peek() != null;
                    }

                    @Override
                    public boolean nextEntry(@NotNull Replica.EntryCallback callback, int na) {
                        Bytes bytes = this.payloads.poll();
                        if (bytes == null) {
                            return false;
                        }
                        callback.onEntry(bytes, 0);
                        return true;
                    }

                    @Override
                    public void dirtyEntries(long fromTimeStamp) {
                    }

                    @Override
                    public void addPayload(Bytes bytes) {
                        if (bytes.remaining() == 0L) {
                            return;
                        }
                        this.payloads.add(bytes);
                        modificationNotifier.onChange();
                    }
                };
                SystemQueue.this.systemModificationIterator.set(remoteIdentifier, iterator);
                SystemQueue.this.systemModificationIteratorBitSet.set((long)remoteIdentifier);
                return iterator;
            }

            @Override
            public long lastModificationTime(byte remoteIdentifier) {
                return 0L;
            }

            @Override
            public void close() throws IOException {
            }
        };
        final Replica.EntryExternalizable asEntryExternalizable = new Replica.EntryExternalizable(){

            @Override
            public void writeExternalEntry(@NotNull Bytes entry, @NotNull Bytes destination, int na) {
                destination.write((RandomDataInput)entry);
            }

            @Override
            public void readExternalEntry(@NotNull Bytes source) {
                SystemQueue.this.messageHandler.onMessage(source);
            }
        };
        private final DirectBitSet systemModificationIteratorBitSet;
        private final AtomicReferenceArray<PayloadProvider> systemModificationIterator;
        private final MessageHandler messageHandler;

        SystemQueue(DirectBitSet systemModificationIteratorBitSet, AtomicReferenceArray<PayloadProvider> systemModificationIterator, MessageHandler messageHandler) {
            this.systemModificationIteratorBitSet = systemModificationIteratorBitSet;
            this.systemModificationIterator = systemModificationIterator;
            this.messageHandler = messageHandler;
        }
    }

    private static interface PayloadProvider
    extends Replica.ModificationIterator {
        public void addPayload(Bytes var1);
    }

    private static interface MessageHandler {
        public void onMessage(Bytes var1);
    }
}

