/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.set;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.ChronicleSet;
import net.openhft.chronicle.map.MapErrorListener;
import net.openhft.chronicle.map.Replicator;
import net.openhft.chronicle.map.TimeProvider;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import org.jetbrains.annotations.NotNull;

public class ChronicleSetBuilder<E>
implements Cloneable {
    private ChronicleMapBuilder<E, Void> chronicleMapBuilder;

    ChronicleSetBuilder(Class<E> keyClass) {
        this.chronicleMapBuilder = ChronicleMapBuilder.of(keyClass, Void.class);
    }

    public static <K> ChronicleSetBuilder<K> of(Class<K> keyClass) {
        return new ChronicleSetBuilder<K>(keyClass);
    }

    public ChronicleSetBuilder<E> clone() {
        try {
            ChronicleSetBuilder result = (ChronicleSetBuilder)super.clone();
            result.chronicleMapBuilder = this.chronicleMapBuilder.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ChronicleSetBuilder<E> actualSegments(int actualSegments) {
        this.chronicleMapBuilder.actualSegments(actualSegments);
        return this;
    }

    public int actualSegments() {
        return this.chronicleMapBuilder.actualSegments();
    }

    public ChronicleSetBuilder<E> minSegments(int minSegments) {
        this.chronicleMapBuilder.minSegments(minSegments);
        return this;
    }

    public int minSegments() {
        return this.chronicleMapBuilder.minSegments();
    }

    public ChronicleSetBuilder<E> actualElementsPerSegment(int actualEntriesPerSegment) {
        this.chronicleMapBuilder.actualEntriesPerSegment(actualEntriesPerSegment);
        return this;
    }

    public int actualElementsPerSegment() {
        return this.chronicleMapBuilder.actualEntriesPerSegment();
    }

    public ChronicleSetBuilder<E> elementSize(int elementSize) {
        this.chronicleMapBuilder.keySize(elementSize);
        return this;
    }

    public ChronicleSetBuilder<E> constantElementsSizeBySample(E element) {
        this.chronicleMapBuilder.constantKeySizeBySample(element);
        return this;
    }

    public ChronicleSetBuilder<E> alignment(Alignment alignment) {
        this.chronicleMapBuilder.entryAndValueAlignment(alignment);
        return this;
    }

    public Alignment alignment() {
        return this.chronicleMapBuilder.entryAndValueAlignment();
    }

    public ChronicleSetBuilder<E> elements(long entries) {
        this.chronicleMapBuilder.entries(entries);
        return this;
    }

    public long elements() {
        return this.chronicleMapBuilder.entries();
    }

    public ChronicleSetBuilder<E> replicas(int replicas) {
        this.chronicleMapBuilder.replicas(replicas);
        return this;
    }

    public int replicas() {
        return this.chronicleMapBuilder.replicas();
    }

    public ChronicleSetBuilder<E> transactional(boolean transactional) {
        this.chronicleMapBuilder.transactional(transactional);
        return this;
    }

    public boolean transactional() {
        return this.chronicleMapBuilder.transactional();
    }

    public ChronicleSetBuilder<E> lockTimeOut(long lockTimeOut, TimeUnit unit) {
        this.chronicleMapBuilder.lockTimeOut(lockTimeOut, unit);
        return this;
    }

    public long lockTimeOut(TimeUnit unit) {
        return this.chronicleMapBuilder.lockTimeOut(unit);
    }

    public ChronicleSetBuilder<E> errorListener(MapErrorListener errorListener) {
        this.chronicleMapBuilder.errorListener(errorListener);
        return this;
    }

    public MapErrorListener errorListener() {
        return this.chronicleMapBuilder.errorListener();
    }

    public boolean largeSegments() {
        return this.chronicleMapBuilder.largeSegments();
    }

    public ChronicleSetBuilder<E> largeSegments(boolean largeSegments) {
        this.chronicleMapBuilder.largeSegments(largeSegments);
        return this;
    }

    public ChronicleSetBuilder<E> metaDataBytes(int metaDataBytes) {
        this.chronicleMapBuilder.metaDataBytes(metaDataBytes);
        return this;
    }

    public int metaDataBytes() {
        return this.chronicleMapBuilder.metaDataBytes();
    }

    public String toString() {
        return " ChronicleMapBuilder{actualSegments=" + this.actualSegments() + ", minSegments=" + this.minSegments() + ", actualEntriesPerSegment=" + this.actualElementsPerSegment() + ", alignment=" + (Object)((Object)this.alignment()) + ", entries=" + this.elements() + ", replicas=" + this.replicas() + ", transactional=" + this.transactional() + ", metaDataBytes=" + this.metaDataBytes() + ", errorListener=" + this.errorListener() + ", largeSegments=" + this.largeSegments() + ", timeProvider=" + this.timeProvider() + ", bytesMarshallerfactory=" + this.bytesMarshallerFactory() + '}';
    }

    public boolean equals(Object o) {
        return this.chronicleMapBuilder.equals(o);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public ChronicleSetBuilder<E> addReplicator(Replicator replicator) {
        this.chronicleMapBuilder.addReplicator(replicator);
        return this;
    }

    public ChronicleSetBuilder<E> setReplicators(Replicator ... replicators) {
        this.chronicleMapBuilder.setReplicators(replicators);
        return this;
    }

    public ChronicleSetBuilder<E> timeProvider(TimeProvider timeProvider) {
        this.chronicleMapBuilder.timeProvider(timeProvider);
        return this;
    }

    public TimeProvider timeProvider() {
        return this.chronicleMapBuilder.timeProvider();
    }

    public BytesMarshallerFactory bytesMarshallerFactory() {
        return this.chronicleMapBuilder.bytesMarshallerFactory();
    }

    public ChronicleSetBuilder<E> bytesMarshallerFactory(BytesMarshallerFactory bytesMarshallerFactory) {
        this.chronicleMapBuilder.bytesMarshallerFactory(bytesMarshallerFactory);
        return this;
    }

    public ObjectSerializer objectSerializer() {
        return this.chronicleMapBuilder.objectSerializer();
    }

    public ChronicleSetBuilder<E> objectSerializer(ObjectSerializer objectSerializer) {
        this.chronicleMapBuilder.objectSerializer(objectSerializer);
        return this;
    }

    public ChronicleSetBuilder<E> keyMarshaller(@NotNull BytesMarshaller<E> keyMarshaller) {
        this.chronicleMapBuilder.keyMarshaller(keyMarshaller);
        return this;
    }

    public ChronicleSetBuilder<E> immutableKeys() {
        this.chronicleMapBuilder.immutableKeys();
        return this;
    }

    public ChronicleSet<E> create(File file) throws IOException {
        ChronicleMap<E, Void> map = this.chronicleMapBuilder.create(file);
        return new SetFromMap<E>(map);
    }

    public ChronicleSet<E> create() throws IOException {
        ChronicleMap<E, Void> map = this.chronicleMapBuilder.create();
        return new SetFromMap<E>(map);
    }

    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements ChronicleSet<E>,
    Serializable {
        private final ChronicleMap<E, Void> m;
        private transient Set<E> s;
        private static final long serialVersionUID = 2454657854757543876L;

        SetFromMap(ChronicleMap<E, Void> map) {
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("Map is non-empty");
            }
            this.m = map;
            this.s = map.keySet();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, null) == null;
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.s.toArray(a);
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            return this.s.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.s.equals(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.s.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.s.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.s.retainAll(c);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.s = this.m.keySet();
        }

        @Override
        public long longSize() {
            return this.m.longSize();
        }

        @Override
        public void close() throws IOException {
            this.m.close();
        }
    }
}

