/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.serialization.impl;

import net.openhft.chronicle.map.serialization.BytesInterop;
import net.openhft.chronicle.map.serialization.BytesReader;
import net.openhft.chronicle.map.serialization.Hasher;
import net.openhft.lang.io.Bytes;

public enum ByteArrayMarshaller implements BytesInterop<byte[]>,
BytesReader<byte[]>
{
    INSTANCE;


    @Override
    public long size(byte[] ba) {
        return ba.length;
    }

    @Override
    public boolean startsWith(Bytes bytes, byte[] ba) {
        long pos = bytes.position();
        for (int i = 0; i < ba.length; ++i) {
            if (bytes.readByte(pos + (long)i) == ba[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public long hash(byte[] ba) {
        return Hasher.hash(ba);
    }

    @Override
    public void write(Bytes bytes, byte[] ba) {
        bytes.write(ba);
    }

    @Override
    public byte[] read(Bytes bytes, long size) {
        byte[] ba = new byte[(int)size];
        bytes.read(ba);
        return ba;
    }

    @Override
    public byte[] read(Bytes bytes, long size, byte[] ba) {
        if (ba == null || size != (long)ba.length) {
            ba = new byte[(int)size];
        }
        bytes.read(ba);
        return ba;
    }
}

