/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import net.openhft.chronicle.map.ReplicatingCluster;
import net.openhft.chronicle.map.TcpReplicationConfig;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.UdpReplicationConfig;
import net.openhft.chronicle.map.UdpReplicator;

public final class ReplicatingClusterBuilder {
    final byte identifier;
    final int maxEntrySize;
    int maxNumberOfChronicles = 128;
    private UdpReplicationConfig udpReplicationConfig = null;
    private TcpReplicationConfig tcpReplicationConfig = null;

    ReplicatingClusterBuilder(byte identifier, int maxEntrySize) {
        this.identifier = identifier;
        this.maxEntrySize = maxEntrySize;
        if (identifier <= 0) {
            throw new IllegalArgumentException("Identifier must be positive, identifier=" + identifier);
        }
    }

    public ReplicatingClusterBuilder udpReplication(UdpReplicationConfig replicationConfig) {
        this.udpReplicationConfig = replicationConfig;
        return this;
    }

    public ReplicatingClusterBuilder tcpReplication(TcpReplicationConfig replicationConfig) {
        this.tcpReplicationConfig = replicationConfig;
        return this;
    }

    public ReplicatingClusterBuilder maxNumberOfChronicles(int maxNumberOfChronicles) {
        this.maxNumberOfChronicles = maxNumberOfChronicles;
        return this;
    }

    public ReplicatingCluster create() throws IOException {
        ReplicatingCluster replicatingCluster = new ReplicatingCluster(this);
        if (this.tcpReplicationConfig != null) {
            TcpReplicator tcpReplicator = new TcpReplicator(replicatingCluster.asReplica, replicatingCluster.asEntryExternalizable, this.tcpReplicationConfig, this.maxEntrySize);
            replicatingCluster.add(tcpReplicator);
        }
        if (this.udpReplicationConfig != null) {
            UdpReplicator udpReplicator = new UdpReplicator(replicatingCluster.asReplica, replicatingCluster.asEntryExternalizable, this.udpReplicationConfig, this.maxEntrySize);
            replicatingCluster.add(udpReplicator);
        }
        return replicatingCluster;
    }
}

