/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.serialization;

import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.NativeBytes;

public final class Hasher {
    public static long hash(Bytes bytes) {
        return Hasher.hash(bytes, bytes.position(), bytes.limit());
    }

    public static long hash(Bytes bytes, long offset, long limit) {
        long i;
        long h = 0L;
        for (i = offset; i < limit - 7L; i += 8L) {
            h = 1011001110001111L * h + bytes.readLong(i);
        }
        while (i < limit - 1L) {
            h = 101111L * h + (long)bytes.readShort(i);
            i += 2L;
        }
        if (i < limit) {
            h = 2111L * h + (long)bytes.readByte(i);
        }
        return Hasher.hash(h);
    }

    public static long hash(byte[] ba) {
        long i;
        long h = 0L;
        long base = NativeBytes.UNSAFE.arrayBaseOffset(byte[].class);
        long limit = ba.length;
        for (i = 0L; i < limit - 7L; i += 8L) {
            h = 1011001110001111L * h + NativeBytes.UNSAFE.getLong(ba, base + i);
        }
        while (i < limit - 1L) {
            h = 101111L * h + (long)NativeBytes.UNSAFE.getShort(ba, base + i);
            i += 2L;
        }
        if (i < limit) {
            h = 2111L * h + (long)NativeBytes.UNSAFE.getByte(ba, base + i);
        }
        return Hasher.hash(h);
    }

    public static long hash(long value) {
        value *= 11018881818881011L;
        value ^= value >>> 41 ^ value >>> 21;
        return value;
    }

    private Hasher() {
    }
}

