/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collections;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.collections.AbstractVanillaSharedHashMap;
import net.openhft.collections.IntIntMultiMap;
import net.openhft.collections.Replica;
import net.openhft.collections.ReplicaExternalizable;
import net.openhft.collections.SharedHashMap;
import net.openhft.collections.SharedHashMapBuilder;
import net.openhft.collections.SharedMapEventListener;
import net.openhft.collections.SharedSegment;
import net.openhft.collections.TimeProvider;
import net.openhft.collections.VanillaSharedReplicatedHashMap;
import net.openhft.lang.Maths;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.io.AbstractBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.MappedStore;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.DataValueClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VanillaSharedReplicatedHashMap<K, V>
extends AbstractVanillaSharedHashMap<K, V>
implements ChronicleMap<K, V>,
ReplicaExternalizable<K, V>,
Replica.EntryResolver<K, V>,
Closeable {
    static final int MAX_UNSIGNED_SHORT = 65535;
    private static final Logger LOG = LoggerFactory.getLogger(VanillaSharedReplicatedHashMap.class);
    private static final int LAST_UPDATED_HEADER_SIZE = 1016;
    public static final int RESERVED_MOD_ITER = 8;
    private final TimeProvider timeProvider;
    private final byte localIdentifier;
    private final Set<Closeable> closeables = new CopyOnWriteArraySet<Closeable>();
    private Bytes identifierUpdatedBytes;
    private Bytes modDelBytes;
    private final ModificationDelegator modificationDelegator;
    private int startOfModificationIterators;

    public VanillaSharedReplicatedHashMap(@NotNull SharedHashMapBuilder builder, @NotNull Class<K> kClass, @NotNull Class<V> vClass) throws IOException {
        super(builder, kClass, vClass);
        this.timeProvider = builder.timeProvider();
        this.localIdentifier = builder.identifier();
        File file = builder.file();
        ObjectSerializer objectSerializer = builder.objectSerializer();
        MappedStore bytesStore = file == null ? DirectStore.allocateLazy((long)this.sizeInBytes(), (ObjectSerializer)objectSerializer) : new MappedStore(file, FileChannel.MapMode.READ_WRITE, this.sizeInBytes(), objectSerializer);
        this.createMappedStoreAndSegments((BytesStore)bytesStore);
        this.modificationDelegator = new ModificationDelegator(this.eventListener, this.modDelBytes, this.startOfModificationIterators);
        this.eventListener = this.modificationDelegator;
    }

    private int assignedModIterBitSetSizeInBytes() {
        return (int)VanillaSharedReplicatedHashMap.align64(16L);
    }

    @Override
    AbstractVanillaSharedHashMap.Segment createSegment(NativeBytes bytes, int index) {
        return new Segment(bytes, index);
    }

    @Override
    Class segmentType() {
        return Segment.class;
    }

    int modIterBitSetSizeInBytes() {
        return (int)VanillaSharedReplicatedHashMap.align64(this.bitsPerSegmentInModIterBitSet() * (long)this.segments.length / 8L);
    }

    private long bitsPerSegmentInModIterBitSet() {
        return Maths.nextPower2((long)this.entriesPerSegment, (long)1024L);
    }

    @Override
    int multiMapsPerSegment() {
        return 2;
    }

    @Override
    int getHeaderSize() {
        int headerSize = super.getHeaderSize();
        return headerSize + 1016 + this.modIterBitSetSizeInBytes() * 136 + this.assignedModIterBitSetSizeInBytes();
    }

    void setLastModificationTime(byte identifier, long timestamp) {
        int offset = identifier * 8;
        if (this.identifierUpdatedBytes.readLong((long)offset) < timestamp) {
            this.identifierUpdatedBytes.writeLong((long)offset, timestamp);
        }
    }

    public long lastModificationTime(byte remoteIdentifier) {
        assert (remoteIdentifier != this.identifier());
        int offset = remoteIdentifier * 8;
        return this.identifierUpdatedBytes.readLong((long)offset);
    }

    @Override
    void onHeaderCreated() {
        int offset = super.getHeaderSize();
        this.identifierUpdatedBytes = this.ms.bytes((long)offset, 1016L).zeroOut();
        this.modDelBytes = this.ms.bytes((long)(offset += 1016), (long)this.assignedModIterBitSetSizeInBytes()).zeroOut();
        this.startOfModificationIterators = offset += this.assignedModIterBitSetSizeInBytes();
    }

    @Override
    public V put(K key, V value) {
        return this.put0(key, value, true, this.localIdentifier, this.timeProvider.currentTimeMillis());
    }

    V put(K key, V value, byte identifier, long timeStamp) {
        assert (identifier > 0);
        return this.put0(key, value, true, identifier, timeStamp);
    }

    @Override
    public V putIfAbsent(@net.openhft.lang.model.constraints.NotNull K key, V value) {
        return this.put0(key, value, false, this.localIdentifier, this.timeProvider.currentTimeMillis());
    }

    private V put0(K key, V value, boolean replaceIfPresent, byte identifier, long timeStamp) {
        this.checkKey(key);
        this.checkValue(value);
        DirectBytes keyBytes = this.getKeyAsBytes(key);
        long hash = AbstractVanillaSharedHashMap.Hasher.hash((Bytes)keyBytes);
        int segmentNum = this.hasher.getSegment(hash);
        int segmentHash = this.hasher.segmentHash(hash);
        return this.segment(segmentNum).put((Bytes)keyBytes, key, value, segmentHash, replaceIfPresent, identifier, timeStamp);
    }

    private Segment segment(int segmentNum) {
        return (Segment)this.segments[segmentNum];
    }

    @Override
    V lookupUsing(K key, V value, boolean create) {
        this.checkKey(key);
        DirectBytes keyBytes = this.getKeyAsBytes(key);
        long hash = AbstractVanillaSharedHashMap.Hasher.hash((Bytes)keyBytes);
        int segmentNum = this.hasher.getSegment(hash);
        int segmentHash = this.hasher.segmentHash(hash);
        return this.segment(segmentNum).acquire((Bytes)keyBytes, key, value, segmentHash, create, this.timeProvider.currentTimeMillis());
    }

    @Override
    public V remove(Object key) {
        return this.removeIfValueIs(key, null, this.localIdentifier, this.timeProvider.currentTimeMillis());
    }

    V remove(K key, V value, byte identifier, long timeStamp) {
        assert (identifier > 0);
        return this.removeIfValueIs(key, null, identifier, timeStamp);
    }

    void addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    @Override
    public void close() {
        for (Closeable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.close();
    }

    public byte identifier() {
        return this.localIdentifier;
    }

    public Replica.ModificationIterator acquireModificationIterator(short remoteIdentifier, @NotNull Replica.ModificationNotifier modificationNotifier) {
        return this.modificationDelegator.acquireModificationIterator(remoteIdentifier, modificationNotifier);
    }

    @Override
    public boolean remove(@net.openhft.lang.model.constraints.NotNull Object key, Object value) {
        if (value == null) {
            return false;
        }
        return this.removeIfValueIs(key, value, this.localIdentifier, this.timeProvider.currentTimeMillis()) != null;
    }

    private V removeIfValueIs(Object key, V expectedValue, byte identifier, long timestamp) {
        this.checkKey(key);
        DirectBytes keyBytes = this.getKeyAsBytes(key);
        long hash = AbstractVanillaSharedHashMap.Hasher.hash((Bytes)keyBytes);
        int segmentNum = this.hasher.getSegment(hash);
        int segmentHash = this.hasher.segmentHash(hash);
        return this.segment(segmentNum).remove((Bytes)keyBytes, key, expectedValue, segmentHash, timestamp, identifier);
    }

    @Override
    V replaceIfValueIs(@net.openhft.lang.model.constraints.NotNull K key, V existingValue, V newValue) {
        this.checkKey(key);
        this.checkValue(newValue);
        DirectBytes keyBytes = this.getKeyAsBytes(key);
        long hash = AbstractVanillaSharedHashMap.Hasher.hash((Bytes)keyBytes);
        int segmentNum = this.hasher.getSegment(hash);
        int segmentHash = this.hasher.segmentHash(hash);
        return this.segment(segmentNum).replace((Bytes)keyBytes, key, existingValue, newValue, segmentHash, this.timeProvider.currentTimeMillis());
    }

    public void writeExternalEntry(@NotNull AbstractBytes entry, @NotNull Bytes destination, int chronicleId) {
        long valueLen;
        long initialLimit = entry.limit();
        long keyLen = entry.readStopBit();
        long keyPosition = entry.position();
        entry.skip(keyLen);
        long keyLimit = entry.position();
        long timeStamp = entry.readLong();
        byte identifier = entry.readByte();
        if (identifier != this.localIdentifier) {
            return;
        }
        boolean isDeleted = entry.readBoolean();
        if (!isDeleted) {
            valueLen = entry.readStopBit();
            assert (valueLen > 0L);
        } else {
            valueLen = 0L;
        }
        long valuePosition = entry.position();
        destination.writeStopBit(keyLen);
        destination.writeStopBit(valueLen);
        destination.writeStopBit(timeStamp);
        destination.writeByte((int)(isDeleted ? -identifier : identifier));
        entry.position(keyPosition);
        entry.limit(keyLimit);
        destination.write((RandomDataInput)entry);
        boolean debugEnabled = LOG.isDebugEnabled();
        String message = null;
        if (debugEnabled) {
            if (isDeleted) {
                LOG.debug("WRITING ENTRY TO DEST -  into local-id={}, remove(key={})", (Object)this.localIdentifier, (Object)entry.toString().trim());
            } else {
                message = String.format("WRITING ENTRY TO DEST  -  into local-id=%d, put(key=%s,", this.localIdentifier, entry.toString().trim());
            }
        }
        if (isDeleted) {
            return;
        }
        entry.limit(initialLimit);
        entry.position(valuePosition);
        this.alignment.alignPositionAddr((Bytes)entry);
        entry.limit(entry.position() + valueLen);
        destination.write((RandomDataInput)entry);
        if (debugEnabled) {
            LOG.debug(message + "value=" + entry.toString().trim() + ")");
        }
    }

    public void readExternalEntry(@NotNull Bytes source) {
        byte remoteIdentifier;
        boolean isDeleted;
        long keyLen = source.readStopBit();
        long valueLen = source.readStopBit();
        long timeStamp = source.readStopBit();
        byte id = source.readByte();
        if (id < 0) {
            isDeleted = true;
            remoteIdentifier = -id;
        } else if (id != 0) {
            isDeleted = false;
            remoteIdentifier = id;
        } else {
            throw new IllegalStateException("identifier can't be 0");
        }
        if (remoteIdentifier == this.identifier()) {
            return;
        }
        long keyPosition = source.position();
        long keyLimit = keyPosition + keyLen;
        source.limit(keyLimit);
        long hash = AbstractVanillaSharedHashMap.Hasher.hash(source);
        int segmentNum = this.hasher.getSegment(hash);
        int segmentHash = this.hasher.segmentHash(hash);
        boolean debugEnabled = LOG.isDebugEnabled();
        if (isDeleted) {
            if (debugEnabled) {
                LOG.debug("READING FROM SOURCE -  into local-id={}, remote={}, remove(key={})", new Object[]{this.localIdentifier, remoteIdentifier, source.toString().trim()});
            }
            this.segment(segmentNum).remoteRemove(source, segmentHash, timeStamp, remoteIdentifier);
            this.setLastModificationTime(remoteIdentifier, timeStamp);
            return;
        }
        String message = null;
        if (debugEnabled) {
            message = String.format("READING FROM SOURCE -  into local-id=%d, remote-id=%d, put(key=%s,", this.localIdentifier, remoteIdentifier, source.toString().trim());
        }
        long valuePosition = keyLimit;
        long valueLimit = valuePosition + valueLen;
        this.segment(segmentNum).remotePut(source, segmentHash, remoteIdentifier, timeStamp, valuePosition, valueLimit);
        this.setLastModificationTime(remoteIdentifier, timeStamp);
        if (debugEnabled) {
            source.limit(valueLimit);
            source.position(valuePosition);
            LOG.debug(message + "value=" + source.toString().trim() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K key(@NotNull AbstractBytes entry, K usingKey) {
        long start = entry.position();
        try {
            entry.readStopBit();
            long keyPosition = entry.position();
            if (this.generatedValueType) {
                if (usingKey == null) {
                    usingKey = DataValueClasses.newDirectReference((Class)this.kClass);
                } else assert (usingKey instanceof Byteable);
            }
            if (usingKey instanceof Byteable) {
                ((Byteable)usingKey).bytes((Bytes)entry, keyPosition);
                Object object = usingKey;
                return object;
            }
            Object object = entry.readInstance(this.kClass, usingKey);
            return (K)object;
        }
        finally {
            entry.position(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V value(@NotNull AbstractBytes entry, V usingValue) {
        long start = entry.position();
        try {
            entry.skip(entry.readStopBit());
            entry.readLong();
            byte identifier = entry.readByte();
            if (identifier != this.localIdentifier) {
                V v = null;
                return v;
            }
            boolean isDeleted = entry.readBoolean();
            if (!isDeleted) {
                long valueLen = entry.readStopBit();
                assert (valueLen > 0L);
            } else {
                V v = null;
                return v;
            }
            long valueOffset = entry.position();
            if (this.generatedValueType) {
                if (usingValue == null) {
                    usingValue = DataValueClasses.newDirectReference((Class)this.vClass);
                } else assert (usingValue instanceof Byteable);
            }
            if (usingValue instanceof Byteable) {
                ((Byteable)usingValue).bytes((Bytes)entry, valueOffset);
                Object object = usingValue;
                return object;
            }
            Object object = entry.readInstance(this.vClass, usingValue);
            return (V)object;
        }
        finally {
            entry.position(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasRemoved(@NotNull AbstractBytes entry) {
        long start = entry.position();
        try {
            boolean bl = entry.readBoolean(entry.readStopBit() + 10L);
            return bl;
        }
        finally {
            entry.position(start);
        }
    }

    class ModificationIterator
    extends SharedMapEventListener<K, V, SharedHashMap<K, V>>
    implements Replica.ModificationIterator {
        private final Replica.ModificationNotifier modificationNotifier;
        private final ATSDirectBitSet changes;
        private final int segmentIndexShift;
        private final long posMask;
        private final net.openhft.collections.VanillaSharedReplicatedHashMap$ModificationIterator.EntryModifiableCallback entryModifiableCallback = new EntryModifiableCallback();
        private long position = -1L;

        public ModificationIterator(@NotNull Bytes bytes, Replica.ModificationNotifier modificationNotifier) {
            this.modificationNotifier = modificationNotifier;
            long bitsPerSegment = VanillaSharedReplicatedHashMap.this.bitsPerSegmentInModIterBitSet();
            this.segmentIndexShift = Long.numberOfTrailingZeros(bitsPerSegment);
            this.posMask = bitsPerSegment - 1L;
            this.changes = new ATSDirectBitSet(bytes);
        }

        private long combine(int segmentIndex, long pos) {
            return (long)segmentIndex << this.segmentIndexShift | pos;
        }

        public void onPut(SharedHashMap<K, V> map, Bytes entry, int metaDataBytes, boolean added, K key, V value, long pos, SharedSegment segment) {
            assert (VanillaSharedReplicatedHashMap.this == map) : "ModificationIterator.onPut() is called from outside of the parent map";
            this.changes.set(this.combine(segment.getIndex(), pos));
            this.modificationNotifier.onChange();
        }

        public void onRemove(SharedHashMap<K, V> map, Bytes entry, int metaDataBytes, K key, V value, int pos, SharedSegment segment) {
            assert (VanillaSharedReplicatedHashMap.this == map) : "ModificationIterator.onRemove() is called from outside of the parent map";
            this.changes.set(this.combine(segment.getIndex(), pos));
            this.modificationNotifier.onChange();
        }

        void onRelocation(int pos, SharedSegment segment) {
            this.changes.clear(this.combine(segment.getIndex(), pos));
        }

        public boolean hasNext() {
            long position = this.position;
            return this.changes.nextSetBit(position == -1L ? 0L : position) != -1L || position > 0L && this.changes.nextSetBit(0L) != -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean nextEntry(@NotNull Replica.AbstractEntryCallback entryCallback, int chronicleId) {
            long position = this.position;
            while (true) {
                long oldPosition;
                if ((position = this.changes.nextSetBit((oldPosition = position) + 1L)) == -1L) {
                    if (oldPosition != -1L) continue;
                    this.position = -1L;
                    return false;
                }
                this.position = position;
                Segment segment = VanillaSharedReplicatedHashMap.this.segment((int)(position >>> this.segmentIndexShift));
                segment.lock();
                try {
                    if (!this.changes.clearIfSet(position)) continue;
                    entryCallback.onBeforeEntry();
                    long segmentPos = position & this.posMask;
                    NativeBytes entry = segment.entry(segment.offsetFromPos(segmentPos));
                    boolean success = entryCallback.onEntry((AbstractBytes)entry, chronicleId);
                    entryCallback.onAfterEntry();
                    if (!success) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    segment.unlock();
                    continue;
                }
                break;
            }
        }

        public void dirtyEntries(long fromTimeStamp) {
            for (Segment segment : (Segment[])VanillaSharedReplicatedHashMap.this.segments) {
                segment.dirtyEntries(fromTimeStamp, (EntryModifiableCallback)this.entryModifiableCallback);
            }
        }

        class EntryModifiableCallback {
            EntryModifiableCallback() {
            }

            public void set(int segmentIndex, int pos) {
                long combine = ModificationIterator.this.combine(segmentIndex, pos);
                ModificationIterator.this.changes.set(combine);
            }
        }
    }

    class ModificationDelegator
    extends SharedMapEventListener<K, V, SharedHashMap<K, V>> {
        private final ATSDirectBitSet bitSet;
        private final AtomicReferenceArray<ModificationIterator> modificationIterators = new AtomicReferenceArray(135);
        private final SharedMapEventListener<K, V, SharedHashMap<K, V>> nextListener;
        private long startOfModificationIterators;

        public ModificationDelegator(SharedMapEventListener<K, V, SharedHashMap<K, V>> nextListener, Bytes bytes, long startOfModificationIterators) {
            this.nextListener = nextListener;
            this.startOfModificationIterators = startOfModificationIterators;
            this.bitSet = new ATSDirectBitSet(bytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ModificationIterator acquireModificationIterator(short remoteIdentifier, @NotNull Replica.ModificationNotifier modificationNotifier) {
            ModificationIterator modificationIterator = this.modificationIterators.get(remoteIdentifier);
            if (modificationIterator != null) {
                return modificationIterator;
            }
            AtomicReferenceArray<ModificationIterator> atomicReferenceArray = this.modificationIterators;
            synchronized (atomicReferenceArray) {
                ModificationIterator modificationIterator0 = this.modificationIterators.get(remoteIdentifier);
                if (modificationIterator0 != null) {
                    return modificationIterator0;
                }
                Bytes bytes = VanillaSharedReplicatedHashMap.this.ms.bytes(this.startOfModificationIterators + (long)(VanillaSharedReplicatedHashMap.this.modIterBitSetSizeInBytes() * remoteIdentifier), (long)VanillaSharedReplicatedHashMap.this.modIterBitSetSizeInBytes());
                ModificationIterator newModificationIterator = new ModificationIterator(bytes, modificationNotifier);
                this.modificationIterators.set(remoteIdentifier, newModificationIterator);
                this.bitSet.set((long)remoteIdentifier);
                return newModificationIterator;
            }
        }

        public void onPut(SharedHashMap<K, V> map, Bytes entry, int metaDataBytes, boolean added, K key, V value, long pos, SharedSegment segment) {
            assert (VanillaSharedReplicatedHashMap.this == map) : "ModificationIterator.onPut() is called from outside of the parent map";
            try {
                this.nextListener.onPut(map, entry, metaDataBytes, added, key, value, pos, segment);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            long next = this.bitSet.nextSetBit(0L);
            while (next > 0L) {
                try {
                    ModificationIterator modificationIterator = this.modificationIterators.get((int)next);
                    modificationIterator.onPut(map, entry, metaDataBytes, added, key, value, pos, segment);
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
                next = this.bitSet.nextSetBit(next + 1L);
            }
        }

        public void onRemove(SharedHashMap<K, V> map, Bytes entry, int metaDataBytes, K key, V value, int pos, SharedSegment segment) {
            assert (VanillaSharedReplicatedHashMap.this == map) : "ModificationIterator.onRemove() is called from outside of the parent map";
            try {
                this.nextListener.onRemove(map, entry, metaDataBytes, key, value, pos, segment);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            long next = this.bitSet.nextSetBit(0L);
            while (next > 0L) {
                try {
                    ModificationIterator modificationIterator = this.modificationIterators.get((int)next);
                    modificationIterator.onRemove(map, entry, metaDataBytes, key, value, pos, segment);
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
                next = this.bitSet.nextSetBit(next + 1L);
            }
        }

        public V onGetMissing(SharedHashMap<K, V> map, Bytes keyBytes, K key, V usingValue) {
            return this.nextListener.onGetMissing(map, keyBytes, key, usingValue);
        }

        public void onGetFound(SharedHashMap<K, V> map, Bytes entry, int metaDataBytes, K key, V value) {
            this.nextListener.onGetFound(map, entry, metaDataBytes, key, value);
        }
    }

    class Segment
    extends AbstractVanillaSharedHashMap.Segment {
        private volatile IntIntMultiMap hashLookupLiveAndDeleted;
        private volatile IntIntMultiMap hashLookupLiveOnly;

        Segment(NativeBytes bytes, int index) {
            super(bytes, index);
        }

        @Override
        void createHashLookups(long start) {
            this.hashLookupLiveAndDeleted = this.createMultiMap(start);
            this.hashLookupLiveOnly = this.createMultiMap(start += VanillaSharedReplicatedHashMap.this.sizeOfMultiMap());
        }

        @Override
        public IntIntMultiMap getHashLookup() {
            return this.hashLookupLiveOnly;
        }

        private long entrySize(long keyLen, long valueLen) {
            long result = VanillaSharedReplicatedHashMap.this.alignment.alignAddr((long)(VanillaSharedReplicatedHashMap.this.metaDataBytes + AbstractVanillaSharedHashMap.expectedStopBits(keyLen)) + keyLen + 10L + (long)AbstractVanillaSharedHashMap.expectedStopBits(valueLen)) + valueLen;
            if (result > 65535L) {
                throw new IllegalStateException("ENTRY WRITE_BUFFER_SIZE TOO LARGE : Replicated SharedHashMap's are restricted to an entry size of 65535, your entry size=" + result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V acquire(Bytes keyBytes, K key, V usingValue, int hash2, boolean create, long timestamp) {
            this.lock();
            try {
                MultiStoreBytes entry = this.tmpBytes;
                long offset = this.searchKey(keyBytes, hash2, entry, this.hashLookupLiveOnly);
                if (offset >= 0L) {
                    entry.skip(10L);
                    Object v = this.onKeyPresentOnAcquire(key, usingValue, offset, (NativeBytes)entry);
                    return v;
                }
                if ((usingValue = this.tryObtainUsingValueOnAcquire(keyBytes, key, usingValue, create)) != null) {
                    offset = this.putEntryOnAcquire(keyBytes, hash2, usingValue, create, timestamp);
                    this.incrementSize();
                    this.notifyPut(offset, true, key, usingValue, this.posFromOffset(offset));
                    Object v = usingValue;
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        private long putEntryOnAcquire(Bytes keyBytes, int hash2, V value, boolean usingValue, long timestamp) {
            return this.putEntry(keyBytes, hash2, value, usingValue, VanillaSharedReplicatedHashMap.this.localIdentifier, timestamp, this.hashLookupLiveOnly);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remoteRemove(Bytes keyBytes, int hash2, long timestamp, byte identifier) {
            this.lock();
            try {
                int pos;
                long keyLen = keyBytes.remaining();
                this.hashLookupLiveAndDeleted.startSearch(hash2);
                while ((pos = this.hashLookupLiveAndDeleted.nextPos()) >= 0) {
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyBytes, keyLen, (Bytes)entry)) continue;
                    entry.skip(keyLen);
                    long timeStampPos = entry.position();
                    if (this.shouldIgnore((NativeBytes)entry, timestamp, identifier)) {
                        return;
                    }
                    boolean wasDeleted = entry.readBoolean();
                    if (!wasDeleted) {
                        this.hashLookupLiveOnly.remove(hash2, pos);
                        this.decrementSize();
                    }
                    entry.position(timeStampPos);
                    entry.writeLong(timestamp);
                    assert (identifier > 0);
                    entry.writeByte((int)identifier);
                    entry.writeBoolean(true);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Segment.remoteRemove() : key=" + keyBytes.toString().trim() + " was not " + "found");
                }
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remotePut(@NotNull Bytes inBytes, int hash2, byte identifier, long timestamp, long valuePos, long valueLimit) {
            this.lock();
            try {
                int pos;
                long keyLen = inBytes.remaining();
                this.hashLookupLiveAndDeleted.startSearch(hash2);
                while ((pos = this.hashLookupLiveAndDeleted.nextPos()) >= 0) {
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(inBytes, keyLen, (Bytes)entry)) continue;
                    entry.skip(keyLen);
                    long timeStampPos = entry.positionAddr();
                    if (this.shouldIgnore((NativeBytes)entry, timestamp, identifier)) {
                        return;
                    }
                    boolean wasDeleted = entry.readBoolean();
                    entry.positionAddr(timeStampPos);
                    entry.writeLong(timestamp);
                    assert (identifier > 0);
                    entry.writeByte((int)identifier);
                    entry.writeBoolean(false);
                    long valueLenPos = entry.position();
                    long valueLen = this.readValueLen((Bytes)entry);
                    long entryEndAddr = entry.positionAddr() + valueLen;
                    inBytes.limit(valueLimit);
                    inBytes.position(valuePos);
                    this.putValue(pos, offset, (NativeBytes)entry, valueLenPos, entryEndAddr, inBytes, null, true, this.hashLookupLiveAndDeleted);
                    if (wasDeleted) {
                        this.hashLookupLiveOnly.put(hash2, pos);
                        this.incrementSize();
                    }
                    return;
                }
                long valueLen = valueLimit - valuePos;
                int pos2 = this.alloc(this.inBlocks(this.entrySize(keyLen, valueLen)));
                long offset = this.offsetFromPos(pos2);
                this.clearMetaData(offset);
                MultiStoreBytes entry = this.entry(offset);
                entry.writeStopBit(keyLen);
                entry.write((RandomDataInput)inBytes);
                entry.writeLong(timestamp);
                entry.writeByte((int)identifier);
                entry.writeBoolean(false);
                entry.writeStopBit(valueLen);
                VanillaSharedReplicatedHashMap.this.alignment.alignPositionAddr((Bytes)entry);
                inBytes.limit(valueLimit);
                inBytes.position(valuePos);
                entry.write((RandomDataInput)inBytes);
                this.hashLookupLiveAndDeleted.putAfterFailedSearch(pos2);
                this.hashLookupLiveOnly.put(hash2, pos2);
                this.incrementSize();
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(Bytes keyBytes, K key, V value, int hash2, boolean replaceIfPresent, byte identifier, long timestamp) {
            this.lock();
            try {
                long offset;
                int pos;
                IntIntMultiMap hashLookup = this.hashLookupLiveAndDeleted;
                long keyLen = keyBytes.remaining();
                hashLookup.startSearch(hash2);
                while ((pos = hashLookup.nextPos()) >= 0) {
                    offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyBytes, keyLen, (Bytes)entry)) continue;
                    entry.skip(keyLen);
                    long timeStampPos = entry.positionAddr();
                    if (this.shouldIgnore((NativeBytes)entry, timestamp, identifier)) {
                        Object v = null;
                        return v;
                    }
                    boolean wasDeleted = entry.readBoolean();
                    if (replaceIfPresent || wasDeleted) {
                        entry.positionAddr(timeStampPos);
                        entry.writeLong(timestamp);
                        entry.writeByte((int)identifier);
                        entry.writeBoolean(false);
                        Object prevValue = this.replaceValueOnPut(key, value, (NativeBytes)entry, pos, offset, !wasDeleted && !VanillaSharedReplicatedHashMap.this.putReturnsNull, hashLookup);
                        if (wasDeleted) {
                            this.hashLookupLiveOnly.put(hash2, pos);
                            this.incrementSize();
                            Object v = null;
                            return v;
                        }
                        Object v = prevValue;
                        return v;
                    }
                    Object v = VanillaSharedReplicatedHashMap.this.putReturnsNull ? null : (Object)this.readValue((NativeBytes)entry, null);
                    return v;
                }
                offset = this.putEntry(keyBytes, hash2, value, false, identifier, timestamp, hashLookup);
                this.incrementSize();
                this.notifyPut(offset, true, key, value, this.posFromOffset(offset));
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        private boolean shouldIgnore(@NotNull NativeBytes entry, long timestamp, byte identifier) {
            long lastModifiedTimeStamp = entry.readLong();
            if (lastModifiedTimeStamp < timestamp) {
                entry.skip(1L);
                return false;
            }
            if (lastModifiedTimeStamp > timestamp) {
                return true;
            }
            return entry.readByte() > identifier;
        }

        private long putEntry(Bytes keyBytes, int hash2, V value, boolean usingValue, int identifier, long timestamp, IntIntMultiMap searchedHashLookup) {
            long valueLen;
            long keyLen = keyBytes.remaining();
            boolean byteableValue = usingValue && value instanceof Byteable;
            DirectBytes valueBytes = null;
            Byteable valueAsByteable = null;
            if (!byteableValue) {
                valueBytes = VanillaSharedReplicatedHashMap.this.getValueAsBytes(value);
                valueLen = valueBytes.remaining();
            } else {
                valueAsByteable = (Byteable)value;
                valueLen = valueAsByteable.maxSize();
            }
            long entrySize = this.entrySize(keyLen, valueLen);
            int pos = this.alloc(this.inBlocks(entrySize));
            long offset = this.offsetFromPos(pos);
            this.clearMetaData(offset);
            MultiStoreBytes entry = this.entry(offset);
            entry.writeStopBit(keyLen);
            entry.write((RandomDataInput)keyBytes);
            entry.writeLong(timestamp);
            entry.writeByte(identifier);
            entry.writeBoolean(false);
            this.writeValueOnPutEntry(valueLen, (Bytes)valueBytes, valueAsByteable, (NativeBytes)entry);
            if (searchedHashLookup == this.hashLookupLiveAndDeleted) {
                this.hashLookupLiveAndDeleted.putAfterFailedSearch(pos);
                this.hashLookupLiveOnly.put(hash2, pos);
            } else {
                this.hashLookupLiveOnly.putAfterFailedSearch(pos);
                this.hashLookupLiveAndDeleted.put(hash2, pos);
            }
            return offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V remove(Bytes keyBytes, K key, V expectedValue, int hash2, long timestamp, byte identifier) {
            assert (identifier > 0);
            this.lock();
            try {
                int pos;
                long keyLen = keyBytes.remaining();
                IntIntMultiMap multiMap = this.hashLookupLiveAndDeleted;
                multiMap.startSearch(hash2);
                while ((pos = multiMap.nextPos()) >= 0) {
                    Object valueRemoved;
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyBytes, keyLen, (Bytes)entry)) continue;
                    entry.skip(keyLen);
                    long timeStampPos = entry.position();
                    if (this.shouldIgnore((NativeBytes)entry, timestamp, identifier)) {
                        Object v = null;
                        return v;
                    }
                    boolean wasDeleted = entry.readBoolean();
                    if (wasDeleted) {
                        entry.position(timeStampPos);
                        entry.writeLong(timestamp);
                        entry.writeByte((int)identifier);
                        entry.skip(1L);
                        this.notifyRemoved(offset, key, null, pos);
                        Object v = null;
                        return v;
                    }
                    long valueLen = this.readValueLen((Bytes)entry);
                    Object v = valueRemoved = expectedValue != null || !VanillaSharedReplicatedHashMap.this.removeReturnsNull ? (Object)this.readValue((NativeBytes)entry, null, valueLen) : null;
                    if (expectedValue != null && !expectedValue.equals(valueRemoved)) {
                        Object v2 = null;
                        return v2;
                    }
                    this.hashLookupLiveOnly.remove(hash2, pos);
                    this.decrementSize();
                    entry.position(timeStampPos);
                    entry.writeLong(timestamp);
                    entry.writeByte((int)identifier);
                    entry.writeBoolean(true);
                    this.notifyRemoved(offset, key, valueRemoved, pos);
                    Object v3 = valueRemoved;
                    return v3;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        @Override
        IntIntMultiMap containsKeyHashLookup() {
            return this.hashLookupLiveOnly;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V replace(Bytes keyBytes, K key, V expectedValue, V newValue, int hash2, long timestamp) {
            this.lock();
            try {
                int pos;
                long keyLen = keyBytes.remaining();
                this.hashLookupLiveOnly.startSearch(hash2);
                while ((pos = this.hashLookupLiveOnly.nextPos()) >= 0) {
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyBytes, keyLen, (Bytes)entry)) continue;
                    entry.skip(keyLen);
                    if (this.shouldIgnore((NativeBytes)entry, timestamp, VanillaSharedReplicatedHashMap.this.localIdentifier)) {
                        Object v = null;
                        return v;
                    }
                    entry.skip(1L);
                    Object v = this.onKeyPresentOnReplace(key, expectedValue, newValue, pos, offset, (NativeBytes)entry, this.hashLookupLiveOnly);
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        @Override
        void replacePosInHashLookupOnRelocation(IntIntMultiMap searchedHashLookup, int prevPos, int pos) {
            searchedHashLookup.replacePrevPos(pos);
            int hash = searchedHashLookup.getSearchHash();
            IntIntMultiMap anotherLookup = searchedHashLookup == this.hashLookupLiveAndDeleted ? this.hashLookupLiveOnly : this.hashLookupLiveAndDeleted;
            anotherLookup.replace(hash, prevPos, pos);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dirtyEntries(final long timeStamp, final ModificationIterator.EntryModifiableCallback callback) {
            this.lock();
            try {
                final int index = this.getIndex();
                this.hashLookupLiveAndDeleted.forEach(new IntIntMultiMap.EntryConsumer(){

                    public void accept(int hash, int pos) {
                        MultiStoreBytes entry = Segment.this.entry(Segment.this.offsetFromPos(pos));
                        long keyLen = entry.readStopBit();
                        entry.skip(keyLen);
                        long entryTimestamp = entry.readLong();
                        if (entryTimestamp >= timeStamp && entry.readByte() == VanillaSharedReplicatedHashMap.this.identifier()) {
                            callback.set(index, pos);
                        }
                    }
                });
            }
            finally {
                this.unlock();
            }
        }

        @Override
        void clear() {
            for (Object k : VanillaSharedReplicatedHashMap.this.keySet()) {
                VanillaSharedReplicatedHashMap.this.remove(k);
            }
        }

        @Override
        void visit(IntIntMultiMap.EntryConsumer entryConsumer) {
            this.hashLookupLiveOnly.forEach(entryConsumer);
        }

        @Override
        @Nullable
        public Map.Entry<K, V> getEntry(long pos) {
            long offset = this.offsetFromPos(pos);
            MultiStoreBytes entry = this.entry(offset);
            entry.readStopBit();
            Object key = entry.readInstance(VanillaSharedReplicatedHashMap.this.kClass, null);
            entry.skip(10L);
            Object value = this.readValue((NativeBytes)entry, null);
            return new AbstractVanillaSharedHashMap.WriteThroughEntry(key, value);
        }
    }
}

