/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.joran.spi.DefaultClass;
import java.io.IOException;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.DefaultChronicleLogWriter;
import net.openhft.chronicle.logger.LogAppenderConfig;
import net.openhft.chronicle.logger.logback.AbstractChronicleAppender;

public class ChronicleAppender
extends AbstractChronicleAppender {
    private boolean includeCallerData = true;
    private boolean includeMDC = true;
    private LogAppenderConfig config = new LogAppenderConfig();

    public LogAppenderConfig getChronicleConfig() {
        return this.config;
    }

    @DefaultClass(value=LogAppenderConfig.class)
    public void setChronicleConfig(LogAppenderConfig config) {
        this.config = config;
    }

    @Override
    protected ChronicleLogWriter createWriter() throws IOException {
        return new DefaultChronicleLogWriter(this.config.build(this.getPath(), this.getWireType()));
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean logCallerData) {
        this.includeCallerData = logCallerData;
    }

    public boolean isIncludeMappedDiagnosticContext() {
        return this.includeMDC;
    }

    public void setIncludeMappedDiagnosticContext(boolean logMDC) {
        this.includeMDC = logMDC;
    }

    @Override
    public void doAppend(ILoggingEvent event, ChronicleLogWriter writer) {
        ThrowableProxy tp = (ThrowableProxy)event.getThrowableProxy();
        writer.write(ChronicleAppender.toChronicleLogLevel(event.getLevel()), event.getTimeStamp(), event.getThreadName(), event.getLoggerName(), event.getMessage(), tp != null ? tp.getThrowable() : null, event.getArgumentArray());
    }
}

