/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;

public class UniqueMicroTimeProvider
implements TimeProvider {
    public static final UniqueMicroTimeProvider INSTANCE = new UniqueMicroTimeProvider();
    private final AtomicLong lastIssuedTimeMicros = new AtomicLong();
    private TimeProvider provider = SystemTimeProvider.INSTANCE;

    public UniqueMicroTimeProvider provider(TimeProvider provider) {
        this.provider = provider;
        this.lastIssuedTimeMicros.set(provider.currentTimeMicros());
        return this;
    }

    @Override
    public long currentTimeMillis() {
        long proposedTimeMillis = this.provider.currentTimeMillis();
        while (true) {
            long lastTimeMicros;
            long lastTimeMillis;
            if ((lastTimeMillis = (lastTimeMicros = this.lastIssuedTimeMicros.get()) / 1000L) >= proposedTimeMillis) {
                this.validateMillisecondTimestamp(proposedTimeMillis, lastTimeMillis);
                proposedTimeMillis = lastTimeMillis + 1L;
            }
            if (this.lastIssuedTimeMicros.compareAndSet(lastTimeMicros, proposedTimeMillis * 1000L)) {
                return proposedTimeMillis;
            }
            Jvm.nanoPause();
        }
    }

    @Override
    public long currentTimeMicros() {
        long proposedTimeMicros = this.provider.currentTimeMicros();
        while (true) {
            long lastTimeMicros;
            if ((lastTimeMicros = this.lastIssuedTimeMicros.get()) >= proposedTimeMicros) {
                this.validateMicrosecondTimestamp(proposedTimeMicros, lastTimeMicros);
                proposedTimeMicros = lastTimeMicros + 1L;
            }
            if (this.lastIssuedTimeMicros.compareAndSet(lastTimeMicros, proposedTimeMicros)) {
                return proposedTimeMicros;
            }
            Jvm.nanoPause();
        }
    }

    @Override
    public long currentTimeNanos() {
        long proposedTimeNanos = this.provider.currentTimeNanos();
        long proposedTimeMicros = proposedTimeNanos / 1000L;
        while (true) {
            long lastTimeMicros;
            if ((lastTimeMicros = this.lastIssuedTimeMicros.get()) >= proposedTimeNanos / 1000L) {
                this.validateMicrosecondTimestamp(proposedTimeMicros, lastTimeMicros);
                proposedTimeMicros = lastTimeMicros + 1L;
                proposedTimeNanos = proposedTimeMicros * 1000L;
            }
            if (this.lastIssuedTimeMicros.compareAndSet(lastTimeMicros, proposedTimeMicros)) {
                return proposedTimeNanos;
            }
            Jvm.nanoPause();
        }
    }

    private void validateMillisecondTimestamp(long realTimeMS, long lastTimeMS) {
        assert (lastTimeMS - realTimeMS < 1000L || lastTimeMS - this.provider.currentTimeMillis() < 1000L) : "Exceeding 1,000 calls per second will advance time by more than 1 second.";
    }

    private void validateMicrosecondTimestamp(long realTimeUS, long lastTimeUS) {
        assert (lastTimeUS - realTimeUS < 1000000L || lastTimeUS - this.provider.currentTimeMicros() < 1000000L) : "Exceeding 1 million calls per second will advance time by more than 1 second.";
    }
}

