/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.shutdown;

import java.util.TreeMap;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.shutdown.Hooklet;

public class PriorityHook {
    private static PriorityHook registeredHook;
    private final TreeMap<Hooklet, Hooklet> hookletPool = new TreeMap();
    private Thread shutdownThread;

    private PriorityHook() {
    }

    public static boolean add(int priority, Runnable hook) {
        return PriorityHook.addAndGet(Hooklet.of(priority, hook)).equals(hook);
    }

    public static synchronized <H extends Hooklet> H addAndGet(H hooklet) {
        Hooklet registered;
        if (registeredHook == null) {
            registeredHook = new PriorityHook();
            Runtime.getRuntime().addShutdownHook(registeredHook.shutdownThread());
        }
        if ((registered = (Hooklet)Jvm.uncheckedCast(PriorityHook.registeredHook.hookletPool.get(hooklet))) == null) {
            PriorityHook.registeredHook.hookletPool.put(hooklet, hooklet);
            return hooklet;
        }
        return (H)registered;
    }

    private Thread shutdownThread() {
        if (this.shutdownThread != null) {
            return this.shutdownThread;
        }
        this.shutdownThread = new Thread(registeredHook::onShutdown);
        return this.shutdownThread;
    }

    public static synchronized void clear() {
        if (registeredHook != null) {
            Runtime.getRuntime().removeShutdownHook(registeredHook.shutdownThread());
        }
        registeredHook = null;
    }

    public void onShutdown() {
        for (Hooklet hooklet : this.hookletPool.keySet()) {
            hooklet.onShutdown();
        }
    }

    public static PriorityHook getRegisteredHook() {
        return registeredHook;
    }
}

