/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import java.util.stream.Stream;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.ThreadLocalisedExceptionHandler;
import net.openhft.chronicle.core.util.IgnoresEverything;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedExceptionHandler
implements ExceptionHandler {
    @NotNull
    private final ExceptionHandler[] chain;

    public ChainedExceptionHandler(ExceptionHandler ... chain) {
        ObjectUtils.requireNonNull(chain);
        this.chain = (ExceptionHandler[])Stream.of(chain).filter(e -> !(e instanceof IgnoresEverything)).map(ObjectUtils::requireNonNull).map(ThreadLocalisedExceptionHandler::unwrap).toArray(ExceptionHandler[]::new);
    }

    @Override
    public void on(@NotNull Class<?> clazz, @Nullable String message, @Nullable Throwable thrown) {
        for (ExceptionHandler eh : this.chain) {
            try {
                eh.on(clazz, message, thrown);
            }
            catch (Throwable t) {
                LoggerFactory.getLogger(eh.getClass()).error("Unable to call with message " + message, t);
            }
        }
    }

    @Override
    public void on(@NotNull Logger logger, @Nullable String message, Throwable thrown) {
        for (ExceptionHandler eh : this.chain) {
            try {
                eh.on(logger, message, thrown);
            }
            catch (Throwable t) {
                LoggerFactory.getLogger(eh.getClass()).error("Unable to call with message " + message, t);
            }
        }
    }

    @NotNull
    public ExceptionHandler[] chain() {
        return this.chain;
    }
}

