/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.ServiceLoader;
import net.openhft.chronicle.core.ChronicleInitRunnable;
import net.openhft.chronicle.core.internal.Bootstrap;

public final class ChronicleInit {
    public static final String CHRONICLE_INIT_CLASS = "chronicle.init.runnable";
    public static final String CHRONICLE_POSTINIT_CLASS = "chronicle.postinit.runnable";

    private ChronicleInit() {
    }

    static void init() {
    }

    static void postInit() {
        String initRunnableClass = System.getProperty(CHRONICLE_POSTINIT_CLASS);
        if (initRunnableClass != null && !initRunnableClass.isEmpty()) {
            try {
                Class descendant = (Class)Bootstrap.uncheckedCast(Class.forName(initRunnableClass));
                Runnable chronicleInit = (Runnable)descendant.getConstructor(new Class[0]).newInstance(new Object[0]);
                chronicleInit.run();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            ServiceLoader<ChronicleInitRunnable> runnableLoader = ServiceLoader.load(ChronicleInitRunnable.class);
            for (ChronicleInitRunnable runnable : runnableLoader) {
                try {
                    runnable.postInit();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        String initRunnableClass = System.getProperty(CHRONICLE_INIT_CLASS);
        if (initRunnableClass != null && !initRunnableClass.isEmpty()) {
            try {
                Class descendant = (Class)Bootstrap.uncheckedCast(Class.forName(initRunnableClass));
                Runnable chronicleInit = (Runnable)descendant.getConstructor(new Class[0]).newInstance(new Object[0]);
                chronicleInit.run();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            ServiceLoader<ChronicleInitRunnable> runnableLoader = ServiceLoader.load(ChronicleInitRunnable.class);
            for (Runnable runnable : runnableLoader) {
                try {
                    runnable.run();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

