/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.function.BiConsumer;
import javax.naming.TimeLimitExceededException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;

public interface LicenceCheck {
    public static final String CHRONICLE_LICENSE = "chronicle.license";

    public static void check(String product, Class<?> caller) {
        BiConsumer<Long, String> logLicenceExpiryDetails = (days, owner) -> {
            String message;
            String ownerId = owner == null ? "" : "for " + owner + " ";
            String expires = "The license " + ownerId + "expires";
            String string = message = days <= 1L ? expires + " in 1 day" : expires + " in " + days + " days";
            if (days > 500L) {
                message = expires + " in about " + days / 365L + " years";
            }
            if (days < 30L) {
                Jvm.warn().on(LicenceCheck.class, message + ". At which point, this product will stop working, if you wish to renew this licence please contact sales@chronicle.software");
            } else {
                Jvm.startup().on(LicenceCheck.class, message + ".");
            }
        };
        LicenceCheck.licenceExpiry(product, caller, logLicenceExpiryDetails);
    }

    public static void licenceExpiry(String product, Class<?> caller, BiConsumer<Long, String> licenceExpiryDetails) {
        String key = Jvm.getProperty(CHRONICLE_LICENSE);
        if (key == null || !key.contains(product + '.')) {
            String expiryDateFile = product + ".expiry-date";
            try {
                String source = new String(IOTools.readFile(LicenceCheck.class, expiryDateFile));
                LocalDate expiryDate = LocalDate.parse(source.trim());
                long days = ChronoUnit.DAYS.between(LocalDate.now(), expiryDate);
                if (days < 0L) {
                    throw Jvm.rethrow(new TimeLimitExceededException("Failed to read '" + expiryDateFile));
                }
                licenceExpiryDetails.accept(days, null);
            }
            catch (Throwable t) {
                throw Jvm.rethrow(new TimeLimitExceededException("Failed to read expiry date, from '" + expiryDateFile + "'"));
            }
        } else {
            int start = key.indexOf("expires=") + 8;
            int end = key.indexOf(",", start);
            LocalDate date = LocalDate.parse(key.substring(start, end));
            int start2 = key.indexOf("owner=") + 6;
            int end2 = key.indexOf(",", start2);
            long days = date.toEpochDay() - System.currentTimeMillis() / 86400000L;
            if (days < 0L) {
                throw Jvm.rethrow(new TimeLimitExceededException());
            }
            String owner = key.substring(start2, end2);
            licenceExpiryDetails.accept(days, owner);
        }
    }

    public void licenceCheck();

    public boolean isAvailable();
}

