/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.invariant.ints;

import java.util.Objects;
import java.util.function.IntPredicate;

public enum IntCondition implements IntPredicate
{
    POSITIVE("> 0", value -> value > 0),
    NEGATIVE("< 0", value -> value < 0),
    ZERO("== 0", value -> value == 0),
    NON_POSITIVE("<= 0", value -> value <= 0),
    NON_NEGATIVE(">= 0", value -> value >= 0),
    NON_ZERO("!= 0", value -> value != 0),
    BYTE_CONVERTIBLE(-128, 127),
    SHORT_CONVERTIBLE(Short.MIN_VALUE, Short.MAX_VALUE),
    EVEN_POWER_OF_TWO(" > 0 && bitcount == 1", value -> value > 0 && Integer.bitCount(value) == 1);

    private final String operation;
    private final IntPredicate predicate;

    private IntCondition(String operation, IntPredicate predicate) {
        this.operation = Objects.requireNonNull(operation);
        this.predicate = Objects.requireNonNull(predicate);
    }

    private IntCondition(int fromInclusive, int toInclusive) {
        this.operation = "\u2208 [" + fromInclusive + ", " + toInclusive + "]";
        this.predicate = value -> value >= fromInclusive && value <= toInclusive;
    }

    @Override
    public boolean test(int value) {
        return this.predicate.test(value);
    }

    @Override
    public IntPredicate negate() {
        switch (this) {
            case POSITIVE: {
                return NON_POSITIVE;
            }
            case NEGATIVE: {
                return NON_NEGATIVE;
            }
            case ZERO: {
                return NON_ZERO;
            }
            case NON_POSITIVE: {
                return POSITIVE;
            }
            case NON_NEGATIVE: {
                return NEGATIVE;
            }
            case NON_ZERO: {
                return ZERO;
            }
        }
        return IntPredicate.super.negate();
    }

    public String toString() {
        return this.operation;
    }
}

