/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.invariant.ints;

import java.util.Objects;
import net.openhft.chronicle.core.util.IntTriPredicate;

public enum IntTriCondition implements IntTriPredicate
{
    BETWEEN("\u2208 [fromInclusive, toExclusive), where (fromInclusive, toExclusive) = ", (value, otherFirst, otherSecond) -> value >= otherFirst && value < otherSecond),
    BETWEEN_CLOSED("\u2208 [fromInclusive, toInclusive], where (fromInclusive, toInclusive) = ", (value, otherFirst, otherSecond) -> value >= otherFirst && value <= otherSecond),
    BETWEEN_ZERO_AND_ENSURING("\u2208 [0, index - size ], where (index, size) = ", (value, otherFirst, otherSecond) -> value >= 0 && value <= otherFirst - otherSecond);

    private final String operation;
    private final IntTriPredicate predicate;

    private IntTriCondition(String operation, IntTriPredicate predicate) {
        this.operation = Objects.requireNonNull(operation);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public boolean test(int value, int otherFirst, int otherSecond) {
        return this.predicate.test(value, otherFirst, otherSecond);
    }

    public String toString() {
        return this.operation;
    }
}

