/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.AbstractCloseable;
import sun.misc.Unsafe;

public abstract class UnsafeCloseable
extends AbstractCloseable {
    protected long address;
    protected Unsafe unsafe = null;

    public UnsafeCloseable() {
        this.disableThreadSafetyCheck(true);
    }

    protected void address(long address) {
        this.address = address;
        this.unsafe = UnsafeMemory.UNSAFE;
    }

    @Override
    protected void performClose() throws IllegalStateException {
        this.unsafe = null;
    }

    public long getLong() throws IllegalStateException {
        try {
            return this.unsafe.getLong(this.address);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public void setLong(long value) throws IllegalStateException {
        try {
            this.unsafe.putLong(this.address, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public long getVolatileLong() throws IllegalStateException {
        try {
            return this.unsafe.getLongVolatile(null, this.address);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public void setVolatileLong(long value) throws IllegalStateException {
        try {
            this.unsafe.putLongVolatile(null, this.address, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public long getVolatileLong(long closedLong) {
        if (this.isClosed()) {
            return closedLong;
        }
        try {
            return this.getVolatileLong();
        }
        catch (Exception e) {
            return closedLong;
        }
    }

    public void setOrderedLong(long value) throws IllegalStateException {
        try {
            this.unsafe.putOrderedLong(null, this.address, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public long addLong(long delta) throws IllegalStateException {
        try {
            return this.unsafe.getAndAddLong(null, this.address, delta) + delta;
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public long addAtomicLong(long delta) throws IllegalStateException {
        try {
            return this.addLong(delta);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }

    public boolean compareAndSwapLong(long expected, long value) throws IllegalStateException {
        try {
            return this.unsafe.compareAndSwapLong(null, this.address, expected, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
    }
}

