/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.lang.reflect.Field;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.internal.AbstractBytesStore;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.NoBytesStore;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.cleaner.CleanerServiceLocator;
import net.openhft.chronicle.core.cleaner.spi.ByteBufferCleanerService;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.util.Ints;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.SimpleCleaner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeBytesStore<U>
extends AbstractBytesStore<NativeBytesStore<U>, U> {
    private static final SimpleCleaner NO_DEALLOCATOR = new NoDeallocator();
    private static final long MEMORY_MAPPED_SIZE = 131072L;
    private static final Field BB_ADDRESS;
    private static final Field BB_CAPACITY;
    private static final Field BB_ATT;
    private static final ByteBufferCleanerService CLEANER_SERVICE;
    private final Finalizer finalizer;
    public long address;
    public Memory memory = OS.memory();
    public long maximumLimit;
    protected long limit;
    @Nullable
    private SimpleCleaner cleaner;
    private boolean elastic;
    @Nullable
    private U underlyingObject;

    private NativeBytesStore() {
        this.finalizer = null;
    }

    private NativeBytesStore(@NotNull ByteBuffer bb, boolean elastic) {
        this(bb, elastic, 0x7FFFFFF0);
    }

    @Deprecated
    public NativeBytesStore(@NotNull ByteBuffer bb, boolean elastic, int maximumLimit) {
        this(bb, elastic, (long)maximumLimit);
    }

    public NativeBytesStore(@NotNull ByteBuffer bb, boolean elastic, long maximumLimit) {
        this();
        super.init(bb, elastic);
        this.maximumLimit = elastic ? maximumLimit : Math.min(this.limit, maximumLimit);
    }

    public NativeBytesStore(long address, long limit) {
        this(address, limit, null, false);
    }

    public NativeBytesStore(long address, @NonNegative long limit, @Nullable Runnable deallocator, boolean elastic) {
        this(address, limit, deallocator, elastic, false);
    }

    protected NativeBytesStore(long address, @NonNegative long limit, @Nullable Runnable deallocator, boolean elastic, boolean monitored) {
        super(monitored);
        this.setAddress(address);
        this.limit = limit;
        this.maximumLimit = elastic ? 0x7FFFFFFFFFFFFFF0L : limit;
        this.cleaner = deallocator == null ? null : new SimpleCleaner(deallocator);
        this.underlyingObject = null;
        this.elastic = elastic;
        this.finalizer = this.cleaner == null || !Jvm.isResourceTracing() ? null : new Finalizer();
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> wrap(@NotNull ByteBuffer bb) {
        return new NativeBytesStore<ByteBuffer>(bb, false);
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> follow(@NotNull ByteBuffer bb) {
        NativeBytesStore<ByteBuffer> store = new NativeBytesStore<ByteBuffer>();
        super.init(bb, false);
        store.maximumLimit = store.limit;
        store.cleaner = NO_DEALLOCATOR;
        return store;
    }

    @NotNull
    public static <T> NativeBytesStore<T> uninitialized() {
        return new NativeBytesStore();
    }

    @NotNull
    public static NativeBytesStore<Void> nativeStore(@NonNegative long capacity) throws IllegalArgumentException {
        return NativeBytesStore.of(capacity, true, true);
    }

    @NotNull
    private static NativeBytesStore<Void> of(@NonNegative long capacity, boolean zeroOut, boolean elastic) throws IllegalArgumentException {
        if (capacity <= 0L) {
            return new NativeBytesStore<Void>(NoBytesStore.NO_PAGE, 0L, null, elastic);
        }
        Memory memory = OS.memory();
        long address = memory.allocate(capacity);
        if (zeroOut || capacity < 131072L) {
            memory.setMemory(address, capacity, (byte)0);
            memory.storeFence();
        }
        @NotNull Deallocator deallocator = new Deallocator(address, capacity);
        return new NativeBytesStore<Void>(address, capacity, deallocator, elastic);
    }

    @NotNull
    public static NativeBytesStore<Void> nativeStoreWithFixedCapacity(@NonNegative long capacity) throws IllegalArgumentException {
        return NativeBytesStore.of(capacity, true, false);
    }

    @NotNull
    public static NativeBytesStore<Void> lazyNativeBytesStoreWithFixedCapacity(@NonNegative long capacity) throws IllegalArgumentException {
        return NativeBytesStore.of(capacity, false, false);
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> elasticByteBuffer() {
        return NativeBytesStore.elasticByteBuffer(OS.pageSize(), 0x7FFFFFFFFFFFFFF0L);
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> elasticByteBuffer(@NonNegative int size, @NonNegative long maxSize) {
        if (maxSize > 0x7FFFFFF0L) {
            Jvm.warn().on(NativeBytesStore.class, "maxSize " + maxSize + " exceeds " + 0x7FFFFFF0 + ", capping to " + 0x7FFFFFF0);
            maxSize = 0x7FFFFFF0L;
        }
        return new NativeBytesStore<ByteBuffer>(ByteBuffer.allocateDirect(size), true, maxSize);
    }

    @NotNull
    public static NativeBytesStore from(@NotNull String text) {
        return NativeBytesStore.from(text.getBytes(StandardCharsets.ISO_8859_1));
    }

    @NotNull
    public static NativeBytesStore from(byte[] bytes) {
        @NotNull NativeBytesStore<Void> nbs = NativeBytesStore.nativeStoreWithFixedCapacity(bytes.length);
        nbs.write(0L, bytes);
        return nbs;
    }

    @Override
    public boolean isDirectMemory() {
        return true;
    }

    @Override
    public boolean canReadDirect(@NonNegative long length) {
        return this.limit >= length;
    }

    private void init(@NotNull ByteBuffer bb, boolean elastic) {
        this.elastic = elastic;
        this.underlyingObject = Jvm.uncheckedCast((Object)bb);
        bb.order(ByteOrder.nativeOrder());
        this.setAddress(Jvm.address((ByteBuffer)bb));
        this.limit = bb.capacity();
    }

    @Override
    public void move(@NonNegative long from, @NonNegative long to, @NonNegative long length) throws BufferUnderflowException, ClosedIllegalStateException {
        if (from < 0L || to < 0L) {
            throw new IllegalArgumentException();
        }
        long addr = this.address;
        if (addr == 0L) {
            this.throwException(null);
        }
        this.memoryCopyMemory(addr + from, addr + to, length);
    }

    private void memoryCopyMemory(long fromAddress, long toAddress, @NonNegative long length) throws ClosedIllegalStateException {
        if (length < 0L) {
            throw new IllegalArgumentException();
        }
        try {
            this.memory.copyMemory(fromAddress, toAddress, length);
        }
        catch (NullPointerException ifReleased) {
            this.throwException(ifReleased);
        }
    }

    private void throwException(Throwable ifReleased) throws ClosedIllegalStateException {
        this.throwExceptionIfReleased();
        throw new ClosedIllegalStateException("Closed", ifReleased);
    }

    @Override
    @NotNull
    public BytesStore<NativeBytesStore<U>, U> copy() throws ClosedIllegalStateException {
        if (this.underlyingObject == null) {
            @NotNull NativeBytesStore<Void> copy = NativeBytesStore.of(this.realCapacity(), false, true);
            this.memoryCopyMemory(this.address, copy.address, this.capacity());
            return (BytesStore)Jvm.uncheckedCast(copy);
        }
        if (this.underlyingObject instanceof ByteBuffer) {
            ByteBuffer bb = ByteBuffer.allocateDirect(Maths.toInt32((long)this.capacity()));
            bb.put((ByteBuffer)this.underlyingObject);
            bb.clear();
            return (BytesStore)Jvm.uncheckedCast(NativeBytesStore.wrap(bb));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public VanillaBytes<U> bytesForWrite() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.elastic ? NativeBytes.wrapWithNativeBytes(this, this.capacity()) : new NativeBytes(this);
    }

    @Override
    @NonNegative
    public long realCapacity() {
        return this.limit;
    }

    @Override
    @NonNegative
    public long capacity() {
        return this.maximumLimit;
    }

    @Override
    @Nullable
    public U underlyingObject() {
        return this.underlyingObject;
    }

    @Override
    @NotNull
    public NativeBytesStore<U> zeroOut(@NonNegative long start, @NonNegative long end) {
        long i;
        long size;
        if (end <= start) {
            return this;
        }
        if (start < this.start()) {
            start = this.start();
        }
        if (end > this.capacity()) {
            end = this.capacity();
        }
        long addr = this.address + this.translate(start);
        for (size = end - start; (addr & 7L) != 0L && size > 0L; --size) {
            this.memory.writeByte(addr, (byte)0);
            ++addr;
        }
        for (i = 0L; i < size - 7L; i += 8L) {
            if (this.memory.readLong(addr + i) == 0L) continue;
            this.memory.writeLong(addr + i, 0L);
        }
        while (i < size) {
            this.memory.writeByte(addr + i, (byte)0);
            ++i;
        }
        return this;
    }

    @Override
    public boolean compareAndSwapInt(@NonNegative long offset, int expected, int value) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.memory.compareAndSwapInt(this.address + this.translate(offset), expected, value);
    }

    @Override
    public void testAndSetInt(@NonNegative long offset, int expected, int value) throws ClosedIllegalStateException {
        this.memory.testAndSetInt(this.address + this.translate(offset), offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(@NonNegative long offset, long expected, long value) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.memory.compareAndSwapLong(this.address + this.translate(offset), expected, value);
    }

    public long translate(@NonNegative long offset) {
        return offset;
    }

    @Override
    public byte readByte(@NonNegative long offset) {
        return this.memory.readByte(this.address + this.translate(offset));
    }

    @Override
    public int readUnsignedByte(@NonNegative long offset) throws BufferUnderflowException {
        return this.readByte(offset) & 0xFF;
    }

    @Override
    public short readShort(@NonNegative long offset) {
        return this.memory.readShort(this.address + this.translate(offset));
    }

    @Override
    public int readInt(@NonNegative long offset) {
        return this.memory.readInt(this.address + this.translate(offset));
    }

    @Override
    public long readLong(@NonNegative long offset) {
        long addr = this.address;
        assert (addr != 0L);
        return this.memory.readLong(addr + this.translate(offset));
    }

    @Override
    public float readFloat(@NonNegative long offset) {
        return this.memory.readFloat(this.address + this.translate(offset));
    }

    @Override
    public double readDouble(@NonNegative long offset) {
        return this.memory.readDouble(this.address + this.translate(offset));
    }

    @Override
    public byte readVolatileByte(@NonNegative long offset) {
        return this.memory.readVolatileByte(this.address + this.translate(offset));
    }

    @Override
    public short readVolatileShort(@NonNegative long offset) {
        return this.memory.readVolatileShort(this.address + this.translate(offset));
    }

    @Override
    public int readVolatileInt(@NonNegative long offset) {
        return this.memory.readVolatileInt(this.address + this.translate(offset));
    }

    @Override
    public long readVolatileLong(@NonNegative long offset) {
        return this.memory.readVolatileLong(this.address + this.translate(offset));
    }

    @Override
    @NotNull
    public NativeBytesStore<U> writeByte(@NonNegative long offset, byte i8) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.memory.writeByte(this.address + this.translate(offset), i8);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<U> writeShort(@NonNegative long offset, short i16) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.memory.writeShort(this.address + this.translate(offset), i16);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<U> writeInt(@NonNegative long offset, int i32) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        try {
            this.memory.writeInt(this.address + this.translate(offset), i32);
            return this;
        }
        catch (NullPointerException e) {
            this.throwExceptionIfReleased();
            throw e;
        }
    }

    @Override
    @NotNull
    public NativeBytesStore<U> writeOrderedInt(@NonNegative long offset, int i) {
        this.memory.writeOrderedInt(this.address + this.translate(offset), i);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<U> writeLong(@NonNegative long offset, long i64) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.memory.writeLong(this.address + this.translate(offset), i64);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<U> writeOrderedLong(@NonNegative long offset, long i) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.memory.writeOrderedLong(this.address + this.translate(offset), i);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<U> writeFloat(@NonNegative long offset, float f) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.memory.writeFloat(this.address + this.translate(offset), f);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<U> writeDouble(@NonNegative long offset, double d) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.memory.writeDouble(this.address + this.translate(offset), d);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<U> writeVolatileByte(@NonNegative long offset, byte i8) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.memory.writeVolatileByte(this.address + this.translate(offset), i8);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<U> writeVolatileShort(@NonNegative long offset, short i16) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.memory.writeVolatileShort(this.address + this.translate(offset), i16);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<U> writeVolatileInt(@NonNegative long offset, int i32) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.memory.writeVolatileInt(this.address + this.translate(offset), i32);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<U> writeVolatileLong(@NonNegative long offset, long i64) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.memory.writeVolatileLong(this.address + this.translate(offset), i64);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<U> write(@NonNegative long offsetInRDO, byte[] byteArray, @NonNegative int offset, @NonNegative int length) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        Longs.requireNonNegative((long)offsetInRDO);
        ObjectUtils.requireNonNull((Object)byteArray);
        Longs.requireNonNegative((long)offset);
        Longs.requireNonNegative((long)length);
        this.memory.copyMemory(byteArray, offset, this.address + this.translate(offsetInRDO), length);
        return this;
    }

    @Override
    public void write(@NonNegative long offsetInRDO, @NotNull ByteBuffer bytes, @NonNegative int offset, @NonNegative int length) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        if (bytes.isDirect()) {
            this.memoryCopyMemory(Jvm.address((ByteBuffer)bytes) + (long)offset, this.address + this.translate(offsetInRDO), length);
        } else {
            this.memory.copyMemory(bytes.array(), offset, this.address + this.translate(offsetInRDO), length);
        }
    }

    @Override
    @NotNull
    public NativeBytesStore<U> write(@NonNegative long writeOffset, @NotNull RandomDataInput bytes, @NonNegative long readOffset, @NonNegative long length) throws BufferOverflowException, BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        Longs.requireNonNegative((long)writeOffset);
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative((long)readOffset);
        Longs.requireNonNegative((long)length);
        this.throwExceptionIfReleased();
        if (bytes.isDirectMemory()) {
            this.memoryCopyMemory(bytes.addressForRead(readOffset), this.addressForWrite(writeOffset), length);
        } else {
            this.write0(writeOffset, bytes, readOffset, length);
        }
        return this;
    }

    public void write0(@NonNegative long offsetInRDO, @NotNull RandomDataInput bytes, @NonNegative long offset, @NonNegative long length) throws BufferUnderflowException, ClosedIllegalStateException {
        long i;
        for (i = 0L; i < length - 7L; i += 8L) {
            this.writeLong(offsetInRDO + i, bytes.readLong(offset + i));
        }
        while (i < length) {
            this.writeByte(offsetInRDO + i, bytes.readByte(offset + i));
            ++i;
        }
    }

    @Override
    public long addressForRead(@NonNegative long offset) throws BufferUnderflowException {
        if (offset < this.start() || offset > this.realCapacity()) {
            if (offset < 0L) {
                throw new IllegalArgumentException();
            }
            throw new BufferUnderflowException();
        }
        return this.address + this.translate(offset);
    }

    @Override
    public long addressForWrite(@NonNegative long offset) throws BufferOverflowException {
        if (offset < this.start() || offset > this.realCapacity()) {
            if (offset < 0L) {
                throw new IllegalArgumentException();
            }
            throw new BufferOverflowException();
        }
        return this.address + this.translate(offset);
    }

    @Override
    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException {
        return this.addressForWrite(this.start());
    }

    protected void backgroundPerformRelease() {
        this.memory = null;
        super.backgroundPerformRelease();
    }

    protected void performRelease() {
        ByteBuffer underlying;
        this.memory = null;
        if (this.cleaner != null) {
            this.cleaner.clean();
        } else if (this.underlyingObject instanceof ByteBuffer && (underlying = (ByteBuffer)this.underlyingObject).isDirect()) {
            CLEANER_SERVICE.clean(underlying);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return BytesInternal.toString(this);
    }

    @Override
    public void nativeRead(@NonNegative long position, long address, @NonNegative long size) throws BufferUnderflowException, ClosedIllegalStateException {
        this.memoryCopyMemory(this.addressForRead(position), address, size);
    }

    @Override
    public void nativeWrite(long address, @NonNegative long position, @NonNegative long size) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.memoryCopyMemory(address, this.addressForWrite(position), size);
    }

    void write8bit(@NonNegative long position, char[] chars, @NonNegative int offset, @NonNegative int length) throws ClosedIllegalStateException {
        long addr = this.address + this.translate(position);
        @Nullable Memory mem = this.memory;
        for (int i = 0; i < length; ++i) {
            mem.writeByte(addr + (long)i, (byte)chars[offset + i]);
        }
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull BytesStore<?, ?> bs) {
        Longs.requireNonNegative((long)position);
        long length = bs.readRemaining();
        long addressForWrite = this.addressForWrite(position);
        addressForWrite = BytesUtil.writeStopBit(addressForWrite, length);
        if (bs.isDirectMemory()) {
            this.copy8bit(bs.addressForRead(bs.readPosition()), addressForWrite, length);
        } else {
            Object o = bs.underlyingObject();
            if (o instanceof byte[]) {
                this.copy8bit((byte[])o, bs.readPosition(), addressForWrite, length);
            } else {
                BytesUtil.copy8bit(bs, addressForWrite, length);
            }
        }
        return addressForWrite + length;
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull String s, @NonNegative int start, @NonNegative int length) throws ClosedIllegalStateException {
        Longs.requireNonNegative((long)position);
        ObjectUtils.requireNonNull((Object)s);
        Ints.requireNonNegative((int)start);
        Ints.requireNonNegative((int)length);
        position = BytesUtil.writeStopBit(this, position, length);
        UnsafeMemory.MEMORY.copy8bit(s, start, length, this.addressForWrite(position));
        return position + (long)length;
    }

    private void copy8bit(byte[] arr, @NonNegative long readPosition, long addressForWrite, @NonNegative long readRemaining) {
        ObjectUtils.requireNonNull((Object)arr);
        int readOffset = Math.toIntExact(readPosition);
        int length = Math.toIntExact(readRemaining);
        UnsafeMemory.MEMORY.copyMemory(arr, readOffset, addressForWrite, length);
    }

    private void copy8bit(long addressForRead, long addressForWrite, @NonNegative long length) {
        OS.memory().copyMemory(addressForRead, addressForWrite, length);
    }

    public void read8bit(@NonNegative long position, char[] chars, @NonNegative int length) {
        long addr = this.address + this.translate(position);
        Memory mem = this.memory;
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(mem.readByte(addr + (long)i) & 0xFF);
        }
    }

    @Override
    public long readIncompleteLong(@NonNegative long offset) {
        int remaining = (int)Math.min(8L, this.readRemaining() - offset);
        long l = 0L;
        for (int i = 0; i < remaining; ++i) {
            byte b = this.memory.readByte(this.address + offset + (long)i);
            l |= (long)(b & 0xFF) << i * 8;
        }
        return l;
    }

    public void setAddress(long address) {
        if ((address & 0xFFFFFFFFFFFFC000L) == 0L) {
            throw new AssertionError((Object)("Invalid addressForRead " + Long.toHexString(address)));
        }
        this.address = address;
    }

    public long appendUtf8(@NonNegative long pos, char[] chars, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        int i;
        block6: {
            ObjectUtils.requireNonNull((Object)chars);
            if (pos + (long)length > this.realCapacity()) {
                throw new BufferOverflowException();
            }
            long addr = this.address + this.translate(0L);
            @Nullable Memory mem = this.memory;
            if (mem == null) {
                throw new NullPointerException();
            }
            for (i = 0; i < length - 3; i += 4) {
                int i2 = offset + i;
                char c0 = chars[i2];
                char c1 = chars[i2 + 1];
                char c2 = chars[i2 + 2];
                char c3 = chars[i2 + 3];
                if ((c0 | c1 | c2 | c3) <= 127) {
                    int value = c0 | c1 << 8 | c2 << 16 | c3 << 24;
                    UnsafeMemory.unsafePutInt((long)(addr + pos), (int)value);
                    pos += 4L;
                    continue;
                }
                break block6;
            }
            while (i < length) {
                char c = chars[offset + i];
                if (c <= '\u007f') {
                    UnsafeMemory.unsafePutByte((long)(addr + pos++), (byte)((byte)c));
                    ++i;
                    continue;
                }
                break block6;
            }
            return pos;
        }
        return this.appendUtf8a(pos, chars, offset, length, i);
    }

    private long appendUtf8a(@NonNegative long pos, char[] chars, @NonNegative int offset, @NonNegative int length, int i) throws ClosedIllegalStateException {
        while (i < length) {
            char c = chars[offset + i];
            if (c <= '\u007f') {
                this.writeByte(pos++, (byte)c);
            } else if (c <= '\u07ff') {
                this.writeByte(pos++, (byte)(0xC0 | c >> 6 & 0x1F));
                this.writeByte(pos++, (byte)(0x80 | c & 0x3F));
            } else {
                this.writeByte(pos++, (byte)(0xE0 | c >> 12 & 0xF));
                this.writeByte(pos++, (byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte(pos++, (byte)(0x80 | c & 0x3F));
            }
            ++i;
        }
        return pos;
    }

    @Override
    public long copyTo(@NotNull BytesStore<?, ?> store) throws ClosedIllegalStateException {
        if (store.isDirectMemory()) {
            return this.copyToDirect(store);
        }
        return super.copyTo(store);
    }

    public long copyToDirect(@NotNull BytesStore<?, ?> store) throws ClosedIllegalStateException {
        long toCopy = Math.min(this.limit, store.safeLimit());
        if (toCopy > 0L) {
            long addr = this.address;
            long addr2 = store.addressForWrite(0L);
            this.memoryCopyMemory(addr, addr2, toCopy);
        }
        return toCopy;
    }

    @Override
    @NotNull
    public ByteBuffer toTemporaryDirectByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocateDirect(0);
        try {
            BB_ADDRESS.setLong(bb, this.address);
            BB_CAPACITY.setInt(bb, Maths.toUInt31((long)this.readRemaining()));
            BB_ATT.set(bb, this);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        bb.clear();
        return bb;
    }

    @Override
    public int byteCheckSum() throws IORuntimeException {
        return this.byteCheckSum(this.start(), this.readLimit());
    }

    @Override
    public int byteCheckSum(@NonNegative long position, @NonNegative long limit) {
        long ptr;
        @Nullable Memory mem = this.memory;
        assert (mem != null);
        int b = 0;
        long end = this.address + limit;
        for (ptr = this.address + position; ptr < end - 7L; ptr += 8L) {
            b += mem.readByte(ptr) + mem.readByte(ptr + 1L) + mem.readByte(ptr + 2L) + mem.readByte(ptr + 3L) + mem.readByte(ptr + 4L) + mem.readByte(ptr + 5L) + mem.readByte(ptr + 6L) + mem.readByte(ptr + 7L);
        }
        while (ptr < end) {
            b += mem.readByte(ptr);
            ++ptr;
        }
        return b & 0xFF;
    }

    @Override
    public boolean sharedMemory() {
        return false;
    }

    @Override
    public long read(@NonNegative long offsetInRDI, byte[] bytes, @NonNegative int offset, @NonNegative int length) {
        ObjectUtils.requireNonNull((Object)bytes);
        int len = Maths.toUInt31((long)Math.min((long)length, Longs.requireNonNegative((long)(this.readLimit() - offsetInRDI))));
        this.memory.readBytes(this.address + this.translate(offsetInRDI), bytes, (long)offset, len);
        return len;
    }

    @Override
    public int peekUnsignedByte(@NonNegative long offset) {
        long addr = this.address;
        @Nullable Memory mem = this.memory;
        long translate = this.translate(offset);
        long address2 = addr + translate;
        return translate < this.start() || this.limit <= translate ? -1 : mem.readByte(address2) & 0xFF;
    }

    @Override
    public int fastHash(@NonNegative long offset, @NonNegative int length) throws BufferUnderflowException, ClosedIllegalStateException {
        long ret;
        switch (length) {
            case 0: {
                return 0;
            }
            case 1: {
                ret = this.readByte(offset);
                break;
            }
            case 2: {
                ret = this.readShort(offset);
                break;
            }
            case 4: {
                ret = this.readInt(offset);
                break;
            }
            case 8: {
                ret = (long)this.readInt(offset) * 1829709757L + (long)this.readInt(offset + 4L);
                break;
            }
            default: {
                return super.fastHash(offset, length);
            }
        }
        long hash = ret * -2057448229L;
        return (int)(hash ^ hash >> 32);
    }

    @Override
    public long safeLimit() {
        return this.limit;
    }

    @Override
    public boolean isEqual(@NonNegative long start, @NonNegative long length, String s) {
        if (s == null || (long)s.length() != length) {
            return false;
        }
        return UnsafeMemory.MEMORY.isEqual(this.addressForRead(start), s, (int)length);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public long appendAndReturnLength(long writePosition, boolean negative, long mantissa, int exponent, boolean append0) {
        if (writePosition + (long)BytesInternal.digitsForExponent(exponent) > this.capacity()) {
            throw new IllegalArgumentException();
        }
        this.throwExceptionIfReleased();
        try {
            long start;
            long addr = start = this.address + this.translate(writePosition);
            if (exponent <= 0) {
                if (append0) {
                    this.memory.writeByte(addr++, (byte)48);
                    this.memory.writeByte(addr++, (byte)46);
                }
                while (exponent++ < 0) {
                    this.memory.writeByte(addr++, (byte)48);
                }
                exponent = -1;
            }
            do {
                long base = mantissa % 10L;
                mantissa /= 10L;
                this.memory.writeByte(addr++, (byte)(48L + base));
                if (--exponent != 0) continue;
                this.memory.writeByte(addr++, (byte)46);
            } while (mantissa > 0L || exponent >= 0);
            if (negative) {
                this.memory.writeByte(addr++, (byte)45);
            }
            this.reverseBytesFrom(start, addr);
            return addr - start;
        }
        catch (NullPointerException npe) {
            this.throwExceptionIfReleased();
            throw npe;
        }
    }

    protected void reverseBytesFrom(long start, long end) {
        while (end > start) {
            byte b1 = this.memory.readByte(start);
            byte b2 = this.memory.readByte(--end);
            this.memory.writeByte(start, b2);
            this.memory.writeByte(end, b1);
            ++start;
        }
    }

    static {
        CLEANER_SERVICE = CleanerServiceLocator.cleanerService();
        Class<?> directBB = ByteBuffer.allocateDirect(0).getClass();
        Field address = null;
        Field capacity = null;
        Field att = null;
        try {
            address = Jvm.getField(directBB, (String)"address");
            capacity = Jvm.getField(directBB, (String)"capacity");
            att = Jvm.getField(directBB, (String)"att");
        }
        catch (Throwable t) {
            Jvm.warn().on(NativeBytesStore.class, "Unable to access ByteBuffer fields", t);
        }
        BB_ADDRESS = address;
        BB_CAPACITY = capacity;
        BB_ATT = att;
    }

    private static final class NoDeallocator
    extends SimpleCleaner {
        private NoDeallocator() {
            super(null);
        }

        public void clean() {
        }
    }

    private final class Finalizer {
        private Finalizer() {
        }

        protected void finalize() throws Throwable {
            super.finalize();
            NativeBytesStore.this.warnAndReleaseIfNotReleased();
        }
    }

    static final class Deallocator
    implements Runnable {
        private final long size;
        private volatile long address;

        Deallocator(long address, @NonNegative long size) {
            assert (address != 0L);
            this.address = address;
            this.size = size;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            long addressToFree = this.address;
            this.address = 0L;
            OS.memory().freeMemory(addressToFree, this.size);
        }
    }
}

