/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.bytes.UncheckedBytes;
import net.openhft.chronicle.bytes.UncheckedNativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.EmbeddedBytes;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.annotation.SingleThreaded;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.SingleThreadedChecked;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.io.ValidatableUtil;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SingleThreaded
public interface Bytes<U>
extends BytesStore<Bytes<U>, U>,
BytesIn<U>,
BytesOut<U>,
SingleThreadedChecked {
    public static final long MAX_CAPACITY = 0x7FFFFFFFFFFFFFF0L;
    public static final int MAX_HEAP_CAPACITY = 0x7FFFFFF0;
    public static final int DEFAULT_BYTE_BUFFER_CAPACITY = 256;

    @NotNull
    public static Bytes<ByteBuffer> elasticByteBuffer() {
        return Bytes.elasticByteBuffer(256);
    }

    @NotNull
    public static Bytes<ByteBuffer> elasticByteBuffer(@NonNegative int initialCapacity) {
        return Bytes.elasticByteBuffer(initialCapacity, 0x7FFFFFF0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Bytes<ByteBuffer> elasticByteBuffer(@NonNegative int initialCapacity, @NonNegative int maxCapacity) {
        Longs.requireNonNegative((long)initialCapacity);
        Longs.requireNonNegative((long)maxCapacity);
        @NotNull BytesStore<?, ByteBuffer> bs = BytesStore.elasticByteBuffer(initialCapacity, maxCapacity);
        try {
            Bytes<ByteBuffer> bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release(ReferenceOwner.INIT);
        }
    }

    @NotNull
    public static Bytes<ByteBuffer> elasticHeapByteBuffer(@NonNegative int initialCapacity) {
        Longs.requireNonNegative((long)initialCapacity);
        @NotNull BytesStore<?, ByteBuffer> bs = BytesStore.wrap(ByteBuffer.allocate(initialCapacity));
        try {
            NativeBytes<ByteBuffer> nativeBytes = NativeBytes.wrapWithNativeBytes(bs, 0x7FFFFFF0L);
            return nativeBytes;
        }
        finally {
            bs.release(INIT);
        }
    }

    @NotNull
    public static Bytes<ByteBuffer> elasticHeapByteBuffer() {
        return Bytes.elasticHeapByteBuffer(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Bytes<T> forFieldGroup(@NotNull T object, @NotNull String groupName) {
        ObjectUtils.requireNonNull(object);
        ObjectUtils.requireNonNull((Object)groupName);
        @NotNull BytesStore<?, T> bs = BytesStore.forFields(object, groupName, 1);
        try {
            EmbeddedBytes bytes = EmbeddedBytes.wrap(bs);
            StreamingDataOutput streamingDataOutput = bytes.writeLimit(bs.writeLimit());
            return streamingDataOutput;
        }
        finally {
            bs.release(INIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Bytes<ByteBuffer> wrapForRead(@NotNull ByteBuffer byteBuffer) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull((Object)byteBuffer);
        BytesStore<?, ByteBuffer> bs = BytesStore.wrap(byteBuffer);
        try {
            Bytes<ByteBuffer> bytesForRead = bs.bytesForRead();
            bytesForRead.readLimit(byteBuffer.limit());
            bytesForRead.readPosition(byteBuffer.position());
            Bytes<ByteBuffer> bytes = bytesForRead;
            return bytes;
        }
        finally {
            bs.release(INIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Bytes<ByteBuffer> wrapForWrite(@NotNull ByteBuffer byteBuffer) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull((Object)byteBuffer);
        BytesStore<?, ByteBuffer> bs = BytesStore.wrap(byteBuffer);
        try {
            Bytes<ByteBuffer> bytesForWrite = bs.bytesForWrite();
            bytesForWrite.writePosition(byteBuffer.position());
            bytesForWrite.writeLimit(byteBuffer.limit());
            Bytes<ByteBuffer> bytes = bytesForWrite;
            return bytes;
        }
        finally {
            bs.release(INIT);
        }
    }

    @NotNull
    public static Bytes<byte[]> wrapForRead(byte[] byteArray) {
        ObjectUtils.requireNonNull((Object)byteArray);
        @NotNull BytesStore<?, byte[]> bs = BytesStore.wrap(byteArray);
        try {
            Bytes<byte[]> bytes = bs.bytesForRead();
            return bytes;
        }
        finally {
            bs.release(INIT);
        }
    }

    @NotNull
    public static Bytes<byte[]> wrapForWrite(byte[] byteArray) {
        ObjectUtils.requireNonNull((Object)byteArray);
        BytesStore<?, byte[]> bs = BytesStore.wrap(byteArray);
        try {
            Bytes<byte[]> bytes = bs.bytesForWrite();
            return bytes;
        }
        finally {
            bs.release(INIT);
        }
    }

    @NotNull
    public static Bytes<byte[]> from(@NotNull CharSequence text) {
        ObjectUtils.requireNonNull((Object)text);
        return Bytes.from(text.toString());
    }

    public static Bytes<Void> fromDirect(@NotNull CharSequence text) {
        ObjectUtils.requireNonNull((Object)text);
        return (Bytes)NativeBytes.nativeBytes(text.length()).append(text);
    }

    @NotNull
    public static Bytes<byte[]> directFrom(@NotNull String text) {
        BytesStore<?, byte[]> from = BytesStore.from(text);
        try {
            Bytes<byte[]> bytes = from.bytesForRead();
            return bytes;
        }
        finally {
            from.release(INIT);
        }
    }

    @NotNull
    public static Bytes<byte[]> from(@NotNull String text) {
        return Bytes.wrapForRead(text.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static Bytes<?> empty() {
        return BytesStore.empty().bytesForRead();
    }

    @UsedViaReflection
    public static Bytes<byte[]> valueOf(String text) {
        return Bytes.from(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VanillaBytes<Void> allocateDirect(@NonNegative long capacity) throws IllegalArgumentException {
        @NotNull BytesStore<?, Void> bs = BytesStore.nativeStoreWithFixedCapacity(Longs.requireNonNegative((long)capacity));
        try {
            NativeBytes<Void> nativeBytes = new NativeBytes<Void>(bs);
            return nativeBytes;
        }
        finally {
            bs.release(INIT);
        }
    }

    @NotNull
    public static NativeBytes<Void> allocateElasticDirect() {
        return NativeBytes.nativeBytes();
    }

    @NotNull
    public static NativeBytes<Void> allocateElasticDirect(@NonNegative long initialCapacity) throws IllegalArgumentException {
        return NativeBytes.nativeBytes(Longs.requireNonNegative((long)initialCapacity));
    }

    @NotNull
    public static OnHeapBytes allocateElasticOnHeap() {
        return Bytes.allocateElasticOnHeap(32);
    }

    public static Bytes<?> allocateElastic() {
        return Jvm.maxDirectMemory() == 0L ? Bytes.allocateElasticOnHeap() : Bytes.allocateElasticDirect();
    }

    @NotNull
    public static OnHeapBytes allocateElasticOnHeap(@NonNegative int initialCapacity) {
        Longs.requireNonNegative((long)initialCapacity);
        BytesStore<?, byte[]> wrap = BytesStore.wrap(new byte[initialCapacity]);
        try {
            OnHeapBytes onHeapBytes = new OnHeapBytes(wrap, true);
            return onHeapBytes;
        }
        finally {
            wrap.release(INIT);
        }
    }

    public static Bytes<?> allocateElastic(@NonNegative int initialCapacity) {
        return Jvm.maxDirectMemory() == 0L ? Bytes.allocateElasticOnHeap(initialCapacity) : Bytes.allocateElasticDirect(initialCapacity);
    }

    @NotNull
    public static String toString(@NotNull Bytes<?> buffer) throws BufferUnderflowException, IllegalArgumentException {
        return Bytes.toString(buffer, 0x7FFFFFF0L);
    }

    @NotNull
    public static String toString(@NotNull Bytes<?> buffer, @NonNegative long maxLen) throws BufferUnderflowException, IllegalArgumentException {
        return Bytes.toString(buffer, buffer.readPosition(), Math.min(maxLen, buffer.readRemaining()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String toString(@NotNull Bytes<?> buffer, @NonNegative long position, @NonNegative long length) {
        String string;
        ObjectUtils.requireNonNull(buffer);
        Longs.requireNonNegative((long)position);
        Longs.requireNonNegative((long)length);
        long pos = buffer.readPosition();
        long limit = buffer.readLimit();
        buffer.readPositionRemaining(position, length);
        try {
            @NotNull StringBuilder builder = new StringBuilder();
            while (buffer.readRemaining() > 0L) {
                builder.append((char)buffer.readByte());
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                buffer.readLimit(limit);
                buffer.readPosition(pos);
                throw throwable;
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        buffer.readLimit(limit);
        buffer.readPosition(pos);
        return string;
    }

    @NotNull
    public static VanillaBytes allocateDirect(byte[] bytes) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        VanillaBytes<Void> result = Bytes.allocateDirect(bytes.length);
        result.write(bytes);
        return result;
    }

    @NotNull
    public static Bytes<?> fromHexString(@NotNull String s) {
        return BytesInternal.fromHexString(s);
    }

    @NotNull
    default public Bytes<U> unchecked(boolean unchecked) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        if (unchecked) {
            if (this.isElastic()) {
                BytesUtil.WarnUncheckedElasticBytes.warn();
            }
            UncheckedBytes underlyingBytes = this.start() == 0L && this.bytesStore().isDirectMemory() ? new UncheckedNativeBytes(this) : new UncheckedBytes(this);
            this.release(INIT);
            return underlyingBytes;
        }
        return this;
    }

    default public boolean unchecked() {
        return false;
    }

    @Override
    default public long safeLimit() {
        return this.bytesStore().safeLimit();
    }

    @Override
    default public boolean isClear() {
        return this.start() == this.readPosition() && this.writeLimit() == this.capacity();
    }

    @Override
    @NonNegative
    default public long realCapacity() {
        return BytesStore.super.realCapacity();
    }

    @Override
    public BytesStore<Bytes<U>, U> copy() throws IllegalStateException, ClosedIllegalStateException, ThreadingIllegalStateException;

    @NotNull
    default public String toHexString() {
        return this.toHexString(1024L);
    }

    @NotNull
    default public String toHexString(@NonNegative long maxLength) {
        return this.toHexString(this.readPosition(), maxLength);
    }

    @NotNull
    default public String toHexString(@NonNegative long offset, @NonNegative long maxLength) {
        Longs.requireNonNegative((long)offset);
        Longs.requireNonNegative((long)maxLength);
        long maxLength2 = Math.min(maxLength, this.readLimit() - offset);
        String ret = BytesInternal.toHexString(this, offset, maxLength2);
        return maxLength2 < this.readLimit() - offset ? ret + "... truncated" : ret;
    }

    public boolean isElastic();

    @Override
    default public void ensureCapacity(@NonNegative long desiredCapacity) throws DecoratedBufferOverflowException, IllegalStateException, ClosedIllegalStateException, ThreadingIllegalStateException {
        Longs.requireNonNegative((long)desiredCapacity);
        if (desiredCapacity > this.capacity()) {
            throw new DecoratedBufferOverflowException(this.isElastic() ? "Resizing required" : "Buffer is not elastic");
        }
    }

    @Override
    @NotNull
    default public Bytes<U> bytesForRead() throws IllegalStateException, ClosedIllegalStateException, ThreadingIllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        BytesStore<?, U> bytesStore = this.bytesStore();
        if (!1.$assertionsDisabled && bytesStore == null) {
            throw new AssertionError((Object)"bytesStore is null");
        }
        return this.isClear() ? bytesStore.bytesForRead() : new SubBytes(bytesStore, this.readPosition(), this.readLimit() + this.start());
    }

    @Override
    @NotNull
    default public Bytes<U> bytesForWrite() throws IllegalStateException, ClosedIllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        BytesStore<?, U> bytesStore = this.bytesStore();
        if (!1.$assertionsDisabled && bytesStore == null) {
            throw new AssertionError((Object)"bytesStore is null");
        }
        return new VanillaBytes(bytesStore, this.writePosition(), this.writeLimit());
    }

    @Override
    @Nullable
    public BytesStore<?, U> bytesStore();

    default public boolean isEqual(@Nullable String other) throws IllegalStateException {
        return StringUtils.isEqual((CharSequence)this, (CharSequence)other);
    }

    @NotNull
    public Bytes<U> compact() throws ClosedIllegalStateException, ThreadingIllegalStateException;

    @Override
    default public long copyTo(@NotNull BytesStore<?, ?> targetByteStore) throws ClosedIllegalStateException {
        return BytesStore.super.copyTo(targetByteStore);
    }

    @Override
    default public void copyTo(@NotNull OutputStream outputStream) throws IOException, ClosedIllegalStateException {
        BytesStore.super.copyTo(outputStream);
    }

    @Override
    default public boolean sharedMemory() {
        return this.bytesStore().sharedMemory();
    }

    default public void unwrite(@NonNegative long fromOffset, @NonNegative int count) throws BufferUnderflowException, BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long wp = this.writePosition();
        if (wp < fromOffset) {
            return;
        }
        this.write(fromOffset, this, fromOffset + (long)count, wp - fromOffset - (long)count);
        this.writePosition(wp - (long)count);
    }

    default public long indexOf(@NotNull Bytes source) throws ClosedIllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        ReferenceCountedUtil.throwExceptionIfReleased(source);
        long sourceOffset = this.readPosition();
        long otherOffset = source.readPosition();
        long sourceCount = this.readRemaining();
        long otherCount = source.readRemaining();
        if (sourceCount <= 0L) {
            return Math.toIntExact(otherCount == 0L ? sourceCount : -1L);
        }
        if (otherCount == 0L) {
            return 0L;
        }
        byte firstByte = source.readByte(otherOffset);
        long max = sourceOffset + (sourceCount - otherCount);
        for (long i = sourceOffset; i <= max; ++i) {
            if (this.readByte(i) != firstByte) {
                while (++i <= max && this.readByte(i) != firstByte) {
                }
            }
            if (i > max) continue;
            long j = i + 1L;
            long end = j + otherCount - 1L;
            long k = otherOffset + 1L;
            while (j < end && this.readByte(j) == source.readByte(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return Math.toIntExact(i - sourceOffset);
        }
        return -1L;
    }

    default public int indexOf(@NotNull BytesStore<?, ?> source, @NonNegative int fromIndex) throws ClosedIllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        ReferenceCountedUtil.throwExceptionIfReleased(source);
        long sourceOffset = this.readPosition();
        long otherOffset = source.readPosition();
        long sourceCount = this.readRemaining();
        long otherCount = source.readRemaining();
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if ((long)fromIndex >= sourceCount) {
            return Math.toIntExact(otherCount == 0L ? sourceCount : -1L);
        }
        if (otherCount == 0L) {
            return fromIndex;
        }
        byte firstByte = source.readByte(otherOffset);
        long max = sourceOffset + (sourceCount - otherCount);
        for (long i = sourceOffset + (long)fromIndex; i <= max; ++i) {
            if (this.readByte(i) != firstByte) {
                while (++i <= max && this.readByte(i) != firstByte) {
                }
            }
            if (i > max) continue;
            long j = i + 1L;
            long end = j + otherCount - 1L;
            long k = otherOffset + 1L;
            while (j < end && this.readByte(j) == source.readByte(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return Math.toIntExact(i - sourceOffset);
        }
        return -1;
    }

    @Override
    @NotNull
    public Bytes<U> clear() throws IllegalStateException, ClosedIllegalStateException, ThreadingIllegalStateException;

    @Override
    default public boolean readWrite() {
        return this.bytesStore().readWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void readWithLength(@NonNegative long length, @NotNull BytesOut<?> bytesOut) throws BufferUnderflowException, IORuntimeException, BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        Longs.requireNonNegative((long)length);
        if (length > this.readRemaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.readLimit();
        long limit = this.readPosition() + length;
        boolean lenient = this.lenient();
        try {
            this.lenient(true);
            this.readLimit(limit);
            bytesOut.write(this);
        }
        finally {
            this.readLimit(limit0);
            this.readPosition(limit);
            this.lenient(lenient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public <T extends ReadBytesMarshallable> T readMarshallableLength16(@NotNull Class<T> clazz, @Nullable T using) throws BufferUnderflowException, ClosedIllegalStateException, InvalidMarshallableException, ThreadingIllegalStateException {
        T object = using == null ? (ReadBytesMarshallable)ObjectUtils.newInstance(clazz) : using;
        int length = this.readUnsignedShort();
        long limit = this.readLimit();
        long end = this.readPosition() + (long)length;
        boolean lenient = this.lenient();
        try {
            this.lenient(true);
            this.readLimit(end);
            object.readMarshallable(this);
        }
        finally {
            this.readPosition(end);
            this.readLimit(limit);
            this.lenient(lenient);
        }
        return object;
    }

    @Override
    default public void writeMarshallableLength16(@NotNull WriteBytesMarshallable marshallable) throws BufferOverflowException, ClosedIllegalStateException, BufferUnderflowException, InvalidMarshallableException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull((Object)marshallable);
        long position = this.writePosition();
        ValidatableUtil.validate((Object)marshallable);
        this.writeUnsignedShort(0);
        marshallable.writeMarshallable(this);
        long length = this.lengthWritten(position) - 2L;
        if (length >= 65536L) {
            throw new IllegalStateException("Marshallable " + marshallable.getClass() + " too long was " + length);
        }
        this.writeUnsignedShort(position, (int)length);
    }

    default public Bytes write(@NotNull InputStream inputStream) throws IOException, BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        int read;
        ObjectUtils.requireNonNull((Object)inputStream);
        while ((read = inputStream.read()) != -1) {
            this.writeByte((byte)read);
        }
        return this;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

