/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RandomDataOutput<R extends RandomDataOutput<R>>
extends RandomCommon {
    @NotNull
    default public R writeByte(@NonNegative long offset, int i) throws BufferOverflowException, IllegalArgumentException, ClosedIllegalStateException {
        return this.writeByte(offset, Maths.toInt8((long)i));
    }

    @NotNull
    default public R writeUnsignedByte(@NonNegative long offset, int i) throws BufferOverflowException, IllegalArgumentException, ClosedIllegalStateException {
        return this.writeByte(offset, (byte)Maths.toUInt8((long)i));
    }

    @NotNull
    default public R writeBoolean(@NonNegative long offset, boolean flag) throws BufferOverflowException, ClosedIllegalStateException {
        return this.writeByte(offset, flag ? 89 : 78);
    }

    @NotNull
    default public R writeUnsignedShort(@NonNegative long offset, int i) throws BufferOverflowException, ArithmeticException, ClosedIllegalStateException {
        return this.writeShort(offset, (short)Maths.toUInt16((long)i));
    }

    @NotNull
    default public R writeUnsignedInt(@NonNegative long offset, long i) throws BufferOverflowException, ArithmeticException, ClosedIllegalStateException {
        return this.writeInt(offset, (int)Maths.toUInt32((long)i));
    }

    @NotNull
    public R writeByte(@NonNegative long var1, byte var3) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    public R writeShort(@NonNegative long var1, short var3) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    default public R writeInt24(@NonNegative long offset, int i) throws BufferOverflowException, ClosedIllegalStateException {
        this.writeShort(offset, (short)i);
        return this.writeByte(offset + 2L, (byte)(i >> 16));
    }

    @NotNull
    public R writeInt(@NonNegative long var1, int var3) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    public R writeOrderedInt(@NonNegative long var1, int var3) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    default public R writeOrderedFloat(@NonNegative long offset, float f) throws BufferOverflowException, ClosedIllegalStateException {
        return this.writeOrderedInt(offset, Float.floatToRawIntBits(f));
    }

    @NotNull
    public R writeLong(@NonNegative long var1, long var3) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    public R writeOrderedLong(@NonNegative long var1, long var3) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    default public R writeOrderedDouble(@NonNegative long offset, double d) throws BufferOverflowException, ClosedIllegalStateException {
        return this.writeOrderedLong(offset, Double.doubleToRawLongBits(d));
    }

    @NotNull
    public R writeFloat(@NonNegative long var1, float var3) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    public R writeDouble(@NonNegative long var1, double var3) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    public R writeVolatileByte(@NonNegative long var1, byte var3) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    public R writeVolatileShort(@NonNegative long var1, short var3) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    public R writeVolatileInt(@NonNegative long var1, int var3) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    public R writeVolatileLong(@NonNegative long var1, long var3) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    default public R writeVolatileFloat(@NonNegative long offset, float f) throws BufferOverflowException, ClosedIllegalStateException {
        return this.writeVolatileInt(offset, Float.floatToRawIntBits(f));
    }

    @NotNull
    default public R writeVolatileDouble(@NonNegative long offset, double d) throws BufferOverflowException, ClosedIllegalStateException {
        return this.writeVolatileLong(offset, Double.doubleToRawLongBits(d));
    }

    @NotNull
    default public R write(@NonNegative long offsetInRDO, byte[] bytes) throws BufferOverflowException, ClosedIllegalStateException {
        ObjectUtils.requireNonNull((Object)bytes);
        return this.write(offsetInRDO, bytes, 0, bytes.length);
    }

    @NotNull
    public R write(@NonNegative long var1, byte[] var3, @NonNegative int var4, @NonNegative int var5) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    public void write(@NonNegative long var1, @NotNull ByteBuffer var3, @NonNegative int var4, @NonNegative int var5) throws BufferOverflowException, ClosedIllegalStateException;

    @NotNull
    default public R write(@NonNegative long offsetInRDO, @NotNull BytesStore bytes) throws BufferOverflowException, ClosedIllegalStateException {
        ObjectUtils.requireNonNull((Object)bytes);
        return this.write(offsetInRDO, bytes, bytes.readPosition(), bytes.readRemaining());
    }

    @NotNull
    public R write(@NonNegative long var1, @NotNull RandomDataInput var3, @NonNegative long var4, @NonNegative long var6) throws BufferOverflowException, BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    @NotNull
    public R zeroOut(@NonNegative long var1, @NonNegative long var3) throws ClosedIllegalStateException;

    @NotNull
    default public R append(@NonNegative long offset, long value, int digits) throws BufferOverflowException, IllegalArgumentException, ClosedIllegalStateException {
        BytesInternal.append(this, offset, value, digits);
        return (R)this;
    }

    @NotNull
    default public R append(@NonNegative long offset, double value, int decimalPlaces, int digits) throws BufferOverflowException, IllegalArgumentException, ClosedIllegalStateException, ArithmeticException, ThreadingIllegalStateException {
        double d2;
        if (decimalPlaces < 20 && (d2 = value * (double)Maths.tens((int)decimalPlaces)) <= 9.223372036854776E18 && d2 >= -9.223372036854776E18) {
            BytesInternal.appendDecimal(this, Math.round(d2), offset, decimalPlaces, digits);
            return (R)this;
        }
        BytesInternal.append((StreamingDataOutput)((Object)this), value);
        return (R)this;
    }

    public void nativeWrite(long var1, @NonNegative long var3, @NonNegative long var5) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    default public long writeUtf8(@NonNegative long writeOffset, @Nullable CharSequence text) throws BufferOverflowException, ClosedIllegalStateException, ArithmeticException {
        return BytesInternal.writeUtf8(this, writeOffset, text);
    }

    default public long writeUtf8Limited(@NonNegative long writeOffset, @Nullable CharSequence text, @NonNegative int maxUtf8Len) throws BufferOverflowException, ClosedIllegalStateException, ArithmeticException {
        return BytesInternal.writeUtf8(this, writeOffset, text, maxUtf8Len);
    }

    public long write8bit(@NonNegative long var1, @NotNull BytesStore var3) throws ClosedIllegalStateException, ThreadingIllegalStateException;

    public long write8bit(@NonNegative long var1, @NotNull String var3, @NonNegative int var4, @NonNegative int var5) throws ClosedIllegalStateException, ThreadingIllegalStateException;

    public boolean compareAndSwapInt(@NonNegative long var1, int var3, int var4) throws BufferOverflowException, ClosedIllegalStateException;

    public void testAndSetInt(@NonNegative long var1, int var3, int var4) throws BufferOverflowException, ClosedIllegalStateException;

    public boolean compareAndSwapLong(@NonNegative long var1, long var3, long var5) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    public boolean compareAndSwapFloat(@NonNegative long var1, float var3, float var4) throws ClosedIllegalStateException;

    public boolean compareAndSwapDouble(@NonNegative long var1, double var3, double var5) throws ClosedIllegalStateException;

    public int addAndGetInt(@NonNegative long var1, int var3) throws ClosedIllegalStateException;

    public long addAndGetLong(@NonNegative long var1, long var3) throws ClosedIllegalStateException;

    public float addAndGetFloat(@NonNegative long var1, float var3) throws ClosedIllegalStateException;

    public double addAndGetDouble(@NonNegative long var1, double var3) throws ClosedIllegalStateException;

    default public long appendAndReturnLength(long writePosition, boolean negative, long mantissa, int exponent, boolean append0) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public byte[] internalNumberBuffer();
}

