/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ManagedCloseable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappedBytes
extends AbstractBytes<Void>
implements Closeable,
ManagedCloseable {
    private static final boolean TRACE = Jvm.getBoolean((String)"trace.mapped.bytes");
    private final MappedFile mappedFile;
    private final boolean backingFileIsReadOnly;
    private MappedBytesStore bytesStore;
    private long lastActualSize = 0L;
    private boolean disableThreadSafetyCheck;
    private final AbstractCloseable closeable = new AbstractCloseable(){

        protected void performClose() throws IllegalStateException {
            MappedBytes.this.performClose();
        }

        protected boolean threadSafetyCheck(boolean isUsed) throws IllegalStateException {
            return MappedBytes.this.disableThreadSafetyCheck || super.threadSafetyCheck(isUsed);
        }
    };

    public void clearUsedByThread() {
        super.clearUsedByThread();
        this.closeable.clearUsedByThread();
    }

    protected MappedBytes(@NotNull MappedFile mappedFile) throws IllegalStateException {
        this(mappedFile, "");
    }

    protected MappedBytes(@NotNull MappedFile mappedFile, String name) throws IllegalStateException {
        super(NoBytesStore.noBytesStore(), NoBytesStore.noBytesStore().writePosition(), NoBytesStore.noBytesStore().writeLimit(), name);
        assert (mappedFile != null);
        this.mappedFile = mappedFile;
        mappedFile.reserve((ReferenceOwner)this);
        boolean bl = this.backingFileIsReadOnly = !mappedFile.file().canWrite();
        assert (!mappedFile.isClosed());
        this.clear();
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull String filename, long chunkSize) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.mappedBytes(new File(filename), chunkSize);
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.mappedBytes(file, chunkSize, OS.pageSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize, long overlapSize) throws FileNotFoundException, IllegalStateException {
        @NotNull MappedFile rw = MappedFile.of(file, chunkSize, overlapSize, false);
        try {
            MappedBytes mappedBytes = MappedBytes.mappedBytes(rw);
            return mappedBytes;
        }
        finally {
            rw.release(INIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize, long overlapSize, boolean readOnly) throws FileNotFoundException, IllegalStateException {
        @NotNull MappedFile rw = MappedFile.of(file, chunkSize, overlapSize, readOnly);
        try {
            MappedBytes mappedBytes = MappedBytes.mappedBytes(rw);
            return mappedBytes;
        }
        finally {
            rw.release(INIT);
        }
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull MappedFile rw) throws IllegalStateException {
        return new MappedBytes(rw);
    }

    @NotNull
    public static MappedBytes readOnly(@NotNull File file) throws FileNotFoundException {
        MappedBytes mappedBytes;
        MappedFile mappedFile = MappedFile.readOnly(file);
        try {
            mappedBytes = new MappedBytes(mappedFile);
        }
        catch (Throwable throwable) {
            try {
                mappedFile.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException e) {
                throw new AssertionError((Object)e);
            }
        }
        mappedFile.release(INIT);
        return mappedBytes;
    }

    @Override
    protected void bytesStore(BytesStore bytesStore) {
        super.bytesStore(bytesStore);
        this.bytesStore = bytesStore instanceof MappedBytesStore ? (MappedBytesStore)bytesStore : null;
    }

    @Override
    @NotNull
    public String toString() {
        if (!TRACE) {
            return super.toString();
        }
        return "MappedBytes{\nrefCount=" + this.refCount() + ",\nmappedFile=" + this.mappedFile.file().getAbsolutePath() + ",\nmappedFileRefCount=" + this.mappedFile.refCount() + ",\nmappedFileIsClosed=" + this.mappedFile.isClosed() + ",\nmappedFileRafIsClosed=" + Jvm.getValue((Object)this.mappedFile.raf(), (String)"closed") + ",\nmappedFileRafChannelIsClosed=" + !this.mappedFile.raf().getChannel().isOpen() + ",\nisClosed=" + this.isClosed() + '}';
    }

    @Override
    @NotNull
    public MappedBytes write(@NotNull byte[] bytes, int offset, int length) throws IllegalStateException, BufferOverflowException {
        this.throwExceptionIfClosed();
        this.write(this.writePosition(), bytes, offset, length);
        this.uncheckedWritePosition(this.writePosition() + (long)Math.min(length, bytes.length - offset));
        return this;
    }

    @Override
    @NotNull
    public MappedBytes write(long offsetInRDO, byte[] bytes, int offset, int length) throws IllegalStateException, BufferOverflowException {
        this.throwExceptionIfClosed();
        long wp = offsetInRDO;
        if (length + offset > bytes.length) {
            throw new ArrayIndexOutOfBoundsException("bytes.length=" + bytes.length + ", length=" + length + ", offset=" + offset);
        }
        if ((long)length > this.writeRemaining()) {
            throw new DecoratedBufferOverflowException(String.format("write failed. Length: %d > writeRemaining: %d", length, this.writeRemaining()));
        }
        int remaining = length;
        this.acquireNextByteStore(wp, false);
        while (remaining > 0) {
            long safeCopySize = this.copySize(wp);
            if (safeCopySize + this.mappedFile.overlapSize() >= (long)remaining) {
                this.bytesStore.write(wp, bytes, offset, remaining);
                return this;
            }
            this.bytesStore.write(wp, bytes, offset, (int)safeCopySize);
            offset = (int)((long)offset + safeCopySize);
            remaining = (int)((long)remaining - safeCopySize);
            this.acquireNextByteStore0(wp += safeCopySize, false);
        }
        return this;
    }

    @Override
    @NotNull
    public MappedBytes write(long writeOffset, RandomDataInput bytes, long readOffset, long length) throws BufferOverflowException, BufferUnderflowException, IllegalStateException {
        long safeCopySize;
        this.throwExceptionIfClosed();
        long wp = writeOffset;
        if (length > this.writeRemaining()) {
            throw new DecoratedBufferOverflowException(String.format("write failed. Length: %d > writeRemaining: %d", length, this.writeRemaining()));
        }
        this.acquireNextByteStore(wp, false);
        for (long remaining = length; remaining > 0L; remaining -= safeCopySize) {
            safeCopySize = this.copySize(wp);
            if (safeCopySize + this.mappedFile.overlapSize() >= remaining) {
                this.bytesStore.write(wp, bytes, readOffset, remaining);
                return this;
            }
            this.bytesStore.write(wp, bytes, readOffset, safeCopySize);
            readOffset += safeCopySize;
            this.acquireNextByteStore0(wp += safeCopySize, false);
        }
        return this;
    }

    @Override
    @NotNull
    public MappedBytes write(@NotNull RandomDataInput bytes) throws IllegalStateException, BufferOverflowException {
        this.throwExceptionIfClosed();
        assert (bytes != this) : "you should not write to yourself !";
        long remaining = bytes.readRemaining();
        this.write(this.writePosition(), bytes);
        this.uncheckedWritePosition(this.writePosition() + remaining);
        return this;
    }

    @NotNull
    public MappedBytes write(long offsetInRDO, @NotNull RandomDataInput bytes) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        try {
            this.write(offsetInRDO, bytes, bytes.readPosition(), bytes.readRemaining());
            return this;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    private long copySize(long writePosition) {
        long size = this.mappedFile.chunkSize();
        return size - writePosition % size;
    }

    public void setNewChunkListener(NewChunkListener listener) {
        this.mappedFile.setNewChunkListener(listener);
    }

    @NotNull
    public MappedFile mappedFile() {
        return this.mappedFile;
    }

    @Override
    public BytesStore<Bytes<Void>, Void> copy() throws IllegalStateException {
        return NativeBytes.copyOf(this);
    }

    @Override
    public long capacity() {
        return this.mappedFile.capacity();
    }

    @Override
    public Bytes<Void> readLimitToCapacity() {
        this.uncheckedWritePosition(this.mappedFile.capacity());
        return this;
    }

    @Override
    public long realReadRemaining() {
        long limit = this.readLimit();
        if (limit > this.lastActualSize) {
            limit = Math.min(this.realCapacity(), limit);
        }
        return limit - this.readPosition();
    }

    @Override
    public long realWriteRemaining() {
        long limit = this.writeLimit();
        if (limit > this.lastActualSize) {
            limit = Math.min(this.realCapacity(), limit);
        }
        return limit - this.writePosition();
    }

    @Override
    public long realCapacity() {
        try {
            this.lastActualSize = this.mappedFile.actualSize();
            return this.lastActualSize;
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), "Unable to obtain the real size for " + this.mappedFile.file(), (Throwable)e);
            this.lastActualSize = 0L;
            return 0L;
        }
    }

    @Override
    @NotNull
    public Bytes<Void> readPositionRemaining(long position, long remaining) throws BufferUnderflowException, IllegalStateException {
        long limit = position + remaining;
        this.acquireNextByteStore(position, true);
        try {
            if (this.writeLimit < limit) {
                this.writeLimit(limit);
            }
            if (Jvm.isAssertEnabled()) {
                this.readLimit(limit);
            } else {
                this.uncheckedWritePosition(limit);
            }
            return this.readPosition(position);
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public Bytes<Void> readPosition(long position) throws BufferUnderflowException, IllegalStateException {
        if (this.bytesStore != null && this.bytesStore.inside(position)) {
            return super.readPosition(position);
        }
        this.acquireNextByteStore0(position, true);
        return this;
    }

    @Override
    public long addressForRead(long offset) throws BufferUnderflowException, IllegalStateException {
        if (this.bytesStore == null || !this.bytesStore.inside(offset)) {
            this.acquireNextByteStore0(offset, true);
        }
        return this.bytesStore.addressForRead(offset);
    }

    @Override
    public long addressForRead(long offset, int buffer) throws UnsupportedOperationException, BufferUnderflowException, IllegalStateException {
        if (this.bytesStore == null || !this.bytesStore.inside(offset, buffer)) {
            this.acquireNextByteStore0(offset, true);
        }
        return this.bytesStore.addressForRead(offset);
    }

    @Override
    public long addressForWrite(long offset) throws UnsupportedOperationException, BufferOverflowException, IllegalStateException {
        if (this.bytesStore == null || !this.bytesStore.inside(offset)) {
            this.acquireNextByteStore0(offset, true);
        }
        return this.bytesStore.addressForWrite(offset);
    }

    @Override
    protected void readCheckOffset(long offset, long adding, boolean given) throws BufferUnderflowException, IllegalStateException {
        long check;
        long l = check = adding >= 0L ? offset : offset + adding;
        if (this.bytesStore == null || !this.bytesStore.inside(check, adding)) {
            this.acquireNextByteStore0(offset, false);
        }
        super.readCheckOffset(offset, adding, given);
    }

    @Override
    @Nullable
    public String read8bit() throws IORuntimeException, BufferUnderflowException, IllegalStateException, ArithmeticException {
        return BytesInternal.read8bit(this);
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (offset + adding < this.start() || offset > this.mappedFile.capacity() - adding) {
            throw this.writeBufferOverflowException(offset);
        }
        if (this.bytesStore == null || adding > 0L && !this.bytesStore.inside(offset, this.checkSize(adding))) {
            this.acquireNextByteStore0(offset, false);
        }
    }

    private long checkSize(long adding) {
        if (adding < 0L || adding > 0x7FFFFFFFFFFFFFF0L) {
            throw new IllegalArgumentException("Invalid size " + adding);
        }
        return adding;
    }

    @Override
    public void ensureCapacity(long desiredCapacity) throws IllegalArgumentException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.bytesStore == null || !this.bytesStore.inside(this.writePosition(), this.checkSize(desiredCapacity))) {
            this.acquireNextByteStore0(this.writePosition(), false);
        }
    }

    @Override
    @NotNull
    public Bytes<Void> writeSkip(long bytesToSkip) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(this.writePosition(), Math.min(128L, bytesToSkip));
        this.uncheckedWritePosition(this.writePosition() + bytesToSkip);
        return this;
    }

    @NotNull
    private BufferOverflowException writeBufferOverflowException(long offset) {
        BufferOverflowException exception = new BufferOverflowException();
        exception.initCause(new IllegalArgumentException("Offset out of bound " + offset));
        return exception;
    }

    private void acquireNextByteStore(long offset, boolean set) throws IllegalStateException {
        if (this.bytesStore != null && this.bytesStore.inside(offset)) {
            return;
        }
        this.throwExceptionIfReleased();
        this.acquireNextByteStore0(offset, set);
    }

    private synchronized void acquireNextByteStore0(long offset, boolean set) throws IllegalStateException {
        this.throwExceptionIfClosed();
        @Nullable MappedBytesStore oldBS = this.bytesStore;
        try {
            @NotNull MappedBytesStore newBS = this.mappedFile.acquireByteStore((ReferenceOwner)this, offset, oldBS);
            if (newBS != oldBS) {
                this.bytesStore((BytesStore)newBS);
                if (oldBS != null) {
                    oldBS.release((ReferenceOwner)this);
                }
                if (this.lastActualSize < newBS.maximumLimit) {
                    this.lastActualSize = newBS.maximumLimit;
                }
            }
            assert (this.bytesStore.reservedBy((ReferenceOwner)this));
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        if (set) {
            try {
                if (this.writeLimit() < this.readPosition) {
                    this.writeLimit(this.readPosition);
                }
                if (this.readLimit() < this.readPosition) {
                    this.readLimit(this.readPosition);
                }
            }
            catch (BufferOverflowException | BufferUnderflowException e) {
                throw new AssertionError((Object)e);
            }
            this.readPosition = offset;
        }
    }

    @Override
    @NotNull
    public Bytes<Void> readSkip(long bytesToSkip) throws BufferUnderflowException, IllegalStateException {
        long check;
        if (this.readPosition + bytesToSkip > this.readLimit()) {
            throw new BufferUnderflowException();
        }
        long l = check = bytesToSkip >= 0L ? this.readPosition : this.readPosition + bytesToSkip;
        if (this.bytesStore == null || bytesToSkip != (long)((int)bytesToSkip) || !this.bytesStore.inside(this.readPosition, (int)bytesToSkip)) {
            this.acquireNextByteStore0(check, false);
        }
        this.readPosition += bytesToSkip;
        return this;
    }

    @Override
    @NotNull
    public MappedBytesStore bytesStore() {
        return (MappedBytesStore)super.bytesStore();
    }

    @Override
    public long start() {
        return 0L;
    }

    @Override
    @NotNull
    public Bytes<Void> writePosition(long position) throws BufferOverflowException {
        if (position > this.writeLimit) {
            throw new BufferOverflowException();
        }
        if (position < 0L) {
            throw new BufferOverflowException();
        }
        if (position < this.readPosition) {
            this.readPosition = position;
        }
        this.uncheckedWritePosition(position);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> clear() throws IllegalStateException {
        long start;
        this.throwExceptionIfClosed();
        this.readPosition = start = 0L;
        this.uncheckedWritePosition(start);
        this.writeLimit = this.mappedFile.capacity();
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeByte(byte i8) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        long oldPosition = this.writePosition();
        if (this.writePosition() < 0L || this.writePosition() > this.capacity() - 1L) {
            throw this.writeBufferOverflowException(this.writePosition());
        }
        if (this.bytesStore == null || !this.bytesStore.inside(this.writePosition(), 1L)) {
            this.acquireNextByteStore0(this.writePosition(), false);
        }
        this.uncheckedWritePosition(this.writePosition() + 1L);
        this.bytesStore.writeByte(oldPosition, i8);
        return this;
    }

    @Override
    protected void performRelease() {
        super.performRelease();
        try {
            if (this.mappedFile.refCount() > 0) {
                this.mappedFile.release((ReferenceOwner)this);
            }
        }
        catch (IllegalStateException e) {
            Jvm.warn().on(this.getClass(), (Throwable)e);
        }
    }

    protected boolean performReleaseInBackground() {
        return true;
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    public boolean isBackingFileReadOnly() {
        return this.backingFileIsReadOnly;
    }

    @Override
    @NotNull
    public Bytes<Void> write(@NotNull RandomDataInput bytes, long offset, long length) throws BufferUnderflowException, BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (bytes instanceof BytesStore) {
            this.write((BytesStore)bytes, offset, length);
        } else if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (length > 0L) {
            BytesInternal.writeFully(bytes, offset, length, this);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> write(@NotNull BytesStore bytes, long offset, long length) throws BufferUnderflowException, BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (length > 0L) {
            if (bytes.isDirectMemory()) {
                long fromAddress = bytes.addressForRead(offset);
                if (length <= bytes.bytesStore().realCapacity() - offset) {
                    this.acquireNextByteStore(this.writePosition(), false);
                    if (this.bytesStore.realCapacity() - this.writePosition() >= length) {
                        this.rawCopy(length, fromAddress);
                        return this;
                    }
                }
            }
            BytesInternal.writeFully(bytes, offset, length, this);
        }
        return this;
    }

    void rawCopy(long length, long fromAddress) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfReleased();
        OS.memory().copyMemory(fromAddress, this.addressForWritePosition(), length);
        this.uncheckedWritePosition(this.writePosition() + length);
    }

    @Override
    @NotNull
    public Bytes<Void> append8bit(@NotNull CharSequence cs, int start, int end) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException, IllegalStateException {
        this.throwExceptionIfClosed();
        long pos = this.writePosition();
        this.writeCheckOffset(pos, 0L);
        if (!(cs instanceof String) || pos + (long)((end - start) * 3) + 5L >= this.safeLimit()) {
            return (Bytes)super.append8bit(cs, start, end);
        }
        return this.append8bit0((String)cs, start, end - start);
    }

    @Override
    @NotNull
    public MappedBytes write8bit(@NotNull CharSequence s, int start, int length) throws IllegalStateException, BufferUnderflowException, BufferOverflowException, ArithmeticException, IndexOutOfBoundsException {
        this.throwExceptionIfClosed();
        ObjectUtils.requireNonNull((Object)s);
        long pos = this.writePosition();
        this.writeCheckOffset(pos, 0L);
        if (!(s instanceof String) || pos + (long)length * 3L + 5L >= this.safeLimit()) {
            super.write8bit(s, start, length);
            return this;
        }
        this.writeStopBit(length);
        return this.append8bit0((String)s, start, length);
    }

    @NotNull
    private MappedBytes append8bit0(@NotNull String s, int start, int length) throws BufferOverflowException, IllegalStateException {
        if (Jvm.isJava9Plus()) {
            int i;
            byte[] bytes = StringUtils.extractBytes((String)s);
            long address = this.addressForWritePosition();
            Memory memory = this.bytesStore().memory;
            for (i = 0; i < length - 3; i += 4) {
                int c0 = bytes[i + start] & 0xFF;
                int c1 = bytes[i + start + 1] & 0xFF;
                int c2 = bytes[i + start + 2] & 0xFF;
                int c3 = bytes[i + start + 3] & 0xFF;
                memory.writeInt(address, c3 << 24 | c2 << 16 | c1 << 8 | c0);
                address += 4L;
            }
            while (i < length) {
                byte c = bytes[i + start];
                memory.writeByte(address++, c);
                ++i;
            }
            this.writeSkip(length);
        } else {
            int i;
            char[] chars = StringUtils.extractChars((String)s);
            long address = this.addressForWritePosition();
            Memory memory = this.bytesStore().memory;
            for (i = 0; i < length - 3; i += 4) {
                int c0 = chars[i + start] & 0xFF;
                int c1 = chars[i + start + 1] & 0xFF;
                int c2 = chars[i + start + 2] & 0xFF;
                int c3 = chars[i + start + 3] & 0xFF;
                memory.writeInt(address, c3 << 24 | c2 << 16 | c1 << 8 | c0);
                address += 4L;
            }
            while (i < length) {
                char c = chars[i + start];
                memory.writeByte(address++, (byte)c);
                ++i;
            }
            this.writeSkip(length);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> appendUtf8(@NotNull CharSequence cs, int start, int length) throws BufferOverflowException, IllegalStateException, BufferUnderflowException, IndexOutOfBoundsException {
        this.throwExceptionIfClosed();
        long pos = this.writePosition();
        this.writeCheckOffset(pos, 0L);
        if (!(cs instanceof String) || pos + (long)length * 3L + 5L >= this.safeLimit()) {
            super.appendUtf8(cs, start, length);
            return this;
        }
        if (Jvm.isJava9Plus()) {
            char c;
            int i;
            String str;
            block9: {
                str = (String)cs;
                long address = this.addressForWrite(pos);
                Memory memory = OS.memory();
                for (i = 0; i < length; ++i) {
                    c = str.charAt(i + start);
                    if (c > '\u007f') {
                        this.writeSkip(i);
                        break block9;
                    }
                    memory.writeByte(address++, (byte)c);
                }
                this.writeSkip(length);
                return this;
            }
            while (i < length) {
                c = str.charAt(i + start);
                this.appendUtf8(c);
                ++i;
            }
        } else {
            char c;
            int i;
            char[] chars;
            block10: {
                chars = StringUtils.extractChars((String)((String)cs));
                long address = this.addressForWrite(pos);
                Memory memory = OS.memory();
                for (i = 0; i < length; ++i) {
                    c = chars[i + start];
                    if (c > '\u007f') {
                        this.writeSkip(i);
                        break block10;
                    }
                    memory.writeByte(address++, (byte)c);
                }
                this.writeSkip(length);
                return this;
            }
            while (i < length) {
                c = chars[i + start];
                this.appendUtf8(c);
                ++i;
            }
        }
        return this;
    }

    @Override
    public boolean sharedMemory() {
        return true;
    }

    @Override
    @NotNull
    public Bytes<Void> writeOrderedInt(long offset, int i) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        this.writeCheckOffset(offset, 4L);
        if (this.bytesStore == null || !this.bytesStore.inside(offset, 4L)) {
            this.acquireNextByteStore0(offset, false);
        }
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.bytesStore == null || !this.bytesStore.inside(offset, 1L)) {
            this.acquireNextByteStore0(offset, false);
        }
        return this.bytesStore.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.bytesStore == null || !this.bytesStore.inside(offset, 2L)) {
            this.acquireNextByteStore0(offset, false);
        }
        return this.bytesStore.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.bytesStore == null || !this.bytesStore.inside(offset, 4L)) {
            this.acquireNextByteStore0(offset, false);
        }
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.bytesStore == null || !this.bytesStore.inside(offset, 8L)) {
            this.acquireNextByteStore0(offset, false);
        }
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    public int peekUnsignedByte() throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.bytesStore == null || !this.bytesStore.inside(this.readPosition, 1L)) {
            this.acquireNextByteStore0(this.readPosition, false);
        }
        return super.peekUnsignedByte();
    }

    @Override
    public int peekUnsignedByte(long offset) throws BufferUnderflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.bytesStore == null || !this.bytesStore.inside(offset, 1L)) {
            this.acquireNextByteStore0(offset, false);
        }
        return super.peekUnsignedByte(offset);
    }

    @Override
    public int peekVolatileInt() throws IllegalStateException {
        if (this.bytesStore == null || !this.bytesStore.inside(this.readPosition, 4L)) {
            this.acquireNextByteStore0(this.readPosition, true);
        }
        @Nullable MappedBytesStore bytesStore = this.bytesStore;
        long address = bytesStore.address + bytesStore.translate(this.readPosition);
        @Nullable Memory memory = bytesStore.memory;
        if ((address & 0x3FL) <= 60L) {
            ObjectUtils.requireNonNull((Object)memory);
            UnsafeMemory.unsafeLoadFence();
            return UnsafeMemory.unsafeGetInt((long)address);
        }
        return memory.readVolatileInt(address);
    }

    public void release(ReferenceOwner id) throws IllegalStateException {
        super.release(id);
        if (this.refCount() <= 0) {
            this.closeable.close();
        }
    }

    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        super.releaseLast(id);
        this.closeable.close();
    }

    public void close() {
        this.closeable.close();
    }

    void performClose() {
        try {
            if (this.refCount() > 0) {
                this.release(INIT);
            }
        }
        catch (IllegalStateException e) {
            Jvm.warn().on(this.getClass(), (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.closeable.isClosed();
    }

    public void warnAndCloseIfNotClosed() {
        this.closeable.warnAndCloseIfNotClosed();
    }

    public void throwExceptionIfClosed() throws IllegalStateException {
        this.closeable.throwExceptionIfClosed();
    }

    @Override
    @NotNull
    public Bytes<Void> writeUtf8(CharSequence str) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (str instanceof String) {
            this.writeUtf8((String)str);
            return this;
        }
        if (str == null) {
            BytesInternal.writeStopBitNeg1(this);
        } else {
            long utfLength = AppendableUtil.findUtf8Length(str);
            this.writeStopBit(utfLength);
            BytesInternal.appendUtf8(this, str, 0, str.length());
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeUtf8(String str) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (str == null) {
            BytesInternal.writeStopBitNeg1(this);
            return this;
        }
        try {
            if (Jvm.isJava9Plus()) {
                byte[] strBytes = StringUtils.extractBytes((String)str);
                byte coder = StringUtils.getStringCoder((String)str);
                long utfLength = AppendableUtil.findUtf8Length(strBytes, coder);
                this.writeStopBit(utfLength);
                this.appendUtf8(strBytes, 0, str.length(), coder);
            } else {
                char[] chars = StringUtils.extractChars((String)str);
                long utfLength = AppendableUtil.findUtf8Length(chars);
                this.writeStopBit(utfLength);
                this.appendUtf8(chars, 0, chars.length);
            }
            return this;
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public Bytes<Void> appendUtf8(char[] chars, int offset, int length) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        char c;
        int i;
        block5: {
            this.throwExceptionIfClosed();
            if (this.writePosition() < 0L || this.writePosition() > this.capacity() - 1L + (long)length) {
                throw this.writeBufferOverflowException(this.writePosition());
            }
            for (i = 0; i < length; ++i) {
                c = chars[offset + i];
                if (c <= '\u007f') {
                    long oldPosition = this.writePosition();
                    if (this.bytesStore == null || (this.writePosition() & 0xFFL) == 0L && !this.bytesStore.inside(this.writePosition(), (long)(length - i) * 3L)) {
                        this.acquireNextByteStore0(this.writePosition(), false);
                    }
                    this.uncheckedWritePosition(this.writePosition() + 1L);
                    this.bytesStore.writeByte(oldPosition, (byte)c);
                    continue;
                }
                break block5;
            }
            return this;
        }
        while (i < length) {
            c = chars[offset + i];
            BytesInternal.appendUtf8Char(this, c);
            ++i;
        }
        return this;
    }

    @Override
    public long readStopBit() throws IORuntimeException, IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        long offset = this.readOffsetPositionMoved(1L);
        byte l = this.bytesStore.readByte(offset);
        if (l >= 0) {
            return l;
        }
        return BytesInternal.readStopBit0(this, l);
    }

    @Override
    public char readStopBitChar() throws IORuntimeException, IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        long offset = this.readOffsetPositionMoved(1L);
        byte l = this.bytesStore.readByte(offset);
        if (l >= 0) {
            return (char)l;
        }
        return (char)BytesInternal.readStopBit0(this, l);
    }

    @Override
    @NotNull
    public Bytes<Void> writeStopBit(long n) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.writeByte((byte)(n & 0x7FL));
            return this;
        }
        if (((n ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.writeByte((byte)(0x80L | n ^ 0xFFFFFFFFFFFFFFFFL));
            this.writeByte((byte)0);
            return this;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            this.writeByte((byte)(n & 0x7FL | 0x80L));
            this.writeByte((byte)(n >> 7));
            return this;
        }
        BytesInternal.writeStopBit0(this, n);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeStopBit(char n) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if ((n & 0xFFFFFF80) == 0) {
            this.writeByte((byte)(n & 0x7F));
            return this;
        }
        if ((n & 0xFFFFC000) == 0) {
            this.writeByte((byte)(n & 0x7F | 0x80));
            this.writeByte((byte)(n >> 7));
            return this;
        }
        BytesInternal.writeStopBit0(this, (long)n);
        return this;
    }

    @Override
    public boolean isDirectMemory() {
        return true;
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (offset < 0L || offset > this.mappedFile.capacity() - 8L) {
            throw this.writeBufferOverflowException(offset);
        }
        if (this.bytesStore == null || this.bytesStore.start() > offset || offset + 8L >= this.bytesStore.safeLimit()) {
            this.acquireNextByteStore0(offset, false);
        }
        return this.bytesStore.compareAndSwapLong(offset, expected, value);
    }

    public MappedBytes disableThreadSafetyCheck(boolean disableThreadSafetyCheck) {
        this.disableThreadSafetyCheck = disableThreadSafetyCheck;
        return this;
    }
}

