/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.Field;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.AbstractBytesStore;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.cleaner.CleanerServiceLocator;
import net.openhft.chronicle.core.cleaner.spi.ByteBufferCleanerService;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.SimpleCleaner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class NativeBytesStore<Underlying>
extends AbstractBytesStore<NativeBytesStore<Underlying>, Underlying> {
    private static final long MEMORY_MAPPED_SIZE = 131072L;
    private static final Field BB_ADDRESS;
    private static final Field BB_CAPACITY;
    private static final Field BB_ATT;
    private static final ByteBufferCleanerService CLEANER_SERVICE;
    private final Finalizer finalizer;
    protected long address;
    protected Memory memory = OS.memory();
    protected long limit;
    protected long maximumLimit;
    @Nullable
    private SimpleCleaner cleaner;
    private boolean elastic;
    @Nullable
    private Underlying underlyingObject;

    private NativeBytesStore() {
        this.finalizer = null;
    }

    private NativeBytesStore(@NotNull ByteBuffer bb, boolean elastic) {
        this(bb, elastic, 0x7FFFFFF0);
    }

    public NativeBytesStore(@NotNull ByteBuffer bb, boolean elastic, int maximumLimit) {
        this();
        this.init(bb, elastic);
        this.maximumLimit = elastic ? (long)maximumLimit : Math.min(this.limit, (long)maximumLimit);
    }

    public NativeBytesStore(long address, long limit) {
        this(address, limit, null, false);
    }

    public NativeBytesStore(long address, long limit, @Nullable Runnable deallocator, boolean elastic) {
        this(address, limit, deallocator, elastic, false);
    }

    protected NativeBytesStore(long address, long limit, @Nullable Runnable deallocator, boolean elastic, boolean monitored) {
        super(monitored);
        this.setAddress(address);
        this.limit = limit;
        this.maximumLimit = elastic ? 0x7FFFFFFFFFFFFFF0L : limit;
        this.cleaner = deallocator == null ? null : new SimpleCleaner(deallocator);
        this.underlyingObject = null;
        this.elastic = elastic;
        this.finalizer = this.cleaner == null ? null : new Finalizer();
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> wrap(@NotNull ByteBuffer bb) {
        return new NativeBytesStore<ByteBuffer>(bb, false);
    }

    @NotNull
    public static <T> NativeBytesStore<T> uninitialized() {
        return new NativeBytesStore();
    }

    @NotNull
    public static NativeBytesStore<Void> nativeStore(long capacity) throws IllegalArgumentException {
        return NativeBytesStore.of(capacity, true, true);
    }

    @NotNull
    private static NativeBytesStore<Void> of(long capacity, boolean zeroOut, boolean elastic) throws IllegalArgumentException {
        if (capacity <= 0L) {
            return new NativeBytesStore<Void>(NoBytesStore.NO_PAGE, 0L, null, elastic);
        }
        Memory memory = OS.memory();
        long address = memory.allocate(capacity);
        if (zeroOut || capacity < 131072L) {
            memory.setMemory(address, capacity, (byte)0);
            memory.storeFence();
        }
        @NotNull Deallocator deallocator = new Deallocator(address, capacity);
        return new NativeBytesStore<Void>(address, capacity, deallocator, elastic);
    }

    @NotNull
    public static NativeBytesStore<Void> nativeStoreWithFixedCapacity(long capacity) throws IllegalArgumentException {
        return NativeBytesStore.of(capacity, true, false);
    }

    @NotNull
    public static NativeBytesStore<Void> lazyNativeBytesStoreWithFixedCapacity(long capacity) throws IllegalArgumentException {
        return NativeBytesStore.of(capacity, false, false);
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> elasticByteBuffer() {
        return NativeBytesStore.elasticByteBuffer(OS.pageSize(), 0x7FFFFFFFFFFFFFF0L);
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> elasticByteBuffer(int size, long maxSize) {
        return new NativeBytesStore<ByteBuffer>(ByteBuffer.allocateDirect(size), true, Math.toIntExact(maxSize));
    }

    @NotNull
    public static NativeBytesStore from(@NotNull String text) {
        return NativeBytesStore.from(text.getBytes(StandardCharsets.ISO_8859_1));
    }

    @NotNull
    public static NativeBytesStore from(@NotNull byte[] bytes) {
        try {
            @NotNull NativeBytesStore<Void> nbs = NativeBytesStore.nativeStoreWithFixedCapacity(bytes.length);
            Bytes<byte[]> bytes2 = Bytes.wrapForRead(bytes);
            bytes2.copyTo(nbs);
            bytes2.releaseLast();
            return nbs;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean isDirectMemory() {
        return true;
    }

    @Override
    public boolean canReadDirect(long length) {
        return this.limit >= length;
    }

    public void init(@NotNull ByteBuffer bb, boolean elastic) {
        this.elastic = elastic;
        this.underlyingObject = bb;
        this.setAddress(Jvm.address((ByteBuffer)bb));
        this.limit = bb.capacity();
    }

    public void uninit() {
        this.underlyingObject = null;
        this.address = 0L;
        this.limit = 0L;
        this.maximumLimit = 0L;
        this.cleaner = null;
    }

    @Override
    public void move(long from, long to, long length) throws BufferUnderflowException, IllegalStateException {
        if (from < 0L || to < 0L) {
            throw new BufferUnderflowException();
        }
        long address = this.address;
        if (address == 0L) {
            this.throwException(null);
        }
        this.memoryCopyMemory(address + from, address + to, length);
    }

    private void memoryCopyMemory(long fromAddress, long toAddress, long length) throws IllegalStateException {
        try {
            this.memory.copyMemory(fromAddress, toAddress, length);
        }
        catch (NullPointerException ifReleased) {
            this.throwException(ifReleased);
        }
    }

    private void throwException(Throwable ifReleased) throws IllegalStateException {
        this.throwExceptionIfReleased();
        throw new IllegalStateException(ifReleased);
    }

    @Override
    @NotNull
    public BytesStore<NativeBytesStore<Underlying>, Underlying> copy() throws IllegalStateException {
        try {
            if (this.underlyingObject == null) {
                @NotNull NativeBytesStore<Void> copy = NativeBytesStore.of(this.realCapacity(), false, true);
                this.memoryCopyMemory(this.address, copy.address, this.capacity());
                return copy;
            }
            if (this.underlyingObject instanceof ByteBuffer) {
                ByteBuffer bb = ByteBuffer.allocateDirect(Maths.toInt32((long)this.capacity()));
                bb.put((ByteBuffer)this.underlyingObject);
                bb.clear();
                return NativeBytesStore.wrap(bb);
            }
            throw new UnsupportedOperationException();
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public VanillaBytes<Underlying> bytesForWrite() throws IllegalStateException {
        try {
            return this.elastic ? NativeBytes.wrapWithNativeBytes(this, this.capacity()) : new NativeBytes(this);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long realCapacity() {
        return this.limit;
    }

    @Override
    public long capacity() {
        return this.maximumLimit;
    }

    @Override
    @Nullable
    public Underlying underlyingObject() {
        return this.underlyingObject;
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> zeroOut(long start, long end) {
        long i;
        long size;
        if (end <= start) {
            return this;
        }
        if (start < this.start()) {
            start = this.start();
        }
        if (end > this.capacity()) {
            end = this.capacity();
        }
        long address = this.address + this.translate(start);
        for (size = end - start; (address & 7L) != 0L && size > 0L; --size) {
            if (this.memory.readByte((Object)address, 0L) != 0) {
                this.memory.writeByte(address, (byte)0);
            }
            ++address;
        }
        for (i = 0L; i < size - 7L; i += 8L) {
            if (this.memory.readLong((Object)(address + i), 0L) == 0L) continue;
            this.memory.writeLong(address + i, 0L);
        }
        while (i < size) {
            if (this.memory.readByte((Object)(address + i), 0L) != 0) {
                this.memory.writeByte(address + i, (byte)0);
            }
            ++i;
        }
        return this;
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) throws IllegalStateException {
        return this.memory.compareAndSwapInt(this.address + this.translate(offset), expected, value);
    }

    @Override
    public void testAndSetInt(long offset, int expected, int value) throws IllegalStateException {
        this.memory.testAndSetInt(this.address + this.translate(offset), offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) throws IllegalStateException {
        return this.memory.compareAndSwapLong(this.address + this.translate(offset), expected, value);
    }

    @Override
    public long addAndGetLong(long offset, long adding) throws BufferUnderflowException {
        return this.memory.addLong(this.address + this.translate(offset), adding);
    }

    @Override
    public int addAndGetInt(long offset, int adding) throws BufferUnderflowException {
        return this.memory.addInt(this.address + this.translate(offset), adding);
    }

    protected long translate(long offset) {
        return offset;
    }

    @Override
    public byte readByte(long offset) {
        return this.memory.readByte(this.address + this.translate(offset));
    }

    @Override
    public int readUnsignedByte(long offset) throws BufferUnderflowException {
        return this.readByte(offset) & 0xFF;
    }

    @Override
    public short readShort(long offset) {
        return this.memory.readShort(this.address + this.translate(offset));
    }

    @Override
    public int readInt(long offset) {
        return this.memory.readInt(this.address + this.translate(offset));
    }

    @Override
    public long readLong(long offset) {
        long address = this.address;
        assert (address != 0L);
        return this.memory.readLong(address + this.translate(offset));
    }

    @Override
    public float readFloat(long offset) {
        return this.memory.readFloat(this.address + this.translate(offset));
    }

    @Override
    public double readDouble(long offset) {
        return this.memory.readDouble(this.address + this.translate(offset));
    }

    @Override
    public byte readVolatileByte(long offset) {
        return this.memory.readVolatileByte(this.address + this.translate(offset));
    }

    @Override
    public short readVolatileShort(long offset) {
        return this.memory.readVolatileShort(this.address + this.translate(offset));
    }

    @Override
    public int readVolatileInt(long offset) {
        return this.memory.readVolatileInt(this.address + this.translate(offset));
    }

    @Override
    public long readVolatileLong(long offset) {
        return this.memory.readVolatileLong(this.address + this.translate(offset));
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> writeByte(long offset, byte i8) throws IllegalStateException {
        this.memory.writeByte(this.address + this.translate(offset), i8);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> writeShort(long offset, short i16) throws IllegalStateException {
        this.memory.writeShort(this.address + this.translate(offset), i16);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> writeInt(long offset, int i32) throws IllegalStateException {
        try {
            this.memory.writeInt(this.address + this.translate(offset), i32);
            return this;
        }
        catch (NullPointerException e) {
            this.throwExceptionIfReleased();
            throw e;
        }
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> writeOrderedInt(long offset, int i) throws IllegalStateException {
        this.memory.writeOrderedInt(this.address + this.translate(offset), i);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> writeLong(long offset, long i64) throws IllegalStateException {
        this.memory.writeLong(this.address + this.translate(offset), i64);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> writeOrderedLong(long offset, long i) throws IllegalStateException {
        this.memory.writeOrderedLong(this.address + this.translate(offset), i);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> writeFloat(long offset, float f) throws IllegalStateException {
        this.memory.writeFloat(this.address + this.translate(offset), f);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> writeDouble(long offset, double d) throws IllegalStateException {
        this.memory.writeDouble(this.address + this.translate(offset), d);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> writeVolatileByte(long offset, byte i8) throws IllegalStateException {
        this.memory.writeVolatileByte(this.address + this.translate(offset), i8);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> writeVolatileShort(long offset, short i16) throws IllegalStateException {
        this.memory.writeVolatileShort(this.address + this.translate(offset), i16);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> writeVolatileInt(long offset, int i32) throws IllegalStateException {
        this.memory.writeVolatileInt(this.address + this.translate(offset), i32);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> writeVolatileLong(long offset, long i64) throws IllegalStateException {
        this.memory.writeVolatileLong(this.address + this.translate(offset), i64);
        return this;
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) throws IllegalStateException {
        this.memory.copyMemory(bytes, offset, this.address + this.translate(offsetInRDO), length);
        return this;
    }

    @Override
    public void write(long offsetInRDO, @NotNull ByteBuffer bytes, int offset, int length) throws IllegalStateException {
        if (bytes.isDirect()) {
            this.memoryCopyMemory(Jvm.address((ByteBuffer)bytes) + (long)offset, this.address + this.translate(offsetInRDO), length);
        } else {
            this.memory.copyMemory(bytes.array(), offset, this.address + this.translate(offsetInRDO), length);
        }
    }

    @Override
    @NotNull
    public NativeBytesStore<Underlying> write(long writeOffset, @NotNull RandomDataInput bytes, long readOffset, long length) throws BufferOverflowException, BufferUnderflowException, IllegalStateException {
        if (bytes.isDirectMemory()) {
            this.memoryCopyMemory(bytes.addressForRead(readOffset), this.addressForWrite(writeOffset), length);
        } else {
            this.write0(writeOffset, bytes, readOffset, length);
        }
        return this;
    }

    public void write0(long offsetInRDO, @NotNull RandomDataInput bytes, long offset, long length) throws BufferUnderflowException, IllegalStateException {
        long i;
        for (i = 0L; i < length - 7L; i += 8L) {
            this.writeLong(offsetInRDO + i, bytes.readLong(offset + i));
        }
        while (i < length) {
            this.writeByte(offsetInRDO + i, bytes.readByte(offset + i));
            ++i;
        }
    }

    @Override
    public long addressForRead(long offset) throws BufferUnderflowException {
        if (offset < this.start() || offset > this.realCapacity()) {
            throw new BufferUnderflowException();
        }
        return this.address + this.translate(offset);
    }

    @Override
    public long addressForWrite(long offset) throws BufferOverflowException {
        if (offset < this.start() || offset > this.realCapacity()) {
            throw new BufferOverflowException();
        }
        return this.address + this.translate(offset);
    }

    @Override
    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException {
        return this.addressForWrite(this.start());
    }

    protected void performRelease() {
        ByteBuffer underlyingObject;
        this.memory = null;
        if (this.cleaner != null) {
            this.cleaner.clean();
        } else if (this.underlyingObject instanceof ByteBuffer && (underlyingObject = (ByteBuffer)this.underlyingObject).isDirect()) {
            CLEANER_SERVICE.clean(underlyingObject);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return BytesInternal.toString(this);
    }

    @Override
    public void nativeRead(long position, long address, long size) throws BufferUnderflowException, IllegalStateException {
        this.memoryCopyMemory(this.addressForRead(position), address, size);
    }

    @Override
    public void nativeWrite(long address, long position, long size) throws BufferOverflowException, IllegalStateException {
        this.memoryCopyMemory(address, this.addressForWrite(position), size);
    }

    void write8bit(long position, char[] chars, int offset, int length) throws IllegalStateException {
        long addr = this.address + this.translate(position);
        @Nullable Memory memory = this.memory;
        for (int i = 0; i < length; ++i) {
            memory.writeByte(addr + (long)i, (byte)chars[offset + i]);
        }
    }

    @Override
    public long write8bit(long position, BytesStore bs) {
        long addressForWrite = this.addressForWrite(position);
        long length = bs.readRemaining();
        addressForWrite = BytesUtil.writeStopBit(addressForWrite, length);
        if (bs.isDirectMemory()) {
            this.copy8bit(bs.addressForRead(bs.readPosition()), addressForWrite, length);
        } else {
            Object o = bs.underlyingObject();
            if (o instanceof byte[]) {
                this.copy8bit((byte[])o, bs.readPosition(), addressForWrite, length);
            } else {
                BytesUtil.copy8bit(bs, addressForWrite, length);
            }
        }
        return addressForWrite + length;
    }

    @Override
    public long write8bit(long position, String s, int start, int length) {
        position = BytesUtil.writeStopBit(this, position, length);
        UnsafeMemory.MEMORY.copy8bit(s, start, length, this.addressForWrite(position));
        return position + (long)length;
    }

    private void copy8bit(byte[] arr, long readPosition, long addressForWrite, long readRemaining) {
        int readOffset = Math.toIntExact(readPosition);
        int length = Math.toIntExact(readRemaining);
        UnsafeMemory.MEMORY.copyMemory(arr, readOffset, addressForWrite, length);
    }

    private void copy8bit(long addressForRead, long addressForWrite, long length) {
        OS.memory().copyMemory(addressForRead, addressForWrite, length);
    }

    void read8bit(long position, char[] chars, int length) {
        long addr = this.address + this.translate(position);
        Memory memory = this.memory;
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(memory.readByte(addr + (long)i) & 0xFF);
        }
    }

    @Override
    public long readIncompleteLong(long offset) {
        int remaining = (int)Math.min(8L, this.readRemaining() - offset);
        long l = 0L;
        for (int i = 0; i < remaining; ++i) {
            byte b = this.memory.readByte(this.address + offset + (long)i);
            l |= (long)(b & 0xFF) << i * 8;
        }
        return l;
    }

    public boolean equals(Object obj) {
        try {
            return obj instanceof BytesStore && BytesInternal.contentEqual(this, (BytesStore)obj);
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public void setAddress(long address) {
        if ((address & 0xFFFFFFFFFFFFC000L) == 0L) {
            throw new AssertionError((Object)("Invalid addressForRead " + Long.toHexString(address)));
        }
        this.address = address;
    }

    @Deprecated
    public long appendUTF(long pos, char[] chars, int offset, int length) throws BufferOverflowException, IllegalStateException {
        return this.appendUtf8(pos, chars, offset, length);
    }

    public long appendUtf8(long pos, char[] chars, int offset, int length) throws BufferOverflowException, IllegalStateException {
        int i;
        block6: {
            if (pos + (long)length > this.realCapacity()) {
                throw new BufferOverflowException();
            }
            long address = this.address + this.translate(0L);
            @Nullable Memory memory = this.memory;
            if (memory == null) {
                throw new NullPointerException();
            }
            for (i = 0; i < length - 3; i += 4) {
                int i2 = offset + i;
                char c0 = chars[i2];
                char c1 = chars[i2 + 1];
                char c2 = chars[i2 + 2];
                char c3 = chars[i2 + 3];
                if ((c0 | c1 | c2 | c3) <= 127) {
                    int value = c0 | c1 << 8 | c2 << 16 | c3 << 24;
                    UnsafeMemory.unsafePutInt((long)(address + pos), (int)value);
                    pos += 4L;
                    continue;
                }
                break block6;
            }
            while (i < length) {
                char c = chars[offset + i];
                if (c <= '\u007f') {
                    UnsafeMemory.unsafePutByte((long)(address + pos++), (byte)((byte)c));
                    ++i;
                    continue;
                }
                break block6;
            }
            return pos;
        }
        return this.appendUtf8a(pos, chars, offset, length, i);
    }

    private long appendUtf8a(long pos, char[] chars, int offset, int length, int i) throws IllegalStateException {
        while (i < length) {
            char c = chars[offset + i];
            if (c <= '\u007f') {
                this.writeByte(pos++, (byte)c);
            } else if (c <= '\u07ff') {
                this.writeByte(pos++, (byte)(0xC0 | c >> 6 & 0x1F));
                this.writeByte(pos++, (byte)(0x80 | c & 0x3F));
            } else {
                this.writeByte(pos++, (byte)(0xE0 | c >> 12 & 0xF));
                this.writeByte(pos++, (byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte(pos++, (byte)(0x80 | c & 0x3F));
            }
            ++i;
        }
        return pos;
    }

    @Override
    public long copyTo(@NotNull BytesStore store) throws IllegalStateException {
        if (store.isDirectMemory()) {
            return this.copyToDirect(store);
        }
        return super.copyTo(store);
    }

    public long copyToDirect(@NotNull BytesStore store) throws IllegalStateException {
        long toCopy = Math.min(this.limit, store.safeLimit());
        if (toCopy > 0L) {
            try {
                long addr = this.address;
                long addr2 = store.addressForWrite(0L);
                this.memoryCopyMemory(addr, addr2, toCopy);
            }
            catch (BufferOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }
        return toCopy;
    }

    @Override
    @NotNull
    public ByteBuffer toTemporaryDirectByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocateDirect(0);
        try {
            BB_ADDRESS.setLong(bb, this.address);
            BB_CAPACITY.setInt(bb, Maths.toUInt31((long)this.readRemaining()));
            BB_ATT.set(bb, this);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        bb.clear();
        return bb;
    }

    @Override
    public int byteCheckSum() throws IORuntimeException {
        return this.byteCheckSum(this.start(), this.readLimit());
    }

    @Override
    public int byteCheckSum(long position, long limit) {
        long ptr;
        @Nullable Memory memory = this.memory;
        assert (memory != null);
        int b = 0;
        long end = this.address + limit;
        for (ptr = this.address + position; ptr < end - 7L; ptr += 8L) {
            b += memory.readByte(ptr) + memory.readByte(ptr + 1L) + memory.readByte(ptr + 2L) + memory.readByte(ptr + 3L) + memory.readByte(ptr + 4L) + memory.readByte(ptr + 5L) + memory.readByte(ptr + 6L) + memory.readByte(ptr + 7L);
        }
        while (ptr < end) {
            b += memory.readByte(ptr);
            ++ptr;
        }
        return b & 0xFF;
    }

    @Override
    public boolean sharedMemory() {
        return false;
    }

    @Override
    public long read(long offsetInRDI, byte[] bytes, int offset, int length) {
        int i;
        int len = (int)Math.min((long)length, this.readLimit() - offsetInRDI);
        long address = this.address + this.translate(offsetInRDI);
        for (i = 0; i < len - 7; i += 8) {
            UnsafeMemory.unsafePutLong((byte[])bytes, (int)i, (long)this.memory.readLong(address + (long)i));
        }
        if (i < len - 3) {
            UnsafeMemory.unsafePutInt((byte[])bytes, (int)i, (int)this.memory.readInt(address + (long)i));
            i += 4;
        }
        while (i < len) {
            UnsafeMemory.unsafePutByte((byte[])bytes, (int)i, (byte)this.memory.readByte(address + (long)i));
            ++i;
        }
        return len;
    }

    @Override
    public int peekUnsignedByte(long offset) {
        long address = this.address;
        @Nullable Memory memory = this.memory;
        long translate = this.translate(offset);
        long address2 = address + translate;
        int ret = translate >= this.limit ? -1 : memory.readByte(address2) & 0xFF;
        return ret;
    }

    @Override
    public int fastHash(long offset, int length) throws BufferUnderflowException, IllegalStateException {
        long ret;
        switch (length) {
            case 0: {
                return 0;
            }
            case 1: {
                ret = this.readByte(offset);
                break;
            }
            case 2: {
                ret = this.readShort(offset);
                break;
            }
            case 4: {
                ret = this.readInt(offset);
                break;
            }
            case 8: {
                ret = (long)this.readInt(offset) * 1829709757L + (long)this.readInt(offset + 4L);
                break;
            }
            default: {
                return super.fastHash(offset, length);
            }
        }
        long hash = ret * -2057448229L;
        return (int)(hash ^ hash >> 32);
    }

    @Override
    public long safeLimit() {
        return this.limit;
    }

    @Override
    public boolean isEqual(long start, long length, String s) {
        if (s == null || (long)s.length() != length) {
            return false;
        }
        return UnsafeMemory.MEMORY.isEqual(this.addressForRead(start), s, (int)length);
    }

    static {
        CLEANER_SERVICE = CleanerServiceLocator.cleanerService();
        Class<?> directBB = ByteBuffer.allocateDirect(0).getClass();
        BB_ADDRESS = Jvm.getField(directBB, (String)"address");
        BB_CAPACITY = Jvm.getField(directBB, (String)"capacity");
        BB_ATT = Jvm.getField(directBB, (String)"att");
    }

    private class Finalizer {
        private Finalizer() {
        }

        protected void finalize() throws Throwable {
            super.finalize();
            NativeBytesStore.this.warnAndReleaseIfNotReleased();
        }
    }

    static class Deallocator
    implements Runnable {
        private final long size;
        private volatile long address;

        Deallocator(long address, long size) {
            assert (address != 0L);
            this.address = address;
            this.size = size;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            long addressToFree = this.address;
            this.address = 0L;
            OS.memory().freeMemory(addressToFree, this.size);
        }
    }
}

