/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;

public class BinaryLongReference
extends AbstractReference
implements LongReference {
    public static final long LONG_NOT_COMPLETE = -1L;

    @Override
    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException, BufferUnderflowException {
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        super.bytesStore(bytes, offset, length);
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @NotNull
    public String toString() {
        return this.bytes == null ? "bytes is null" : "value: " + this.getValue();
    }

    public long getValue() {
        return this.bytes == null ? 0L : this.bytes.readLong(this.offset);
    }

    public void setValue(long value) {
        this.bytes.writeLong(this.offset, value);
    }

    public long getVolatileValue() {
        try {
            return this.bytes.readVolatileLong(this.offset);
        }
        catch (Exception e) {
            this.throwExceptionIfClosed();
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public void setVolatileValue(long value) {
        this.bytes.writeVolatileLong(this.offset, value);
    }

    public void setOrderedValue(long value) {
        this.bytes.writeOrderedLong(this.offset, value);
    }

    public long addValue(long delta) {
        return this.bytes.addAndGetLong(this.offset, delta);
    }

    public long addAtomicValue(long delta) {
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(long expected, long value) {
        BytesStore bytes = this.bytes;
        return bytes != null && bytes.compareAndSwapLong(this.offset, expected, value);
    }
}

