/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounted;
import org.jetbrains.annotations.NotNull;

public class MappedBytesStore
extends NativeBytesStore<Void> {
    private final long start;
    private final long safeLimit;

    protected MappedBytesStore(ReferenceCounted owner, long start, long address, long capacity, long safeCapacity) throws IllegalStateException {
        super(address, start + capacity, (Runnable)new OS.Unmapper(address, capacity, owner), false);
        this.start = start;
        this.safeLimit = start + safeCapacity;
    }

    @Override
    @NotNull
    public VanillaBytes<Void> bytesForWrite() throws IllegalStateException {
        return new VanillaBytes<Void>(this);
    }

    @Override
    public boolean inside(long offset) {
        return this.start <= offset && offset < this.safeLimit;
    }

    @Override
    public boolean inside(long offset, int buffer) {
        return this.start <= offset && offset + (long)buffer < this.safeLimit;
    }

    @Override
    public long safeLimit() {
        return this.safeLimit;
    }

    @Override
    public byte readByte(long offset) {
        return this.memory.readByte(this.address - this.start + offset);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeOrderedInt(long offset, int i) {
        this.memory.writeOrderedInt(this.address - this.start + offset, i);
        return this;
    }

    @Override
    protected long translate(long offset) {
        return offset - this.start;
    }

    @Override
    public long start() {
        return this.start;
    }

    @Override
    public long readPosition() {
        return this.start();
    }
}

